/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzaoi;
import com.google.android.gms.internal.ads.zzaol;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawx;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LargeParcelTeleporterCreator")
public final class zzaoj
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzaoj> CREATOR = new zzaol();
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zzdll;
    private Parcelable zzdlm;
    private boolean zzdln;

    @SafeParcelable.Constructor
    public zzaoj(@SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor) {
        this.zzdll = parcelFileDescriptor;
        this.zzdlm = null;
        this.zzdln = true;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzdln) {
            byte[] byArray;
            if (this.zzdll == null) {
                zzatm.zzes((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzdll));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzatm.zzc((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzdlm = (Parcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzdln = false;
        }
        return (T)((SafeParcelable)this.zzdlm);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzsx();
        Parcel parcel2 = parcel;
        zzaoj zzaoj2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzaoj2.zzdll, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzsx() {
        if (this.zzdll == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzdlm.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzdll = zzaoj.zzh(byArray);
        }
        return this.zzdll;
    }

    private static <T> ParcelFileDescriptor zzh(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzawx.zzdvx.execute(new zzaoi((OutputStream)autoCloseOutputStream2, byArray));
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzatm.zzc((String)"Error transporting the ad response", (Throwable)iOException);
            zzp.zzkc().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            IOUtils.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }

    static final /* synthetic */ void zza(OutputStream outputStream, byte[] byArray) {
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            block6: {
                try {
                    zzatm.zzc((String)"Error transporting the ad response", (Throwable)iOException);
                    zzp.zzkc().zza(iOException, "LargeParcelTeleporter.pipeData.1");
                    if (dataOutputStream != null) break block6;
                }
                catch (Throwable throwable) {
                    if (dataOutputStream == null) {
                        IOUtils.closeQuietly((Closeable)outputStream);
                    } else {
                        IOUtils.closeQuietly((Closeable)dataOutputStream);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)outputStream);
                return;
            }
            IOUtils.closeQuietly((Closeable)dataOutputStream);
            return;
        }
        IOUtils.closeQuietly((Closeable)dataOutputStream);
        return;
    }
}

