/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaot;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzzr;
import java.util.Locale;

public final class zzaos {
    private int zzdlz;
    private boolean zzdma;
    private boolean zzdmb;
    private int zzdmc;
    private int zzdmd;
    private int zzdme;
    private String zzdmf;
    private int zzdmg;
    private int zzdmh;
    private int zzdmi;
    private boolean zzdmj;
    private int zzdmk;
    private double zzdml;
    private boolean zzdmm;
    private String zzdmn;
    private String zzdmo;
    private boolean zzdmp;
    private boolean zzdmq;
    private String zzdmr;
    private boolean zzdms;
    private final boolean zzdmt;
    private boolean zzdmu;
    private String zzdmv;
    private String zzdmw;
    private float zzbod;
    private int zzdgc;
    private int zzdgd;
    private String zzdmx;
    private boolean zzdmy;

    public zzaos(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzs(context);
        this.zzt(context);
        this.zzu(context);
        Locale locale = Locale.getDefault();
        this.zzdmp = zzaos.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzdmq = zzaos.zza(packageManager, "http://www.google.com") != null;
        this.zzdmr = locale.getCountry();
        zzuo.zzof();
        this.zzdms = zzawe.zzwb();
        this.zzdmt = DeviceProperties.isLatchsky((Context)context);
        this.zzdmu = DeviceProperties.isSidewinder((Context)context);
        this.zzdmv = locale.getLanguage();
        this.zzdmw = zzaos.zza(context, packageManager);
        this.zzdmx = zzaos.zzv(context);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzbod = displayMetrics.density;
        this.zzdgc = displayMetrics.widthPixels;
        this.zzdgd = displayMetrics.heightPixels;
    }

    public zzaos(Context context, zzaot zzaot2) {
        this.zzs(context);
        this.zzt(context);
        this.zzu(context);
        Context context2 = context;
        zzaos zzaos2 = this;
        this.zzdmn = Build.FINGERPRINT;
        zzaos2.zzdmo = Build.DEVICE;
        zzaos2.zzdmy = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzzr.zzj(context2);
        this.zzdmp = zzaot2.zzdmp;
        this.zzdmq = zzaot2.zzdmq;
        this.zzdmr = zzaot2.zzdmr;
        this.zzdms = zzaot2.zzdms;
        this.zzdmt = zzaot2.zzdmt;
        this.zzdmu = zzaot2.zzdmu;
        this.zzdmv = zzaot2.zzdmv;
        this.zzdmw = zzaot2.zzdmw;
        this.zzdmx = zzaot2.zzdmx;
        this.zzbod = zzaot2.zzbod;
        this.zzdgc = zzaot2.zzdgc;
        this.zzdgd = zzaot2.zzdgd;
    }

    private final void zzs(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzdlz = audioManager.getMode();
                this.zzdma = audioManager.isMusicActive();
                this.zzdmb = audioManager.isSpeakerphoneOn();
                this.zzdmc = audioManager.getStreamVolume(3);
                this.zzdmd = audioManager.getRingerMode();
                this.zzdme = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzp.zzkc().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzdlz = -2;
        this.zzdma = false;
        this.zzdmb = false;
        this.zzdmc = 0;
        this.zzdmd = 2;
        this.zzdme = 0;
    }

    @TargetApi(value=16)
    private final void zzt(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzdmf = telephonyManager.getNetworkOperator();
        this.zzdmh = telephonyManager.getNetworkType();
        this.zzdmi = telephonyManager.getPhoneType();
        this.zzdmg = -2;
        this.zzdmj = false;
        this.zzdmk = -1;
        zzp.zzjy();
        if (zzatv.zzq(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzdmg = networkInfo.getType();
                this.zzdmk = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzdmg = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzdmj = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzu(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzdml = (float)n2 / (float)n3;
            this.zzdmm = n == 2 || n == 5;
            return;
        }
        this.zzdml = -1.0;
        this.zzdmm = false;
    }

    private static String zzv(Context context) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zza(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzaos.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzp.zzkc().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaot zzte() {
        return new zzaot(this.zzdlz, this.zzdmp, this.zzdmq, this.zzdmf, this.zzdmr, this.zzdms, this.zzdmt, this.zzdmu, this.zzdma, this.zzdmb, this.zzdmv, this.zzdmw, this.zzdmx, this.zzdmc, this.zzdmg, this.zzdmh, this.zzdmi, this.zzdmd, this.zzdme, this.zzbod, this.zzdgc, this.zzdgd, this.zzdml, this.zzdmm, this.zzdmj, this.zzdmk, this.zzdmn, this.zzdmy, this.zzdmo);
    }
}

