/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzarh;
import com.google.android.gms.internal.ads.zzari;
import com.google.android.gms.internal.ads.zzarj;
import com.google.android.gms.internal.ads.zzarn;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzarp;
import com.google.android.gms.internal.ads.zzarq;
import com.google.android.gms.internal.ads.zzart;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzdcf;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzdot;
import com.google.android.gms.internal.ads.zzdqd;
import com.google.android.gms.internal.ads.zzdtz;
import com.google.android.gms.internal.ads.zzdua;
import com.google.android.gms.internal.ads.zzdul;
import com.google.android.gms.internal.ads.zzdun;
import com.google.android.gms.internal.ads.zzduo;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzarf
implements zzaro {
    private static List<Future<Void>> zzdnv = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="lock")
    private final zzdul zzdnw;
    @GuardedBy(value="lock")
    private final LinkedHashMap<String, zzduo> zzdnx;
    @GuardedBy(value="lock")
    private final List<String> zzdny = new ArrayList<String>();
    @GuardedBy(value="lock")
    private final List<String> zzdnz = new ArrayList<String>();
    private final Context zzlk;
    private final zzarq zzdoa;
    @VisibleForTesting
    private boolean zzdob;
    private final zzarn zzdkx;
    private final zzart zzdoc;
    private final Object lock = new Object();
    private HashSet<String> zzdod = new HashSet();
    private boolean zzdoe = false;
    private boolean zzdof = false;
    private boolean zzdog = false;

    public zzarf(Context context, zzawv zzawv2, zzarn zzarn2, String string2, zzarq zzarq2) {
        long l;
        Preconditions.checkNotNull((Object)((Object)zzarn2), (Object)"SafeBrowsing config is not present.");
        this.zzlk = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdnx = new LinkedHashMap();
        this.zzdoa = zzarq2;
        this.zzdkx = zzarn2;
        for (String string3 : this.zzdkx.zzdoo) {
            this.zzdod.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzdod.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzawv zzawv3 = zzawv2;
        zzarf zzarf2 = this;
        zzdul zzdul2 = new zzdul();
        new zzdul().zzhur = zzdua.zzb.zzg.zzhtw;
        zzdul2.url = string4;
        zzdul2.zzhut = string4;
        zzdua.zzb.zzb.zza zza2 = zzdua.zzb.zzb.zzbci();
        if (zzarf2.zzdkx.zzdok != null) {
            zza2.zzhn(zzarf2.zzdkx.zzdok);
        }
        zzdul2.zzhuv = (zzdua.zzb.zzb)((zzdqd)zza2.zzazm());
        zzdua.zzb.zzi.zza zza3 = zzdua.zzb.zzi.zzbcs().zzbm(Wrappers.packageManager((Context)zzarf2.zzlk).isCallerInstantApp());
        if (zzawv3.zzbnh != null) {
            zza3.zzhq(zzawv3.zzbnh);
        }
        if ((l = (long)GoogleApiAvailabilityLight.getInstance().getApkVersion(zzarf2.zzlk)) > 0L) {
            zza3.zzfo(l);
        }
        zzdul2.zzhvf = (zzdua.zzb.zzi)((zzdqd)zza3.zzazm());
        this.zzdnw = zzdul2;
        this.zzdoc = new zzart(this.zzlk, this.zzdkx.zzdor, this);
    }

    @Override
    public final zzarn zzti() {
        return this.zzdkx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdq(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdnw.zzhux = string2;
            return;
        }
    }

    @Override
    public final boolean zztj() {
        return PlatformVersion.isAtLeastKitKat() && this.zzdkx.zzdom && !this.zzdof;
    }

    @Override
    public final void zzj(View view) {
        if (!this.zzdkx.zzdom) {
            return;
        }
        if (this.zzdof) {
            return;
        }
        zzp.zzjy();
        Bitmap bitmap = zzatv.zzl(view);
        if (bitmap == null) {
            zzarp.zzdv("Failed to capture the webview bitmap.");
            return;
        }
        this.zzdof = true;
        zzatv.zzd(new zzarg(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n == 3) {
                this.zzdog = true;
            }
            if (this.zzdnx.containsKey(string2)) {
                if (n == 3) {
                    this.zzdnx.get((Object)string2).zzhvu = zzdua.zzb.zzh.zza.zzhk(n);
                }
                return;
            }
            zzduo zzduo2 = new zzduo();
            new zzduo().zzhvu = zzdua.zzb.zzh.zza.zzhk(n);
            zzduo2.zzhvo = this.zzdnx.size();
            zzduo2.url = string2;
            zzduo2.zzhvp = new zzdun();
            if (this.zzdod.size() > 0 && map != null) {
                ArrayList<zzdua.zzb.zzc> arrayList = new ArrayList<zzdua.zzb.zzc>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string3;
                    String string4 = entry.getKey() != null ? entry.getKey() : "";
                    String string5 = string3 = entry.getValue() != null ? entry.getValue() : "";
                    String string6 = string4.toLowerCase(Locale.ENGLISH);
                    if (!this.zzdod.contains(string6)) continue;
                    zzdua.zzb.zzc zzc2 = (zzdua.zzb.zzc)((zzdqd)zzdua.zzb.zzc.zzbck().zzdd(zzdot.zzhh((String)string4)).zzde(zzdot.zzhh((String)string3)).zzazm());
                    arrayList.add(zzc2);
                }
                zzdua.zzb.zzc[] zzcArray = new zzdua.zzb.zzc[arrayList.size()];
                arrayList.toArray(zzcArray);
                zzduo2.zzhvp.zzhvj = zzcArray;
            }
            this.zzdnx.put(string2, zzduo2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdr(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdny.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzds(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdnz.add(string2);
            return;
        }
    }

    @Override
    public final String[] zza(String[] stringArray) {
        return this.zzdoc.zzb(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zztk() {
        this.zzdoe = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzduo zzdt(String string2) {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdnx.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zztl() {
        Object object = this.lock;
        synchronized (object) {
            zzdcp zzdcp2 = zzdcf.zzb(this.zzdoa.zza(this.zzlk, this.zzdnx.keySet()), new zzare(this), (Executor)zzawx.zzdwb);
            zzdcp zzdcp3 = zzdcf.zza(zzdcp2, 10L, TimeUnit.SECONDS, zzawx.zzdvz);
            zzdcf.zza(zzdcp2, new zzarj(this, zzdcp3), zzawx.zzdwb);
            zzdnv.add(zzdcp3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzdcp<Void> zztm() {
        if (!(this.zzdob && this.zzdkx.zzdoq || this.zzdog && this.zzdkx.zzdop || !this.zzdob && this.zzdkx.zzdon)) {
            return zzdcf.zzah(null);
        }
        Object object = this.lock;
        synchronized (object) {
            this.zzdnw.zzhuw = new zzduo[this.zzdnx.size()];
            this.zzdnx.values().toArray(this.zzdnw.zzhuw);
            this.zzdnw.zzhvg = this.zzdny.toArray(new String[0]);
            this.zzdnw.zzhvh = this.zzdnz.toArray(new String[0]);
            if (zzarp.isEnabled()) {
                zzduo[] zzduoArray = this.zzdnw.url;
                String string2 = this.zzdnw.zzhux;
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(zzduoArray).length() + String.valueOf(string2).length()).append("Sending SB report\n  url: ").append((String)zzduoArray).append("\n  clickUrl: ").append(string2).append("\n  resources: \n").toString());
                zzduoArray = this.zzdnw.zzhuw;
                int n = this.zzdnw.zzhuw.length;
                for (int i = 0; i < n; ++i) {
                    zzduo zzduo2 = zzduoArray[i];
                    stringBuilder.append("    [");
                    stringBuilder.append(zzduo2.zzhvv.length);
                    stringBuilder.append("] ");
                    stringBuilder.append(zzduo2.url);
                }
                zzarp.zzdv(stringBuilder.toString());
            }
            String string3 = this.zzdkx.zzdol;
            byte[] byArray = zzdtz.zzb(this.zzdnw);
            zzarf zzarf2 = this;
            zzdcp<String> zzdcp2 = new zzave(zzarf2.zzlk).zza(1, string3, null, byArray);
            if (zzarp.isEnabled()) {
                zzdcp2.addListener(new zzari(zzarf2), zzawx.zzdvx);
            }
            return zzdcf.zzb(zzdcp2, zzarh.zzdoi, (Executor)zzawx.zzdwb);
        }
    }

    static final /* synthetic */ Void zzdu(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzdcp zzh(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzarf zzarf2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzarf2.lock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzduo zzduo2 = zzarf2.zzdt(string2);
                        if (zzduo2 == null) {
                            String string4 = String.valueOf(string2);
                            zzarp.zzdv(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        zzduo2.zzhvv = new String[n];
                        for (int i = 0; i < n; ++i) {
                            zzduo2.zzhvv[i] = jSONArray.getJSONObject(i).getString("threat_type");
                        }
                        zzarf2.zzdob = zzarf2.zzdob | n > 0;
                    }
                }
            }
            if (this.zzdob) {
                Object object = this.lock;
                synchronized (object) {
                    this.zzdnw.zzhur = zzdua.zzb.zzg.zzhtx;
                }
            }
            return this.zztm();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            zzyi zzyi2 = zzyt.zzcpb;
            if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
                zzatm.zzb((String)string5, (Throwable)jSONException2);
            }
            return zzdcf.zzi(new Exception("Safebrowsing report transmission failed."));
        }
    }

    static /* synthetic */ Object zza(zzarf zzarf2) {
        return zzarf2.lock;
    }

    static /* synthetic */ zzdul zzb(zzarf zzarf2) {
        return zzarf2.zzdnw;
    }

    static /* synthetic */ List zztn() {
        return zzdnv;
    }
}

