/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzasy;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzato;
import com.google.android.gms.internal.ads.zzatq;
import com.google.android.gms.internal.ads.zzatt;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzqb;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzatr
implements zzato {
    private final Object lock = new Object();
    private boolean zzdrp;
    private final List<Runnable> zzdrq = new ArrayList<Runnable>();
    private zzdcp<?> zzdrr;
    @GuardedBy(value="lock")
    @Nullable
    private zzqb zzdrs = null;
    @GuardedBy(value="lock")
    @Nullable
    private SharedPreferences zzcfs;
    @GuardedBy(value="lock")
    @Nullable
    private SharedPreferences.Editor zzdrt;
    @GuardedBy(value="lock")
    private boolean zzdru = false;
    @GuardedBy(value="lock")
    private boolean zzdip = true;
    @GuardedBy(value="lock")
    @Nullable
    private String zzdrv;
    @GuardedBy(value="lock")
    @Nullable
    private String zzdrw;
    @GuardedBy(value="lock")
    private boolean zzdjc = false;
    @GuardedBy(value="lock")
    private String zzdjf = "";
    @GuardedBy(value="lock")
    private long zzdrx = 0L;
    @GuardedBy(value="lock")
    private long zzdry = 0L;
    @GuardedBy(value="lock")
    private long zzdrz = 0L;
    @GuardedBy(value="lock")
    private int zzdsa = -1;
    @GuardedBy(value="lock")
    private int zzdsb = 0;
    @GuardedBy(value="lock")
    private Set<String> zzdsc = Collections.emptySet();
    @GuardedBy(value="lock")
    private JSONObject zzdsd = new JSONObject();
    @GuardedBy(value="lock")
    private boolean zzdko = true;
    @GuardedBy(value="lock")
    private boolean zzdkz = true;
    @GuardedBy(value="lock")
    private String zzdse = null;
    @GuardedBy(value="lock")
    private int zzdsf = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string2, boolean bl) {
        String string3;
        Object object = this.lock;
        synchronized (object) {
            if (this.zzcfs != null) {
                return;
            }
        }
        if (string2 == null) {
            string3 = "admob";
        } else {
            String string4 = String.valueOf("admob__");
            String string5 = String.valueOf(string2);
            string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        object = string3;
        this.zzdrr = zzawx.zzdvx.zzg(new zzatq(this, context, (String)object));
        this.zzdrp = bl;
    }

    private final void zzvf() {
        if (this.zzdrr == null) {
            return;
        }
        if (this.zzdrr.isDone()) {
            return;
        }
        try {
            this.zzdrr.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzatm.zzd((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzatm.zzc((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzvg() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzdip);
            bundle.putBoolean("content_url_opted_out", this.zzdko);
            bundle.putBoolean("content_vertical_opted_out", this.zzdkz);
            bundle.putBoolean("auto_collect_location", this.zzdjc);
            bundle.putInt("version_code", this.zzdsb);
            bundle.putStringArray("never_pool_slots", this.zzdsc.toArray(new String[0]));
            bundle.putString("app_settings_json", this.zzdjf);
            bundle.putLong("app_settings_last_update_ms", this.zzdrx);
            bundle.putLong("app_last_background_time_ms", this.zzdry);
            bundle.putInt("request_in_session_count", this.zzdsa);
            bundle.putLong("first_ad_req_time_ms", this.zzdrz);
            bundle.putString("native_advanced_settings", this.zzdsd.toString());
            bundle.putString("display_cutout", this.zzdse);
            bundle.putInt("app_measurement_npa", this.zzdsf);
            if (this.zzdrv != null) {
                bundle.putString("content_url_hashes", this.zzdrv);
            }
            if (this.zzdrw != null) {
                bundle.putString("content_vertical_hashes", this.zzdrw);
            }
        }
        return bundle;
    }

    private final void zzc(Bundle bundle) {
        zzawx.zzdvx.execute(new zzatt(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final zzqb zzur() {
        if (!this.zzdrp) {
            return null;
        }
        if (!PlatformVersion.isAtLeastIceCreamSandwich()) {
            return null;
        }
        if (this.zzus() && this.zzuu()) {
            return null;
        }
        zzyi zzyi2 = zzyt.zzcih;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (Looper.getMainLooper() == null) {
                return null;
            }
            if (this.zzdrs == null) {
                this.zzdrs = new zzqb();
            }
            this.zzdrs.zzlr();
            zzatm.zzet((String)"start fetching content...");
            return this.zzdrs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzah(boolean bl) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdko == bl) {
                return;
            }
            this.zzdko = bl;
            if (this.zzdrt != null) {
                this.zzdrt.putBoolean("content_url_opted_out", bl);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdko);
            bundle.putBoolean("content_vertical_opted_out", this.zzdkz);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzus() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdko;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdz(@Nullable String string2) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdrv)) {
                return;
            }
            this.zzdrv = string2;
            if (this.zzdrt != null) {
                this.zzdrt.putString("content_url_hashes", string2);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzut() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdrv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzai(boolean bl) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdkz == bl) {
                return;
            }
            this.zzdkz = bl;
            if (this.zzdrt != null) {
                this.zzdrt.putBoolean("content_vertical_opted_out", bl);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdko);
            bundle.putBoolean("content_vertical_opted_out", this.zzdkz);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzuu() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdkz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzea(@Nullable String string2) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdrw)) {
                return;
            }
            this.zzdrw = string2;
            if (this.zzdrt != null) {
                this.zzdrt.putString("content_vertical_hashes", string2);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzuv() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdrw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaj(boolean bl) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdjc == bl) {
                return;
            }
            this.zzdjc = bl;
            if (this.zzdrt != null) {
                this.zzdrt.putBoolean("auto_collect_location", bl);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzuw() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdjc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcn(int n) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdsb == n) {
                return;
            }
            this.zzdsb = n;
            if (this.zzdrt != null) {
                this.zzdrt.putInt("version_code", n);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzux() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdsb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzeb(String string2) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            long l;
            this.zzdrx = l = zzp.zzkf().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzdjf)) {
                return;
            }
            this.zzdjf = string2;
            if (this.zzdrt != null) {
                this.zzdrt.putString("app_settings_json", string2);
                this.zzdrt.putLong("app_settings_last_update_ms", l);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzc(bundle);
            Iterator<Runnable> iterator = this.zzdrq.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzasy zzuy() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return new zzasy(this.zzdjf, this.zzdrx);
        }
    }

    @Override
    public final void zzc(Runnable runnable) {
        this.zzdrq.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzet(long l) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdry == l) {
                return;
            }
            this.zzdry = l;
            if (this.zzdrt != null) {
                this.zzdrt.putLong("app_last_background_time_ms", l);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzuz() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzco(int n) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdsa == n) {
                return;
            }
            this.zzdsa = n;
            if (this.zzdrt != null) {
                this.zzdrt.putInt("request_in_session_count", n);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzva() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdsa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzeu(long l) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdrz == l) {
                return;
            }
            this.zzdrz = l;
            if (this.zzdrt != null) {
                this.zzdrt.putLong("first_ad_req_time_ms", l);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzvb() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdrz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(String string2, String string3, boolean bl) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzdsd.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false)) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzp.zzkf().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzdsd.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzatm.zzd((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzdrt != null) {
                this.zzdrt.putString("native_advanced_settings", this.zzdsd.toString());
                this.zzdrt.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzdsd.toString());
            this.zzc((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject zzvc() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdsd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzvd() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            this.zzdsd = new JSONObject();
            if (this.zzdrt != null) {
                this.zzdrt.remove("native_advanced_settings");
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzve() {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzec(String string2) {
        this.zzvf();
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.equals((CharSequence)this.zzdse, (CharSequence)string2)) {
                return;
            }
            this.zzdse = string2;
            if (this.zzdrt != null) {
                this.zzdrt.putString("display_cutout", string2);
                this.zzdrt.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("display_cutout", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zzp(Context context, String string2) {
        String string3 = string2;
        Context context2 = context;
        zzatr zzatr2 = this;
        SharedPreferences sharedPreferences = context2.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = zzatr2.lock;
        synchronized (object) {
            zzatr2.zzcfs = sharedPreferences;
            zzatr2.zzdrt = editor;
            zzatr2.zzdru = PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
            zzatr2.zzdip = zzatr2.zzcfs.getBoolean("use_https", zzatr2.zzdip);
            zzatr2.zzdko = zzatr2.zzcfs.getBoolean("content_url_opted_out", zzatr2.zzdko);
            zzatr2.zzdrv = zzatr2.zzcfs.getString("content_url_hashes", zzatr2.zzdrv);
            zzatr2.zzdjc = zzatr2.zzcfs.getBoolean("auto_collect_location", zzatr2.zzdjc);
            zzatr2.zzdkz = zzatr2.zzcfs.getBoolean("content_vertical_opted_out", zzatr2.zzdkz);
            zzatr2.zzdrw = zzatr2.zzcfs.getString("content_vertical_hashes", zzatr2.zzdrw);
            zzatr2.zzdsb = zzatr2.zzcfs.getInt("version_code", zzatr2.zzdsb);
            zzatr2.zzdjf = zzatr2.zzcfs.getString("app_settings_json", zzatr2.zzdjf);
            zzatr2.zzdrx = zzatr2.zzcfs.getLong("app_settings_last_update_ms", zzatr2.zzdrx);
            zzatr2.zzdry = zzatr2.zzcfs.getLong("app_last_background_time_ms", zzatr2.zzdry);
            zzatr2.zzdsa = zzatr2.zzcfs.getInt("request_in_session_count", zzatr2.zzdsa);
            zzatr2.zzdrz = zzatr2.zzcfs.getLong("first_ad_req_time_ms", zzatr2.zzdrz);
            zzatr2.zzdsc = zzatr2.zzcfs.getStringSet("never_pool_slots", zzatr2.zzdsc);
            zzatr2.zzdse = zzatr2.zzcfs.getString("display_cutout", zzatr2.zzdse);
            zzatr2.zzdsf = zzatr2.zzcfs.getInt("app_measurement_npa", zzatr2.zzdsf);
            try {
                zzatr2.zzdsd = new JSONObject(zzatr2.zzcfs.getString("native_advanced_settings", "{}"));
            }
            catch (JSONException jSONException) {
                zzatm.zzd((String)"Could not convert native advanced settings to json object", (Throwable)jSONException);
            }
            zzatr2.zzc(zzatr2.zzvg());
            return;
        }
    }
}

