/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzapf;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatp;
import com.google.android.gms.internal.ads.zzatw;
import com.google.android.gms.internal.ads.zzatx;
import com.google.android.gms.internal.ads.zzaty;
import com.google.android.gms.internal.ads.zzatz;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzavv;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawi;
import com.google.android.gms.internal.ads.zzawj;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzatv {
    private AtomicReference<Pattern> zzdsi = new AtomicReference<Object>(null);
    private AtomicReference<Pattern> zzdsj = new AtomicReference<Object>(null);
    public static final Handler zzdsk = new zzatp(Looper.getMainLooper());
    private boolean zzyf = true;
    private final Object zzdsl = new Object();
    @GuardedBy(value="userAgentLock")
    private String zzbey;
    private boolean zzdsm = false;
    private boolean zzdsn = false;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzatv zzatv2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzatv2.zzr(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzq(Context context, String string2) {
        context = zzapf.zzz(context);
        String string3 = string2;
        String string4 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string3, string4) == 0;
    }

    public static void zzb(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        ArrayList<String> arrayList2 = arrayList;
        String string4 = string2;
        Context context2 = context;
        ArrayList<String> arrayList3 = arrayList2;
        int n = arrayList3.size();
        Object var7_10 = null;
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            String string5 = (String)e;
            new zzavv(context2, string4, string5).zzup();
        }
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzan(Context context) {
        if (this.zzdsm) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzaty(this, null), intentFilter);
        this.zzdsm = true;
        return true;
    }

    public final boolean zzao(Context context) {
        if (this.zzdsn) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzatz(this, null), intentFilter);
        this.zzdsn = true;
        return true;
    }

    public final void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzr(context, string2));
    }

    private static String zzvh() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzr(Context context, String string2) {
        Object object = this.zzdsl;
        synchronized (object) {
            if (this.zzbey != null) {
                return this.zzbey;
            }
            if (string2 == null) {
                return zzatv.zzvh();
            }
            try {
                this.zzbey = zzp.zzka().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzbey)) {
                zzuo.zzof();
                if (!zzawe.zzwc()) {
                    this.zzbey = null;
                    zzdsk.post((Runnable)new zzatx(this, context));
                    while (this.zzbey == null) {
                        try {
                            this.zzdsl.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzbey = zzatv.zzvh();
                            String string3 = String.valueOf(this.zzbey);
                            zzatm.zzeu((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzbey = zzatv.zzap(context);
                }
            }
            String string4 = String.valueOf(this.zzbey);
            this.zzbey = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (Wrappers.packageManager((Context)context).isCallerInstantApp()) {
                    this.zzbey = String.valueOf(this.zzbey).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzp.zzkc().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzbey = String.valueOf(this.zzbey).concat(")");
            return this.zzbey;
        }
    }

    @VisibleForTesting
    protected static String zzap(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzatv.zzvh();
        }
    }

    public final JSONObject zzi(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zzd(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzatm.zzc((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    public final JSONObject zzd(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzi(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzatv zzatv2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzatv2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzi(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    private static int zza(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid Hex.");
    }

    public static Map<String, String> zzi(Uri uri) {
        zzyi zzyi2 = zzyt.zzcsv;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            zzyi2 = uri;
            if (zzyi2 == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            zzp.zzka();
            for (String string2 : zzyi2.getQueryParameterNames()) {
                hashMap.put(string2, zzyi2.getQueryParameter(string2));
            }
            return hashMap;
        }
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(20);
        String string3 = uri.getEncodedQuery();
        if (string3 == null) {
            return hashMap;
        }
        int n = string3.length();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(n);
        StringBuilder stringBuilder3 = stringBuilder;
        block11: while (n2 < n) {
            char c = string3.charAt(n2);
            switch (c) {
                case '+': {
                    stringBuilder3.append(' ');
                    break;
                }
                case '=': {
                    if (stringBuilder3 != stringBuilder2) {
                        stringBuilder3 = stringBuilder2;
                        break;
                    }
                    stringBuilder3.append(c);
                    break;
                }
                case '&': {
                    if (stringBuilder.length() > 0 && stringBuilder3 != stringBuilder) {
                        hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
                        stringBuilder.setLength(0);
                        stringBuilder2.setLength(0);
                    }
                    stringBuilder3 = stringBuilder;
                    break;
                }
                case '%': {
                    byte[] byArray = new byte[(n - n2) / 3];
                    int n3 = 0;
                    while (n2 < n - 2 && c == '%') {
                        try {
                            byArray[n3] = (byte)((zzatv.zza(string3.charAt(n2 + 1)) << 4) + zzatv.zza(string3.charAt(n2 + 2)));
                            ++n3;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        if ((n2 += 3) >= n) continue;
                        c = string3.charAt(n2);
                    }
                    try {
                        stringBuilder3.append(new String(byArray, 0, n3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    if (c == '%') break;
                    continue block11;
                }
                default: {
                    stringBuilder3.append(c);
                }
            }
            ++n2;
        }
        if (stringBuilder.length() > 0 && stringBuilder3 != stringBuilder) {
            hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
        }
        return hashMap;
    }

    public static String zzvi() {
        return UUID.randomUUID().toString();
    }

    public static int zzed(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzatm.zzeu((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzvj() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzvk() {
        return new int[]{0, 0};
    }

    public static int[] zzd(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzatv.zzvk();
    }

    public final int[] zze(Activity activity) {
        int[] nArray = zzatv.zzd(activity);
        return new int[]{zzuo.zzof().zzb((Context)activity, nArray[0]), zzuo.zzof().zzb((Context)activity, nArray[1])};
    }

    public final int[] zzf(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzatv.zzvk();
        }
        int[] nArray3 = nArray;
        return new int[]{zzuo.zzof().zzb((Context)activity, nArray3[0]), zzuo.zzof().zzb((Context)activity, nArray3[1])};
    }

    public static boolean zzee(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzaq(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzye zzar(Context context) {
        return new zzye(context);
    }

    public static Bitmap zzk(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    @SuppressLint(value={"NewApi"})
    public static String zzas(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static boolean zzat(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        zzp.zzjy();
        bundle.putString("device", zzatv.zzvj());
        bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zzyt.zzpn()));
        zzuo.zzof();
        zzawe.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)true, (zzawj)new zzatw(this, context, string2));
    }

    public static void zzd(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzawx.zzdvx.execute(runnable);
    }

    public static Bitmap zzl(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzatv.zzn(view);
        if (bitmap == null) {
            bitmap = zzatv.zzm(view);
        }
        return bitmap;
    }

    private static Bitmap zzm(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzatm.zzeu((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzatm.zzc((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzn(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzatm.zzc((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static int zzau(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzatv.zzav(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzav(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    public final boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl;
        KeyguardManager keyguardManager2;
        boolean bl2 = zzp.zzjy().zzyf || !((keyguardManager2 = keyguardManager) == null ? false : keyguardManager2.inKeyguardRestrictedInputMode()) || zzatv.zzo(view) ? true : (bl = false);
        if (view.getVisibility() == 0 && view.isShown() && ((keyguardManager2 = powerManager) == null || keyguardManager2.isScreenOn()) && bl) {
            keyguardManager2 = zzyt.zzclq;
            if (!((Boolean)zzuo.zzoj().zzd((zzyi)keyguardManager2)).booleanValue() || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzo(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzaw(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        KeyguardManager keyguardManager = zzatv.zzav(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzp(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzax(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzatm.zzc((String)"Error loading class.", (Throwable)throwable);
            zzp.zzkc().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzatv.zzb(context, intent);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzatm.zzdv((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzatm.zzc((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzc(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzs(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(IOUtils.readInputStreamFully((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzatm.zzdv((String)"Error reading from internal storage.");
            return "";
        }
    }

    public final boolean zzef(String string2) {
        zzyi zzyi2 = zzyt.zzcja;
        return zzatv.zza(string2, this.zzdsi, (String)zzuo.zzoj().zzd(zzyi2));
    }

    public final boolean zzeg(String string2) {
        zzyi zzyi2 = zzyt.zzcjb;
        return zzatv.zza(string2, this.zzdsj, (String)zzuo.zzoj().zzd(zzyi2));
    }

    private static boolean zza(String string2, AtomicReference<Pattern> atomicReference, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            Pattern pattern = atomicReference.get();
            if (pattern == null || !string3.equals(pattern.pattern())) {
                pattern = Pattern.compile(string3);
                atomicReference.set(pattern);
            }
            return pattern.matcher(string2).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static String zzvl() {
        Resources resources = zzp.zzkc().getResources();
        String string2 = resources != null ? resources.getString(R.string.s7) : "Test Ad";
        return string2;
    }

    @Nullable
    public static WebResourceResponse zzd(Context context, String string2, String string3) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("User-Agent", zzp.zzjy().zzr(context, string2));
            hashMap.put("Cache-Control", "max-stale=3600");
            String string4 = (String)new zzave(context).zzc(string3, hashMap).get(60L, TimeUnit.SECONDS);
            if (string4 != null) {
                return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(string4.getBytes("UTF-8")));
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzatm.zzd((String)"Could not fetch MRAID JS.", (Throwable)exception);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WebResourceResponse zzd(HttpURLConnection httpURLConnection) throws IOException {
        String string2;
        String string3;
        Object object2;
        block4: {
            Object object;
            zzp.zzjy();
            object2 = httpURLConnection.getContentType();
            string3 = TextUtils.isEmpty((CharSequence)object2) ? "" : ((String)object2).split(";")[0].trim();
            zzp.zzjy();
            object2 = httpURLConnection.getContentType();
            if (!TextUtils.isEmpty((CharSequence)object2) && ((String[])(object = ((String)object2).split(";"))).length != 1) {
                void entry;
                boolean i = true;
                while (entry < ((String[])object).length) {
                    String[] stringArray;
                    if (object[entry].trim().startsWith("charset") && (stringArray = ((String)object[entry]).trim().split("=")).length > 1) {
                        string2 = stringArray[1].trim();
                        break block4;
                    }
                    ++entry;
                }
            }
            string2 = "";
        }
        String string4 = string2;
        object2 = httpURLConnection.getHeaderFields();
        HashMap<String, String> hashMap = new HashMap<String, String>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            hashMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        HashMap<String, String> hashMap2 = hashMap;
        return zzp.zzka().zza(string3, string4, httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage(), hashMap2, httpURLConnection.getInputStream());
    }

    public static void zza(Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        boolean bl = false;
        try {
            zzyi zzyi2 = zzyt.zzcgj;
            bl = (Boolean)zzuo.zzoj().zzd(zzyi2);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bl) {
            Throwable throwable2 = throwable;
            CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable2);
        }
    }

    public static String zzay(Context context) {
        zzyi zzyi2 = zzyt.zzcsk;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return "";
        }
        return context.getSharedPreferences("mobileads_consent", 0).getString("consent_string", "");
    }

    public static Bundle zzaz(Context context) {
        zzyi zzyi2 = zzyt.zzcsl;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return null;
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Bundle bundle = new Bundle();
        if (sharedPreferences.contains("IABConsent_CMPPresent")) {
            bundle.putBoolean("IABConsent_CMPPresent", sharedPreferences.getBoolean("IABConsent_CMPPresent", false));
        }
        String[] stringArray = new String[]{"IABConsent_SubjectToGDPR", "IABConsent_ConsentString", "IABConsent_ParsedPurposeConsents", "IABConsent_ParsedVendorConsents"};
        for (int i = 0; i < 4; ++i) {
            String string2 = stringArray[i];
            if (!sharedPreferences.contains(string2)) continue;
            bundle.putString(string2, sharedPreferences.getString(string2, null));
        }
        return bundle;
    }

    public static boolean zzba(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    public static boolean zzeh(String string2) {
        int n;
        Object object;
        if (!zzawi.isEnabled()) {
            return false;
        }
        zzyi zzyi2 = zzyt.zzcqg;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return false;
        }
        zzyi2 = zzyt.zzcqi;
        String string3 = (String)zzuo.zzoj().zzd(zzyi2);
        if (!string3.isEmpty()) {
            object = string3.split(";");
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                if (!((String)object[n]).equals(string2)) continue;
                return false;
            }
        }
        zzyi2 = zzyt.zzcqh;
        object = (String)zzuo.zzoj().zzd(zzyi2);
        if (((String)object).isEmpty()) {
            return true;
        }
        String[] stringArray = ((String)object).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean zza(zzatv zzatv2, boolean bl) {
        zzatv2.zzyf = bl;
        return zzatv2.zzyf;
    }

    static /* synthetic */ Object zza(zzatv zzatv2) {
        return zzatv2.zzdsl;
    }

    static /* synthetic */ String zza(zzatv zzatv2, String string2) {
        zzatv2.zzbey = string2;
        return zzatv2.zzbey;
    }
}

