/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.provider.Settings;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.SharedPreferencesUtils;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzaub;
import com.google.android.gms.internal.ads.zzavw;
import com.google.android.gms.internal.ads.zzavy;
import com.google.android.gms.internal.ads.zzavz;
import com.google.android.gms.internal.ads.zzawb;
import java.util.concurrent.Callable;

@TargetApi(value=17)
public class zzauc
extends zzaub {
    public zzauc() {
        super(null);
    }

    @Override
    public final boolean zza(Context context, WebSettings webSettings) {
        super.zza(context, webSettings);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        return true;
    }

    @Override
    public final String getDefaultUserAgent(Context context) {
        Context context2 = context;
        zzavz zzavz2 = zzavz.zzwa();
        Context context3 = context2;
        zzavz zzavz3 = zzavz2;
        if (TextUtils.isEmpty((CharSequence)zzavz2.zzdur)) {
            String string2;
            if (ClientLibraryUtils.isPackageSide()) {
                string2 = (String)zzavw.zza((Context)context3, (Callable)new zzavy(zzavz3, context3));
            } else {
                Context context4 = GooglePlayServicesUtilLight.getRemoteContext((Context)context3);
                string2 = (String)zzavw.zza((Context)context3, (Callable)new zzawb(zzavz3, context4, context3));
            }
            zzavz3.zzdur = string2;
        }
        return zzavz2.zzdur;
    }

    @Override
    public final void zzbb(Context context) {
        Context context2 = context;
        zzavz zzavz2 = zzavz.zzwa();
        zzatm.zzdy("Updating user agent.");
        String string2 = WebSettings.getDefaultUserAgent((Context)context2);
        if (!string2.equals(zzavz2.zzdur)) {
            Context context3 = GooglePlayServicesUtilLight.getRemoteContext((Context)context2);
            if (ClientLibraryUtils.isPackageSide() || context3 == null) {
                String string3 = WebSettings.getDefaultUserAgent((Context)context2);
                SharedPreferences.Editor editor = context2.getSharedPreferences("admob_user_agent", 0).edit().putString("user_agent", string3);
                if (context3 == null) {
                    editor.apply();
                } else {
                    SharedPreferencesUtils.publishWorldReadableSharedPreferences((Context)context2, (SharedPreferences.Editor)editor, (String)"admob_user_agent");
                }
            }
            zzavz2.zzdur = string2;
        }
        zzatm.zzdy("User agent is updated.");
    }

    @Override
    public final Drawable zza(Context context, Bitmap bitmap, boolean bl, float f) {
        if (!bl || f <= 0.0f || f > 25.0f) {
            return new BitmapDrawable(context.getResources(), bitmap);
        }
        try {
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2);
            RenderScript renderScript = RenderScript.create((Context)context);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2);
            Allocation allocation2 = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap3);
            scriptIntrinsicBlur.setRadius(f);
            scriptIntrinsicBlur.setInput(allocation);
            scriptIntrinsicBlur.forEach(allocation2);
            allocation2.copyTo(bitmap3);
            return new BitmapDrawable(context.getResources(), bitmap3);
        }
        catch (RuntimeException runtimeException) {
            return new BitmapDrawable(context.getResources(), bitmap);
        }
    }

    @Override
    public final int zza(ContentResolver contentResolver) {
        return Settings.Global.getInt((ContentResolver)contentResolver, (String)"wifi_on", (int)0);
    }

    @Override
    public final int zzb(ContentResolver contentResolver) {
        return Settings.Global.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0);
    }
}

