/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PointF;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzaum;
import com.google.android.gms.internal.ads.zzauo;
import com.google.android.gms.internal.ads.zzaup;
import com.google.android.gms.internal.ads.zzauq;
import com.google.android.gms.internal.ads.zzaur;
import com.google.android.gms.internal.ads.zzaut;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.List;

public final class zzaun {
    private final Context zzlk;
    private String zzdhs;
    private String zzccm;
    private String zzbnh;
    @Nullable
    private String zzdky;
    private int state = 0;
    private int zzdsu;
    private PointF zzdsv;
    private PointF zzdsw;
    private Handler handler;
    private Runnable zzdsx = new zzaum(this);

    public zzaun(Context context) {
        this.zzlk = context;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.zzdsu = viewConfiguration.getScaledTouchSlop();
        zzp.zzkm().zzvz();
        this.handler = zzp.zzkm().getHandler();
    }

    public zzaun(Context context, String string2) {
        this(context);
        this.zzdhs = string2;
    }

    public final void zzd(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        int n2 = motionEvent.getHistorySize();
        int n3 = motionEvent.getPointerCount();
        if (n == 0) {
            this.state = 0;
            this.zzdsv = new PointF(motionEvent.getX(0), motionEvent.getY(0));
            return;
        }
        if (this.state == -1) {
            return;
        }
        if (this.state == 0 && n == 5) {
            this.state = 5;
            this.zzdsw = new PointF(motionEvent.getX(1), motionEvent.getY(1));
            zzyi zzyi2 = zzyt.zzcps;
            this.handler.postDelayed(this.zzdsx, ((Long)zzuo.zzoj().zzd(zzyi2)).longValue());
            return;
        }
        if (this.state == 5) {
            boolean bl = false;
            if (n3 != 2) {
                bl = true;
            } else if (n == 2) {
                for (int i = 0; i < n2; ++i) {
                    if (this.zza(motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i), motionEvent.getHistoricalX(1, i), motionEvent.getHistoricalY(1, i))) continue;
                    bl = true;
                }
                if (!this.zza(motionEvent.getX(), motionEvent.getY(), motionEvent.getX(1), motionEvent.getY(1))) {
                    bl = true;
                }
            }
            if (bl) {
                this.state = -1;
                this.handler.removeCallbacks(this.zzdsx);
            }
        }
    }

    private final boolean zza(float f, float f2, float f3, float f4) {
        return Math.abs(this.zzdsv.x - f) < (float)this.zzdsu && Math.abs(this.zzdsv.y - f2) < (float)this.zzdsu && Math.abs(this.zzdsw.x - f3) < (float)this.zzdsu && Math.abs(this.zzdsw.y - f4) < (float)this.zzdsu;
    }

    public final void showDialog() {
        try {
            zzaun zzaun2 = this;
            if (!(zzaun2.zzlk instanceof Activity)) {
                zzatm.zzet((String)"Can not create dialog without Activity Context");
                return;
            }
            String string2 = !TextUtils.isEmpty((CharSequence)zzp.zzki().zzvv()) ? "Creative Preview (Enabled)" : "Creative Preview";
            String string3 = zzp.zzki().zzvw() ? "Troubleshooting (Enabled)" : "Troubleshooting";
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = zzaun.zza(arrayList, "Ad Information", true);
            int n2 = zzaun.zza(arrayList, string2, true);
            int n3 = zzaun.zza(arrayList, string3, true);
            AlertDialog.Builder builder = new AlertDialog.Builder(zzaun2.zzlk, zzp.zzka().zzvp());
            builder.setTitle((CharSequence)"Select a Debug Mode").setItems((CharSequence[])arrayList.toArray(new String[0]), (DialogInterface.OnClickListener)new zzaup(zzaun2, n, n2, n3));
            builder.create().show();
            return;
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzatm.zza("", badTokenException);
            return;
        }
    }

    public final void setAdUnitId(String string2) {
        this.zzccm = string2;
    }

    public final void zzr(String string2) {
        this.zzbnh = string2;
    }

    public final void zzej(String string2) {
        this.zzdhs = string2;
    }

    public final void zzek(String string2) {
        this.zzdky = string2;
    }

    private static int zza(List<String> list, String string2, boolean bl) {
        list.add(string2);
        return list.size() - 1;
    }

    public final String toString() {
        return new StringBuilder(100).append("{Dialog: ").append(this.zzdhs).append(",DebugSignal: ").append(this.zzdky).append(",AFMA Version: ").append(this.zzbnh).append(",Ad Unit ID: ").append(this.zzccm).append("}").toString();
    }

    final /* synthetic */ void zzvs() {
        zzp.zzki().zza(this.zzlk, this.zzccm, this.zzbnh, this.zzdky);
    }

    final /* synthetic */ void zzvt() {
        zzp.zzki().zze(this.zzlk, this.zzccm, this.zzbnh);
    }

    final /* synthetic */ void zza(String string2, DialogInterface dialogInterface, int n) {
        zzp.zzjy();
        zzatv.zza(this.zzlk, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ void zza(int var1_1, int var2_2, int var3_3, DialogInterface var4_4, int var5_5) {
        block6: {
            if (var5_5 != var1_1) break block6;
            var6_6 = this;
            if (!(var6_6.zzlk instanceof Activity)) {
                zzatm.zzet((String)"Can not create dialog without Activity Context");
                return;
            }
            var9_9 = var6_6.zzdhs;
            if (TextUtils.isEmpty((CharSequence)var9_9)) ** GOTO lbl-1000
            var9_9 = var9_9.replaceAll("\\+", "%20");
            var10_10 = new Uri.Builder().encodedQuery(var9_9).build();
            var11_11 = new StringBuilder();
            zzp.zzjy();
            var12_12 = zzatv.zzi(var10_10);
            for (String var14_14 : var12_12.keySet()) {
                var11_11.append(var14_14).append(" = ").append(var12_12.get(var14_14)).append("\n\n");
            }
            var13_13 = var11_11.toString().trim();
            if (!TextUtils.isEmpty((CharSequence)var13_13)) {
                v0 = var13_13;
            } else lbl-1000:
            // 2 sources

            {
                v0 = "No debug information";
            }
            var7_15 = v0;
            var8_16 = new AlertDialog.Builder(var6_6.zzlk);
            var8_16.setMessage((CharSequence)var7_15);
            var8_16.setTitle((CharSequence)"Ad Information");
            var8_16.setPositiveButton((CharSequence)"Share", (DialogInterface.OnClickListener)new zzauo(var6_6, var7_15));
            var8_16.setNegativeButton((CharSequence)"Close", zzaur.zzdtb);
            var8_16.create().show();
            return;
        }
        if (var5_5 == var2_2) {
            var6_7 = this;
            zzatm.zzdv((String)"Debug mode [Creative Preview] selected.");
            zzawx.zzdvx.execute(new zzauq(var6_7));
            return;
        }
        if (var5_5 == var3_3) {
            var6_8 = this;
            zzatm.zzdv((String)"Debug mode [Troubleshooting] selected.");
            zzawx.zzdvx.execute(new zzaut(var6_8));
        }
    }

    final /* synthetic */ void zzvu() {
        this.state = 4;
        this.showDialog();
    }
}

