/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzauv;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaus {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String zzdtc = "";
    @GuardedBy(value="lock")
    private String zzdtd = "";
    @GuardedBy(value="lock")
    private boolean zzdte = false;
    @VisibleForTesting
    private String zzdtf = "";

    public final void zze(Context context, String string2, String string3) {
        if (!this.zzf(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzdtf)) {
            zzatm.zzdv((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
            return;
        }
        if ("1".equals(this.zzdtf)) {
            zzatm.zzdv((String)"The app is not linked for creative preview.");
            this.zzi(context, string2, string3);
            return;
        }
        if ("0".equals(this.zzdtf)) {
            zzatm.zzdv((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public final void zza(Context context, String string2, String string3, @Nullable String string4) {
        boolean bl = this.zzvw();
        if (this.zzg(context, string2, string3)) {
            if (!bl && !TextUtils.isEmpty((CharSequence)string4)) {
                this.zzc(context, string3, string4, string2);
            }
            zzatm.zzdv((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzi(context, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzf(Context context, String string2, String string3) {
        String string4;
        Object object = zzyt.zzcpu;
        String string5 = zzaus.zzh(context, this.zzd(context, (String)zzuo.zzoj().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzatm.zzdv((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzdtf = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzatm.zzd((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        String string6 = string4;
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdtd = string6;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzg(Context context, String string2, String string3) {
        String string4;
        Object object = zzyt.zzcpv;
        String string5 = zzaus.zzh(context, this.zzd(context, (String)zzuo.zzoj().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzatm.zzdv((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            string4 = new JSONObject(string5).optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzatm.zzd((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdte = bl;
        }
        return bl;
    }

    @VisibleForTesting
    private static String zzh(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzp.zzjy().zzr(context, string3));
        zzdcp<String> zzdcp2 = new zzave(context).zzc(string2, hashMap);
        try {
            zzyi zzyi2 = zzyt.zzcpx;
            return (String)zzdcp2.get(((Integer)zzuo.zzoj().zzd(zzyi2)).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzatm.zzc((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzdcp2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzatm.zzc((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzdcp2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzatm.zzc((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private final void zzi(Context context, String string2, String string3) {
        zzp.zzjy();
        zzyi zzyi2 = zzyt.zzcpt;
        zzatv.zza(context, this.zzd(context, (String)zzuo.zzoj().zzd(zzyi2), string2, string3));
    }

    public final boolean zzb(Context context, String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string3) || !zzp.zzki().zzvw()) {
            return false;
        }
        zzatm.zzdv((String)"Sending troubleshooting signals to the server.");
        this.zzc(context, string2, string3, string4);
        return true;
    }

    private final void zzc(Context context, String string2, String string3, String string4) {
        zzyi zzyi2 = zzyt.zzcpw;
        Uri.Builder builder = this.zzd(context, (String)zzuo.zzoj().zzd(zzyi2), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzp.zzjy();
        zzatv.zzb(context, string2, builder.build().toString());
    }

    private final Uri zzd(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzbe(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzbe(Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzdtc)) {
                zzp.zzjy();
                this.zzdtc = zzatv.zzs(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzdtc)) {
                    zzp.zzjy();
                    this.zzdtc = zzatv.zzvi();
                    zzp.zzjy();
                    zzatv.zzc(context, "debug_signals_id.txt", this.zzdtc);
                }
            }
            return this.zzdtc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzvv() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdtd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzvw() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdte;
        }
    }

    @VisibleForTesting
    private final void zza(Context context, String string2, boolean bl, boolean bl2) {
        if (!(context instanceof Activity)) {
            zzatm.zzet((String)"Can not create dialog without Activity Context");
            return;
        }
        zzatv.zzdsk.post((Runnable)new zzauv(this, context, string2, bl, bl2));
    }
}

