/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzaxq;
import com.google.android.gms.internal.ads.zzaxs;
import com.google.android.gms.internal.ads.zzaxt;
import com.google.android.gms.internal.ads.zzaxu;
import com.google.android.gms.internal.ads.zzaxv;
import com.google.android.gms.internal.ads.zzaxw;
import com.google.android.gms.internal.ads.zzaxx;
import com.google.android.gms.internal.ads.zzaxy;
import com.google.android.gms.internal.ads.zzaxz;
import com.google.android.gms.internal.ads.zzaya;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayr;
import com.google.android.gms.internal.ads.zzays;
import com.google.android.gms.internal.ads.zzrl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=14)
public final class zzaxr
extends zzaya
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzdwp = new HashMap<Integer, String>();
    private final zzays zzdwq;
    private final boolean zzdwr;
    private int zzdws = 0;
    private int zzdwt = 0;
    private MediaPlayer zzdwu;
    private Uri zzdwv;
    private int zzdww;
    private int zzdwx;
    private int zzdwy;
    private int zzdwz;
    private int zzdxa;
    private zzayr zzdxb;
    private boolean zzdxc;
    private int zzdxd;
    private zzayb zzdxe;

    public zzaxr(Context context, boolean bl, boolean bl2, zzayq zzayq2, zzays zzays2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzdwq = zzays2;
        this.zzdxc = bl;
        this.zzdwr = bl2;
        this.zzdwq.zzb(this);
    }

    @Override
    public final String zzwm() {
        String string2 = String.valueOf(this.zzdxc ? " spherical" : "");
        if (string2.length() != 0) {
            return "MediaPlayer".concat(string2);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzayb zzayb2) {
        this.zzdxe = zzayb2;
    }

    @Override
    public final void setVideoPath(String string2) {
        Uri uri = Uri.parse((String)string2);
        zzaxr zzaxr2 = this;
        zzrl zzrl2 = zzrl.zze(uri);
        if (zzrl2 == null || zzrl2.url != null) {
            zzaxr2.zzdwv = zzrl2 == null ? uri : Uri.parse((String)zzrl2.url);
            zzaxr2.zzdxd = 0;
            zzaxr2.zzwn();
            zzaxr2.requestLayout();
            zzaxr2.invalidate();
        }
    }

    @Override
    public final void stop() {
        zzatm.zzdy("AdMediaPlayerView stop");
        if (this.zzdwu != null) {
            this.zzdwu.stop();
            this.zzdwu.release();
            this.zzdwu = null;
            this.zzcr(0);
            this.zzdwt = 0;
        }
        this.zzdwq.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzatm.zzdy(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzdww = mediaPlayer.getVideoWidth();
        this.zzdwx = mediaPlayer.getVideoHeight();
        if (this.zzdww != 0 && this.zzdwx != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzatm.zzdy("AdMediaPlayerView prepared");
        this.zzcr(2);
        this.zzdwq.zzei();
        zzatv.zzdsk.post((Runnable)new zzaxt(this));
        this.zzdww = mediaPlayer.getVideoWidth();
        this.zzdwx = mediaPlayer.getVideoHeight();
        if (this.zzdxd != 0) {
            ((zzaya)this).seekTo(this.zzdxd);
        }
        this.zzwo();
        int n = this.zzdww;
        int n2 = this.zzdwx;
        zzatm.zzet((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzdwt == 3) {
            ((zzaya)this).play();
        }
        ((zzaya)this).zzwq();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzatm.zzdy("AdMediaPlayerView completion");
        this.zzcr(5);
        this.zzdwt = 5;
        zzatv.zzdsk.post((Runnable)new zzaxs(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdwp.get(n);
        String string3 = zzdwp.get(n2);
        zzatm.zzdy(new StringBuilder(37 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string2).append(":").append(string3).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = zzdwp.get(n);
        String string3 = zzdwp.get(n2);
        zzatm.zzeu((String)new StringBuilder(38 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string2).append(":").append(string3).toString());
        this.zzcr(-1);
        this.zzdwt = -1;
        zzatv.zzdsk.post((Runnable)new zzaxv(this, string2, string3));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzdwy = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzatm.zzdy("AdMediaPlayerView surface created");
        this.zzwn();
        zzatv.zzdsk.post((Runnable)new zzaxu(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzatm.zzdy("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzdwt == 3;
        boolean bl3 = bl = this.zzdww == n && this.zzdwx == n2;
        if (this.zzdwu != null && bl2 && bl) {
            if (this.zzdxd != 0) {
                ((zzaya)this).seekTo(this.zzdxd);
            }
            ((zzaya)this).play();
        }
        if (this.zzdxb != null) {
            this.zzdxb.zzl(n, n2);
        }
        zzatv.zzdsk.post((Runnable)new zzaxx(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzatm.zzdy("AdMediaPlayerView surface destroyed");
        if (this.zzdwu != null && this.zzdxd == 0) {
            this.zzdxd = this.zzdwu.getCurrentPosition();
        }
        if (this.zzdxb != null) {
            this.zzdxb.zzxd();
        }
        zzatv.zzdsk.post((Runnable)new zzaxw(this));
        this.zzam(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzdwq.zzc(this);
        this.zzdxk.zza(surfaceTexture, this.zzdxe);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzatm.zzdy(new StringBuilder(58).append("AdMediaPlayerView window visibility changed to ").append(n).toString());
        zzatv.zzdsk.post((Runnable)new zzaxq(this, n));
        super.onWindowVisibilityChanged(n);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzaxr.getDefaultSize((int)this.zzdww, (int)n);
        int n4 = zzaxr.getDefaultSize((int)this.zzdwx, (int)n2);
        if (this.zzdww > 0 && this.zzdwx > 0 && this.zzdxb == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzdww * n4 < n3 * this.zzdwx) {
                    n3 = n4 * this.zzdww / this.zzdwx;
                } else if (this.zzdww * n4 > n3 * this.zzdwx) {
                    n4 = n3 * this.zzdwx / this.zzdww;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzdwx / this.zzdww;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzdww / this.zzdwx;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzdww;
                n4 = this.zzdwx;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzdww / this.zzdwx;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzdwx / this.zzdww;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzdxb != null) {
            this.zzdxb.zzl(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdwz > 0 && this.zzdwz != n3 || this.zzdxa > 0 && this.zzdxa != n4) {
                this.zzwo();
            }
            this.zzdwz = n3;
            this.zzdxa = n4;
        }
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("@").append(string3).toString();
    }

    private final void zzwn() {
        zzatm.zzdy("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzdwv == null || surfaceTexture == null) {
            return;
        }
        this.zzam(false);
        try {
            Surface surface;
            zzp.zzko();
            this.zzdwu = new MediaPlayer();
            this.zzdwu.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzdwu.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzdwu.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzdwu.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzdwu.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzdwu.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzdwy = 0;
            if (this.zzdxc) {
                this.zzdxb = new zzayr(this.getContext());
                this.zzdxb.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzdxb.start();
                surface = this.zzdxb.zzxe();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzdxb.zzxd();
                    this.zzdxb = null;
                }
            }
            this.zzdwu.setDataSource(this.getContext(), this.zzdwv);
            zzp.zzkp();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzdwu.setSurface(surface);
            this.zzdwu.setAudioStreamType(3);
            this.zzdwu.setScreenOnWhilePlaying(true);
            this.zzdwu.prepareAsync();
            this.zzcr(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(this.zzdwv);
            zzatm.zzd((String)new StringBuilder(36 + String.valueOf(string2).length()).append("Failed to initialize MediaPlayer at ").append(string2).toString(), (Throwable)exception);
            this.onError(this.zzdwu, 1, 0);
            return;
        }
    }

    private final void zzwo() {
        if (!this.zzdwr) {
            return;
        }
        if (this.zzwp() && this.zzdwu.getCurrentPosition() > 0 && this.zzdwt != 3) {
            zzatm.zzdy("AdMediaPlayerView nudging MediaPlayer");
            this.zzd(0.0f);
            this.zzdwu.start();
            int n = this.zzdwu.getCurrentPosition();
            long l = zzp.zzkf().currentTimeMillis();
            while (this.zzwp() && this.zzdwu.getCurrentPosition() == n && zzp.zzkf().currentTimeMillis() - l <= 250L) {
            }
            this.zzdwu.pause();
            ((zzaya)this).zzwq();
        }
    }

    private final void zzam(boolean bl) {
        zzatm.zzdy("AdMediaPlayerView release");
        if (this.zzdxb != null) {
            this.zzdxb.zzxd();
            this.zzdxb = null;
        }
        if (this.zzdwu != null) {
            this.zzdwu.reset();
            this.zzdwu.release();
            this.zzdwu = null;
            this.zzcr(0);
            if (bl) {
                this.zzdwt = 0;
                this.zzdwt = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzatm.zzdy("AdMediaPlayerView play");
        if (this.zzwp()) {
            this.zzdwu.start();
            this.zzcr(3);
            this.zzdxk.zzws();
            zzatv.zzdsk.post((Runnable)new zzaxz(this));
        }
        this.zzdwt = 3;
    }

    @Override
    public final void pause() {
        zzatm.zzdy("AdMediaPlayerView pause");
        if (this.zzwp() && this.zzdwu.isPlaying()) {
            this.zzdwu.pause();
            this.zzcr(4);
            zzatv.zzdsk.post((Runnable)new zzaxy(this));
        }
        this.zzdwt = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzwp()) {
            return this.zzdwu.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzwp()) {
            return this.zzdwu.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzatm.zzdy(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzwp()) {
            this.zzdwu.seekTo(n);
            this.zzdxd = 0;
            return;
        }
        this.zzdxd = n;
    }

    private final boolean zzwp() {
        return this.zzdwu != null && this.zzdws != -1 && this.zzdws != 0 && this.zzdws != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzdxb != null) {
            this.zzdxb.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzdwu != null) {
            return this.zzdwu.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzdwu != null) {
            return this.zzdwu.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzwq() {
        this.zzd(this.zzdxl.getVolume());
    }

    private final void zzd(float f) {
        if (this.zzdwu != null) {
            try {
                this.zzdwu.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzatm.zzeu((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzcr(int n) {
        if (n == 3) {
            this.zzdwq.zzxg();
            this.zzdxl.zzxg();
        } else if (this.zzdws == 3) {
            this.zzdwq.zzxh();
            this.zzdxl.zzxh();
        }
        this.zzdws = n;
    }

    final /* synthetic */ void zzcs(int n) {
        if (this.zzdxe != null) {
            this.zzdxe.onWindowVisibilityChanged(n);
        }
    }

    static /* synthetic */ zzayb zza(zzaxr zzaxr2) {
        return zzaxr2.zzdxe;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzdwp.put(-1004, "MEDIA_ERROR_IO");
            zzdwp.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzdwp.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzdwp.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzdwp.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzdwp.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzdwp.put(1, "MEDIA_ERROR_UNKNOWN");
        zzdwp.put(1, "MEDIA_INFO_UNKNOWN");
        zzdwp.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzdwp.put(701, "MEDIA_INFO_BUFFERING_START");
        zzdwp.put(702, "MEDIA_INFO_BUFFERING_END");
        zzdwp.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzdwp.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzdwp.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzdwp.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzdwp.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

