/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzaya;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzaye;
import com.google.android.gms.internal.ads.zzayf;
import com.google.android.gms.internal.ads.zzayg;
import com.google.android.gms.internal.ads.zzayh;
import com.google.android.gms.internal.ads.zzayj;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzh;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzayc
extends FrameLayout
implements zzayb {
    private final zzayt zzdxm;
    private final FrameLayout zzdxn;
    private final zzzh zzdxo;
    private final zzayv zzdxp;
    private final long zzdxq;
    @Nullable
    private zzaya zzdxr;
    private boolean zzdxs;
    private boolean zzdxt;
    private boolean zzdxu;
    private boolean zzdxv;
    private long zzdxw;
    private long zzdxx;
    private String zzdxy;
    private String[] zzdxz;
    private Bitmap zzdya;
    private ImageView zzdyb;
    private boolean zzdyc;

    public static void zza(zzayt zzayt2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzayt2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzayt zzayt2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzayt2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzayt zzayt2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzayt2.zza("onVideoEvent", hashMap);
    }

    public zzayc(Context context, zzayt zzayt2, int n, boolean bl, zzzh zzzh2, zzayq zzayq2) {
        super(context);
        zzyi zzyi2;
        this.zzdxm = zzayt2;
        this.zzdxo = zzzh2;
        this.zzdxn = new FrameLayout(context);
        this.addView((View)this.zzdxn, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)zzayt2.zzxm());
        this.zzdxr = zzayt2.zzxm().zzbkp.zza(context, zzayt2, n, bl, zzzh2, zzayq2);
        if (this.zzdxr != null) {
            this.zzdxn.addView((View)this.zzdxr, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzyi2 = zzyt.zzchj;
            if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
                this.zzwy();
            }
        }
        this.zzdyb = new ImageView(context);
        zzyi2 = zzyt.zzchn;
        this.zzdxq = (Long)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzchl;
        this.zzdxv = (Boolean)zzuo.zzoj().zzd(zzyi2);
        if (this.zzdxo != null) {
            this.zzdxo.zzj("spinner_used", this.zzdxv ? "1" : "0");
        }
        this.zzdxp = new zzayv(this);
        if (this.zzdxr != null) {
            this.zzdxr.zza(this);
        }
        if (this.zzdxr == null) {
            this.zzn("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzdxn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzc(String string2, String[] stringArray) {
        this.zzdxy = string2;
        this.zzdxz = stringArray;
    }

    public final void zza(float f, float f2) {
        if (this.zzdxr != null) {
            this.zzdxr.zza(f, f2);
        }
    }

    public final void zzhh() {
        if (this.zzdxr == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzdxy)) {
            this.zzdxr.zzb(this.zzdxy, this.zzdxz);
            return;
        }
        this.zzd("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzdxr == null) {
            return;
        }
        this.zzdxr.pause();
    }

    public final void play() {
        if (this.zzdxr == null) {
            return;
        }
        this.zzdxr.play();
    }

    public final void seekTo(int n) {
        if (this.zzdxr == null) {
            return;
        }
        this.zzdxr.seekTo(n);
    }

    public final void zzww() {
        if (this.zzdxr == null) {
            return;
        }
        zzaya zzaya2 = this.zzdxr;
        zzaya2.zzdxl.setMuted(true);
        zzaya2.zzwq();
    }

    public final void zzwx() {
        if (this.zzdxr == null) {
            return;
        }
        zzaya zzaya2 = this.zzdxr;
        zzaya2.zzdxl.setMuted(false);
        zzaya2.zzwq();
    }

    public final void setVolume(float f) {
        if (this.zzdxr == null) {
            return;
        }
        float f2 = f;
        zzaya zzaya2 = this.zzdxr;
        zzaya2.zzdxl.setVolume(f2);
        zzaya2.zzwq();
    }

    public final void zzct(int n) {
        this.zzdxr.zzct(n);
    }

    public final void zzcu(int n) {
        this.zzdxr.zzcu(n);
    }

    public final void zzcv(int n) {
        this.zzdxr.zzcv(n);
    }

    public final void zzcw(int n) {
        this.zzdxr.zzcw(n);
    }

    public final void zzcx(int n) {
        this.zzdxr.zzcx(n);
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzdxr == null) {
            return;
        }
        this.zzdxr.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzwy() {
        if (this.zzdxr == null) {
            return;
        }
        Context context = this.zzdxr.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzdxr.zzwm());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzdxn.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzdxn.bringChildToFront((View)textView);
    }

    @Override
    public final void zzwr() {
        this.zzdxp.resume();
        zzatv.zzdsk.post((Runnable)new zzayh(this));
    }

    @Override
    public final void zzei() {
        if (this.zzdxr == null) {
            return;
        }
        if (this.zzdxx == 0L) {
            float f = (float)this.zzdxr.getDuration() / 1000.0f;
            int n = this.zzdxr.getVideoWidth();
            int n2 = this.zzdxr.getVideoHeight();
            this.zzd("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzws() {
        zzayc zzayc2 = this;
        if (zzayc2.zzdxm.zzxl() != null && !zzayc2.zzdxt) {
            WindowManager.LayoutParams layoutParams = zzayc2.zzdxm.zzxl().getWindow().getAttributes();
            boolean bl = zzayc2.zzdxu = (layoutParams.flags & 0x80) != 0;
            if (!zzayc2.zzdxu) {
                zzayc2.zzdxm.zzxl().getWindow().addFlags(128);
                zzayc2.zzdxt = true;
            }
        }
        this.zzdxs = true;
    }

    @Override
    public final void onPaused() {
        this.zzd("pause", new String[0]);
        this.zzxb();
        this.zzdxs = false;
    }

    @Override
    public final void zzwt() {
        this.zzd("ended", new String[0]);
        this.zzxb();
    }

    @Override
    public final void zzn(String string2, @Nullable String string3) {
        this.zzd("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzwu() {
        zzayc zzayc2 = this;
        if (zzayc2.zzdyc && zzayc2.zzdya != null && !zzayc2.zzxa()) {
            zzayc2.zzdyb.setImageBitmap(zzayc2.zzdya);
            zzayc2.zzdyb.invalidate();
            zzayc2.zzdxn.addView((View)zzayc2.zzdyb, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzayc2.zzdxn.bringChildToFront((View)zzayc2.zzdyb);
        }
        this.zzdxp.pause();
        this.zzdxx = this.zzdxw;
        zzatv.zzdsk.post((Runnable)new zzayg(this));
    }

    public final void destroy() {
        this.zzdxp.pause();
        if (this.zzdxr != null) {
            this.zzdxr.stop();
        }
        this.zzxb();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzdxp.pause();
            if (this.zzdxr != null) {
                zzaya zzaya2;
                zzaya zzaya3 = zzaya2 = this.zzdxr;
                zzaya3.getClass();
                zzawx.zzdwa.execute(zzayf.zza(zzaya3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzwz() {
        if (this.zzdxr == null) {
            return;
        }
        long l = this.zzdxr.getCurrentPosition();
        if (this.zzdxw != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zzd("timeupdate", "time", String.valueOf(f));
            this.zzdxw = l;
        }
    }

    @Override
    public final void zzwv() {
        zzayc zzayc2;
        if (this.zzdxs && (zzayc2 = this).zzxa()) {
            zzayc2.zzdxn.removeView((View)zzayc2.zzdyb);
        }
        zzayc2 = this;
        if (zzayc2.zzdya != null) {
            long l = zzp.zzkf().elapsedRealtime();
            if (zzayc2.zzdxr.getBitmap(zzayc2.zzdya) != null) {
                zzayc2.zzdyc = true;
            }
            long l2 = zzp.zzkf().elapsedRealtime() - l;
            if (zzatm.zzuq()) {
                zzatm.zzdy(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzayc2.zzdxq) {
                zzatm.zzeu((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzayc2.zzdxv = false;
                zzayc2.zzdya = null;
                if (zzayc2.zzdxo != null) {
                    zzayc2.zzdxo.zzj("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzj(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzayc zzayc2 = this;
        if (zzayc2.zzdxv) {
            zzyi zzyi2 = zzyt.zzchm;
            n4 = Math.max(n4 / (Integer)zzuo.zzoj().zzd(zzyi2), 1);
            zzyi2 = zzyt.zzchm;
            n3 = Math.max(n3 / (Integer)zzuo.zzoj().zzd(zzyi2), 1);
            if (zzayc2.zzdya == null || zzayc2.zzdya.getWidth() != n4 || zzayc2.zzdya.getHeight() != n3) {
                zzayc2.zzdya = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzayc2.zzdyc = false;
            }
        }
    }

    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzdxp.resume();
        } else {
            this.zzdxp.pause();
            this.zzdxx = this.zzdxw;
        }
        zzatv.zzdsk.post((Runnable)new zzaye(this, bl));
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zzdxp.resume();
            bl = true;
        } else {
            this.zzdxp.pause();
            this.zzdxx = this.zzdxw;
            bl = false;
        }
        zzatv.zzdsk.post((Runnable)new zzayj(this, bl));
    }

    private final boolean zzxa() {
        return this.zzdyb.getParent() != null;
    }

    private final void zzd(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzdxm.zza("onVideoEvent", hashMap);
    }

    private final void zzxb() {
        if (this.zzdxm.zzxl() == null) {
            return;
        }
        if (this.zzdxt && !this.zzdxu) {
            this.zzdxm.zzxl().getWindow().clearFlags(128);
            this.zzdxt = false;
        }
    }

    final /* synthetic */ void zzan(boolean bl) {
        this.zzd("windowFocusChanged", "hasWindowFocus", String.valueOf(bl));
    }

    static /* synthetic */ void zza(zzayc zzayc2, String string2, String[] stringArray) {
        zzayc2.zzd(string2, stringArray);
    }
}

