/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzayo;
import com.google.android.gms.internal.ads.zzayp;
import com.google.android.gms.internal.ads.zzczj;
import javax.annotation.concurrent.GuardedBy;

final class zzaym
implements SensorEventListener {
    private final SensorManager zzdyn;
    private final Object zzdyo;
    private final Display zzdyp;
    private final float[] zzdyq;
    private final float[] zzdyr;
    @GuardedBy(value="sensorThreadLock")
    private float[] zzdys;
    private Handler zzdyt;
    private zzayo zzdyu;

    zzaym(Context context) {
        this.zzdyn = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzdyp = windowManager.getDefaultDisplay();
        this.zzdyq = new float[9];
        this.zzdyr = new float[9];
        this.zzdyo = new Object();
    }

    final void start() {
        if (this.zzdyt != null) {
            return;
        }
        Sensor sensor = this.zzdyn.getDefaultSensor(11);
        if (sensor == null) {
            zzatm.zzes((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzdyt = new zzczj(handlerThread.getLooper());
        if (!this.zzdyn.registerListener((SensorEventListener)this, sensor, 0, this.zzdyt)) {
            zzatm.zzes((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzdyt == null) {
            return;
        }
        this.zzdyn.unregisterListener((SensorEventListener)this);
        this.zzdyt.post((Runnable)new zzayp(this));
        this.zzdyt = null;
    }

    final void zza(zzayo zzayo2) {
        this.zzdyu = zzayo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzaym zzaym2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzaym2.zzdyo;
            synchronized (object) {
                if (zzaym2.zzdys == null) {
                    zzaym2.zzdys = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzaym2.zzdyq, (float[])fArray);
            switch (zzaym2.zzdyp.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzaym2.zzdyq, (int)2, (int)129, (float[])zzaym2.zzdyr);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzaym2.zzdyq, (int)129, (int)130, (float[])zzaym2.zzdyr);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzaym2.zzdyq, (int)130, (int)1, (float[])zzaym2.zzdyr);
                    break;
                }
                default: {
                    System.arraycopy(zzaym2.zzdyq, 0, zzaym2.zzdyr, 0, 9);
                }
            }
            zzaym2.zzk(1, 3);
            zzaym2.zzk(2, 6);
            zzaym2.zzk(5, 7);
            Object object2 = zzaym2.zzdyo;
            synchronized (object2) {
                System.arraycopy(zzaym2.zzdyr, 0, zzaym2.zzdys, 0, 9);
            }
            if (zzaym2.zzdyu != null) {
                zzaym2.zzdyu.zzsp();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzdyo;
        synchronized (object) {
            if (this.zzdys == null) {
                return false;
            }
            System.arraycopy(this.zzdys, 0, fArray, 0, this.zzdys.length);
            return true;
        }
    }

    private final void zzk(int n, int n2) {
        float f = this.zzdyr[n];
        this.zzdyr[n] = this.zzdyr[n2];
        this.zzdyr[n2] = f;
    }
}

