/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzaym;
import com.google.android.gms.internal.ads.zzayo;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@TargetApi(value=14)
public final class zzayr
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzayo {
    private static final float[] zzdzh = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzaym zzdzi;
    private final float[] zzdys;
    private final float[] zzdzj;
    private final float[] zzdzk;
    private final float[] zzdzl;
    private final float[] zzdzm;
    private final float[] zzdzn;
    private final float[] zzdzo;
    private float zzdzp;
    private float zzdzq;
    private float zzdzr;
    private int height;
    private int width;
    private SurfaceTexture zzdzs;
    private SurfaceTexture zzdzt;
    private int zzdzu;
    private int zzdzv;
    private int zzdzw;
    private FloatBuffer zzdzx = ByteBuffer.allocateDirect(zzdzh.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzdzy;
    private final Object zzdzz;
    private EGL10 zzeaa;
    private EGLDisplay zzeab;
    private EGLContext zzeac;
    private EGLSurface zzead;
    private volatile boolean zzeae;
    private volatile boolean zzeaf;

    public zzayr(Context context) {
        super("SphericalVideoProcessor");
        this.zzdzx.put(zzdzh).position(0);
        this.zzdys = new float[9];
        this.zzdzj = new float[9];
        this.zzdzk = new float[9];
        this.zzdzl = new float[9];
        this.zzdzm = new float[9];
        this.zzdzn = new float[9];
        this.zzdzo = new float[9];
        this.zzdzp = Float.NaN;
        this.zzdzi = new zzaym(context);
        this.zzdzi.zza(this);
        this.zzdzy = new CountDownLatch(1);
        this.zzdzz = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.zzdzt = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzl(int n, int n2) {
        Object object = this.zzdzz;
        synchronized (object) {
            this.width = n;
            this.height = n2;
            this.zzeae = true;
            this.zzdzz.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzxd() {
        Object object = this.zzdzz;
        synchronized (object) {
            this.zzeaf = true;
            this.zzdzt = null;
            this.zzdzz.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzxe() {
        if (this.zzdzt == null) {
            return null;
        }
        try {
            this.zzdzy.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzdzs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzdzw;
        Object object = this.zzdzz;
        synchronized (object) {
            this.zzdzz.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsp() {
        Object object = this.zzdzz;
        synchronized (object) {
            this.zzdzz.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzyi zzyi2;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        if (this.zzdzt == null) {
            zzatm.zzes((String)"SphericalVideoProcessor started with no output texture.");
            this.zzdzy.countDown();
            return;
        }
        zzayr zzayr2 = this;
        this.zzeaa = (EGL10)EGLContext.getEGL();
        zzayr2.zzeab = zzayr2.zzeaa.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzayr2.zzeab == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzayr2.zzeaa.eglInitialize(zzayr2.zzeab, nArray)) {
                bl2 = false;
            } else {
                object3 = zzayr2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                object2 = new int[1];
                object = ((zzayr)object3).zzeaa.eglChooseConfig(((zzayr)object3).zzeab, nArray2, eGLConfigArray, 1, (int[])object2) && object2[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzayr2.zzeac = zzayr2.zzeaa.eglCreateContext(zzayr2.zzeab, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzayr2.zzeac == null || zzayr2.zzeac == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzayr2.zzead = zzayr2.zzeaa.eglCreateWindowSurface(zzayr2.zzeab, (EGLConfig)object, (Object)zzayr2.zzdzt, null);
                        bl2 = zzayr2.zzead == null || zzayr2.zzead == EGL10.EGL_NO_SURFACE ? false : zzayr2.zzeaa.eglMakeCurrent(zzayr2.zzeab, zzayr2.zzead, zzayr2.zzead, zzayr2.zzeac);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzayr2 = this;
        object2 = zzayr2;
        zzyi zzyi3 = zzyi2 = zzyt.zzcln;
        if (!((String)zzuo.zzoj().zzd(zzyi3)).equals(zzyi2.zzpm())) {
            zzyi3 = zzyi2;
            string2 = (String)zzuo.zzoj().zzd(zzyi3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzayr.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzyi3 = zzyi2 = zzyt.zzclo;
            if (!((String)zzuo.zzoj().zzd(zzyi3)).equals(zzyi2.zzpm())) {
                zzyi3 = zzyi2;
                string3 = (String)zzuo.zzoj().zzd(zzyi3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzayr.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzayr.zzey("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzayr.zzey("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzayr.zzey("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzayr.zzey("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzayr.zzey("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzayr.zzey("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzayr.zzey("validateProgram");
                    }
                }
                n = n4;
            }
        }
        zzayr2.zzdzu = n;
        GLES20.glUseProgram((int)zzayr2.zzdzu);
        zzayr.zzey("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzayr2.zzdzu, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzayr2.zzdzx);
        zzayr.zzey("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzayr.zzey("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzayr.zzey("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzayr.zzey("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzayr.zzey("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzayr.zzey("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzayr.zzey("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzayr.zzey("texParameteri");
        zzayr2.zzdzv = GLES20.glGetUniformLocation((int)zzayr2.zzdzu, (String)"uVMat");
        object3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzayr2.zzdzv, (int)1, (boolean)false, (float[])object3, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzdzu != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzeaa.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzatm.zzes((String)string6);
            zzp.zzkc().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzxf();
            this.zzdzy.countDown();
            return;
        }
        this.zzdzs = new SurfaceTexture(n7);
        this.zzdzs.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzdzy.countDown();
        this.zzdzi.start();
        try {
            this.zzeae = true;
            while (!this.zzeaf) {
                zzayr2 = this;
                while (zzayr2.zzdzw > 0) {
                    zzayr2.zzdzs.updateTexImage();
                    --zzayr2.zzdzw;
                }
                if (zzayr2.zzdzi.zza(zzayr2.zzdys)) {
                    if (Float.isNaN(zzayr2.zzdzp)) {
                        float[] fArray = zzayr2.zzdys;
                        object2 = new float[]{0.0f, 1.0f, 0.0f};
                        object3 = zzayr2.zzdys;
                        float[] fArray2 = new float[]{(float)(object3[0] * object2[0] + object3[1] * object2[1] + object3[2] * object2[2]), (float)(object3[3] * object2[0] + object3[4] * object2[1] + object3[5] * object2[2]), (float)(object3[6] * object2[0] + object3[7] * object2[1] + object3[8] * object2[2])};
                        zzayr2.zzdzp = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzayr.zzb(zzayr2.zzdzn, zzayr2.zzdzp + zzayr2.zzdzq);
                } else {
                    zzayr.zza(zzayr2.zzdys, -1.5707964f);
                    zzayr.zzb(zzayr2.zzdzn, zzayr2.zzdzq);
                }
                zzayr.zza(zzayr2.zzdzj, 1.5707964f);
                zzayr.zza(zzayr2.zzdzk, zzayr2.zzdzn, zzayr2.zzdzj);
                zzayr.zza(zzayr2.zzdzl, zzayr2.zzdys, zzayr2.zzdzk);
                zzayr.zza(zzayr2.zzdzm, zzayr2.zzdzr);
                zzayr.zza(zzayr2.zzdzo, zzayr2.zzdzm, zzayr2.zzdzl);
                GLES20.glUniformMatrix3fv((int)zzayr2.zzdzv, (int)1, (boolean)false, (float[])zzayr2.zzdzo, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzayr.zzey("drawArrays");
                GLES20.glFinish();
                zzayr2.zzeaa.eglSwapBuffers(zzayr2.zzeab, zzayr2.zzead);
                if (this.zzeae) {
                    zzayr2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzayr2.width, (int)zzayr2.height);
                    zzayr.zzey("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzayr2.zzdzu, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzayr2.zzdzu, (String)"uFOVy");
                    if (zzayr2.width > zzayr2.height) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzayr2.height / (float)zzayr2.width));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzayr2.width / (float)zzayr2.height));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzeae = false;
                }
                try {
                    Object object4 = this.zzdzz;
                    synchronized (object4) {
                        if (!this.zzeaf && !this.zzeae && this.zzdzw == 0) {
                            this.zzdzz.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzatm.zzeu((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzatm.zzc((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzp.zzkc().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzdzi.stop();
            this.zzdzs.setOnFrameAvailableListener(null);
            this.zzdzs = null;
            this.zzxf();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.width > this.height) {
            f4 = 1.7453293f * f / (float)this.width;
            f3 = 1.7453293f * f2 / (float)this.width;
        } else {
            f4 = 1.7453293f * f / (float)this.height;
            f3 = 1.7453293f * f2 / (float)this.height;
        }
        this.zzdzq -= f4;
        this.zzdzr -= f3;
        if (this.zzdzr < -1.5707964f) {
            this.zzdzr = -1.5707964f;
        }
        if (this.zzdzr > 1.5707964f) {
            this.zzdzr = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzayr.zzey("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzayr.zzey("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzayr.zzey("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzayr.zzey("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzayr.zzey("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zzxf() {
        boolean bl = false;
        if (this.zzead != null && this.zzead != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzeaa.eglMakeCurrent(this.zzeab, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzeaa.eglDestroySurface(this.zzeab, this.zzead);
            this.zzead = null;
        }
        if (this.zzeac != null) {
            bl |= this.zzeaa.eglDestroyContext(this.zzeab, this.zzeac);
            this.zzeac = null;
        }
        if (this.zzeab != null) {
            bl |= this.zzeaa.eglTerminate(this.zzeab);
            this.zzeab = null;
        }
        return bl;
    }

    private static void zzey(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

