/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzaya;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayr;
import com.google.android.gms.internal.ads.zzays;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzayy;
import com.google.android.gms.internal.ads.zzayz;
import com.google.android.gms.internal.ads.zzaza;
import com.google.android.gms.internal.ads.zzazb;
import com.google.android.gms.internal.ads.zzazc;
import com.google.android.gms.internal.ads.zzazd;
import com.google.android.gms.internal.ads.zzaze;
import com.google.android.gms.internal.ads.zzazf;
import com.google.android.gms.internal.ads.zzazg;
import com.google.android.gms.internal.ads.zzazh;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbas;
import com.google.android.gms.internal.ads.zzbat;
import com.google.android.gms.internal.ads.zzge;
import java.nio.ByteBuffer;
import java.util.Arrays;

@TargetApi(value=16)
public final class zzayw
extends zzaya
implements TextureView.SurfaceTextureListener,
zzazu {
    private final zzayt zzdxm;
    private final zzays zzdwq;
    private final boolean zzdwr;
    private final zzayq zzeaw;
    private zzayb zzdxe;
    private Surface zzbhq;
    private zzazm zzeax;
    private String zzeay;
    private String[] zzdxz;
    private boolean zzeaz;
    private int zzeba = 1;
    private zzayr zzdxb;
    private final boolean zzdxc;
    private boolean zzebb;
    private boolean zzebc;
    private int zzdww;
    private int zzdwx;
    private int zzdwz;
    private int zzdxa;
    private float zzebd;

    public zzayw(Context context, zzays zzays2, zzayt zzayt2, boolean bl, boolean bl2, zzayq zzayq2) {
        super(context);
        this.zzdwr = bl2;
        this.zzdxm = zzayt2;
        this.zzdwq = zzays2;
        this.zzdxc = bl;
        this.zzeaw = zzayq2;
        this.setSurfaceTextureListener(this);
        this.zzdwq.zzb(this);
    }

    private final zzazm zzxv() {
        return new zzazm(this.zzdxm.getContext(), this.zzeaw);
    }

    private final String zzxw() {
        return zzp.zzjy().zzr(this.zzdxm.getContext(), this.zzdxm.zzxp().zzbnh);
    }

    private final boolean zzxx() {
        return this.zzeax != null && !this.zzeaz;
    }

    private final boolean zzxy() {
        return this.zzxx() && this.zzeba != 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzxz() {
        block9: {
            block10: {
                if (this.zzeax != null) {
                    return;
                }
                if (this.zzeay == null || this.zzbhq == null) {
                    return;
                }
                if (!this.zzeay.startsWith("cache:")) break block10;
                zzbah zzbah2 = this.zzdxm.zzez(this.zzeay);
                if (zzbah2 instanceof zzbas) {
                    zzbas zzbas2 = (zzbas)zzbah2;
                    this.zzeax = zzbas2.zzyp();
                    break block9;
                } else if (zzbah2 instanceof zzbat) {
                    zzbat zzbat2 = (zzbat)zzbah2;
                    String string2 = this.zzxw();
                    ByteBuffer byteBuffer = zzbat2.getByteBuffer();
                    boolean bl = zzbat2.zzyq();
                    String string3 = zzbat2.getUrl();
                    if (string3 == null) {
                        zzatm.zzeu((String)"Stream cache URL is null.");
                        return;
                    }
                    this.zzeax = this.zzxv();
                    this.zzeax.zza(new Uri[]{Uri.parse((String)string3)}, string2, byteBuffer, bl);
                    break block9;
                } else {
                    String string4 = String.valueOf(this.zzeay);
                    zzatm.zzeu((String)(string4.length() != 0 ? "Stream cache miss: ".concat(string4) : new String("Stream cache miss: ")));
                    return;
                }
            }
            this.zzeax = this.zzxv();
            String string5 = this.zzxw();
            Uri[] uriArray = new Uri[this.zzdxz.length];
            for (int i = 0; i < this.zzdxz.length; ++i) {
                uriArray[i] = Uri.parse((String)this.zzdxz[i]);
            }
            this.zzeax.zza(uriArray, string5);
        }
        this.zzeax.zza(this);
        this.zza(this.zzbhq, false);
        this.zzeba = this.zzeax.zzyk().getPlaybackState();
        if (this.zzeba == 3) {
            this.zzya();
        }
    }

    private final void zza(Surface surface, boolean bl) {
        if (this.zzeax != null) {
            this.zzeax.zza(surface, bl);
            return;
        }
        zzatm.zzeu((String)"Trying to set surface before player is initalized.");
    }

    private final void zza(float f, boolean bl) {
        if (this.zzeax != null) {
            this.zzeax.zzb(f, bl);
            return;
        }
        zzatm.zzeu((String)"Trying to set volume before player is initalized.");
    }

    @Override
    public final void zzwq() {
        this.zza(this.zzdxl.getVolume(), false);
    }

    private final void zzya() {
        if (this.zzebb) {
            return;
        }
        this.zzebb = true;
        zzatv.zzdsk.post((Runnable)new zzayz(this));
        ((zzaya)this).zzwq();
        this.zzdwq.zzei();
        if (this.zzebc) {
            ((zzaya)this).play();
        }
    }

    @Override
    public final String zzwm() {
        String string2 = String.valueOf("ExoPlayer/3");
        String string3 = String.valueOf(this.zzdxc ? " spherical" : "");
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    @Override
    public final void zza(zzayb zzayb2) {
        this.zzdxe = zzayb2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzeay = string2;
            this.zzdxz = new String[]{string2};
            this.zzxz();
        }
    }

    @Override
    public final void zzb(String string2, String[] stringArray) {
        if (string2 != null) {
            if (stringArray == null) {
                ((zzaya)this).setVideoPath(string2);
            }
            this.zzeay = string2;
            this.zzdxz = Arrays.copyOf(stringArray, stringArray.length);
            this.zzxz();
        }
    }

    @Override
    public final void play() {
        if (this.zzxy()) {
            if (this.zzeaw.zzdyw) {
                this.zzyc();
            }
            this.zzeax.zzyk().zzf(true);
            this.zzdwq.zzxg();
            this.zzdxl.zzxg();
            this.zzdxk.zzws();
            zzatv.zzdsk.post((Runnable)new zzaza(this));
            return;
        }
        this.zzebc = true;
    }

    @Override
    public final void stop() {
        if (this.zzxx()) {
            this.zzeax.zzyk().stop();
            zzayw zzayw2 = this;
            if (zzayw2.zzeax != null) {
                zzayw2.zza(null, true);
                if (zzayw2.zzeax != null) {
                    zzayw2.zzeax.zza((zzazu)null);
                    zzayw2.zzeax.release();
                    zzayw2.zzeax = null;
                }
                zzayw2.zzeba = 1;
                zzayw2.zzeaz = false;
                zzayw2.zzebb = false;
                zzayw2.zzebc = false;
            }
        }
        this.zzdwq.zzxh();
        this.zzdxl.zzxh();
        this.zzdwq.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzxy()) {
            if (this.zzeaw.zzdyw) {
                this.zzyd();
            }
            this.zzeax.zzyk().zzf(false);
            this.zzdwq.zzxh();
            this.zzdxl.zzxh();
            zzatv.zzdsk.post((Runnable)new zzazd(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzxy()) {
            this.zzeax.zzyk().seekTo(n);
        }
    }

    @Override
    public final void zzct(int n) {
        if (this.zzeax != null) {
            this.zzeax.zzyn().zzda(n);
        }
    }

    @Override
    public final void zzcu(int n) {
        if (this.zzeax != null) {
            this.zzeax.zzyn().zzdb(n);
        }
    }

    @Override
    public final void zzcv(int n) {
        if (this.zzeax != null) {
            this.zzeax.zzyn().zzcv(n);
        }
    }

    @Override
    public final void zzcw(int n) {
        if (this.zzeax != null) {
            this.zzeax.zzyn().zzcw(n);
        }
    }

    @Override
    public final void zzcx(int n) {
        if (this.zzeax != null) {
            this.zzeax.zzcx(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzdxb != null) {
            this.zzdxb.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzxy()) {
            return (int)this.zzeax.zzyk().zzdu();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzxy()) {
            return (int)this.zzeax.zzyk().getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzdww;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzdwx;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzebd != 0.0f && this.zzdxb == null) {
            float f = (float)n3 / (float)n4;
            if (this.zzebd > f) {
                n4 = (int)((float)n3 / this.zzebd);
            }
            if (this.zzebd < f) {
                n3 = (int)((float)n4 * this.zzebd);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzdxb != null) {
            this.zzdxb.zzl(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzdwz > 0 && this.zzdwz != n3 || this.zzdxa > 0 && this.zzdxa != n4) {
                zzge zzge2;
                zzayw zzayw2 = this;
                if (zzayw2.zzdwr && zzayw2.zzxx() && (zzge2 = zzayw2.zzeax.zzyk()).zzdu() > 0L && !zzge2.zzds()) {
                    zzayw2.zza(0.0f, true);
                    zzge2.zzf(true);
                    long l = zzge2.zzdu();
                    long l2 = zzp.zzkf().currentTimeMillis();
                    while (zzayw2.zzxx() && zzge2.zzdu() == l && zzp.zzkf().currentTimeMillis() - l2 <= 250L) {
                    }
                    zzge2.zzf(false);
                    ((zzaya)zzayw2).zzwq();
                }
            }
            this.zzdwz = n3;
            this.zzdxa = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzdxc) {
            this.zzdxb = new zzayr(this.getContext());
            this.zzdxb.zza(surfaceTexture, n, n2);
            this.zzdxb.start();
            SurfaceTexture surfaceTexture2 = this.zzdxb.zzxe();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzdxb.zzxd();
                this.zzdxb = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzbhq = new Surface(surfaceTexture3);
        if (this.zzeax == null) {
            this.zzxz();
        } else {
            this.zza(this.zzbhq, true);
            if (!this.zzeaw.zzdyw) {
                this.zzyc();
            }
        }
        if (this.zzdww == 0 || this.zzdwx == 0) {
            this.zzn(n, n2);
        } else {
            this.zzyb();
        }
        zzatv.zzdsk.post((Runnable)new zzazc(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzdxb != null) {
            this.zzdxb.zzl(n, n2);
        }
        zzatv.zzdsk.post((Runnable)new zzazf(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzdwq.zzc(this);
        this.zzdxk.zza(surfaceTexture, this.zzdxe);
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ((zzaya)this).pause();
        if (this.zzdxb != null) {
            this.zzdxb.zzxd();
            this.zzdxb = null;
        }
        if (this.zzeax != null) {
            this.zzyd();
            if (this.zzbhq != null) {
                this.zzbhq.release();
            }
            this.zzbhq = null;
            this.zza(null, true);
        }
        zzatv.zzdsk.post((Runnable)new zzaze(this));
        return true;
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzatm.zzdy(new StringBuilder(57).append("AdExoPlayerView3 window visibility changed to ").append(n).toString());
        zzatv.zzdsk.post((Runnable)new zzazh(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzb(boolean bl, long l) {
        if (this.zzdxm != null) {
            zzawx.zzdwa.execute(new zzazg(this, bl, l));
        }
    }

    @Override
    public final void zzcy(int n) {
        if (this.zzeba != n) {
            this.zzeba = n;
            switch (n) {
                case 3: {
                    this.zzya();
                    return;
                }
                case 4: {
                    zzayw zzayw2 = this;
                    if (zzayw2.zzeaw.zzdyw) {
                        zzayw2.zzyd();
                    }
                    zzayw2.zzdwq.zzxh();
                    zzayw2.zzdxl.zzxh();
                    zzatv.zzdsk.post((Runnable)new zzayy(zzayw2));
                }
            }
        }
    }

    @Override
    public final void zzm(int n, int n2) {
        this.zzdww = n;
        this.zzdwx = n2;
        this.zzyb();
    }

    @Override
    public final void zza(String string2, Exception exception) {
        Exception exception2 = exception;
        String string3 = string2;
        zzayw zzayw2 = this;
        String string4 = exception2.getClass().getCanonicalName();
        String string5 = exception2.getMessage();
        String string6 = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append("/").append(string4).append(":").append(string5).toString();
        String string7 = String.valueOf(string6);
        zzatm.zzeu((String)(string7.length() != 0 ? "ExoPlayerAdapter error: ".concat(string7) : new String("ExoPlayerAdapter error: ")));
        zzayw2.zzeaz = true;
        if (zzayw2.zzeaw.zzdyw) {
            zzayw2.zzyd();
        }
        zzatv.zzdsk.post((Runnable)new zzazb(zzayw2, string6));
    }

    private final void zzyb() {
        this.zzn(this.zzdww, this.zzdwx);
    }

    private final void zzn(int n, int n2) {
        float f;
        float f2 = f = n2 > 0 ? (float)n / (float)n2 : 1.0f;
        if (this.zzebd != f) {
            this.zzebd = f;
            this.requestLayout();
        }
    }

    private final void zzyc() {
        if (this.zzeax != null) {
            this.zzeax.zzap(true);
        }
    }

    private final void zzyd() {
        if (this.zzeax != null) {
            this.zzeax.zzap(false);
        }
    }

    final /* synthetic */ void zzc(boolean bl, long l) {
        this.zzdxm.zza(bl, l);
    }

    final /* synthetic */ void zzcz(int n) {
        if (this.zzdxe != null) {
            this.zzdxe.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzye() {
        if (this.zzdxe != null) {
            this.zzdxe.zzwu();
        }
    }

    final /* synthetic */ void zzo(int n, int n2) {
        if (this.zzdxe != null) {
            this.zzdxe.zzj(n, n2);
        }
    }

    final /* synthetic */ void zzyf() {
        if (this.zzdxe != null) {
            this.zzdxe.zzwr();
        }
    }

    final /* synthetic */ void zzyg() {
        if (this.zzdxe != null) {
            this.zzdxe.onPaused();
        }
    }

    final /* synthetic */ void zzyh() {
        if (this.zzdxe != null) {
            this.zzdxe.zzws();
        }
    }

    final /* synthetic */ void zzfa(String string2) {
        if (this.zzdxe != null) {
            this.zzdxe.zzn("ExoPlayerAdapter error", string2);
        }
    }

    final /* synthetic */ void zzyi() {
        if (this.zzdxe != null) {
            this.zzdxe.zzwt();
        }
    }

    final /* synthetic */ void zzyj() {
        if (this.zzdxe != null) {
            this.zzdxe.zzei();
        }
    }
}

