/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzazi;
import com.google.android.gms.internal.ads.zznc;
import com.google.android.gms.internal.ads.zzne;
import com.google.android.gms.internal.ads.zznh;
import com.google.android.gms.internal.ads.zzni;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznq;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zzoh;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

final class zzazj
implements zznc {
    private static final Pattern zzbet = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzbeu = new AtomicReference();
    private SSLSocketFactory zzebi = new zzazi(this);
    private final int zzbew;
    private final int zzbex;
    private final String zzbey;
    private final zznk zzbfb;
    private final zznq<? super zzazj> zzbfc;
    private zznh zzbes;
    private HttpURLConnection zzbfd;
    private InputStream zzbfe;
    private boolean zzbff;
    private long zzbfg;
    private long zzbfh;
    private long zzbfi;
    private long zzcc;
    private int zzebj;
    private Set<Socket> zzebk = new HashSet<Socket>();

    zzazj(String string2, zznq<? super zzazj> zznq2, int n, int n2, int n3) {
        this.zzbey = zznt.checkNotEmpty(string2);
        this.zzbfc = zznq2;
        this.zzbfb = new zznk();
        this.zzbew = n;
        this.zzbex = n2;
        this.zzebj = n3;
    }

    @Override
    public final Uri getUri() {
        if (this.zzbfd == null) {
            return null;
        }
        return Uri.parse((String)this.zzbfd.getURL().toString());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public final long zza(zznh var1_1) throws zzni {
        this.zzbes = var1_1;
        this.zzcc = 0L;
        this.zzbfi = 0L;
        try {
            block20: {
                var6_2 = var1_1;
                var5_3 = this;
                var7_4 = new URL(var6_2.uri.toString());
                var8_5 = var6_2.zzbeq;
                var9_6 = var6_2.zzams;
                var11_7 = var6_2.zzcb;
                var13_8 = var6_2.zzba(1);
                var14_9 = 0;
                while (var14_9++ <= 20) {
                    var25_20 = var13_8;
                    var23_19 = var11_7;
                    var21_18 = var9_6;
                    var20_16 /* !! */  = var8_5;
                    var19_15 = var7_4;
                    var18_14 = var5_3;
                    var26_21 = (HttpURLConnection)var19_15.openConnection();
                    if (var26_21 instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)var26_21).setSSLSocketFactory(var18_14.zzebi);
                    }
                    var26_21.setConnectTimeout(var18_14.zzbew);
                    var26_21.setReadTimeout(var18_14.zzbex);
                    for (Object var28_23 : var18_14.zzbfb.zzib().entrySet()) {
                        var26_21.setRequestProperty(var28_23.getKey(), var28_23.getValue());
                    }
                    if (var21_18 != 0L || var23_19 != -1L) {
                        var27_22 = new StringBuilder(27).append("bytes=").append(var21_18).append("-").toString();
                        if (var23_19 != -1L) {
                            var28_23 = String.valueOf(var27_22);
                            var29_24 = var21_18 + var23_19 - 1L;
                            var27_22 = new StringBuilder(20 + String.valueOf(var28_23).length()).append((String)var28_23).append(var29_24).toString();
                        }
                        var26_21.setRequestProperty("Range", (String)var27_22);
                    }
                    var26_21.setRequestProperty("User-Agent", var18_14.zzbey);
                    if (!var25_20) {
                        var26_21.setRequestProperty("Accept-Encoding", "identity");
                    }
                    var26_21.setInstanceFollowRedirects(false);
                    var26_21.setDoOutput(var20_16 /* !! */  != null);
                    if (var20_16 /* !! */  == null) ** GOTO lbl-1000
                    var26_21.setRequestMethod("POST");
                    if (var20_16 /* !! */ .length != 0) {
                        var26_21.setFixedLengthStreamingMode(var20_16 /* !! */ .length);
                        var26_21.connect();
                        var27_22 = var26_21.getOutputStream();
                        var27_22.write(var20_16 /* !! */ );
                        var27_22.close();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var26_21.connect();
                    }
                    var15_10 = var26_21;
                    var16_12 = var15_10.getResponseCode();
                    if (var16_12 == 300 || var16_12 == 301 || var16_12 == 302 || var16_12 == 303 || var8_5 == null && (var16_12 == 307 || var16_12 == 308)) {
                        var8_5 = null;
                        var17_13 = var15_10.getHeaderField("Location");
                        var15_10.disconnect();
                        var19_15 = var17_13;
                        var18_14 = var7_4;
                        if (var19_15 == null) {
                            throw new ProtocolException("Null location redirect");
                        }
                        v0 = new URL((URL)var18_14, (String)var19_15);
                        var20_16 /* !! */  = (byte[])v0;
                        var21_17 = v0.getProtocol();
                        if (!"https".equals(var21_17) && !"http".equals(var21_17)) {
                            v1 = String.valueOf(var21_17);
                            throw new ProtocolException(v1.length() != 0 ? "Unsupported protocol redirect: ".concat(v1) : new String("Unsupported protocol redirect: "));
                        }
                        var7_4 = var20_16 /* !! */ ;
                        continue;
                    }
                    break block20;
                }
                var15_11 = var14_9;
                throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(var15_11).toString());
            }
            this.zzbfd = var15_10;
        }
        catch (IOException var2_25) {
            v2 = String.valueOf(var1_1.uri.toString());
            throw new zzni(v2.length() != 0 ? "Unable to connect to ".concat(v2) : new String("Unable to connect to "), var2_25, var1_1, 1);
        }
        try {
            var2_26 = this.zzbfd.getResponseCode();
        }
        catch (IOException var3_27) {
            this.zzia();
            v3 = String.valueOf(var1_1.uri.toString());
            throw new zzni(v3.length() != 0 ? "Unable to connect to ".concat(v3) : new String("Unable to connect to "), var3_27, var1_1, 1);
        }
        if (var2_26 < 200 || var2_26 > 299) {
            var3_28 = this.zzbfd.getHeaderFields();
            this.zzia();
            var4_31 = new zznl(var2_26, var3_28, var1_1);
            if (var2_26 == 416) {
                var4_31.initCause(new zzne(0));
            }
            throw var4_31;
        }
        v4 = this.zzbfg = var2_26 == 200 && var1_1.zzams != 0L ? var1_1.zzams : 0L;
        this.zzbfh = !var1_1.zzba(1) ? (var1_1.zzcb != -1L ? var1_1.zzcb : ((var3_29 = zzazj.zzc(this.zzbfd)) != -1L ? var3_29 - this.zzbfg : -1L)) : var1_1.zzcb;
        try {
            this.zzbfe = this.zzbfd.getInputStream();
        }
        catch (IOException var3_30) {
            this.zzia();
            throw new zzni(var3_30, var1_1, 1);
        }
        this.zzbff = true;
        if (this.zzbfc != null) {
            this.zzbfc.zza(this, var1_1);
        }
        return this.zzbfh;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzni {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zzazj zzazj2 = this;
            if (zzazj2.zzbfi != zzazj2.zzbfg) {
                byArray2 = zzbeu.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zzazj2.zzbfi != zzazj2.zzbfg) {
                    n5 = (int)Math.min(zzazj2.zzbfg - zzazj2.zzbfi, (long)byArray2.length);
                    n4 = zzazj2.zzbfe.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zzazj2.zzbfi += (long)n4;
                    if (zzazj2.zzbfc == null) continue;
                    zzazj2.zzbfc.zzc(zzazj2, n4);
                }
                zzbeu.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zzazj2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zzazj2.zzbfh != -1L) {
                long l = zzazj2.zzbfh - zzazj2.zzcc;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zzazj2.zzbfe.read(byArray2, n5, n4)) == -1) {
                if (zzazj2.zzbfh != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zzazj2.zzcc += (long)n3;
            if (zzazj2.zzbfc != null) {
                zzazj2.zzbfc.zzc(zzazj2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzni(iOException, this.zzbes, 2);
        }
    }

    @Override
    public final void close() throws zzni {
        try {
            if (this.zzbfe != null) {
                block13: {
                    Object object = this;
                    long l = ((zzazj)object).zzbfh == -1L ? ((zzazj)object).zzbfh : ((zzazj)object).zzbfh - ((zzazj)object).zzcc;
                    object = this.zzbfd;
                    if (zzoh.SDK_INT == 19 || zzoh.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block13;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzbfe.close();
                }
                catch (IOException iOException) {
                    throw new zzni(iOException, this.zzbes, 3);
                }
            }
            return;
        }
        finally {
            this.zzbfe = null;
            this.zzia();
            if (this.zzbff) {
                this.zzbff = false;
                if (this.zzbfc != null) {
                    this.zzbfc.zze(this);
                }
            }
            this.zzebk.clear();
        }
    }

    final void setReceiveBufferSize(int n) {
        this.zzebj = n;
        for (Socket socket : this.zzebk) {
            if (socket.isClosed()) continue;
            try {
                socket.setReceiveBufferSize(this.zzebj);
            }
            catch (SocketException socketException) {
                zzatm.zzd((String)"Failed to update receive buffer size.", (Throwable)socketException);
            }
        }
    }

    private final void zzb(Socket socket) {
        this.zzebk.add(socket);
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                zzatm.zzes((String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzbet.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    zzatm.zzeu((String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzatm.zzes((String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzia() {
        if (this.zzbfd != null) {
            try {
                this.zzbfd.disconnect();
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzbfd = null;
        }
    }

    static /* synthetic */ int zza(zzazj zzazj2) {
        return zzazj2.zzebj;
    }

    static /* synthetic */ void zza(zzazj zzazj2, Socket socket) {
        zzazj2.zzb(socket);
    }
}

