/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzazk;
import com.google.android.gms.internal.ads.zznc;
import com.google.android.gms.internal.ads.zznh;
import com.google.android.gms.internal.ads.zznq;
import com.google.android.gms.internal.ads.zzrg;
import com.google.android.gms.internal.ads.zzrl;
import com.google.android.gms.internal.ads.zzrw;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzazl
implements zznc {
    private InputStream zzebl;
    private boolean isOpen;
    private final Context zzlk;
    private final zznc zzebm;
    @Nullable
    private final zznq<zznc> zzebn;
    private final zzazk zzebo;
    private Uri uri;

    public zzazl(Context context, zznc zznc2, zznq<zznc> zznq2, zzazk zzazk2) {
        this.zzlk = context;
        this.zzebm = zznc2;
        this.zzebn = zznq2;
        this.zzebo = zzazk2;
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        this.uri = null;
        if (this.zzebl != null) {
            IOUtils.closeQuietly((Closeable)this.zzebl);
            this.zzebl = null;
        } else {
            this.zzebm.close();
        }
        zzazl zzazl2 = this;
        if (zzazl2.zzebn != null) {
            zzazl2.zzebn.zze(zzazl2);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zznh zznh2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        this.uri = zznh2.uri;
        zznh zznh3 = zznh2;
        zzazl zzazl2 = this;
        if (zzazl2.zzebn != null) {
            zzazl2.zzebn.zza(zzazl2, zznh3);
        }
        zzrl zzrl2 = zzrl.zze(zznh2.uri);
        zzazl2 = zzyt.zzcpk;
        if (((Boolean)zzuo.zzoj().zzd((zzyi)zzazl2)).booleanValue()) {
            if (zzrl2 != null) {
                long l;
                Long l2;
                zzrl2.zzbrf = zznh2.zzams;
                if (zzrl2.zzbre) {
                    zzazl2 = zzyt.zzcpm;
                    l2 = (Long)zzuo.zzoj().zzd((zzyi)zzazl2);
                } else {
                    zzazl2 = zzyt.zzcpl;
                    l2 = (Long)zzuo.zzoj().zzd((zzyi)zzazl2);
                }
                long l3 = l2;
                long l4 = zzp.zzkf().elapsedRealtime();
                zzp.zzks();
                Future<InputStream> future = zzrw.zza(this.zzlk, zzrl2);
                try {
                    this.zzebl = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzp.zzkf().elapsedRealtime() - l4;
                    this.zzebo.zzb(true, l);
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzp.zzkf().elapsedRealtime() - l4;
                    this.zzebo.zzb(false, l5);
                    zzatm.zzdy(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzatm.zzdy(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzrg zzrg2 = null;
            if (zzrl2 != null) {
                zzrl2.zzbrf = zznh2.zzams;
                zzrg2 = zzp.zzke().zza(zzrl2);
            }
            if (zzrg2 != null && zzrg2.zzmg()) {
                this.zzebl = zzrg2.zzmh();
                return -1L;
            }
        }
        if (zzrl2 != null) {
            zznh2 = new zznh(Uri.parse((String)zzrl2.url), zznh2.zzbeq, zznh2.zzber, zznh2.zzams, zznh2.zzcb, zznh2.zzce, zznh2.flags);
        }
        return this.zzebm.zza(zznh2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        int n3 = this.zzebl != null ? this.zzebl.read(byArray, n, n2) : this.zzebm.read(byArray, n, n2);
        int n4 = n3;
        zzazl zzazl2 = this;
        if (zzazl2.zzebn != null) {
            zzazl2.zzebn.zzc(zzazl2, n4);
        }
        return n3;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }
}

