/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawc;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzayc;
import com.google.android.gms.internal.ads.zzayi;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzuo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbaa
implements zzadx<zzayt> {
    private boolean zzeco;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzuo.zzof();
                n2 = zzawe.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzatm.zzeu((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzayc zzayc2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        String string6 = map.get("socketReceiveBufferSize");
        try {
            int n;
            if (string2 != null) {
                n = Integer.parseInt(string2);
                zzayc2.zzct(n);
            }
            if (string3 != null) {
                n = Integer.parseInt(string3);
                zzayc2.zzcu(n);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
                zzayc2.zzcv(n);
            }
            if (string5 != null) {
                n = Integer.parseInt(string5);
                zzayc2.zzcw(n);
            }
            if (string6 != null) {
                n = Integer.parseInt(string6);
                zzayc2.zzcx(n);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzatm.zzeu((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        zzayc zzayc2;
        Object object2;
        Object object3;
        Map map2 = map;
        zzayt zzayt2 = (zzayt)object;
        zzbaa zzbaa2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzatm.zzeu((String)"Action missing from video GMSG.");
            return;
        }
        if (zzatm.isLoggable((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzatm.zzdv((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzatm.zzeu((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzayt2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzatm.zzeu((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzatm.zzeu((String)"No MIME types specified for decoder properties inspection.");
                zzayc.zza(zzayt2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzatm.zzeu((String)"Video decoder properties available on API versions >= 16.");
                zzayc.zza(zzayt2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzawc.zzem(string3.trim()));
            }
            zzayc.zza(zzayt2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzayt2.zzxi();
        if (object3 == null) {
            zzatm.zzeu((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzayt2.getContext();
            int n2 = zzbaa.zza(context, map2, "x", 0);
            int n3 = zzbaa.zza(context, map2, "y", 0);
            int n4 = zzbaa.zza(context, map2, "w", -1);
            int n5 = zzbaa.zza(context, map2, "h", -1);
            n4 = Math.min(n4, zzayt2.zzxr() - n2);
            n5 = Math.min(n5, zzayt2.zzxq() - n3);
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzayi)object3).zzxc() == null) {
                zzayq zzayq2 = new zzayq((String)map2.get("flags"));
                ((zzayi)object3).zza(n2, n3, n4, n5, n, bl3, zzayq2);
                zzayc zzayc3 = ((zzayi)object3).zzxc();
                if (zzayc3 != null) {
                    zzbaa.zza(zzayc3, map2);
                }
                return;
            }
            ((zzayi)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzbbu zzbbu2 = zzayt2.zzxj();
        if (zzbbu2 != null) {
            if ("timeupdate".equals(string2)) {
                String string4 = (String)map2.get("currentTime");
                if (string4 == null) {
                    zzatm.zzeu((String)"currentTime parameter missing from timeupdate video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzbbu2.zze(f);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzatm.zzeu((String)(string5.length() != 0 ? "Could not parse currentTime parameter from timeupdate video GMSG: ".concat(string5) : new String("Could not parse currentTime parameter from timeupdate video GMSG: ")));
                    return;
                }
            }
            if ("skip".equals(string2)) {
                zzbbu2.zzaal();
                return;
            }
        }
        if ((zzayc2 = ((zzayi)object3).zzxc()) == null) {
            zzayc.zza(zzayt2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzayt2.getContext();
            int n = zzbaa.zza(context, map2, "x", 0);
            int n6 = zzbaa.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzayc2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string6 = (String)map2.get("time");
            if (string6 == null) {
                zzatm.zzeu((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string6) * 1000.0f);
                zzayc2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzatm.zzeu((String)(string7.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string7) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzayc2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzayc2.zzhh();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzbaa.zza(zzayc2, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzayc2.zzww();
                return;
            }
            zzayc2.zzwx();
            return;
        }
        if ("pause".equals(string2)) {
            zzayc2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzayc2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzayc2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            String string8 = (String)map2.get("src");
            String[] stringArray = new String[]{string8};
            String string9 = (String)map2.get("demuxed");
            if (string9 != null) {
                try {
                    JSONArray jSONArray = new JSONArray(string9);
                    stringArray = new String[jSONArray.length()];
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        stringArray[i] = jSONArray.getString(i);
                    }
                }
                catch (JSONException jSONException) {
                    String string10 = String.valueOf(string9);
                    zzatm.zzeu((String)(string10.length() != 0 ? "Malformed demuxed URL list for playback: ".concat(string10) : new String("Malformed demuxed URL list for playback: ")));
                    stringArray = new String[]{string8};
                }
            }
            zzayc2.zzc(string8, stringArray);
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzayt2.getContext();
            int n = zzbaa.zza(context, map2, "dx", 0);
            int n7 = zzbaa.zza(context, map2, "dy", 0);
            zzayc2.zza(n, n7);
            if (!zzbaa2.zzeco) {
                zzayt2.zzsr();
                zzbaa2.zzeco = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string11 = (String)map2.get("volume");
            if (string11 == null) {
                zzatm.zzeu((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string11);
                zzayc2.setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string12 = String.valueOf(string11);
                zzatm.zzeu((String)(string12.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string12) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzayc2.zzwy();
            return;
        }
        String string13 = String.valueOf(string2);
        zzatm.zzeu((String)(string13.length() != 0 ? "Unknown video action: ".concat(string13) : new String("Unknown video action: ")));
    }
}

