/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzavu;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawi;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzbag;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class zzbao
extends zzbah {
    private static final Set<String> zzede = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzedf = new DecimalFormat("#,###");
    private File zzedg;
    private boolean zzedh;

    public zzbao(zzayt zzayt2) {
        super(zzayt2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzatm.zzeu((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzedg = new File(file, "admobVideoStreams");
        if (!this.zzedg.isDirectory() && !this.zzedg.mkdirs()) {
            String string2 = String.valueOf(this.zzedg.getAbsolutePath());
            zzatm.zzeu((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzedg = null;
            return;
        }
        if (!this.zzedg.setReadable(true, false) || !this.zzedg.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzedg.getAbsolutePath());
            zzatm.zzeu((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzedg = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzfd(String string2) {
        int n;
        Object object;
        int n2;
        Object object2;
        block41: {
            int n3;
            if (this.zzedg == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzbao)object2).zzedg == null) {
                    n4 = 0;
                } else {
                    n2 = 0;
                    object = ((zzbao)object2).zzedg.listFiles();
                    int n5 = ((File[])object).length;
                    for (n = 0; n < n5; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n2;
                    }
                    n4 = n2;
                }
                object2 = zzyt.zzcha;
                if (n4 <= (Integer)zzuo.zzoj().zzd((zzyi)object2)) break block41;
                object2 = this;
                if (((zzbao)object2).zzedg == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzbao)object2).zzedg.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = ((zzbao)object2).zzc(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzatm.zzeu((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzfe(string2);
        File file = new File(this.zzedg, string3);
        File file4 = this.zzc(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzatm.zzdv((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzedg.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzede;
        synchronized (object3) {
            if (zzede.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzatm.zzeu((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzede.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            HttpURLConnection httpURLConnection;
            block42: {
                zzp.zzkk();
                object2 = zzyt.zzchf;
                n2 = (Integer)zzuo.zzoj().zzd((zzyi)object2);
                object2 = string2;
                URL uRL = new URL((String)object2);
                n = 0;
                while (++n <= 20) {
                    File file2;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n2);
                    uRLConnection.setReadTimeout(n2);
                    if (!(uRLConnection instanceof HttpURLConnection)) {
                        throw new IOException("Invalid protocol.");
                    }
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    file2 = new zzawi();
                    file2.zza(httpURLConnection, null);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    int n9 = httpURLConnection.getResponseCode();
                    file2.zza(httpURLConnection, n9);
                    if (n9 / 100 == 3) {
                        String string11 = httpURLConnection.getHeaderField("Location");
                        if (string11 == null) {
                            throw new IOException("Missing Location header in redirect");
                        }
                        String string12 = (uRL = new URL(uRL, string11)).getProtocol();
                        if (string12 == null) {
                            throw new IOException("Protocol is null");
                        }
                        if (!string12.equals("http") && !string12.equals("https")) {
                            String string13 = String.valueOf(string12);
                            throw new IOException(string13.length() != 0 ? "Unsupported scheme: ".concat(string13) : new String("Unsupported scheme: "));
                        }
                        String string14 = String.valueOf(string11);
                        zzatm.zzdv((String)(string14.length() != 0 ? "Redirecting to ".concat(string14) : new String("Redirecting to ")));
                        httpURLConnection.disconnect();
                        continue;
                    }
                    break block42;
                }
                throw new IOException("Too many redirects (20)");
            }
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 instanceof HttpURLConnection && (n8 = httpURLConnection2.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string15 = String.valueOf(Integer.toString(n8));
                string10 = string15.length() != 0 ? "HTTP request failed. Code: ".concat(string15) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection2.getContentLength();
            if (n8 < 0) {
                String string16 = String.valueOf(string2);
                zzatm.zzeu((String)(string16.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string16) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzede.remove(string7);
                return false;
            }
            String string17 = zzedf.format(n8);
            object2 = zzyt.zzchb;
            int n10 = (Integer)zzuo.zzoj().zzd((zzyi)object2);
            if (n8 > n10) {
                zzatm.zzeu((String)new StringBuilder(33 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Content length ").append(string17).append(" exceeds limit at ").append(string2).toString());
                String string18 = String.valueOf(string17);
                String string19 = string18.length() != 0 ? "File too big for full file cache. Size: ".concat(string18) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string19);
                zzede.remove(string7);
                return false;
            }
            zzatm.zzdv((String)new StringBuilder(20 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Caching ").append(string17).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection2.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            Clock clock = zzp.zzkf();
            int n11 = 0;
            long l = clock.currentTimeMillis();
            object2 = zzyt.zzche;
            long l3 = (Long)zzuo.zzoj().zzd((zzyi)object2);
            zzavu zzavu2 = new zzavu(l3);
            object2 = zzyt.zzchd;
            long l4 = (Long)zzuo.zzoj().zzd((zzyi)object2);
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n11 += n7) > n10) {
                    string9 = "sizeExceeded";
                    String string20 = String.valueOf(Integer.toString(n11));
                    string10 = string20.length() != 0 ? "File too big for full file cache. Size: ".concat(string20) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (clock.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string21 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string21).length()).append("Timeout exceeded. Limit: ").append(string21).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzedh) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzavu2.tryAcquire()) continue;
                n = n8;
                int n12 = n11;
                object = file.getAbsolutePath();
                String string22 = string2;
                object2 = this;
                zzawe.zzzb.post((Runnable)new zzbag((zzbah)object2, string22, (String)object, n12, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzatm.isLoggable((int)3)) {
                String string23 = zzedf.format(n11);
                zzatm.zzdv((String)new StringBuilder(22 + String.valueOf(string23).length() + String.valueOf(string2).length()).append("Preloaded ").append(string23).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n11);
            zzede.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzp.zzkc().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzedh) {
                zzatm.zzet((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzatm.zzd((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string24 = String.valueOf(file.getAbsolutePath());
                zzatm.zzeu((String)(string24.length() != 0 ? "Could not delete partial cache file at ".concat(string24) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzede.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzedh = true;
    }

    private final File zzc(File file) {
        return new File(this.zzedg, String.valueOf(file.getName()).concat(".done"));
    }
}

