/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbav;
import com.google.android.gms.internal.ads.zzge;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@TargetApi(value=16)
public final class zzbas
extends zzbah
implements zzazu {
    private zzazm zzedk;
    private String zzdxy;
    private boolean zzedh;
    private Exception zzedl;
    private boolean zzedm;

    public zzbas(zzayt zzayt2, zzayq zzayq2) {
        super(zzayt2);
        zzayq zzayq3 = zzayq2;
        Context context = zzayt2.getContext();
        this.zzedk = new zzazm(context, zzayq3);
        this.zzedk.zza(this);
    }

    @Override
    public final void zzb(boolean bl, long l) {
        zzayt zzayt2 = (zzayt)this.zzecy.get();
        if (zzayt2 != null) {
            zzawx.zzdwa.execute(new zzbav(zzayt2, bl, l));
        }
    }

    @Override
    public final void zzcy(int n) {
    }

    @Override
    public final void zzm(int n, int n2) {
    }

    @Override
    public final void zza(String string2, Exception exception) {
        zzyi zzyi2 = zzyt.zzcgx;
        String string3 = (String)zzuo.zzoj().zzd(zzyi2);
        if (string3 != null) {
            List<String> list = Arrays.asList(string3.split(","));
            if (list.contains("all")) {
                return;
            }
            String string4 = exception.getClass().getCanonicalName();
            if (list.contains(string4)) {
                return;
            }
        }
        this.zzedl = exception;
        zzatm.zzd((String)"Precache error", (Throwable)exception);
        this.zzfg(string2);
    }

    @Override
    public final void zzcu(int n) {
        this.zzedk.zzyn().zzdb(n);
    }

    @Override
    public final void zzct(int n) {
        this.zzedk.zzyn().zzda(n);
    }

    @Override
    public final void zzcv(int n) {
        this.zzedk.zzyn().zzcv(n);
    }

    @Override
    public final void zzcw(int n) {
        this.zzedk.zzyn().zzcw(n);
    }

    @Override
    public final void release() {
        if (this.zzedk != null) {
            this.zzedk.zza((zzazu)null);
            this.zzedk.release();
        }
        super.release();
    }

    @Override
    protected final String zzfe(String string2) {
        String string3 = String.valueOf("cache:");
        String string4 = String.valueOf(super.zzfe(string2));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Override
    public final boolean zzfd(String string2) {
        return ((zzbah)this).zze(string2, new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean zze(String string2, String[] stringArray) {
        this.zzdxy = string2;
        String string3 = ((zzbah)this).zzfe(string2);
        String string4 = "error";
        try {
            Uri[] uriArray = new Uri[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                uriArray[i] = Uri.parse((String)stringArray[i]);
            }
            this.zzedk.zza(uriArray, this.zzdur);
            zzayt zzayt2 = (zzayt)this.zzecy.get();
            if (zzayt2 != null) {
                zzayt2.zza(string3, this);
            }
            Clock clock = zzp.zzkf();
            long l = clock.currentTimeMillis();
            zzyi zzyi2 = zzyt.zzche;
            long l2 = (Long)zzuo.zzoj().zzd(zzyi2);
            zzyi2 = zzyt.zzchd;
            long l3 = (Long)zzuo.zzoj().zzd(zzyi2) * 1000L;
            zzyi2 = zzyt.zzchc;
            long l4 = ((Integer)zzuo.zzoj().zzd(zzyi2)).intValue();
            long l5 = -1L;
            while (true) {
                zzbas zzbas2 = this;
                synchronized (zzbas2) {
                    if (clock.currentTimeMillis() - l > l3) {
                        string4 = "downloadTimeout";
                        throw new IOException(new StringBuilder(47).append("Timeout reached. Limit: ").append(l3).append(" ms").toString());
                    }
                    if (this.zzedh) {
                        if (this.zzedl != null) {
                            string4 = "badUrl";
                            throw this.zzedl;
                        }
                        string4 = "externalAbort";
                        throw new IOException("Abort requested before buffering finished. ");
                    }
                    if (this.zzedm) {
                        return true;
                    }
                    zzge zzge2 = this.zzedk.zzyk();
                    if (zzge2 == null) {
                        string4 = "exoPlayerReleased";
                        throw new IOException("ExoPlayer was released during preloading.");
                    }
                    long l6 = zzge2.getDuration();
                    if (l6 > 0L) {
                        long l7 = zzge2.getBufferedPosition();
                        if (l7 != l5) {
                            boolean bl = l7 > 0L;
                            this.zza(string2, string3, l7, l6, bl, zzazm.zzyl(), zzazm.zzym());
                            l5 = l7;
                        }
                        if (l7 >= l6) {
                            this.zzb(string2, string3, l6);
                            return true;
                        }
                        if (this.zzedk.getBytesTransferred() >= l4 && l7 > 0L) {
                            return true;
                        }
                    }
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        string4 = "interrupted";
                        throw new IOException("Wait interrupted.");
                    }
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string5 = exception.getMessage();
            zzatm.zzeu((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Failed to preload url ").append(string2).append(" Exception: ").append(string5).toString());
            ((zzbah)this).release();
            string5 = zzbas.zzb(string4, exception2);
            this.zza(string2, string3, string4, string5);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzfg(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfg(String string2) {
        Object object = this;
        synchronized (object) {
            this.zzedh = true;
            this.notify();
            ((zzbah)this).release();
        }
        if (this.zzdxy != null) {
            object = ((zzbah)this).zzfe(this.zzdxy);
            if (this.zzedl != null) {
                this.zza(this.zzdxy, (String)object, "badUrl", zzbas.zzb(string2, this.zzedl));
                return;
            }
            this.zza(this.zzdxy, (String)object, "externalAbort", "Programmatic precache abort.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzazm zzyp() {
        Object object = this;
        synchronized (object) {
            this.zzedm = true;
            this.notify();
        }
        this.zzedk.zza((zzazu)null);
        object = this.zzedk;
        this.zzedk = null;
        return object;
    }

    private static String zzb(String string2, Exception exception) {
        String string3 = exception.getClass().getCanonicalName();
        String string4 = exception.getMessage();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("/").append(string3).append(":").append(string4).toString();
    }
}

