/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzb;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadd;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadi;
import com.google.android.gms.internal.ads.zzadk;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzadz;
import com.google.android.gms.internal.ads.zzaea;
import com.google.android.gms.internal.ads.zzaeb;
import com.google.android.gms.internal.ads.zzaec;
import com.google.android.gms.internal.ads.zzamf;
import com.google.android.gms.internal.ads.zzamq;
import com.google.android.gms.internal.ads.zzams;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzask;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawi;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzbam;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbe;
import com.google.android.gms.internal.ads.zzbbg;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbj;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbcr;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzrb;
import com.google.android.gms.internal.ads.zzrg;
import com.google.android.gms.internal.ads.zzrl;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzth;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzbbf
extends WebViewClient
implements zzbcm {
    private static final String[] zzedy = new String[]{"UNKNOWN", "HOST_LOOKUP", "UNSUPPORTED_AUTH_SCHEME", "AUTHENTICATION", "PROXY_AUTHENTICATION", "CONNECT", "IO", "TIMEOUT", "REDIRECT_LOOP", "UNSUPPORTED_SCHEME", "FAILED_SSL_HANDSHAKE", "BAD_URL", "FILE", "FILE_NOT_FOUND", "TOO_MANY_REQUESTS"};
    private static final String[] zzedz = new String[]{"NOT_YET_VALID", "EXPIRED", "ID_MISMATCH", "UNTRUSTED", "DATE_INVALID", "INVALID"};
    protected zzbbc zzeea;
    @Nullable
    private final zzrz zzeeb;
    private final HashMap<String, List<zzadx<? super zzbbc>>> zzeec = new HashMap();
    private final Object lock = new Object();
    private zzth zzcbl;
    private zzp zzdhm;
    private zzbcp zzeed;
    private zzbco zzeee;
    private zzadg zzcwp;
    private zzadi zzcwr;
    private zzbcr zzeef;
    private boolean zzeeg = false;
    @GuardedBy(value="lock")
    private boolean zzbni;
    @GuardedBy(value="lock")
    private boolean zzeeh;
    @GuardedBy(value="lock")
    private boolean zzeei;
    private zzv zzdhq;
    private final zzamq zzeej;
    private zza zzcxn;
    private zzamf zzcxo;
    @Nullable
    protected zzaro zzeek;
    private boolean zzeel;
    private boolean zzeem;
    private int zzeen;
    private boolean zzdlf;
    private View.OnAttachStateChangeListener zzeeo;

    public zzbbf(zzbbc zzbbc2, zzrz zzrz2, boolean bl) {
        this(zzbbc2, zzrz2, bl, new zzamq(zzbbc2, zzbbc2.zzyt(), new zzye(zzbbc2.getContext())), null);
    }

    @VisibleForTesting
    private zzbbf(zzbbc zzbbc2, zzrz zzrz2, boolean bl, zzamq zzamq2, zzamf zzamf2) {
        this.zzeeb = zzrz2;
        this.zzeea = zzbbc2;
        this.zzbni = bl;
        this.zzeej = zzamq2;
        this.zzcxo = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzeej.zzi(n, n2);
        if (this.zzcxo != null) {
            this.zzcxo.zza(n, n2, false);
        }
    }

    @Override
    public final void zza(zzth zzth2, zzadg zzadg2, zzp zzp2, zzadi zzadi2, zzv zzv2, boolean bl, @Nullable zzaea zzaea2, zza zza2, zzams zzams2, @Nullable zzaro zzaro2) {
        boolean bl2;
        if (zza2 == null) {
            zza2 = new zza(this.zzeea.getContext(), zzaro2, null);
        }
        this.zzcxo = new zzamf(this.zzeea, zzams2);
        this.zzeek = zzaro2;
        zzyi zzyi2 = zzyt.zzckf;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            this.zza("/adMetadata", new zzadd(zzadg2));
        }
        this.zza("/appEvent", new zzadf(zzadi2));
        this.zza("/backButton", zzadk.zzcxc);
        this.zza("/refresh", zzadk.zzcxd);
        this.zza("/canOpenURLs", zzadk.zzcwt);
        this.zza("/canOpenIntents", zzadk.zzcwu);
        this.zza("/click", zzadk.zzcwv);
        this.zza("/close", zzadk.zzcww);
        this.zza("/customClose", zzadk.zzcwx);
        this.zza("/instrument", zzadk.zzcxg);
        this.zza("/delayPageLoaded", zzadk.zzcxi);
        this.zza("/delayPageClosed", zzadk.zzcxj);
        this.zza("/getLocationInfo", zzadk.zzcxk);
        this.zza("/httpTrack", zzadk.zzcwy);
        this.zza("/log", zzadk.zzcwz);
        this.zza("/mraid", new zzaec(zza2, this.zzcxo, zzams2));
        this.zza("/mraidLoaded", this.zzeej);
        this.zza("/open", new zzaeb(zza2, this.zzcxo));
        this.zza("/precache", new zzbam());
        this.zza("/touch", zzadk.zzcxb);
        this.zza("/video", zzadk.zzcxe);
        this.zza("/videoMeta", zzadk.zzcxf);
        if (com.google.android.gms.ads.internal.zzp.zzkw().zzaa(this.zzeea.getContext())) {
            this.zza("/logScionEvent", new zzadz(this.zzeea.getContext()));
        }
        this.zzcbl = zzth2;
        this.zzdhm = zzp2;
        this.zzcwp = zzadg2;
        this.zzcwr = zzadi2;
        this.zzdhq = zzv2;
        this.zzcxn = zza2;
        this.zzeeg = bl2 = bl;
    }

    @Override
    public final zza zzzq() {
        return this.zzcxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzzr() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzbni;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzzs() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzeeh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzzt() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzzu() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        zzrb zzrb2 = this.zzeea.zzzo();
        if (zzrb2 != null && webView == zzrb2.getWebView()) {
            zzrb2.onPageStarted(webView, string2, bitmap);
        }
        super.onPageStarted(webView, string2, bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzeea.isDestroyed()) {
                zzatm.zzdy("Blank page loaded, 1...");
                this.zzeea.zzze();
                return;
            }
        }
        this.zzeel = true;
        zzbbf zzbbf2 = this;
        if (zzbbf2.zzeee != null) {
            zzbbf2.zzeee.zzrb();
            zzbbf2.zzeee = null;
        }
        this.zzaaa();
    }

    private final void zza(View view, zzaro zzaro2, int n) {
        if (zzaro2.zztj() && n > 0) {
            zzaro2.zzj(view);
            if (zzaro2.zztj()) {
                zzatv.zzdsk.postDelayed((Runnable)new zzbbg(this, view, zzaro2, n), 100L);
            }
        }
    }

    private final void zzzv() {
        if (this.zzeeo == null) {
            return;
        }
        this.zzeea.getView().removeOnAttachStateChangeListener(this.zzeeo);
    }

    @Override
    public final void zzzw() {
        zzaro zzaro2 = this.zzeek;
        if (zzaro2 != null) {
            WebView webView = this.zzeea.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzaro2, 10);
                return;
            }
            zzaro zzaro3 = zzaro2;
            zzbbf zzbbf2 = this;
            zzbbf2.zzzv();
            zzbbf2.zzeeo = new zzbbj(zzbbf2, zzaro3);
            zzbbf2.zzeea.getView().addOnAttachStateChangeListener(zzbbf2.zzeeo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzzx() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeei = true;
        }
        ++this.zzeen;
        this.zzaaa();
    }

    @Override
    public final void zzzy() {
        --this.zzeen;
        this.zzaaa();
    }

    @Override
    public final void zzzz() {
        if (this.zzeeb != null) {
            this.zzeeb.zza(zzsb.zza.zzb.zzbtl);
        }
        this.zzeem = true;
        this.zzaaa();
        zzyi zzyi2 = zzyt.zzcrq;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            this.zzeea.destroy();
        }
    }

    private final void zzaaa() {
        if (this.zzeed != null && (this.zzeel && this.zzeen <= 0 || this.zzeem)) {
            this.zzeed.zzab(!this.zzeem);
            this.zzeed = null;
        }
        this.zzeea.zzzi();
    }

    public final void zza(zzb zzb2) {
        boolean bl = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel(zzb2, (zzth)(bl && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), bl ? null : this.zzdhm, this.zzdhq, this.zzeea.zzxp()));
    }

    public final void zzc(boolean bl, int n) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), this.zzdhm, this.zzdhq, this.zzeea, bl, n, this.zzeea.zzxp()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), (zzp)(bl2 ? null : new zzbbi(this.zzeea, this.zzdhm)), this.zzcwp, this.zzcwr, this.zzdhq, this.zzeea, bl, n, string2, this.zzeea.zzxp()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), bl2 ? null : new zzbbi(this.zzeea, this.zzdhm), this.zzcwp, this.zzcwr, this.zzdhq, this.zzeea, bl, n, string2, string3, this.zzeea.zzxp()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzcxo != null) {
            bl = this.zzcxo.zzsg();
        }
        com.google.android.gms.ads.internal.zzp.zzjx();
        zzl.zza(this.zzeea.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzeek != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdhl != null) {
                string2 = adOverlayInfoParcel.zzdhl.url;
            }
            this.zzeek.zzdq(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzadx<? super zzbbc> zzadx2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzadx<? super zzbbc>> list = this.zzeec.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzadx<? super zzbbc>>();
                this.zzeec.put(string2, list);
            }
            list.add(zzadx2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzadx<? super zzbbc> zzadx2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzadx<? super zzbbc>> list = this.zzeec.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzadx2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzadx<? super zzbbc>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            List<zzadx<? super zzbbc>> list = this.zzeec.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzadx<? super zzbbc>> arrayList = new ArrayList<zzadx<? super zzbbc>>();
            for (zzadx<? super zzbbc> zzadx2 : list) {
                if (!predicate.apply(zzadx2)) continue;
                arrayList.add(zzadx2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzeek != null) {
            this.zzeek.zztl();
            this.zzeek = null;
        }
        this.zzzv();
        Object object = this.lock;
        synchronized (object) {
            this.zzeec.clear();
            this.zzcbl = null;
            this.zzdhm = null;
            this.zzeed = null;
            this.zzeee = null;
            this.zzcwp = null;
            this.zzcwr = null;
            this.zzeeg = false;
            this.zzbni = false;
            this.zzeeh = false;
            this.zzeei = false;
            this.zzdhq = null;
            this.zzeef = null;
            if (this.zzcxo != null) {
                this.zzcxo.zzv(true);
                this.zzcxo = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbcp zzbcp2) {
        this.zzeed = zzbcp2;
    }

    @Override
    public final void zza(zzbco zzbco2) {
        this.zzeee = zzbco2;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzatm.zzdy(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        }
    }

    public final void onReceivedError(WebView webView, int n, String string2, String string3) {
        String string4 = n < 0 && -n - 1 < zzedy.length ? zzedy[-n - 1] : String.valueOf(n);
        this.zze(this.zzeea.getContext(), "http_err", string4, string3);
        super.onReceivedError(webView, n, string2, string3);
    }

    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (sslError != null) {
            int n = sslError.getPrimaryError();
            String string2 = n >= 0 && n < zzedz.length ? zzedz[n] : String.valueOf(n);
            Context context = this.zzeea.getContext();
            com.google.android.gms.ads.internal.zzp.zzka();
            this.zze(context, "ssl_err", string2, sslError.getUrl());
        }
        super.onReceivedSslError(webView, sslErrorHandler, sslError);
    }

    private final void zze(Context context, String string2, String string3, String string4) {
        Uri uri;
        Object object = zzyt.zzclx;
        if (!((Boolean)zzuo.zzoj().zzd(object)).booleanValue()) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("err", string2);
        bundle.putString("code", string3);
        object = string4;
        bundle.putString("host", !TextUtils.isEmpty((CharSequence)object) && (uri = Uri.parse((String)object)).getHost() != null ? uri.getHost() : "");
        com.google.android.gms.ads.internal.zzp.zzjy().zza(context, this.zzeea.zzxp().zzbnh, "gmob-apps", bundle, true);
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzatm.zzdy(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        } else {
            String string4;
            if (this.zzeeg && webView == this.zzeea.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzcbl != null) {
                    this.zzcbl.onAdClicked();
                    if (this.zzeek != null) {
                        this.zzeek.zzdq(string2);
                    }
                    this.zzcbl = null;
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzeea.getWebView().willNotDraw()) {
                try {
                    zzdf zzdf2 = this.zzeea.zzzb();
                    if (zzdf2 != null && zzdf2.zzc(uri)) {
                        uri = zzdf2.zza(uri, this.zzeea.getContext(), this.zzeea.getView(), this.zzeea.zzxl());
                    }
                }
                catch (zzdi zzdi2) {
                    String string5 = String.valueOf(string2);
                    zzatm.zzeu((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzcxn == null || this.zzcxn.zzjh()) {
                    this.zza(new zzb("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzcxn.zzbl(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzatm.zzeu((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzrg zzrg2;
            String string3 = zzask.zzd(string2, this.zzeea.getContext(), this.zzdlf);
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzrl zzrl2 = zzrl.zzbt(string2);
            if (zzrl2 != null && (zzrg2 = com.google.android.gms.ads.internal.zzp.zzke().zza(zzrl2)) != null && zzrg2.zzmg()) {
                return new WebResourceResponse("", "", zzrg2.zzmh());
            }
            if (zzawi.isEnabled()) {
                zzyi zzyi2 = zzyt.zzclm;
                if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
                    return this.zze(string2, map);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            com.google.android.gms.ads.internal.zzp.zzkc().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbbf.zzaab();
        }
    }

    private static WebResourceResponse zzaab() {
        zzyi zzyi2 = zzyt.zzcju;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            com.google.android.gms.ads.internal.zzp.zzjy().zza(this.zzeea.getContext(), this.zzeea.zzxp().zzbnh, false, httpURLConnection);
            zzawi zzawi22 = new zzawi();
            zzawi22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzawi22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzatm.zzeu((String)"Protocol is null");
                    return zzbbf.zzaab();
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzatm.zzeu((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return zzbbf.zzaab();
                }
                String string6 = String.valueOf(string3);
                zzatm.zzdv((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            com.google.android.gms.ads.internal.zzp.zzjy();
            return zzatv.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzao(boolean bl) {
        this.zzeeg = bl;
    }

    @Override
    public final zzaro zzaac() {
        return this.zzeek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsm() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeeg = false;
            this.zzbni = true;
            zzawx.zzdwa.execute(new zzbbe(this));
            return;
        }
    }

    public final void zzat(boolean bl) {
        this.zzdlf = bl;
    }

    @Override
    public final void zzh(int n, int n2) {
        if (this.zzcxo != null) {
            this.zzcxo.zzh(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void zzh(Uri uri) {
        String string2 = uri.getPath();
        List<zzadx<? super zzbbc>> list = this.zzeec.get(string2);
        if (list != null) {
            com.google.android.gms.ads.internal.zzp.zzjy();
            Map<String, String> map = zzatv.zzi(uri);
            if (zzatm.isLoggable((int)2)) {
                String string3 = String.valueOf(string2);
                zzatm.zzdy(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
                for (String string4 : map.keySet()) {
                    String string5 = map.get(string4);
                    zzatm.zzdy(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
                }
            }
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(this.zzeea, map);
            }
            return;
        }
        String string6 = String.valueOf(uri);
        zzatm.zzdy(new StringBuilder(32 + String.valueOf(string6).length()).append("No GMSG handler found for GMSG: ").append(string6).toString());
        zzyi zzyi2 = zzyt.zzctn;
        if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() || com.google.android.gms.ads.internal.zzp.zzkc().zzud() == null) {
            return;
        }
        zzawx.zzdvx.execute(new zzbbh(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzau(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzeeh = true;
            return;
        }
    }

    @TargetApi(value=26)
    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzeea.zzb(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static final /* synthetic */ void zzfh(String string2) {
        com.google.android.gms.ads.internal.zzp.zzkc().zzud().zzcm(string2.substring(1));
    }

    static /* synthetic */ void zza(zzbbf zzbbf2, View view, zzaro zzaro2, int n) {
        zzbbf2.zza(view, zzaro2, n);
    }
}

