/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzb;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaab;
import com.google.android.gms.internal.ads.zzaag;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzauk;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawf;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzayi;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbf;
import com.google.android.gms.internal.ads.zzbbs;
import com.google.android.gms.internal.ads.zzbbt;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbbv;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcq;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdqd;
import com.google.android.gms.internal.ads.zzpi;
import com.google.android.gms.internal.ads.zzqt;
import com.google.android.gms.internal.ads.zzrb;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzsh;
import com.google.android.gms.internal.ads.zztd;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzc;
import com.google.android.gms.internal.ads.zzzf;
import com.google.android.gms.internal.ads.zzzh;
import com.google.android.gms.internal.ads.zzzi;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbbq
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzbbc {
    private final zzbcq zzefl;
    @Nullable
    private final zzdf zzefm;
    private final zzawv zzblh;
    private final zzk zzefn;
    private final com.google.android.gms.ads.internal.zzb zzefo;
    private final DisplayMetrics zzwl;
    private final float zzefp;
    @Nullable
    private final zzrb zzefq;
    private final boolean zzefr;
    private boolean zzefs = false;
    private boolean zzeft = false;
    private zzbbf zzefu;
    @GuardedBy(value="this")
    private zze zzefv;
    @GuardedBy(value="this")
    private IObjectWrapper zzefw;
    @GuardedBy(value="this")
    private zzbct zzefx;
    @GuardedBy(value="this")
    private String zzabd;
    @GuardedBy(value="this")
    private boolean zzdho;
    @GuardedBy(value="this")
    private boolean zzefy;
    @GuardedBy(value="this")
    private boolean zzefz;
    @GuardedBy(value="this")
    private boolean zzega;
    @GuardedBy(value="this")
    private Boolean zzdql;
    @GuardedBy(value="this")
    private int zzegb;
    @GuardedBy(value="this")
    private boolean zzegc = true;
    @GuardedBy(value="this")
    private boolean zzegd = false;
    @GuardedBy(value="this")
    private String zzdis = "";
    @GuardedBy(value="this")
    private zzbbu zzege;
    @GuardedBy(value="this")
    private boolean zzegf;
    @GuardedBy(value="this")
    private boolean zzegg;
    @GuardedBy(value="this")
    private zzaag zzegh;
    @GuardedBy(value="this")
    private zzaab zzegi;
    @GuardedBy(value="this")
    private zzqt zzegj;
    @GuardedBy(value="this")
    private int zzegk;
    @GuardedBy(value="this")
    private int zzegl;
    private zzzf zzegm;
    private zzzf zzeag;
    private zzzf zzegn;
    private zzzi zzego;
    private WeakReference<View.OnClickListener> zzegp;
    @GuardedBy(value="this")
    private zze zzegq;
    @GuardedBy(value="this")
    private boolean zzegr;
    private zzawf zzegs;
    private int zzdgd = -1;
    private int zzdgc = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbah> zzegt;
    private final WindowManager zzbnm;
    private final zzrz zzeeb;

    static zzbbq zzb(Context context, zzbct zzbct2, String string2, boolean bl, boolean bl2, @Nullable zzdf zzdf2, zzawv zzawv2, zzzh zzzh2, zzk zzk2, com.google.android.gms.ads.internal.zzb zzb2, zzrz zzrz2, zzrb zzrb2, boolean bl3) {
        zzbcq zzbcq2 = new zzbcq(context);
        return new zzbbq(zzbcq2, zzbct2, string2, bl, bl2, zzdf2, zzawv2, zzzh2, zzk2, zzb2, zzrz2, zzrb2, bl3);
    }

    @VisibleForTesting
    private zzbbq(zzbcq zzbcq2, zzbct zzbct2, String string2, boolean bl, boolean bl2, @Nullable zzdf zzdf2, zzawv zzawv2, zzzh zzzh2, zzk zzk2, com.google.android.gms.ads.internal.zzb zzb2, zzrz zzrz2, zzrb zzrb2, boolean bl3) {
        super((Context)zzbcq2);
        this.zzefl = zzbcq2;
        this.zzefx = zzbct2;
        this.zzabd = string2;
        this.zzefz = bl;
        this.zzegb = -1;
        this.zzefm = zzdf2;
        this.zzblh = zzawv2;
        this.zzefn = zzk2;
        this.zzefo = zzb2;
        this.zzbnm = (WindowManager)this.getContext().getSystemService("window");
        zzp.zzjy();
        this.zzwl = zzatv.zza(this.zzbnm);
        this.zzefp = this.zzwl.density;
        this.zzeeb = zzrz2;
        this.zzefq = zzrb2;
        this.zzefr = bl3;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzatm.zzc((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzp.zzjy().zza((Context)zzbcq2, zzawv2.zzbnh, webSettings);
        zzp.zzka().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzaag();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            this.addJavascriptInterface(zzbbz.zzc(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzegs = new zzawf(this.zzefl.zzxl(), (View)this, this, null);
        zzzh zzzh3 = zzzh2;
        zzbbq zzbbq2 = this;
        zzbbq2.zzaak();
        zzbbq2.zzego = new zzzi(new zzzh(true, "make_wv", zzbbq2.zzabd));
        zzbbq2.zzego.zzpy().zzc(zzzh3);
        zzbbq2.zzeag = zzzc.zzb(zzbbq2.zzego.zzpy());
        zzbbq2.zzego.zza("native:view_create", zzbbq2.zzeag);
        zzbbq2.zzegn = null;
        zzbbq2.zzegm = null;
        zzp.zzka().zzbb((Context)zzbcq2);
        zzp.zzkc().zzug();
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzbbf) {
            this.zzefu = (zzbbf)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final com.google.android.gms.ads.internal.zzb zzxm() {
        return this.zzefo;
    }

    private final boolean zzaad() {
        int n;
        int n2;
        if (!this.zzefu.zzzr() && !this.zzefu.zzzs()) {
            return false;
        }
        zzuo.zzof();
        int n3 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)this.zzwl.widthPixels);
        zzuo.zzof();
        int n4 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)this.zzwl.heightPixels);
        Activity activity = this.zzefl.zzxl();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzp.zzjy();
            int[] nArray = zzatv.zzd(activity);
            zzuo.zzof();
            n2 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)nArray[0]);
            zzuo.zzof();
            n = zzawe.zzb((DisplayMetrics)this.zzwl, (int)nArray[1]);
        }
        if (this.zzdgc == n3 && this.zzdgd == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdgc != n3 || this.zzdgd != n4;
        this.zzdgc = n3;
        this.zzdgd = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzamp(this).zza(n3, n4, n2, n, this.zzwl.density, this.zzbnm.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzp.zzjy().zzi(map);
        }
        catch (JSONException jSONException) {
            zzatm.zzeu((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zza(string2, jSONObject);
    }

    @TargetApi(value=19)
    public final synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzatm.zzew((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    private final synchronized void zzfi(String string2) {
        if (!this.isDestroyed()) {
            this.loadUrl(string2);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            try {
                super.loadUrl(string2);
                return;
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                zzp.zzkc().zza(throwable, "AdWebViewImpl.loadUrl");
                zzatm.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
                return;
            }
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final synchronized void zzfj(String string2) {
        try {
            super.loadUrl(string2);
            return;
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
            zzp.zzkc().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
            zzatm.zzd((String)"Could not call loadUrl. ", (Throwable)throwable);
            return;
        }
    }

    @Override
    public final synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, zzbcj.zzf(string3, zzbcj.zzaam()), "text/html", "UTF-8", string4);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    @TargetApi(value=19)
    private final synchronized void zza(String string2, ValueCallback<String> valueCallback) {
        if (!this.isDestroyed()) {
            this.evaluateJavascript(string2, null);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    private final void zzfk(String string2) {
        if (PlatformVersion.isAtLeastKitKat()) {
            if (this.zzue() == null) {
                this.zzaae();
            }
            if (this.zzue().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
                return;
            }
            String string3 = String.valueOf(string2);
            this.zzfi(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            return;
        }
        String string4 = String.valueOf(string2);
        this.zzfi(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
    }

    @Override
    public final void zzct(String string2) {
        this.zzfk(string2);
    }

    private final synchronized void zzaae() {
        this.zzdql = zzp.zzkc().zzue();
        if (this.zzdql == null) {
            try {
                String string2 = "(function(){})()";
                this.evaluateJavascript(string2, null);
                this.zza(true);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.zza(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void zza(Boolean bl) {
        zzbbq zzbbq2 = this;
        synchronized (zzbbq2) {
            this.zzdql = bl;
        }
        zzp.zzkc().zza(bl);
    }

    @VisibleForTesting
    private final synchronized Boolean zzue() {
        return this.zzdql;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        String string3;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string4 = string3 = jSONObject.toString();
        String string5 = string2;
        zzbbq zzbbq2 = this;
        String string6 = new StringBuilder(3 + String.valueOf(string5).length() + String.valueOf(string4).length()).append(string5).append("(").append(string4).append(");").toString();
        zzbbq2.zzfk(string6);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzatm.zzdv((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzfk(stringBuilder.toString());
    }

    @Override
    public final void zzyr() {
        this.zzaaf();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzblh.zzbnh);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzdc(int n) {
        if (n == 0) {
            zzbbq zzbbq2 = this;
            zzzc.zza(zzbbq2.zzego.zzpy(), zzbbq2.zzeag, "aebb2");
        }
        this.zzaaf();
        if (this.zzego.zzpy() != null) {
            this.zzego.zzpy().zzj("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzblh.zzbnh);
        this.zza("onhide", hashMap);
    }

    private final void zzaaf() {
        zzzc.zza(this.zzego.zzpy(), this.zzeag, "aeh2");
    }

    @Override
    public final void zzsq() {
        if (this.zzegm == null) {
            zzzc.zza(this.zzego.zzpy(), this.zzeag, "aes2");
            this.zzegm = zzzc.zzb(this.zzego.zzpy());
            this.zzego.zza("native:view_show", this.zzegm);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzblh.zzbnh);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzys() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzp.zzkd().zzop()));
        hashMap.put("app_volume", String.valueOf(zzp.zzkd().zzoo()));
        hashMap.put("device_volume", String.valueOf(zzauk.zzbd(this.getContext())));
        this.zza("volume", hashMap);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        this.zza("onCacheAccessComplete", hashMap);
    }

    @Override
    public final synchronized zze zzyu() {
        return this.zzefv;
    }

    @Override
    public final synchronized IObjectWrapper zzzc() {
        return this.zzefw;
    }

    @Override
    public final synchronized zze zzyv() {
        return this.zzegq;
    }

    @Override
    public final synchronized zzbct zzyw() {
        return this.zzefx;
    }

    @Override
    public final synchronized String zzyx() {
        return this.zzabd;
    }

    @Override
    public final WebViewClient zzyz() {
        return this.zzefu;
    }

    @Override
    public final synchronized boolean zzza() {
        return this.zzdho;
    }

    @Override
    public final zzdf zzzb() {
        return this.zzefm;
    }

    @Override
    public final zzawv zzxp() {
        return this.zzblh;
    }

    @Override
    public final synchronized boolean zzzd() {
        return this.zzefz;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzp.zzjy();
            zzatv.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzatm.zzdv((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzefu.zzzs()) {
            zzbbq zzbbq2 = this;
            synchronized (zzbbq2) {
                if (this.zzegh != null) {
                    this.zzegh.zzc(motionEvent);
                }
            }
        } else if (this.zzefm != null) {
            this.zzefm.zzb(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzefz || this.zzefx.zzaar()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzefx.zzaat()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzefx.zzaas()) {
            zzyi zzyi2 = zzyt.zzcod;
            if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbbu zzbbu2 = this.zzxj();
            if (zzbbu2 != null) {
                f = zzbbu2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzefx.isFluid()) {
            int n11;
            Object object = zzyt.zzcog;
            if (((Boolean)zzuo.zzoj().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbbs((zzbbq)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            this.zzfk(string2);
            float f = this.zzwl.density;
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzegl) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzegl * f);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzefx.zzaaq()) {
            this.setMeasuredDimension(this.zzwl.widthPixels, this.zzwl.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzefx.widthPixels > n17 || this.zzefx.heightPixels > n18 ? 1 : 0;
        zzyi zzyi3 = zzyt.zzcrb;
        if (((Boolean)zzuo.zzoj().zzd(zzyi3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzefx.widthPixels / this.zzefp > (float)n17 / this.zzefp) && !((float)this.zzefx.heightPixels / this.zzefp > (float)n18 / this.zzefp) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzefx.widthPixels / this.zzefp);
            int n21 = (int)((float)this.zzefx.heightPixels / this.zzefp);
            int n22 = (int)((float)n14 / this.zzefp);
            int n23 = (int)((float)n16 / this.zzefp);
            zzatm.zzeu((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            if (!this.zzefs) {
                this.zzeeb.zza(zzsb.zza.zzb.zzbth);
                this.zzefs = true;
                return;
            }
        } else {
            if (this.getVisibility() != 8) {
                this.setVisibility(0);
            }
            if (!this.zzeft) {
                this.zzeeb.zza(zzsb.zza.zzb.zzbti);
                this.zzeft = true;
            }
            this.setMeasuredDimension(this.zzefx.widthPixels, this.zzefx.heightPixels);
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzaad();
        zze zze2 = this.zzyu();
        if (zze2 != null && bl) {
            zze2.zzsp();
        }
    }

    @Override
    public final synchronized void zza(zze zze2) {
        this.zzefv = zze2;
    }

    @Override
    public final synchronized void zzaq(IObjectWrapper iObjectWrapper) {
        this.zzefw = iObjectWrapper;
    }

    @Override
    public final synchronized void zzb(zze zze2) {
        this.zzegq = zze2;
    }

    @Override
    public final synchronized void zza(zzbct zzbct2) {
        this.zzefx = zzbct2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzefz;
        this.zzefz = bl;
        this.zzaag();
        if (bl2) {
            zzyi zzyi2 = zzyt.zzcic;
            if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() || !this.zzefx.zzaaq()) {
                new zzamp(this).zzdp(bl ? "expanded" : "default");
            }
        }
    }

    @Override
    public final void zzzh() {
        this.zzegs.zzwe();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzegs.onAttachedToWindow();
        }
        boolean bl = this.zzegf;
        if (this.zzefu != null && this.zzefu.zzzs()) {
            bl = true;
            if (!this.zzegg) {
                this.zzefu.zzzt();
                this.zzefu.zzzu();
                this.zzegg = true;
            }
            this.zzaad();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbbq zzbbq2 = this;
        synchronized (zzbbq2) {
            if (!this.isDestroyed()) {
                this.zzegs.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzegg && this.zzefu != null && this.zzefu.zzzs() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzefu.zzzt();
                this.zzefu.zzzu();
                this.zzegg = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbq(Context context) {
        this.zzefl.setBaseContext(context);
        this.zzegs.zzh(this.zzefl.zzxl());
    }

    @Override
    public final synchronized void zzae(boolean bl) {
        if (this.zzefv != null) {
            this.zzefv.zza(this.zzefu.zzzr(), bl);
            return;
        }
        this.zzdho = bl;
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzegb = n;
        if (this.zzefv != null) {
            this.zzefv.setRequestedOrientation(this.zzegb);
        }
    }

    @Override
    public final Activity zzxl() {
        return this.zzefl.zzxl();
    }

    @Override
    public final Context zzyt() {
        return this.zzefl.zzyt();
    }

    private final synchronized void zzaag() {
        if (this.zzefz || this.zzefx.zzaaq()) {
            zzatm.zzdv((String)"Enabling hardware acceleration on an overlay.");
            this.zzaai();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzatm.zzdv((String)"Disabling hardware acceleration on an AdView.");
            this.zzaah();
            return;
        }
        zzatm.zzdv((String)"Enabling hardware acceleration on an AdView.");
        this.zzaai();
    }

    private final synchronized void zzaah() {
        if (!this.zzega) {
            zzp.zzka();
            this.setLayerType(1, null);
        }
        this.zzega = true;
    }

    private final synchronized void zzaai() {
        if (this.zzega) {
            zzp.zzka();
            this.setLayerType(0, null);
        }
        this.zzega = false;
    }

    @Override
    public final synchronized void destroy() {
        this.zzaak();
        this.zzegs.zzwf();
        if (this.zzefv != null) {
            this.zzefv.close();
            this.zzefv.onDestroy();
            this.zzefv = null;
        }
        this.zzefw = null;
        this.zzefu.reset();
        if (this.zzefy) {
            return;
        }
        zzp.zzku();
        zzbae.zzc(this);
        this.zzaaj();
        this.zzefy = true;
        zzatm.zzdy("Initiating WebView self destruct sequence in 3...");
        zzatm.zzdy("Loading blank page in WebView, 2...");
        this.zzfj("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            zzbbq zzbbq2 = this;
            synchronized (zzbbq2) {
                if (!this.zzefy) {
                    this.zzefu.reset();
                    zzp.zzku();
                    zzbae.zzc(this);
                    this.zzaaj();
                    this.zzuh();
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public final synchronized void zzze() {
        zzatm.zzdy("Destroying WebView!");
        this.zzuh();
        zzatv.zzdsk.post((Runnable)new zzbbv(this));
    }

    private final synchronized void zzuh() {
        if (!this.zzegr) {
            this.zzegr = true;
            zzp.zzkc().zzuh();
        }
    }

    @Override
    public final synchronized boolean isDestroyed() {
        return this.zzefy;
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzefu != null) {
            // empty if block
        }
    }

    @Override
    public final void zzzi() {
        if (this.zzegn == null) {
            this.zzegn = zzzc.zzb(this.zzego.zzpy());
            this.zzego.zza("native:view_load", this.zzegn);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzzl() {
        zzatm.zzdy("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzefu.zzat(bl);
    }

    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzegc = bl;
    }

    @Override
    public final synchronized boolean zzzf() {
        return this.zzegc;
    }

    @Override
    public final synchronized void zzju() {
        this.zzegd = true;
        if (this.zzefn != null) {
            this.zzefn.zzju();
        }
    }

    @Override
    public final synchronized void zzjv() {
        this.zzegd = false;
        if (this.zzefn != null) {
            this.zzefn.zzjv();
        }
    }

    private final synchronized void zzaaj() {
        if (this.zzegt != null) {
            Iterator<zzbah> iterator = this.zzegt.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzegt = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbah zzbah2) {
        if (this.zzegt == null) {
            this.zzegt = new HashMap<String, zzbah>();
        }
        this.zzegt.put(string2, zzbah2);
    }

    @Override
    public final synchronized zzbah zzez(String string2) {
        if (this.zzegt == null) {
            return null;
        }
        return this.zzegt.get(string2);
    }

    @Override
    public final synchronized String zzxn() {
        return this.zzdis;
    }

    @Override
    public final zzayi zzxi() {
        return null;
    }

    @Override
    public final synchronized void zzxs() {
        if (this.zzegi != null) {
            this.zzegi.zzqe();
        }
    }

    @Override
    public final synchronized void zza(zzaab zzaab2) {
        this.zzegi = zzaab2;
    }

    @Override
    public final synchronized void zza(zzqt zzqt2) {
        this.zzegj = zzqt2;
    }

    @Override
    public final synchronized zzqt zzzm() {
        return this.zzegj;
    }

    @Override
    public final zzzf zzxk() {
        return this.zzeag;
    }

    @Override
    public final zzzi zzxo() {
        return this.zzego;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzegp = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzaag zzaag2) {
        this.zzegh = zzaag2;
    }

    @Override
    public final synchronized zzaag zzzj() {
        return this.zzegh;
    }

    @Override
    public final synchronized zzbbu zzxj() {
        return this.zzege;
    }

    @Override
    public final synchronized void zza(zzbbu zzbbu2) {
        if (this.zzege != null) {
            zzatm.zzes((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzege = zzbbu2;
    }

    @Override
    public final synchronized boolean zzzg() {
        return this.zzegk > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzegk += bl ? 1 : -1;
        if (this.zzegk <= 0 && this.zzefv != null) {
            this.zzefv.zzss();
        }
    }

    private final void zzaak() {
        if (this.zzego == null) {
            return;
        }
        zzzh zzzh2 = this.zzego.zzpy();
        if (zzzh2 != null && zzp.zzkc().zzud() != null) {
            zzp.zzkc().zzud().zza(zzzh2);
        }
    }

    @Override
    public final void zzzk() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzefu.zzao(bl);
    }

    @Override
    public final void zzsr() {
        zze zze2 = this.zzyu();
        if (zze2 != null) {
            zze2.zzsr();
        }
    }

    @Override
    public final int zzxq() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzxr() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzb zzb2) {
        this.zzefu.zza(zzb2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzefu.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzefu.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzefu.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzpi zzpi2) {
        zzbbq zzbbq2 = this;
        synchronized (zzbbq2) {
            this.zzegf = zzpi2.zzbnr;
        }
        this.zzav(zzpi2.zzbnr);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzadx<? super zzbbc> zzadx2) {
        if (this.zzefu != null) {
            this.zzefu.zza(string2, zzadx2);
        }
    }

    @Override
    public final void zzb(String string2, zzadx<? super zzbbc> zzadx2) {
        if (this.zzefu != null) {
            this.zzefu.zzb(string2, zzadx2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzadx<? super zzbbc>> predicate) {
        if (this.zzefu != null) {
            this.zzefu.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzeeb.zza(new zzbbt(bl, n));
        this.zzeeb.zza(zzsb.zza.zzb.zzbtj);
        return true;
    }

    @Override
    public final boolean zzzn() {
        return false;
    }

    @Override
    public final void zza(ViewGroup viewGroup, Activity activity, String string2, String string3) {
        if (!this.zzzp()) {
            zzatm.zzdy("AR ad is not enabled or the ad from the server is not an AR ad.");
            return;
        }
        if (this.getParent() instanceof ViewGroup) {
            zzbbq zzbbq2 = this;
            if (zzbbq2 == null) {
                throw null;
            }
            ((ViewGroup)this.getParent()).removeView((View)zzbbq2);
        }
        zzatm.zzdy("Initializing ArWebView object.");
        zzbbq zzbbq3 = this;
        if (zzbbq3 == null) {
            throw null;
        }
        this.zzefq.zza(activity, zzbbq3);
        this.zzefq.zze(string2, string3);
        if (viewGroup != null) {
            viewGroup.addView(this.zzefq.getView());
            return;
        }
        zzatm.zzes((String)"The FrameLayout object cannot be null.");
    }

    @Override
    public final zzrb zzzo() {
        return this.zzefq;
    }

    @Override
    public final boolean zzzp() {
        zzyi zzyi2 = zzyt.zzcsy;
        return (Boolean)zzuo.zzoj().zzd(zzyi2) != false && this.zzefq != null && this.zzefr;
    }

    @Override
    public final /* synthetic */ zzbcm zzyy() {
        return this.zzefu;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zztd zztd2) {
        zzsh.zzw.zza zza2 = zzsh.zzw.zznt();
        if (zza2.zzns() != bl) {
            zza2.zzq(bl);
        }
        zztd2.zzcan = (zzsh.zzw)((zzdqd)zza2.zzcg(n).zzazm());
    }

    static /* synthetic */ int zza(zzbbq zzbbq2) {
        return zzbbq2.zzegl;
    }

    static /* synthetic */ int zza(zzbbq zzbbq2, int n) {
        zzbbq2.zzegl = n;
        return zzbbq2.zzegl;
    }

    static /* synthetic */ void zzb(zzbbq zzbbq2) {
        super.destroy();
    }
}

