/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.Uri;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzb;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzadd;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadi;
import com.google.android.gms.internal.ads.zzadk;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzadz;
import com.google.android.gms.internal.ads.zzaea;
import com.google.android.gms.internal.ads.zzaeb;
import com.google.android.gms.internal.ads.zzaec;
import com.google.android.gms.internal.ads.zzagf;
import com.google.android.gms.internal.ads.zzamf;
import com.google.android.gms.internal.ads.zzamq;
import com.google.android.gms.internal.ads.zzams;
import com.google.android.gms.internal.ads.zzaro;
import com.google.android.gms.internal.ads.zzask;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawi;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzbam;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbcr;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzrb;
import com.google.android.gms.internal.ads.zzrg;
import com.google.android.gms.internal.ads.zzrl;
import com.google.android.gms.internal.ads.zzth;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
@VisibleForTesting
public final class zzbcs
extends zzbdf
implements zzbcm {
    protected zzbbc zzeea;
    private final zzagf<zzbbc> zzehm;
    private final Object lock = new Object();
    private zzth zzcbl;
    private zzp zzdhm;
    private zzbcp zzeed;
    private zzbco zzeee;
    private zzadg zzcwp;
    private zzadi zzcwr;
    private zzbcr zzeef;
    private boolean zzeeg = false;
    private volatile boolean zzbni;
    @GuardedBy(value="lock")
    private boolean zzeeh;
    @GuardedBy(value="lock")
    private boolean zzeei;
    private zzv zzdhq;
    private zzamq zzeej;
    private zza zzcxn;
    private zzamf zzcxo;
    @Nullable
    private zzaro zzeek;
    private boolean zzeel;
    private boolean zzeem;
    private int zzeen;
    private boolean zzdlf;
    private View.OnAttachStateChangeListener zzeeo;

    public zzbcs() {
        this.zzehm = new zzagf();
    }

    final void zza(zzbbc zzbbc2, boolean bl) {
        zzamq zzamq2 = new zzamq(zzbbc2, zzbbc2.zzyt(), new zzye(zzbbc2.getContext()));
        boolean bl2 = bl;
        zzbbc zzbbc3 = zzbbc2;
        zzbcs zzbcs2 = this;
        this.zzeea = zzbbc3;
        zzbcs2.zzbni = bl2;
        zzbcs2.zzeej = zzamq2;
        zzbcs2.zzcxo = null;
        zzbcs2.zzehm.zzg(zzbbc3);
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzeej.zzi(n, n2);
        if (this.zzcxo != null) {
            this.zzcxo.zza(n, n2, false);
        }
    }

    public final void zza(String string2, zzadx<? super zzbbc> zzadx2) {
        this.zzehm.zza(string2, zzadx2);
    }

    public final void zzb(String string2, zzadx<? super zzbbc> zzadx2) {
        this.zzehm.zzb(string2, zzadx2);
    }

    public final void zza(String string2, Predicate<zzadx<? super zzbbc>> predicate) {
        this.zzehm.zza(string2, predicate);
    }

    @Override
    public final void zza(zzth zzth2, zzadg zzadg2, zzp zzp2, zzadi zzadi2, zzv zzv2, boolean bl, @Nullable zzaea zzaea2, zza zza2, zzams zzams2, @Nullable zzaro zzaro2) {
        boolean bl2;
        if (zza2 == null) {
            zza2 = new zza(this.zzeea.getContext(), zzaro2, null);
        }
        this.zzcxo = new zzamf(this.zzeea, zzams2);
        this.zzeek = zzaro2;
        zzyi zzyi2 = zzyt.zzckf;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            this.zza("/adMetadata", new zzadd(zzadg2));
        }
        this.zza("/appEvent", new zzadf(zzadi2));
        this.zza("/backButton", zzadk.zzcxc);
        this.zza("/refresh", zzadk.zzcxd);
        this.zza("/canOpenURLs", zzadk.zzcwt);
        this.zza("/canOpenIntents", zzadk.zzcwu);
        this.zza("/click", zzadk.zzcwv);
        this.zza("/close", zzadk.zzcww);
        this.zza("/customClose", zzadk.zzcwx);
        this.zza("/instrument", zzadk.zzcxg);
        this.zza("/delayPageLoaded", zzadk.zzcxi);
        this.zza("/delayPageClosed", zzadk.zzcxj);
        this.zza("/getLocationInfo", zzadk.zzcxk);
        this.zza("/httpTrack", zzadk.zzcwy);
        this.zza("/log", zzadk.zzcwz);
        this.zza("/mraid", new zzaec(zza2, this.zzcxo, zzams2));
        this.zza("/mraidLoaded", this.zzeej);
        this.zza("/open", new zzaeb(zza2, this.zzcxo));
        this.zza("/precache", new zzbam());
        this.zza("/touch", zzadk.zzcxb);
        this.zza("/video", zzadk.zzcxe);
        this.zza("/videoMeta", zzadk.zzcxf);
        if (com.google.android.gms.ads.internal.zzp.zzkw().zzaa(this.zzeea.getContext())) {
            this.zza("/logScionEvent", new zzadz(this.zzeea.getContext()));
        }
        this.zzcbl = zzth2;
        this.zzdhm = zzp2;
        this.zzcwp = zzadg2;
        this.zzcwr = zzadi2;
        this.zzdhq = zzv2;
        this.zzcxn = zza2;
        this.zzeeg = bl2 = bl;
    }

    @Override
    public final zza zzzq() {
        return this.zzcxn;
    }

    @Override
    public final boolean zzzr() {
        return this.zzbni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzzs() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzeeh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzzt() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzzu() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    public final void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
        zzrb zzrb2 = this.zzeea.zzzo();
        if (zzrb2 != null && webView == zzrb2.getWebView()) {
            zzrb2.onPageStarted(webView, string2, bitmap);
        }
        super.onPageStarted(webView, string2, bitmap);
    }

    @Override
    public final void zza(zzbde zzbde2) {
        this.zzeel = true;
        zzbcs zzbcs2 = this;
        if (zzbcs2.zzeee != null) {
            zzbcs2.zzeee.zzrb();
            zzbcs2.zzeee = null;
        }
        this.zzaaa();
    }

    private final void zza(View view, zzaro zzaro2, int n) {
        if (zzaro2.zztj() && n > 0) {
            zzaro2.zzj(view);
            if (zzaro2.zztj()) {
                zzatv.zzdsk.postDelayed((Runnable)new zzbcu(this, view, zzaro2, n), 100L);
            }
        }
    }

    private final void zzzv() {
        if (this.zzeeo == null) {
            return;
        }
        this.zzeea.getView().removeOnAttachStateChangeListener(this.zzeeo);
    }

    @Override
    public final void zzzw() {
        zzaro zzaro2 = this.zzeek;
        if (zzaro2 != null) {
            WebView webView = this.zzeea.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzaro2, 10);
                return;
            }
            zzaro zzaro3 = zzaro2;
            zzbcs zzbcs2 = this;
            zzbcs2.zzzv();
            zzbcs2.zzeeo = new zzbcx(zzbcs2, zzaro3);
            zzbcs2.zzeea.getView().addOnAttachStateChangeListener(zzbcs2.zzeeo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzzx() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeei = true;
        }
        ++this.zzeen;
        this.zzaaa();
    }

    @Override
    public final void zzzy() {
        --this.zzeen;
        this.zzaaa();
    }

    @Override
    public final void zzzz() {
        this.zzeem = true;
        this.zzaaa();
    }

    private final void zzaaa() {
        if (this.zzeed != null && (this.zzeel && this.zzeen <= 0 || this.zzeem)) {
            this.zzeed.zzab(!this.zzeem);
            this.zzeed = null;
        }
        this.zzeea.zzzi();
    }

    public final void zza(zzb zzb2) {
        boolean bl = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel(zzb2, (zzth)(bl && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), bl ? null : this.zzdhm, this.zzdhq, this.zzeea.zzxp()));
    }

    public final void zzc(boolean bl, int n) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), this.zzdhm, this.zzdhq, this.zzeea, bl, n, this.zzeea.zzxp()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), (zzp)(bl2 ? null : new zzbcw(this.zzeea, this.zzdhm)), this.zzcwp, this.zzcwr, this.zzdhq, this.zzeea, bl, n, string2, this.zzeea.zzxp()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzeea.zzzd();
        this.zza(new AdOverlayInfoParcel((zzth)(bl2 && !this.zzeea.zzyw().zzaaq() ? null : this.zzcbl), bl2 ? null : new zzbcw(this.zzeea, this.zzdhm), this.zzcwp, this.zzcwr, this.zzdhq, this.zzeea, bl, n, string2, string3, this.zzeea.zzxp()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzcxo != null) {
            bl = this.zzcxo.zzsg();
        }
        com.google.android.gms.ads.internal.zzp.zzjx();
        zzl.zza(this.zzeea.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzeek != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdhl != null) {
                string2 = adOverlayInfoParcel.zzdhl.url;
            }
            this.zzeek.zzdq(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        if (this.zzeek != null) {
            this.zzeek.zztl();
            this.zzeek = null;
        }
        this.zzzv();
        this.zzehm.reset();
        this.zzehm.zzg((zzbbc)null);
        Object object = this.lock;
        synchronized (object) {
            this.zzcbl = null;
            this.zzdhm = null;
            this.zzeed = null;
            this.zzeee = null;
            this.zzcwp = null;
            this.zzcwr = null;
            this.zzdhq = null;
            this.zzeef = null;
            if (this.zzcxo != null) {
                this.zzcxo.zzv(true);
                this.zzcxo = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbcp zzbcp2) {
        this.zzeed = zzbcp2;
    }

    @Override
    public final void zza(zzbco zzbco2) {
        this.zzeee = zzbco2;
    }

    @Override
    public final void zzb(zzbde zzbde2) {
        this.zzehm.zzg(zzbde2.uri);
    }

    @Override
    public final boolean zzc(zzbde zzbde2) {
        String string2;
        String string3 = String.valueOf(zzbde2.url);
        zzatm.zzdy(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = zzbde2.uri;
        if (this.zzehm.zzg(uri)) {
            return true;
        }
        if (this.zzeeg && ("http".equalsIgnoreCase(string2 = uri.getScheme()) || "https".equalsIgnoreCase(string2))) {
            if (this.zzcbl != null) {
                this.zzcbl.onAdClicked();
                if (this.zzeek != null) {
                    this.zzeek.zzdq(zzbde2.url);
                }
                this.zzcbl = null;
            }
            return false;
        }
        if (!this.zzeea.getWebView().willNotDraw()) {
            try {
                zzdf zzdf2 = this.zzeea.zzzb();
                if (zzdf2 != null && zzdf2.zzc(uri)) {
                    uri = zzdf2.zza(uri, this.zzeea.getContext(), this.zzeea.getView(), this.zzeea.zzxl());
                }
            }
            catch (zzdi zzdi2) {
                String string4 = String.valueOf(zzbde2.url);
                zzatm.zzeu((String)(string4.length() != 0 ? "Unable to append parameter to URL: ".concat(string4) : new String("Unable to append parameter to URL: ")));
            }
            if (this.zzcxn == null || this.zzcxn.zzjh()) {
                this.zza(new zzb("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
            } else {
                this.zzcxn.zzbl(zzbde2.url);
            }
        } else {
            String string5 = String.valueOf(zzbde2.url);
            zzatm.zzeu((String)(string5.length() != 0 ? "AdWebView unable to handle URL: ".concat(string5) : new String("AdWebView unable to handle URL: ")));
        }
        return true;
    }

    @Override
    @Nullable
    public final WebResourceResponse zzd(zzbde zzbde2) {
        WebResourceResponse webResourceResponse;
        WebResourceResponse webResourceResponse2;
        if (this.zzeek != null) {
            this.zzeek.zza(zzbde2.url, zzbde2.zzab, 1);
        }
        zzbde zzbde3 = zzbde2;
        zzbcs zzbcs2 = this;
        String string2 = new File(zzbde3.url).getName();
        if (!"mraid.js".equalsIgnoreCase(string2)) {
            webResourceResponse2 = null;
        } else {
            String string3;
            zzbcs2.zzsm();
            if (zzbcs2.zzeea.zzyw().zzaaq()) {
                zzyi zzyi2 = zzyt.zzcia;
                string3 = (String)zzuo.zzoj().zzd(zzyi2);
            } else if (zzbcs2.zzeea.zzzd()) {
                zzyi zzyi3 = zzyt.zzchz;
                string3 = (String)zzuo.zzoj().zzd(zzyi3);
            } else {
                zzyi zzyi4 = zzyt.zzchy;
                string3 = (String)zzuo.zzoj().zzd(zzyi4);
            }
            com.google.android.gms.ads.internal.zzp.zzjy();
            webResourceResponse2 = webResourceResponse = zzatv.zzd(zzbcs2.zzeea.getContext(), zzbcs2.zzeea.zzxp().zzbnh, string3);
        }
        if (webResourceResponse2 != null) {
            return webResourceResponse;
        }
        try {
            zzrg zzrg2;
            if (!zzask.zzd(zzbde2.url, this.zzeea.getContext(), this.zzdlf).equals(zzbde2.url)) {
                return this.zze(zzbde2);
            }
            zzrl zzrl2 = zzrl.zzbt(zzbde2.url);
            if (zzrl2 != null && (zzrg2 = com.google.android.gms.ads.internal.zzp.zzke().zza(zzrl2)) != null && zzrg2.zzmg()) {
                return new WebResourceResponse("", "", zzrg2.zzmh());
            }
            if (zzawi.isEnabled()) {
                zzbcs2 = zzyt.zzclm;
                if (((Boolean)zzuo.zzoj().zzd((zzyi)zzbcs2)).booleanValue()) {
                    return this.zze(zzbde2);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            com.google.android.gms.ads.internal.zzp.zzkc().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbcs.zzaab();
        }
    }

    private static WebResourceResponse zzaab() {
        zzyi zzyi2 = zzyt.zzcju;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(zzbde zzbde2) throws IOException {
        URL uRL = new URL(zzbde2.url);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : zzbde2.zzab.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            com.google.android.gms.ads.internal.zzp.zzjy().zza(this.zzeea.getContext(), this.zzeea.zzxp().zzbnh, false, httpURLConnection);
            zzawi zzawi22 = new zzawi();
            zzawi22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzawi22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string2 = httpURLConnection.getHeaderField("Location");
                if (string2 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string3 = (uRL = new URL(uRL, string2)).getProtocol();
                if (string3 == null) {
                    zzatm.zzeu((String)"Protocol is null");
                    return zzbcs.zzaab();
                }
                if (!string3.equals("http") && !string3.equals("https")) {
                    String string4 = String.valueOf(string3);
                    zzatm.zzeu((String)(string4.length() != 0 ? "Unsupported scheme: ".concat(string4) : new String("Unsupported scheme: ")));
                    return zzbcs.zzaab();
                }
                String string5 = String.valueOf(string2);
                zzatm.zzdv((String)(string5.length() != 0 ? "Redirecting to ".concat(string5) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            com.google.android.gms.ads.internal.zzp.zzjy();
            return zzatv.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzao(boolean bl) {
        this.zzeeg = bl;
    }

    @Override
    public final zzaro zzaac() {
        return this.zzeek;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsm() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeeg = false;
            this.zzbni = true;
            zzawx.zzdwa.execute(new zzbcv(this));
            return;
        }
    }

    public final void zzat(boolean bl) {
        this.zzdlf = bl;
    }

    @Override
    public final void zzh(int n, int n2) {
        if (this.zzcxo != null) {
            this.zzcxo.zzh(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzau(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzeeh = true;
            return;
        }
    }

    @Override
    public final void zzh(Uri uri) {
        this.zzehm.zzh(uri);
    }

    @TargetApi(value=26)
    public final boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzeea.zzb(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static /* synthetic */ void zza(zzbcs zzbcs2, View view, zzaro zzaro2, int n) {
        zzbcs2.zza(view, zzaro2, n);
    }
}

