/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaab;
import com.google.android.gms.internal.ads.zzaag;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzagb;
import com.google.android.gms.internal.ads.zzage;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzauk;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawf;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzayi;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzbah;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbbz;
import com.google.android.gms.internal.ads.zzbcj;
import com.google.android.gms.internal.ads.zzbcm;
import com.google.android.gms.internal.ads.zzbcq;
import com.google.android.gms.internal.ads.zzbcs;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbda;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbdh;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzdqd;
import com.google.android.gms.internal.ads.zzpi;
import com.google.android.gms.internal.ads.zzqt;
import com.google.android.gms.internal.ads.zzrb;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzsb;
import com.google.android.gms.internal.ads.zzsh;
import com.google.android.gms.internal.ads.zztd;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzc;
import com.google.android.gms.internal.ads.zzzf;
import com.google.android.gms.internal.ads.zzzh;
import com.google.android.gms.internal.ads.zzzi;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbdb
extends zzbdh
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzagb,
zzbbc {
    private final zzbcq zzefl;
    private final zzbcs zzehp;
    @Nullable
    private final zzdf zzefm;
    private final zzawv zzblh;
    private final zzk zzefn;
    private final zzb zzefo;
    private final DisplayMetrics zzwl;
    private final zzrz zzeeb;
    @Nullable
    private final zzrb zzefq;
    private final boolean zzefr;
    @GuardedBy(value="this")
    private zze zzefv;
    @GuardedBy(value="this")
    private zzbct zzefx;
    @GuardedBy(value="this")
    private String zzabd;
    @GuardedBy(value="this")
    private boolean zzdho;
    @GuardedBy(value="this")
    private boolean zzefz;
    @GuardedBy(value="this")
    private boolean zzega;
    @GuardedBy(value="this")
    private int zzegb;
    @GuardedBy(value="this")
    private boolean zzegc = true;
    @GuardedBy(value="this")
    private boolean zzegd = false;
    @GuardedBy(value="this")
    private String zzdis = "";
    @GuardedBy(value="this")
    private zzbbu zzege;
    @GuardedBy(value="this")
    private boolean zzegf;
    @GuardedBy(value="this")
    private boolean zzegg;
    @GuardedBy(value="this")
    private zzaag zzegh;
    @GuardedBy(value="this")
    private zzaab zzegi;
    @GuardedBy(value="this")
    private zzqt zzegj;
    @GuardedBy(value="this")
    private int zzegk;
    @GuardedBy(value="this")
    private int zzegl;
    private zzzf zzegm;
    private zzzf zzeag;
    private zzzf zzegn;
    private zzzi zzego;
    private WeakReference<View.OnClickListener> zzegp;
    @GuardedBy(value="this")
    private zze zzegq;
    private zzawf zzegs;
    private final AtomicReference<IObjectWrapper> zzehq = new AtomicReference();
    private int zzdgd = -1;
    private int zzdgc = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbah> zzegt;
    private final WindowManager zzbnm;

    @VisibleForTesting
    protected zzbdb(zzbcq zzbcq2, zzbcs zzbcs2, zzbct zzbct2, String string2, boolean bl, boolean bl2, @Nullable zzdf zzdf2, zzawv zzawv2, zzzh zzzh2, zzk zzk2, zzb zzb2, zzrz zzrz2, zzrb zzrb2, boolean bl3) {
        super((Context)zzbcq2, zzbcs2);
        this.zzefl = zzbcq2;
        this.zzehp = zzbcs2;
        this.zzefx = zzbct2;
        this.zzabd = string2;
        this.zzefz = bl;
        this.zzegb = -1;
        this.zzefm = zzdf2;
        this.zzblh = zzawv2;
        this.zzefn = zzk2;
        this.zzefo = zzb2;
        this.zzbnm = (WindowManager)this.getContext().getSystemService("window");
        zzp.zzjy();
        this.zzwl = zzatv.zza(this.zzbnm);
        this.zzeeb = zzrz2;
        this.zzefq = zzrb2;
        this.zzefr = bl3;
        this.zzegs = new zzawf(this.zzefl.zzxl(), (View)this, this, null);
        zzp.zzjy().zza((Context)zzbcq2, zzawv2.zzbnh, this.getSettings());
        this.setDownloadListener(this);
        this.zzaag();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            ((zzbdc)this).addJavascriptInterface(zzbbz.zzc(this), "googleAdsJsInterface");
        }
        zzzh zzzh3 = zzzh2;
        zzbdb zzbdb2 = this;
        zzbdb2.zzaak();
        zzbdb2.zzego = new zzzi(new zzzh(true, "make_wv", zzbdb2.zzabd));
        zzbdb2.zzego.zzpy().zzc(zzzh3);
        zzbdb2.zzeag = zzzc.zzb(zzbdb2.zzego.zzpy());
        zzbdb2.zzego.zza("native:view_create", zzbdb2.zzeag);
        zzbdb2.zzegn = null;
        zzbdb2.zzegm = null;
        zzp.zzka().zzbb((Context)zzbcq2);
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zzb zzxm() {
        return this.zzefo;
    }

    private final boolean zzaad() {
        int n;
        int n2;
        if (!this.zzehp.zzzr() && !this.zzehp.zzzs()) {
            return false;
        }
        zzuo.zzof();
        int n3 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)this.zzwl.widthPixels);
        zzuo.zzof();
        int n4 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)this.zzwl.heightPixels);
        Activity activity = this.zzefl.zzxl();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzp.zzjy();
            int[] nArray = zzatv.zzd(activity);
            zzuo.zzof();
            n2 = zzawe.zzb((DisplayMetrics)this.zzwl, (int)nArray[0]);
            zzuo.zzof();
            n = zzawe.zzb((DisplayMetrics)this.zzwl, (int)nArray[1]);
        }
        if (this.zzdgc == n3 && this.zzdgd == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdgc != n3 || this.zzdgd != n4;
        this.zzdgc = n3;
        this.zzdgd = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzamp(this).zza(n3, n4, n2, n, this.zzwl.density, this.zzbnm.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        super.loadDataWithBaseURL(string2, zzbcj.zzf(string3, zzbcj.zzaam()), "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzct(String string2) {
        if (!this.isDestroyed()) {
            super.zzct(string2);
            return;
        }
        zzatm.zzeu((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzyr() {
        this.zzaaf();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzblh.zzbnh);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzage.zza((zzagb)this, "onhide", hashMap2);
    }

    @Override
    public final void zzdc(int n) {
        if (n == 0) {
            zzbdb zzbdb2 = this;
            zzzc.zza(zzbdb2.zzego.zzpy(), zzbdb2.zzeag, "aebb2");
        }
        this.zzaaf();
        if (this.zzego.zzpy() != null) {
            this.zzego.zzpy().zzj("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzblh.zzbnh);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzage.zza((zzagb)this, "onhide", hashMap2);
    }

    private final void zzaaf() {
        zzzc.zza(this.zzego.zzpy(), this.zzeag, "aeh2");
    }

    @Override
    public final void zzsq() {
        if (this.zzegm == null) {
            zzzc.zza(this.zzego.zzpy(), this.zzeag, "aes2");
            this.zzegm = zzzc.zzb(this.zzego.zzpy());
            this.zzego.zza("native:view_show", this.zzegm);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzblh.zzbnh);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzage.zza((zzagb)this, "onshow", hashMap2);
    }

    @Override
    public final void zzys() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzp.zzkd().zzop()));
        hashMap.put("app_volume", String.valueOf(zzp.zzkd().zzoo()));
        hashMap.put("device_volume", String.valueOf(zzauk.zzbd(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzage.zza((zzagb)this, "volume", hashMap2);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onCacheAccessComplete";
        zzage.zza((zzagb)this, "onCacheAccessComplete", hashMap2);
    }

    @Override
    public final synchronized zze zzyu() {
        return this.zzefv;
    }

    @Override
    public final IObjectWrapper zzzc() {
        return this.zzehq.get();
    }

    @Override
    public final synchronized zze zzyv() {
        return this.zzegq;
    }

    @Override
    public final synchronized zzbct zzyw() {
        return this.zzefx;
    }

    @Override
    public final synchronized String zzyx() {
        return this.zzabd;
    }

    @Override
    public final WebViewClient zzyz() {
        return this.zzehp;
    }

    @Override
    public final synchronized boolean zzza() {
        return this.zzdho;
    }

    @Override
    public final zzdf zzzb() {
        return this.zzefm;
    }

    @Override
    public final zzawv zzxp() {
        return this.zzblh;
    }

    @Override
    public final synchronized boolean zzzd() {
        return this.zzefz;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzp.zzjy();
            zzatv.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzatm.zzdv((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzehp.zzzs()) {
            zzbdb zzbdb2 = this;
            synchronized (zzbdb2) {
                if (this.zzegh != null) {
                    this.zzegh.zzc(motionEvent);
                }
            }
        } else if (this.zzefm != null) {
            this.zzefm.zzb(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzefz || this.zzefx.zzaar()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzefx.zzaat()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzefx.zzaas()) {
            zzyi zzyi2 = zzyt.zzcod;
            if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbbu zzbbu2 = this.zzxj();
            if (zzbbu2 != null) {
                f = zzbbu2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzefx.isFluid()) {
            int n11;
            Object object = zzyt.zzcog;
            if (((Boolean)zzuo.zzoj().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbdd((zzbdb)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzbdc)this).zzct(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzegl) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzegl * this.zzwl.density);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzefx.zzaaq()) {
            this.setMeasuredDimension(this.zzwl.widthPixels, this.zzwl.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzefx.widthPixels > n17 || this.zzefx.heightPixels > n18 ? 1 : 0;
        zzyi zzyi3 = zzyt.zzcrb;
        if (((Boolean)zzuo.zzoj().zzd(zzyi3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzefx.widthPixels / this.zzwl.density > (float)n17 / this.zzwl.density) && !((float)this.zzefx.heightPixels / this.zzwl.density > (float)n18 / this.zzwl.density) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzefx.widthPixels / this.zzwl.density);
            int n21 = (int)((float)this.zzefx.heightPixels / this.zzwl.density);
            int n22 = (int)((float)n14 / this.zzwl.density);
            int n23 = (int)((float)n16 / this.zzwl.density);
            zzatm.zzeu((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzefx.widthPixels, this.zzefx.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzaad();
        zze zze2 = this.zzyu();
        if (zze2 != null && bl) {
            zze2.zzsp();
        }
    }

    @Override
    public final synchronized void zza(zze zze2) {
        this.zzefv = zze2;
    }

    @Override
    public final void zzaq(IObjectWrapper iObjectWrapper) {
        this.zzehq.set(iObjectWrapper);
    }

    @Override
    public final synchronized void zzb(zze zze2) {
        this.zzegq = zze2;
    }

    @Override
    public final synchronized void zza(zzbct zzbct2) {
        this.zzefx = zzbct2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzefz;
        this.zzefz = bl;
        this.zzaag();
        if (bl2) {
            zzyi zzyi2 = zzyt.zzcic;
            if (!((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue() || !this.zzefx.zzaaq()) {
                new zzamp(this).zzdp(bl ? "expanded" : "default");
            }
        }
    }

    @Override
    public final void zzzh() {
        this.zzegs.zzwe();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzegs.onAttachedToWindow();
        }
        boolean bl = this.zzegf;
        if (this.zzehp != null && this.zzehp.zzzs()) {
            bl = true;
            if (!this.zzegg) {
                this.zzehp.zzzt();
                this.zzehp.zzzu();
                this.zzegg = true;
            }
            this.zzaad();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbdb zzbdb2 = this;
        synchronized (zzbdb2) {
            if (!this.isDestroyed()) {
                this.zzegs.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzegg && this.zzehp != null && this.zzehp.zzzs() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzehp.zzzt();
                this.zzehp.zzzu();
                this.zzegg = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbq(Context context) {
        this.zzefl.setBaseContext(context);
        this.zzegs.zzh(this.zzefl.zzxl());
    }

    @Override
    public final synchronized void zzae(boolean bl) {
        if (this.zzefv != null) {
            this.zzefv.zza(this.zzehp.zzzr(), bl);
            return;
        }
        this.zzdho = bl;
    }

    @Override
    public final void zzze() {
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzegb = n;
        if (this.zzefv != null) {
            this.zzefv.setRequestedOrientation(this.zzegb);
        }
    }

    @Override
    public final Activity zzxl() {
        return this.zzefl.zzxl();
    }

    @Override
    public final Context zzyt() {
        return this.zzefl.zzyt();
    }

    private final synchronized void zzaag() {
        if (this.zzefz || this.zzefx.zzaaq()) {
            zzatm.zzdv((String)"Enabling hardware acceleration on an overlay.");
            this.zzaai();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzatm.zzdv((String)"Disabling hardware acceleration on an AdView.");
            this.zzaah();
            return;
        }
        zzatm.zzdv((String)"Enabling hardware acceleration on an AdView.");
        this.zzaai();
    }

    private final synchronized void zzaah() {
        if (!this.zzega) {
            zzp.zzka();
            this.setLayerType(1, null);
        }
        this.zzega = true;
    }

    private final synchronized void zzaai() {
        if (this.zzega) {
            zzp.zzka();
            this.setLayerType(0, null);
        }
        this.zzega = false;
    }

    @Override
    protected final synchronized void zzaw(boolean bl) {
        if (!bl) {
            this.zzaak();
            this.zzegs.zzwf();
            if (this.zzefv != null) {
                this.zzefv.close();
                this.zzefv.onDestroy();
                this.zzefv = null;
            }
        }
        this.zzehq.set(null);
        this.zzehp.destroy();
        zzp.zzku();
        zzbae.zzc(this);
        this.zzaaj();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzehp != null) {
            // empty if block
        }
    }

    @Override
    public final void zzzi() {
        if (this.zzegn == null) {
            this.zzegn = zzzc.zzb(this.zzego.zzpy());
            this.zzego.zza("native:view_load", this.zzegn);
        }
    }

    @Override
    public final void onPause() {
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzzl() {
        zzatm.zzdy("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzehp.zzat(bl);
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzegc = bl;
    }

    @Override
    public final synchronized boolean zzzf() {
        return this.zzegc;
    }

    @Override
    public final synchronized void zzju() {
        this.zzegd = true;
        if (this.zzefn != null) {
            this.zzefn.zzju();
        }
    }

    @Override
    public final synchronized void zzjv() {
        this.zzegd = false;
        if (this.zzefn != null) {
            this.zzefn.zzjv();
        }
    }

    private final synchronized void zzaaj() {
        if (this.zzegt != null) {
            Iterator<zzbah> iterator = this.zzegt.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzegt = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbah zzbah2) {
        if (this.zzegt == null) {
            this.zzegt = new HashMap<String, zzbah>();
        }
        this.zzegt.put(string2, zzbah2);
    }

    @Override
    public final synchronized zzbah zzez(String string2) {
        if (this.zzegt == null) {
            return null;
        }
        return this.zzegt.get(string2);
    }

    @Override
    public final synchronized String zzxn() {
        return this.zzdis;
    }

    @Override
    public final zzayi zzxi() {
        return null;
    }

    @Override
    public final zzzf zzxk() {
        return this.zzeag;
    }

    @Override
    public final zzzi zzxo() {
        return this.zzego;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzegp = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzaag zzaag2) {
        this.zzegh = zzaag2;
    }

    @Override
    public final synchronized zzaag zzzj() {
        return this.zzegh;
    }

    @Override
    public final synchronized void zzxs() {
        if (this.zzegi != null) {
            this.zzegi.zzqe();
        }
    }

    @Override
    public final synchronized void zza(zzaab zzaab2) {
        this.zzegi = zzaab2;
    }

    @Override
    public final synchronized void zza(zzqt zzqt2) {
        this.zzegj = zzqt2;
    }

    @Override
    public final synchronized zzqt zzzm() {
        return this.zzegj;
    }

    @Override
    public final synchronized zzbbu zzxj() {
        return this.zzege;
    }

    @Override
    public final synchronized void zza(zzbbu zzbbu2) {
        if (this.zzege != null) {
            zzatm.zzes((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzege = zzbbu2;
    }

    @Override
    public final synchronized boolean zzzg() {
        return this.zzegk > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzegk += bl ? 1 : -1;
        if (this.zzegk <= 0 && this.zzefv != null) {
            this.zzefv.zzss();
        }
    }

    private final void zzaak() {
        if (this.zzego == null) {
            return;
        }
        zzzh zzzh2 = this.zzego.zzpy();
        if (zzzh2 != null && zzp.zzkc().zzud() != null) {
            zzp.zzkc().zzud().zza(zzzh2);
        }
    }

    @Override
    public final void zzzk() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzehp.zzao(bl);
    }

    @Override
    public final void zzsr() {
        zze zze2 = this.zzyu();
        if (zze2 != null) {
            zze2.zzsr();
        }
    }

    @Override
    public final int zzxq() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzxr() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(com.google.android.gms.ads.internal.overlay.zzb zzb2) {
        this.zzehp.zza(zzb2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzehp.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzehp.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzehp.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzpi zzpi2) {
        zzbdb zzbdb2 = this;
        synchronized (zzbdb2) {
            this.zzegf = zzpi2.zzbnr;
        }
        this.zzav(zzpi2.zzbnr);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzage.zza((zzagb)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzadx<? super zzbbc> zzadx2) {
        if (this.zzehp != null) {
            this.zzehp.zza(string2, zzadx2);
        }
    }

    @Override
    public final void zzb(String string2, zzadx<? super zzbbc> zzadx2) {
        if (this.zzehp != null) {
            this.zzehp.zzb(string2, zzadx2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzadx<? super zzbbc>> predicate) {
        if (this.zzehp != null) {
            this.zzehp.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzeeb.zza(new zzbda(bl, n));
        this.zzeeb.zza(zzsb.zza.zzb.zzbtj);
        return true;
    }

    @Override
    public final boolean zzzn() {
        return false;
    }

    @Override
    public final void zza(ViewGroup viewGroup, Activity activity, String string2, String string3) {
        if (!this.zzzp()) {
            zzatm.zzdy("AR ad is not enabled or the ad from the server is not an AR ad.");
            return;
        }
        if (this.getParent() instanceof ViewGroup) {
            zzbdb zzbdb2 = this;
            if (zzbdb2 == null) {
                throw null;
            }
            ((ViewGroup)this.getParent()).removeView((View)zzbdb2);
        }
        zzatm.zzdy("Initializing ArWebView object.");
        zzbdb zzbdb3 = this;
        if (zzbdb3 == null) {
            throw null;
        }
        this.zzefq.zza(activity, zzbdb3);
        this.zzefq.zze(string2, string3);
        if (viewGroup != null) {
            viewGroup.addView(this.zzefq.getView());
            return;
        }
        zzatm.zzes((String)"The FrameLayout object cannot be null.");
    }

    @Override
    public final zzrb zzzo() {
        return this.zzefq;
    }

    @Override
    public final boolean zzzp() {
        zzyi zzyi2 = zzyt.zzcsy;
        return (Boolean)zzuo.zzoj().zzd(zzyi2) != false && this.zzefq != null && this.zzefr;
    }

    @Override
    public final /* synthetic */ zzbcm zzyy() {
        return this.zzehp;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zztd zztd2) {
        zzsh.zzw.zza zza2 = zzsh.zzw.zznt();
        if (zza2.zzns() != bl) {
            zza2.zzq(bl);
        }
        zztd2.zzcan = (zzsh.zzw)((zzdqd)zza2.zzcg(n).zzazm());
    }

    static /* synthetic */ int zza(zzbdb zzbdb2) {
        return zzbdb2.zzegl;
    }

    static /* synthetic */ int zza(zzbdb zzbdb2, int n) {
        zzbdb2.zzegl = n;
        return zzbdb2.zzegl;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzage.zza((zzagb)this, string2, jSONObject);
    }

    @Override
    public final void zzk(String string2, String string3) {
        zzage.zza((zzagb)this, string2, string3);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzage.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzage.zza((zzagb)this, string2, map);
    }
}

