/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.webkit.ValueCallback;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbdi;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@ParametersAreNonnullByDefault
public class zzbdh
extends zzbdc
implements zzbdi {
    private final zzbdf zzehu;
    @GuardedBy(value="this")
    private boolean zzefy;
    @GuardedBy(value="this")
    private boolean zzegr;

    public zzbdh(Context context, zzbdf zzbdf2) {
        super(context);
        zzp.zzkc().zzug();
        this.zzehu = zzbdf2;
        super.setWebViewClient((WebViewClient)zzbdf2);
    }

    public final synchronized boolean isDestroyed() {
        return this.zzefy;
    }

    @GuardedBy(value="this")
    protected void zzaw(boolean bl) {
    }

    public synchronized void destroy() {
        if (this.zzefy) {
            return;
        }
        this.zzefy = true;
        this.zzehu.zza(this);
        this.zzaw(false);
        zzatm.zzdy("Initiating WebView self destruct sequence in 3...");
        zzatm.zzdy("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzp.zzkc().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    @Override
    public final synchronized void zza(zzbde zzbde2) {
        zzatm.zzdy("Blank page loaded, 1...");
        this.zzze();
    }

    @VisibleForTesting
    protected synchronized void zzze() {
        zzatm.zzdy("Destroying WebView!");
        this.zzuh();
        zzawx.zzdwa.execute(new zzbdg(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            zzbdh zzbdh2 = this;
            synchronized (zzbdh2) {
                if (!this.isDestroyed()) {
                    this.zzaw(true);
                }
                this.zzuh();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private final synchronized void zzuh() {
        if (!this.zzegr) {
            this.zzegr = true;
            zzp.zzkc().zzuh();
        }
    }

    @TargetApi(value=19)
    public synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzatm.zzeu((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.isDestroyed() && super.onTouchEvent(motionEvent);
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        super.onPause();
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        super.onResume();
    }

    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        super.stopLoading();
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    final /* synthetic */ void zzaau() {
        super.destroy();
    }
}

