/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzacl;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzavs;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzaxb;
import com.google.android.gms.internal.ads.zzbgu;
import com.google.android.gms.internal.ads.zzbmf;
import com.google.android.gms.internal.ads.zzbmo;
import com.google.android.gms.internal.ads.zzbqb;
import com.google.android.gms.internal.ads.zzbtb;
import com.google.android.gms.internal.ads.zzbtc;
import com.google.android.gms.internal.ads.zzbtx;
import com.google.android.gms.internal.ads.zzbuf;
import com.google.android.gms.internal.ads.zzbui;
import com.google.android.gms.internal.ads.zzbuw;
import com.google.android.gms.internal.ads.zzbxn;
import com.google.android.gms.internal.ads.zzcvb;
import com.google.android.gms.internal.ads.zzcvk;
import com.google.android.gms.internal.ads.zzcxw;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzvx;
import com.google.android.gms.internal.ads.zzwb;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzbta
implements zzbuf {
    private final Context zzlk;
    private final zzbui zzfdc;
    private final JSONObject zzfja;
    private final zzbxn zzfjb;
    private final zzbtx zzfjc;
    private final zzdf zzefm;
    private final zzbmo zzfjd;
    private final zzbmf zzfje;
    private final zzcvb zzfef;
    private final zzawv zzblh;
    private final zzcvk zzffn;
    private final zzbgu zzfjf;
    private final zzbuw zzfjg;
    private final Clock zzbmd;
    private final zzbqb zzfjh;
    private final zzcxw zzfas;
    private boolean zzfji = false;
    private boolean zzfjj;
    private boolean zzfjk = false;
    private boolean zzfjl = false;
    private Point zzfjm = new Point();
    private Point zzfjn = new Point();
    private long zzfjo = 0L;
    private long zzfjp = 0L;
    private zzvx zzfjq;

    public zzbta(Context context, zzbui zzbui2, JSONObject jSONObject, zzbxn zzbxn2, zzbtx zzbtx2, zzdf zzdf2, zzbmo zzbmo2, zzbmf zzbmf2, zzcvb zzcvb2, zzawv zzawv2, zzcvk zzcvk2, zzbgu zzbgu2, zzbuw zzbuw2, Clock clock, zzbqb zzbqb2, zzcxw zzcxw2) {
        this.zzlk = context;
        this.zzfdc = zzbui2;
        this.zzfja = jSONObject;
        this.zzfjb = zzbxn2;
        this.zzfjc = zzbtx2;
        this.zzefm = zzdf2;
        this.zzfjd = zzbmo2;
        this.zzfje = zzbmf2;
        this.zzfef = zzcvb2;
        this.zzblh = zzawv2;
        this.zzffn = zzcvk2;
        this.zzfjf = zzbgu2;
        this.zzfjg = zzbuw2;
        this.zzbmd = clock;
        this.zzfjh = zzbqb2;
        this.zzfas = zzcxw2;
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        this.zzfjm = new Point();
        this.zzfjn = new Point();
        if (!this.zzfjj) {
            this.zzfjh.zzq(view);
            this.zzfjj = true;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        this.zzfjf.zzo(this);
        boolean bl = zzavs.zzcq(this.zzblh.zzdvt);
        if (map != null) {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                if (bl) {
                    view2.setOnTouchListener(onTouchListener);
                }
                view2.setClickable(true);
                view2.setOnClickListener(onClickListener);
            }
        }
        if (map2 != null) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                if (bl) {
                    view2.setOnTouchListener(onTouchListener);
                }
                view2.setClickable(false);
            }
        }
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map) {
        this.zzfjm = new Point();
        this.zzfjn = new Point();
        this.zzfjh.zzr(view);
        this.zzfjj = false;
    }

    private final boolean zzfo(String string2) {
        JSONObject jSONObject = this.zzfja.optJSONObject("allow_pub_event_reporting");
        return jSONObject != null && jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, @Nullable View view2, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        JSONObject jSONObject = this.zza(map, map2, view2);
        JSONObject jSONObject2 = this.zzs(view2);
        JSONObject jSONObject3 = zzbta.zzt(view2);
        JSONObject jSONObject4 = this.zzu(view2);
        String string2 = this.zzb(view, map);
        JSONObject jSONObject5 = this.zzfq(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, false);
    }

    @Nullable
    private final String zzb(@Nullable View view, @Nullable Map<String, WeakReference<View>> map) {
        if (map != null && view != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (!view.equals(view2)) continue;
                return entry.getKey();
            }
        }
        switch (this.zzfjc.zzahl()) {
            case 2: {
                return "2099";
            }
            case 1: {
                return "1099";
            }
            case 3: {
                return null;
            }
            case 6: {
                return "3099";
            }
        }
        return null;
    }

    @Override
    public final void zzfp(String string2) {
        this.zza(null, null, null, null, null, string2, null, null, false, false);
    }

    @Override
    public final void zzf(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzatm.zzdv((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzfo("click_reporting")) {
            zzatm.zzes((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        Bundle bundle2 = bundle.getBundle("click_signal");
        String string2 = bundle2 != null ? bundle2.getString("asset_id") : null;
        JSONObject jSONObject = zzp.zzjy().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject, false, false);
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        if (!this.zzfjl) {
            zzatm.zzdv((String)"Custom click reporting failed. enableCustomClickGesture is not set.");
            return;
        }
        if (!this.zzagy()) {
            zzatm.zzdv((String)"Custom click reporting failed. Ad unit id not whitelisted.");
            return;
        }
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbta.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        String string2 = this.zzb(null, map);
        JSONObject jSONObject5 = this.zzfq(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, true);
    }

    private final boolean zzagy() {
        return this.zzfja.optBoolean("allow_custom_click_gesture", false);
    }

    @Override
    public final void zzqs() {
        this.zzfjl = true;
    }

    @Override
    public final boolean isCustomClickGestureEnabled() {
        return this.zzagy();
    }

    private final void zza(@Nullable View view, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable String string2, @Nullable JSONObject jSONObject5, @Nullable JSONObject jSONObject6, boolean bl, boolean bl2) {
        Preconditions.checkMainThread((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzfja);
            jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            jSONObject7.put("ad_view_signal", (Object)jSONObject);
            jSONObject7.put("click_signal", (Object)jSONObject5);
            jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject7.put("has_custom_click_handler", this.zzfdc.zzfv(this.zzfjc.getCustomTemplateId()) != null);
            jSONObject7.put("provided_signals", (Object)jSONObject6);
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", this.zzfjc.zzahl());
            jSONObject8.put("view_aware_api_used", bl);
            zzbta zzbta2 = this;
            jSONObject8.put("custom_mute_requested", zzbta2.zzffn.zzddy != null && zzbta2.zzffn.zzddy.zzbjy);
            zzbta2 = this;
            jSONObject8.put("custom_mute_enabled", !zzbta2.zzfjc.getMuteThisAdReasons().isEmpty() && zzbta2.zzfjc.zzaho() != null);
            JSONObject jSONObject9 = jSONObject8;
            zzbta2 = this;
            if (zzbta2.zzfjg.zzais() != null && zzbta2.zzfja.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject9.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject9.put("timestamp", zzbta2.zzbmd.currentTimeMillis());
            boolean bl3 = bl2;
            jSONObject9 = jSONObject8;
            zzbta2 = this;
            if (zzbta2.zzfjl && zzbta2.zzagy()) {
                jSONObject9.put("custom_click_gesture_eligible", true);
            }
            if (bl3) {
                jSONObject9.put("is_custom_click_gesture", true);
            }
            jSONObject8.put("has_custom_click_handler", this.zzfdc.zzfv(this.zzfjc.getCustomTemplateId()) != null);
            jSONObject8.put("click_signals", (Object)this.zzv(view));
            jSONObject7.put("click", (Object)jSONObject8);
            JSONObject jSONObject10 = new JSONObject();
            long l = this.zzbmd.currentTimeMillis();
            jSONObject10.put("time_from_last_touch_down", l - this.zzfjo);
            jSONObject10.put("time_from_last_touch", l - this.zzfjp);
            jSONObject7.put("touch_signal", (Object)jSONObject10);
            zzaxb.zza(this.zzfjb.zzc("google.afma.nativeAds.handleClick", jSONObject7), "Error during performing handleClick");
            return;
        }
        catch (JSONException jSONException) {
            zzatm.zzc((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, MotionEvent motionEvent, @Nullable View view2) {
        long l;
        View view3 = view2;
        MotionEvent motionEvent2 = motionEvent;
        int[] nArray = zzbta.zzw(view3);
        int n = (int)motionEvent2.getRawX() - nArray[0];
        int n2 = (int)motionEvent2.getRawY() - nArray[1];
        this.zzfjm = new Point(n, n2);
        this.zzfjp = l = this.zzbmd.currentTimeMillis();
        if (motionEvent.getAction() == 0) {
            this.zzfjo = l;
            this.zzfjn = this.zzfjm;
        }
        MotionEvent motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent3.setLocation((float)this.zzfjm.x, (float)this.zzfjm.y);
        this.zzefm.zzb(motionEvent3);
        motionEvent3.recycle();
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzatm.zzdv((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzfo("touch_reporting")) {
            zzatm.zzes((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzefm.zzcc().zza(n, n2, n3);
    }

    @Override
    public final void zzagz() {
        this.zza((JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null);
    }

    @Override
    public final void setClickConfirmingView(View view) {
        if (!this.zzfja.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzatm.zzeu((String)"setClickConfirmingView: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        zzbuw zzbuw2 = this.zzfjg;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)zzbuw2);
            view2.setClickable(true);
            zzbuw2.zzfmx = new WeakReference<View>(view2);
        }
    }

    @Override
    public final void zza(zzacl zzacl2) {
        if (!this.zzfja.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzatm.zzeu((String)"setUnconfirmedClickListener: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzfjg.zza(zzacl2);
    }

    @Override
    public final void cancelUnconfirmedClick() {
        if (!this.zzfja.optBoolean("custom_one_point_five_click_enabled", false)) {
            return;
        }
        this.zzfjg.cancelUnconfirmedClick();
    }

    @Override
    public final void zza(@Nullable zzwb zzwb2) {
        try {
            if (this.zzfjk) {
                return;
            }
            if (zzwb2 == null && this.zzfjc.zzaho() != null) {
                this.zzfjk = true;
                this.zzfas.zzei(this.zzfjc.zzaho().zzor());
                this.zzaha();
                return;
            }
            this.zzfjk = true;
            this.zzfas.zzei(zzwb2.zzor());
            this.zzaha();
            return;
        }
        catch (RemoteException remoteException) {
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(zzvx zzvx2) {
        this.zzfjq = zzvx2;
    }

    @Override
    public final void zzaha() {
        try {
            if (this.zzfjq != null) {
                this.zzfjq.onAdMuted();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2) {
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbta.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        this.zza(jSONObject2, jSONObject, jSONObject3, jSONObject4, null);
    }

    @Override
    public final void zzahb() {
        Preconditions.checkMainThread((String)"recordDownloadedImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzfja);
            zzaxb.zza(this.zzfjb.zzc("google.afma.nativeAds.handleDownloadedImpression", jSONObject), "Error during performing handleDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzawo.zzc((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final boolean zzh(Bundle bundle) {
        if (!this.zzfo("impression_reporting")) {
            zzatm.zzes((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzp.zzjy().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(@Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"recordImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzfja);
            jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            jSONObject6.put("ad_view_signal", (Object)jSONObject);
            jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject6.put("provided_signals", (Object)jSONObject5);
            this.zzfjb.zza("/logScionEvent", new zzbtc(this, null));
            this.zzfjb.zza("/nativeImpression", new zzbtb(this, null));
            zzaxb.zza(this.zzfjb.zzc("google.afma.nativeAds.handleImpression", jSONObject6), "Error during performing handleImpression");
        }
        catch (JSONException jSONException) {
            zzatm.zzc((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        if (!this.zzfji && this.zzfef.zzgjb != null) {
            this.zzfji |= zzp.zzki().zzb(this.zzlk, this.zzblh.zzbnh, this.zzfef.zzgjb.toString(), this.zzffn.zzgjt);
        }
        return true;
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzdg(rect.right - rect.left));
        jSONObject.put("height", this.zzdg(rect.bottom - rect.top));
        jSONObject.put("x", this.zzdg(rect.left));
        jSONObject.put("y", this.zzdg(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzs(@Nullable View view) {
        JSONObject jSONObject;
        Object object;
        JSONObject jSONObject2 = new JSONObject();
        if (view == null) {
            return jSONObject2;
        }
        try {
            Object object2;
            object = zzbta.zzw(view);
            jSONObject = new JSONObject();
            jSONObject.put("width", this.zzdg(view.getMeasuredWidth()));
            jSONObject.put("height", this.zzdg(view.getMeasuredHeight()));
            jSONObject.put("x", this.zzdg((int)object[0]));
            jSONObject.put("y", this.zzdg((int)object[1]));
            jSONObject.put("relative_to", (Object)"window");
            jSONObject2.put("frame", (Object)jSONObject);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                object2 = this.zzb(rect);
            } else {
                object2 = new JSONObject();
                object2.put("width", 0);
                object2.put("height", 0);
                object2.put("x", this.zzdg((int)object[0]));
                object2.put("y", this.zzdg((int)object[1]));
                object2.put("relative_to", (Object)"window");
            }
            jSONObject2.put("visible_bounds", object2);
        }
        catch (Exception exception) {
            zzatm.zzeu((String)"Unable to get native ad view bounding box");
        }
        zzyi zzyi2 = zzyt.zzcsw;
        if (((Boolean)zzuo.zzoj().zzd(zzyi2)).booleanValue()) {
            object = "";
            jSONObject = view.getParent();
            if (jSONObject != null) {
                try {
                    object = (String)jSONObject.getClass().getMethod("getTemplateTypeName", new Class[0]).invoke((Object)jSONObject, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    zzatm.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    zzatm.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    zzatm.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)invocationTargetException);
                }
            }
            try {
                switch (object) {
                    case "small_template": {
                        jSONObject2.put("native_template_type", 1);
                        break;
                    }
                    case "medium_template": {
                        jSONObject2.put("native_template_type", 2);
                        break;
                    }
                    default: {
                        jSONObject2.put("native_template_type", 0);
                        break;
                    }
                }
            }
            catch (JSONException jSONException) {
                zzatm.zzc((String)"Could not log native template signal to JSON", (Throwable)jSONException);
            }
        }
        return jSONObject2;
    }

    private static JSONObject zzt(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzp.zzjy();
            int n = zzatv.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzu(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzp.zzjy();
            jSONObject.put("can_show_on_lock_screen", zzatv.zzo(view));
            zzp.zzjy();
            jSONObject.put("is_keyguard_locked", zzatv.zzaw(this.zzlk));
        }
        catch (JSONException jSONException) {
            zzatm.zzeu((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    private final JSONObject zza(@Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, @Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzbta.zzw(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzbta.zzw(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzdg(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzdg(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzdg(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzdg(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzdg(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzdg(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject2.put("is_clickable", map2 != null && map2.containsKey(entry.getKey()) && view2.isClickable());
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzatm.zzeu((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    private final String zzv(View view) {
        try {
            JSONObject jSONObject = this.zzfja.optJSONObject("tracking_urls_and_actions");
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            String string2 = jSONObject.optString("click_string");
            return this.zzefm.zzcc().zza(this.zzlk, string2, view);
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Exception obtaining click signals", (Throwable)exception);
            return null;
        }
    }

    private final JSONObject zzfq(@Nullable String string2) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("click_point", (Object)this.zzahc());
            jSONObject.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        return jSONObject;
    }

    @Nullable
    private final JSONObject zzahc() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("x", this.zzdg(this.zzfjm.x));
            jSONObject.put("y", this.zzdg(this.zzfjm.y));
            jSONObject.put("start_x", this.zzdg(this.zzfjn.x));
            jSONObject.put("start_y", this.zzdg(this.zzfjn.y));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zzatm.zzc((String)"Error occurred while putting signals into JSON object.", (Throwable)jSONException);
            return null;
        }
    }

    private static int[] zzw(@Nullable View view) {
        int[] nArray = new int[2];
        if (view != null) {
            view.getLocationOnScreen(nArray);
        }
        return nArray;
    }

    private final int zzdg(int n) {
        return zzuo.zzof().zzb(this.zzlk, n);
    }

    @Override
    public final void destroy() {
        this.zzfjb.destroy();
    }

    static /* synthetic */ zzbmo zza(zzbta zzbta2) {
        return zzbta2.zzfjd;
    }

    static /* synthetic */ zzbmf zzb(zzbta zzbta2) {
        return zzbta2.zzfje;
    }
}

