/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzaae;
import com.google.android.gms.internal.ads.zzaai;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzavm;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzawx;
import com.google.android.gms.internal.ads.zzaxc;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzbbl;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbvr;
import com.google.android.gms.internal.ads.zzbvz;
import com.google.android.gms.internal.ads.zzbwb;
import com.google.android.gms.internal.ads.zzbwc;
import com.google.android.gms.internal.ads.zzbwd;
import com.google.android.gms.internal.ads.zzbwf;
import com.google.android.gms.internal.ads.zzbwg;
import com.google.android.gms.internal.ads.zzbwo;
import com.google.android.gms.internal.ads.zzcvk;
import com.google.android.gms.internal.ads.zzdcf;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzdf;
import com.google.android.gms.internal.ads.zzrz;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzxd;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbwa {
    private final Context zzlk;
    private final zzbvr zzfod;
    private final zzdf zzefm;
    private final zzawv zzblh;
    private final zzb zzfoe;
    private final zzrz zzeeb;
    private final Executor executor;
    private final zzaai zzddy;
    private final zzbwo zzfof;
    private final ScheduledExecutorService zzfez;

    public zzbwa(Context context, zzbvr zzbvr2, zzdf zzdf2, zzawv zzawv2, zzb zzb2, zzrz zzrz2, Executor executor, zzcvk zzcvk2, zzbwo zzbwo2, ScheduledExecutorService scheduledExecutorService) {
        this.zzlk = context;
        this.zzfod = zzbvr2;
        this.zzefm = zzdf2;
        this.zzblh = zzawv2;
        this.zzfoe = zzb2;
        this.zzeeb = zzrz2;
        this.executor = executor;
        this.zzddy = zzcvk2.zzddy;
        this.zzfof = zzbwo2;
        this.zzfez = scheduledExecutorService;
    }

    public static List<zzxd> zzi(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.optJSONObject("mute");
        if (jSONObject2 == null) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = jSONObject2.optJSONArray("reasons");
        if (jSONArray == null || jSONArray.length() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<zzxd> arrayList = new ArrayList<zzxd>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            zzxd zzxd2 = zzbwa.zzk(jSONArray.optJSONObject(i));
            if (zzxd2 == null) continue;
            arrayList.add(zzxd2);
        }
        return arrayList;
    }

    @Nullable
    public static zzxd zzj(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject.optJSONObject("mute");
        if (jSONObject2 == null) {
            return null;
        }
        JSONObject jSONObject3 = jSONObject2.optJSONObject("default_reason");
        if (jSONObject3 == null) {
            return null;
        }
        return zzbwa.zzk(jSONObject3);
    }

    @Nullable
    private static zzxd zzk(@Nullable JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        String string2 = jSONObject.optString("reason");
        String string3 = jSONObject.optString("ping_url");
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        return new zzxd(string2, string3);
    }

    public final zzdcp<zzaae> zzc(JSONObject jSONObject, String string2) {
        return this.zza(jSONObject.optJSONObject(string2), this.zzddy.zzcvn);
    }

    public final zzdcp<List<zzaae>> zzd(JSONObject jSONObject, String string2) {
        return this.zza(jSONObject.optJSONArray(string2), this.zzddy.zzcvn, this.zzddy.zzbjv);
    }

    private final zzdcp<List<zzaae>> zza(@Nullable JSONArray jSONArray, boolean bl, boolean bl2) {
        if (jSONArray == null || jSONArray.length() <= 0) {
            return zzdcf.zzah(Collections.emptyList());
        }
        ArrayList<zzdcp<zzaae>> arrayList = new ArrayList<zzdcp<zzaae>>();
        int n = bl2 ? jSONArray.length() : 1;
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.zza(jSONArray.optJSONObject(i), bl));
        }
        return zzdcf.zzb(zzdcf.zzg(arrayList), zzbvz.zzdoi, this.executor);
    }

    private final zzdcp<zzaae> zza(@Nullable JSONObject jSONObject, boolean bl) {
        if (jSONObject == null) {
            return zzdcf.zzah(null);
        }
        String string2 = jSONObject.optString("url");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzdcf.zzah(null);
        }
        double d = jSONObject.optDouble("scale", 1.0);
        boolean bl2 = jSONObject.optBoolean("is_transparent", true);
        int n = jSONObject.optInt("width", -1);
        int n2 = jSONObject.optInt("height", -1);
        if (bl) {
            return zzdcf.zzah(new zzaae(null, Uri.parse((String)string2), d, n, n2));
        }
        zzdcp zzdcp2 = zzdcf.zzb(this.zzfod.zza(string2, d, bl2), new zzbwc(string2, d, n, n2), this.executor);
        return zzbwa.zza(jSONObject.optBoolean("require"), zzdcp2, null);
    }

    public final zzdcp<zzzz> zze(JSONObject jSONObject, String string2) {
        JSONObject jSONObject2 = jSONObject.optJSONObject(string2);
        if (jSONObject2 == null) {
            return zzdcf.zzah(null);
        }
        JSONArray jSONArray = jSONObject2.optJSONArray("images");
        JSONObject jSONObject3 = jSONObject2.optJSONObject("image");
        if (jSONArray == null && jSONObject3 != null) {
            jSONArray = new JSONArray();
            jSONArray.put((Object)jSONObject3);
        }
        zzdcp zzdcp2 = zzdcf.zzb(this.zza(jSONArray, false, true), new zzbwb(this, jSONObject2), this.executor);
        return zzbwa.zza(jSONObject2.optBoolean("require"), zzdcp2, null);
    }

    private static Integer zzf(JSONObject jSONObject, String string2) {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            return Color.rgb((int)jSONObject2.getInt("r"), (int)jSONObject2.getInt("g"), (int)jSONObject2.getInt("b"));
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public final zzdcp<zzbbc> zzl(JSONObject jSONObject) {
        JSONObject jSONObject2 = zzavm.zza(jSONObject, "html_containers", "instream");
        if (jSONObject2 == null) {
            JSONObject jSONObject3 = jSONObject.optJSONObject("video");
            if (jSONObject3 == null) {
                return zzdcf.zzah(null);
            }
            if (TextUtils.isEmpty((CharSequence)jSONObject3.optString("vast_xml"))) {
                zzatm.zzeu((String)"Required field 'vast_xml' is missing");
                return zzdcf.zzah(null);
            }
            zzyi zzyi2 = zzyt.zzcnw;
            return zzbwa.zza(zzdcf.zza(this.zzfof.zzm(jSONObject3), ((Integer)zzuo.zzoj().zzd(zzyi2)).intValue(), TimeUnit.SECONDS, this.zzfez), null);
        }
        zzdcp<zzbbc> zzdcp2 = this.zzfof.zzp(jSONObject2.optString("base_url"), jSONObject2.optString("html"));
        return zzbwa.zza(jSONObject2.optBoolean("require"), zzdcp2, null);
    }

    private static <T> zzdcp<T> zza(zzdcp<T> zzdcp2, T t) {
        return zzdcf.zzb(zzdcp2, Exception.class, new zzbwd(null), zzawx.zzdwb);
    }

    private static <T> zzdcp<T> zza(boolean bl, zzdcp<T> zzdcp2, T t) {
        if (bl) {
            zzdcp<T> zzdcp3 = zzdcp2;
            return zzdcf.zzb(zzdcp3, new zzbwg(zzdcp3), (Executor)zzawx.zzdwb);
        }
        return zzbwa.zza(zzdcp2, null);
    }

    final /* synthetic */ zzdcp zzb(String string2, Object object) throws Exception {
        zzp.zzjz();
        zzbbc zzbbc2 = zzbbl.zza(this.zzlk, zzbct.zzaan(), "native-omid", false, false, this.zzefm, this.zzblh, null, null, this.zzfoe, this.zzeeb, null, false);
        zzaxc<zzbbc> zzaxc2 = zzaxc.zzl(zzbbc2);
        zzbbc2.zzyy().zza(new zzbwf(zzaxc2));
        zzbbc2.loadData(string2, "text/html", "UTF-8");
        return zzaxc2;
    }

    final /* synthetic */ zzzz zza(JSONObject jSONObject, List list) {
        List list2 = list;
        JSONObject jSONObject2 = jSONObject;
        zzbwa zzbwa2 = this;
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        String string2 = jSONObject2.optString("text");
        Integer n = zzbwa.zzf(jSONObject2, "bg_color");
        Integer n2 = zzbwa.zzf(jSONObject2, "text_color");
        int n3 = jSONObject2.optInt("text_size", -1);
        boolean bl = jSONObject2.optBoolean("allow_pub_rendering");
        int n4 = jSONObject2.optInt("animation_ms", 1000);
        int n5 = jSONObject2.optInt("presentation_ms", 4000);
        return new zzzz(string2, list2, n, n2, n3 > 0 ? Integer.valueOf(n3) : null, n5 + n4, zzbwa2.zzddy.zzbjw, bl);
    }
}

