/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaab;
import com.google.android.gms.internal.ads.zzafn;
import com.google.android.gms.internal.ads.zzafo;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzaxn;
import com.google.android.gms.internal.ads.zzbju;
import com.google.android.gms.internal.ads.zzbtp;
import com.google.android.gms.internal.ads.zzbtx;
import com.google.android.gms.internal.ads.zzbxb;
import com.google.android.gms.internal.ads.zzwk;
import java.util.Collections;

public final class zzbxc
extends zzafo
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzaab {
    private View zzfla;
    private zzwk zzfkv;
    private zzbtp zzfma;
    private boolean zzefy;
    private boolean zzfow;

    public zzbxc(zzbtp zzbtp2, zzbtx zzbtx2) {
        this.zzfla = zzbtx2.zzahp();
        this.zzfkv = zzbtx2.getVideoController();
        this.zzfma = zzbtp2;
        this.zzefy = false;
        this.zzfow = false;
        if (zzbtx2.zzahq() != null) {
            zzbtx2.zzahq().zza(this);
        }
    }

    public final void zza(IObjectWrapper iObjectWrapper, zzafn zzafn2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzefy) {
            zzatm.zzes((String)"Instream ad is destroyed already.");
            zzbxc.zza(zzafn2, 2);
            return;
        }
        if (this.zzfla == null || this.zzfkv == null) {
            String string2 = String.valueOf(this.zzfla == null ? "can not get video view." : "can not get video controller.");
            zzatm.zzes((String)(string2.length() != 0 ? "Instream internal error: ".concat(string2) : new String("Instream internal error: ")));
            zzbxc.zza(zzafn2, 0);
            return;
        }
        if (this.zzfow) {
            zzatm.zzes((String)"Instream ad should not be used again.");
            zzbxc.zza(zzafn2, 1);
            return;
        }
        this.zzfow = true;
        this.zzaiy();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(this.zzfla, new ViewGroup.LayoutParams(-1, -1));
        zzp.zzkv();
        zzaxn.zza(this.zzfla, this);
        zzp.zzkv();
        zzaxn.zza(this.zzfla, this);
        this.zzaiz();
        zzafn zzafn3 = zzafn2;
        try {
            zzafn3.zzqy();
            return;
        }
        catch (RemoteException remoteException) {
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final zzwk getVideoController() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzefy) {
            zzatm.zzes((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzfkv;
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzaiy();
        if (this.zzfma != null) {
            ((zzbju)this.zzfma).destroy();
        }
        this.zzfma = null;
        this.zzfla = null;
        this.zzfkv = null;
        this.zzefy = true;
    }

    private final void zzaiy() {
        if (this.zzfla == null) {
            return;
        }
        ViewParent viewParent = this.zzfla.getParent();
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzfla);
        }
    }

    public final void onGlobalLayout() {
        this.zzaiz();
    }

    public final void onScrollChanged() {
        this.zzaiz();
    }

    @Override
    public final void zzqe() {
        zzatv.zzdsk.post((Runnable)new zzbxb(this));
    }

    private final void zzaiz() {
        if (this.zzfma != null && this.zzfla != null) {
            this.zzfma.zzb(this.zzfla, Collections.emptyMap(), Collections.emptyMap(), zzbtp.zzx(this.zzfla));
        }
    }

    private static void zza(zzafn zzafn2, int n) {
        try {
            zzafn2.zzck(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzaja() {
        try {
            this.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzatm.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

