/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzczx;
import com.google.android.gms.internal.ads.zzdac;
import com.google.android.gms.internal.ads.zzdbx;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzddh;
import com.google.android.gms.internal.ads.zzddk;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import sun.misc.Unsafe;

public class zzdbf<V>
extends zzddh
implements zzdcp<V> {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger zzgpo;
    private static final zza zzgpp;
    private static final Object NULL;
    @NullableDecl
    private volatile Object value;
    @NullableDecl
    private volatile zzd listeners;
    @NullableDecl
    private volatile zzk waiters;

    /*
     * Unable to fully structure code
     */
    private final void zza(zzk var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == zzk.zzgqb) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (zzdbf.zzgpp.zza(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected zzdbf() {
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l2;
        Object object3;
        long l3;
        block15: {
            long l4;
            l3 = l4 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zze)) {
                return zzdbf.zzaf(object3);
            }
            long l5 = l2 = l4 > 0L ? System.nanoTime() + l4 : 0L;
            if (l4 >= 1000L) {
                object2 = this.waiters;
                if (object2 != zzk.zzgqb) {
                    object = new zzk();
                    do {
                        ((zzk)object).zzb((zzk)object2);
                        if (!zzgpp.zza(this, (zzk)object2, (zzk)object)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.zza((zzk)object);
                                throw new InterruptedException();
                            }
                            object3 = this.value;
                            if (!(object3 != null & !(object3 instanceof zze))) continue;
                            return zzdbf.zzaf(object3);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.zza((zzk)object);
                        break block15;
                    } while ((object2 = this.waiters) != zzk.zzgqb);
                }
                return zzdbf.zzaf(this.value);
            }
        }
        while (l3 > 0L) {
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zze)) {
                return zzdbf.zzaf(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        object2 = this.toString();
        object = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string2 = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string3 = new StringBuilder(28 + String.valueOf(string2).length()).append("Waited ").append(l).append(" ").append(string2).toString();
        if (l3 + 1000L < 0L) {
            String string4;
            boolean bl;
            string3 = String.valueOf(string3).concat(" (plus ");
            long l6 = -l3;
            long l7 = timeUnit.convert(l6, TimeUnit.NANOSECONDS);
            long l8 = l6 - timeUnit.toNanos(l7);
            boolean bl2 = bl = l7 == 0L || l8 > 1000L;
            if (l7 > 0L) {
                string4 = String.valueOf(string3);
                string3 = new StringBuilder(21 + String.valueOf(string4).length() + String.valueOf(object).length()).append(string4).append(l7).append(" ").append((String)object).toString();
                if (bl) {
                    string3 = String.valueOf(string3).concat(",");
                }
                string3 = String.valueOf(string3).concat(" ");
            }
            if (bl) {
                string4 = String.valueOf(string3);
                string3 = new StringBuilder(33 + String.valueOf(string4).length()).append(string4).append(l8).append(" nanoseconds ").toString();
            }
            string3 = String.valueOf(string3).concat("delay)");
        }
        if (this.isDone()) {
            throw new TimeoutException(String.valueOf(string3).concat(" but future completed as timeout expired"));
        }
        string2 = string3;
        throw new TimeoutException(new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(object2).length()).append(string2).append(" for ").append((String)object2).toString());
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof zze)) {
            return zzdbf.zzaf(object);
        }
        zzk zzk2 = this.waiters;
        if (zzk2 != zzk.zzgqb) {
            zzk zzk3 = new zzk();
            do {
                zzk3.zzb(zzk2);
                if (!zzgpp.zza(this, zzk2, zzk3)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.zza(zzk3);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof zze)));
                return zzdbf.zzaf(object);
            } while ((zzk2 = this.waiters) != zzk.zzgqb);
        }
        return zzdbf.zzaf(this.value);
    }

    private static V zzaf(Object object) throws ExecutionException {
        if (object instanceof zzc) {
            Throwable throwable = ((zzc)object).cause;
            String string2 = "Task was cancelled.";
            CancellationException cancellationException = new CancellationException(string2);
            cancellationException.initCause(throwable);
            throw cancellationException;
        }
        if (object instanceof zzb) {
            throw new ExecutionException(((zzb)object).exception);
        }
        if (object == NULL) {
            return null;
        }
        return object;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof zze);
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof zzc;
    }

    @Override
    public boolean cancel(boolean bl) {
        Object object = this.value;
        boolean bl2 = false;
        if (object == null | object instanceof zze) {
            zzc zzc2 = GENERATE_CANCELLATION_CAUSES ? new zzc(bl, new CancellationException("Future.cancel() was called.")) : (bl ? zzc.zzgpr : zzc.zzgps);
            zzdbf zzdbf2 = this;
            while (true) {
                if (zzgpp.zza(zzdbf2, object, zzc2)) {
                    bl2 = true;
                    zzdbf.zza(zzdbf2);
                    if (!(object instanceof zze)) break;
                    zzdcp zzdcp2 = ((zze)object).future;
                    if (zzdcp2 instanceof zzg) {
                        zzdbf zzdbf3 = (zzdbf)zzdcp2;
                        object = zzdbf3.value;
                        if (!(object == null | object instanceof zze)) break;
                        zzdbf2 = zzdbf3;
                        continue;
                    }
                    zzdcp2.cancel(bl);
                    break;
                }
                object = zzdbf2.value;
                if (!(object instanceof zze)) break;
            }
        }
        return bl2;
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof zzc && ((zzc)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        zzd zzd2;
        zzczx.checkNotNull(runnable, "Runnable was null.");
        zzczx.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (zzd2 = this.listeners) != zzd.zzgpt) {
            zzd zzd3 = new zzd(runnable, executor);
            do {
                zzd3.next = zzd2;
                if (!zzgpp.zza(this, zzd2, zzd3)) continue;
                return;
            } while ((zzd2 = this.listeners) != zzd.zzgpt);
        }
        zzdbf.zza(runnable, executor);
    }

    protected boolean set(@NullableDecl V v) {
        Object object;
        Object object2 = object = v == null ? NULL : v;
        if (zzgpp.zza(this, null, object)) {
            zzdbf.zza(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        zzb zzb2 = new zzb(zzczx.checkNotNull(throwable));
        if (zzgpp.zza(this, null, zzb2)) {
            zzdbf.zza(this);
            return true;
        }
        return false;
    }

    protected final boolean setFuture(zzdcp<? extends V> zzdcp2) {
        zzczx.checkNotNull(zzdcp2);
        Object object = this.value;
        if (object == null) {
            if (zzdcp2.isDone()) {
                Object object2 = zzdbf.getFutureValue(zzdcp2);
                if (zzgpp.zza(this, null, object2)) {
                    zzdbf.zza(this);
                    return true;
                }
                return false;
            }
            zze<? extends V> zze2 = new zze<V>(this, zzdcp2);
            if (zzgpp.zza(this, null, zze2)) {
                try {
                    zzdcp2.addListener(zze2, zzdbx.zzgqu);
                }
                catch (Throwable throwable) {
                    zzb zzb2;
                    try {
                        zzb2 = new zzb(throwable);
                    }
                    catch (Throwable throwable2) {
                        zzb2 = zzb.zzgpq;
                    }
                    zzgpp.zza(this, zze2, zzb2);
                }
                return true;
            }
            object = this.value;
        }
        if (object instanceof zzc) {
            zzdcp2.cancel(((zzc)object).wasInterrupted);
        }
        return false;
    }

    private static Object getFutureValue(zzdcp<?> zzdcp2) {
        boolean bl;
        Throwable throwable;
        if (zzdcp2 instanceof zzg) {
            Object object = ((zzdbf)zzdcp2).value;
            if (object instanceof zzc) {
                zzc zzc2 = (zzc)object;
                if (zzc2.wasInterrupted) {
                    object = zzc2.cause != null ? new zzc(false, zzc2.cause) : zzc.zzgps;
                }
            }
            return object;
        }
        if (zzdcp2 instanceof zzddh && (throwable = zzddk.zza((zzddh)((Object)zzdcp2))) != null) {
            return new zzb(throwable);
        }
        if (!GENERATE_CANCELLATION_CAUSES & (bl = zzdcp2.isCancelled())) {
            return zzc.zzgps;
        }
        try {
            Object obj = zzdbf.zza(zzdcp2);
            if (bl) {
                String string2 = String.valueOf(zzdcp2);
                return new zzc(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string2).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string2).toString()));
            }
            if (obj == null) {
                return NULL;
            }
            return obj;
        }
        catch (ExecutionException executionException) {
            if (bl) {
                String string3 = String.valueOf(zzdcp2);
                return new zzc(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string3).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string3).toString(), executionException));
            }
            return new zzb(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            if (!bl) {
                String string4 = String.valueOf(zzdcp2);
                return new zzb(new IllegalArgumentException(new StringBuilder(77 + String.valueOf(string4).length()).append("get() threw CancellationException, despite reporting isCancelled() == false: ").append(string4).toString(), cancellationException));
            }
            return new zzc(false, cancellationException);
        }
        catch (Throwable throwable2) {
            return new zzb(throwable2);
        }
    }

    private static <V> V zza(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            block5: {
                try {
                    v = future.get();
                    if (!bl) break block5;
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            return v;
            break;
        }
    }

    private static void zza(zzdbf<?> zzdbf2) {
        Object object = null;
        block0: while (true) {
            Object object2;
            Object object3;
            zzk zzk2;
            zzdbf<?> zzdbf3 = zzdbf2;
            while (!zzgpp.zza(zzdbf3, zzk2 = zzdbf3.waiters, zzk.zzgqb)) {
            }
            Object object4 = zzk2;
            while (object4 != null) {
                object3 = object4;
                object2 = ((zzk)object3).thread;
                if (object2 != null) {
                    ((zzk)object3).thread = null;
                    LockSupport.unpark((Thread)object2);
                }
                object4 = ((zzk)object4).next;
            }
            zzdbf2.afterDone();
            zzk2 = object;
            zzdbf3 = zzdbf2;
            while (!zzgpp.zza(zzdbf3, (zzd)(object4 = zzdbf3.listeners), zzd.zzgpt)) {
            }
            object3 = zzk2;
            while (object4 != null) {
                object2 = object4;
                object4 = ((zzd)object4).next;
                ((zzd)object2).next = object3;
                object3 = object2;
            }
            object = object3;
            while (object != null) {
                zzk zzk3 = object;
                object = ((zzd)object).next;
                Runnable runnable = ((zzd)((Object)zzk3)).task;
                if (runnable instanceof zze) {
                    Object object5;
                    zze zze2 = (zze)runnable;
                    zzdbf2 = zze2.zzgpu;
                    if (zzdbf2.value == zze2 && zzgpp.zza(zzdbf2, zze2, object5 = zzdbf.getFutureValue(zze2.future))) continue block0;
                    continue;
                }
                zzdbf.zza(runnable, ((zzd)((Object)zzk3)).executor);
            }
            break;
        }
    }

    protected void afterDone() {
    }

    @Override
    @NullableDecl
    protected final Throwable zzaor() {
        Object object;
        if (this instanceof zzg && (object = this.value) instanceof zzb) {
            return ((zzb)object).exception;
        }
        return null;
    }

    final void maybePropagateCancellationTo(@NullableDecl Future<?> future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.zza(stringBuilder);
        } else {
            String string2;
            try {
                string2 = this.pendingToString();
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getClass());
                string2 = new StringBuilder(38 + String.valueOf(string3).length()).append("Exception thrown from implementation: ").append(string3).toString();
            }
            if (string2 != null && !string2.isEmpty()) {
                stringBuilder.append("PENDING, info=[").append(string2).append("]");
            } else if (this.isDone()) {
                this.zza(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        return stringBuilder.append("]").toString();
    }

    @NullableDecl
    protected String pendingToString() {
        Object object = this.value;
        if (object instanceof zze) {
            String string2 = this.zzag(((zze)object).future);
            return new StringBuilder(12 + String.valueOf(string2).length()).append("setFuture=[").append(string2).append("]").toString();
        }
        if (this instanceof ScheduledFuture) {
            long l = ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS);
            return new StringBuilder(41).append("remaining delay=[").append(l).append(" ms]").toString();
        }
        return null;
    }

    private final void zza(StringBuilder stringBuilder) {
        try {
            V v = zzdbf.zza(this);
            stringBuilder.append("SUCCESS, result=[").append(this.zzag(v)).append("]");
            return;
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    private final String zzag(Object object) {
        if (object == this) {
            return "this future";
        }
        return String.valueOf(object);
    }

    private static void zza(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(runnable);
            String string3 = String.valueOf(executor);
            zzgpo.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "executeListener", new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string3).toString(), runtimeException);
            return;
        }
    }

    static {
        zza zza2;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        zzgpo = Logger.getLogger(zzdbf.class.getName());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            zza2 = new zzi();
        }
        catch (Throwable throwable3) {
            try {
                zza2 = new zzf(AtomicReferenceFieldUpdater.newUpdater(zzk.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(zzk.class, zzk.class, "next"), AtomicReferenceFieldUpdater.newUpdater(zzdbf.class, zzk.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(zzdbf.class, zzd.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(zzdbf.class, Object.class, "value"));
            }
            catch (Throwable throwable4) {
                zza2 = new zzh();
            }
        }
        zzgpp = zza2;
        if (throwable2 != null) {
            zzgpo.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            zzgpo.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }

    static final class zzh
    extends zza {
        private zzh() {
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            zzk2.thread = thread;
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            zzk2.next = zzk3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzk zzk2, zzk zzk3) {
            zzdbf<?> zzdbf3 = zzdbf2;
            synchronized (zzdbf3) {
                if (((zzdbf)zzdbf2).waiters == zzk2) {
                    ((zzdbf)zzdbf2).waiters = zzk3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzd zzd2, zzd zzd3) {
            zzdbf<?> zzdbf3 = zzdbf2;
            synchronized (zzdbf3) {
                if (((zzdbf)zzdbf2).listeners == zzd2) {
                    ((zzdbf)zzdbf2).listeners = zzd3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdbf<?> zzdbf2, Object object, Object object2) {
            zzdbf<?> zzdbf3 = zzdbf2;
            synchronized (zzdbf3) {
                if (((zzdbf)zzdbf2).value == object) {
                    ((zzdbf)zzdbf2).value = object2;
                    return true;
                }
                return false;
            }
        }
    }

    static final class zzf
    extends zza {
        final AtomicReferenceFieldUpdater<zzk, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<zzk, zzk> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<zzdbf, zzk> waitersUpdater;
        final AtomicReferenceFieldUpdater<zzdbf, zzd> listenersUpdater;
        final AtomicReferenceFieldUpdater<zzdbf, Object> valueUpdater;

        zzf(AtomicReferenceFieldUpdater<zzk, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<zzk, zzk> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<zzdbf, zzk> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<zzdbf, zzd> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<zzdbf, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            this.waiterThreadUpdater.lazySet(zzk2, thread);
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            this.waiterNextUpdater.lazySet(zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzk zzk2, zzk zzk3) {
            return this.waitersUpdater.compareAndSet(zzdbf2, zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzd zzd2, zzd zzd3) {
            return this.listenersUpdater.compareAndSet(zzdbf2, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(zzdbf2, object, object2);
        }
    }

    static final class zzi
    extends zza {
        static final Unsafe zzgpv;
        static final long zzgpw;
        static final long zzgpx;
        static final long zzgpy;
        static final long zzgpz;
        static final long zzgqa;

        private zzi() {
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            zzgpv.putObject(zzk2, zzgpz, thread);
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            zzgpv.putObject(zzk2, zzgqa, zzk3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzk zzk2, zzk zzk3) {
            return zzgpv.compareAndSwapObject(zzdbf2, zzgpx, zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, zzd zzd2, zzd zzd3) {
            return zzgpv.compareAndSwapObject(zzdbf2, zzgpw, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdbf<?> zzdbf2, Object object, Object object2) {
            return zzgpv.compareAndSwapObject(zzdbf2, zzgpy, object, object2);
        }

        static {
            Unsafe unsafe;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public /* synthetic */ Object run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : Unsafe.class.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<zzdbf> clazz = zzdbf.class;
                zzgpx = unsafe.objectFieldOffset(clazz.getDeclaredField("waiters"));
                zzgpw = unsafe.objectFieldOffset(clazz.getDeclaredField("listeners"));
                zzgpy = unsafe.objectFieldOffset(clazz.getDeclaredField("value"));
                zzgpz = unsafe.objectFieldOffset(zzk.class.getDeclaredField("thread"));
                zzgqa = unsafe.objectFieldOffset(zzk.class.getDeclaredField("next"));
                zzgpv = unsafe;
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzdac.zzf(exception);
                throw new RuntimeException(exception2);
            }
        }
    }

    static abstract class zza {
        private zza() {
        }

        abstract void zza(zzk var1, Thread var2);

        abstract void zza(zzk var1, zzk var2);

        abstract boolean zza(zzdbf<?> var1, zzk var2, zzk var3);

        abstract boolean zza(zzdbf<?> var1, zzd var2, zzd var3);

        abstract boolean zza(zzdbf<?> var1, Object var2, Object var3);
    }

    static final class zze<V>
    implements Runnable {
        final zzdbf<V> zzgpu;
        final zzdcp<? extends V> future;

        zze(zzdbf<V> zzdbf2, zzdcp<? extends V> zzdcp2) {
            this.zzgpu = zzdbf2;
            this.future = zzdcp2;
        }

        @Override
        public final void run() {
            if (((zzdbf)this.zzgpu).value != this) {
                return;
            }
            Object object = zzdbf.getFutureValue(this.future);
            if (zzgpp.zza(this.zzgpu, this, object)) {
                zzdbf.zza((zzdbf)this.zzgpu);
            }
        }
    }

    static final class zzc {
        static final zzc zzgpr;
        static final zzc zzgps;
        final boolean wasInterrupted;
        @NullableDecl
        final Throwable cause;

        zzc(boolean bl, @NullableDecl Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                zzgps = null;
                zzgpr = null;
            } else {
                zzgps = new zzc(false, null);
                zzgpr = new zzc(true, null);
            }
        }
    }

    static final class zzb {
        static final zzb zzgpq = new zzb(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        zzb(Throwable throwable) {
            this.exception = zzczx.checkNotNull(throwable);
        }
    }

    static final class zzd {
        static final zzd zzgpt = new zzd(null, null);
        final Runnable task;
        final Executor executor;
        @NullableDecl
        zzd next;

        zzd(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    static final class zzk {
        static final zzk zzgqb = new zzk(false);
        @NullableDecl
        volatile Thread thread;
        @NullableDecl
        volatile zzk next;

        private zzk(boolean bl) {
        }

        zzk() {
            zzgpp.zza(this, Thread.currentThread());
        }

        final void zzb(zzk zzk2) {
            zzgpp.zza(this, zzk2);
        }
    }

    static abstract class zzj<V>
    extends zzdbf<V>
    implements zzg<V> {
        zzj() {
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }
    }

    static interface zzg<V>
    extends zzdcp<V> {
    }
}

