/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzczs;
import com.google.android.gms.internal.ads.zzczx;
import com.google.android.gms.internal.ads.zzdbj;
import com.google.android.gms.internal.ads.zzdbk;
import com.google.android.gms.internal.ads.zzdbq;
import com.google.android.gms.internal.ads.zzdcc;
import com.google.android.gms.internal.ads.zzdcf;
import com.google.android.gms.internal.ads.zzdcp;
import com.google.android.gms.internal.ads.zzdcr;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

abstract class zzdbh<I, O, F, T>
extends zzdcc<O>
implements Runnable {
    @NullableDecl
    private zzdcp<? extends I> zzgpl;
    @NullableDecl
    private F zzgqc;

    static <I, O> zzdcp<O> zza(zzdcp<I> zzdcp2, zzdbq<? super I, ? extends O> zzdbq2, Executor executor) {
        zzczx.checkNotNull(executor);
        zzdbk<? super I, ? extends O> zzdbk2 = new zzdbk<I, O>(zzdcp2, zzdbq2);
        zzdcp2.addListener(zzdbk2, zzdcr.zza(executor, zzdbk2));
        return zzdbk2;
    }

    static <I, O> zzdcp<O> zza(zzdcp<I> zzdcp2, zzczs<? super I, ? extends O> zzczs2, Executor executor) {
        zzczx.checkNotNull(zzczs2);
        zzdbj<? super I, ? extends O> zzdbj2 = new zzdbj<I, O>(zzdcp2, zzczs2);
        zzdcp2.addListener(zzdbj2, zzdcr.zza(executor, zzdbj2));
        return zzdbj2;
    }

    zzdbh(zzdcp<? extends I> zzdcp2, F f) {
        this.zzgpl = zzczx.checkNotNull(zzdcp2);
        this.zzgqc = zzczx.checkNotNull(f);
    }

    @Override
    public final void run() {
        T t;
        I i;
        zzdcp<I> zzdcp2 = this.zzgpl;
        F f = this.zzgqc;
        if (this.isCancelled() | zzdcp2 == null | f == null) {
            return;
        }
        this.zzgpl = null;
        if (zzdcp2.isCancelled()) {
            this.setFuture(zzdcp2);
            return;
        }
        try {
            i = zzdcf.zzb(zzdcp2);
        }
        catch (CancellationException cancellationException) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException executionException) {
            this.setException(executionException.getCause());
            return;
        }
        catch (RuntimeException runtimeException) {
            this.setException(runtimeException);
            return;
        }
        catch (Error error) {
            this.setException(error);
            return;
        }
        try {
            t = this.zzc(f, i);
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return;
        }
        finally {
            this.zzgqc = null;
        }
        this.setResult(t);
    }

    @NullableDecl
    abstract T zzc(F var1, @NullableDecl I var2) throws Exception;

    abstract void setResult(@NullableDecl T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.zzgpl);
        this.zzgpl = null;
        this.zzgqc = null;
    }

    @Override
    protected final String pendingToString() {
        String string2;
        zzdcp<? extends I> zzdcp2 = this.zzgpl;
        F f = this.zzgqc;
        String string3 = super.pendingToString();
        String string4 = "";
        if (zzdcp2 != null) {
            string2 = String.valueOf(zzdcp2);
            string4 = new StringBuilder(16 + String.valueOf(string2).length()).append("inputFuture=[").append(string2).append("], ").toString();
        }
        if (f != null) {
            string2 = string4;
            String string5 = String.valueOf(f);
            return new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string5).length()).append(string2).append("function=[").append(string5).append("]").toString();
        }
        if (string3 != null) {
            String string6 = String.valueOf(string4);
            String string7 = String.valueOf(string3);
            if (string7.length() != 0) {
                return string6.concat(string7);
            }
            return new String(string6);
        }
        return null;
    }
}

