/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzczx;
import com.google.android.gms.internal.ads.zzdaf;
import com.google.android.gms.internal.ads.zzdbb;
import com.google.android.gms.internal.ads.zzdbf;
import com.google.android.gms.internal.ads.zzdbm;
import com.google.android.gms.internal.ads.zzdbn;
import com.google.android.gms.internal.ads.zzdbx;
import com.google.android.gms.internal.ads.zzdcf;
import com.google.android.gms.internal.ads.zzdcp;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class zzdbl<InputT, OutputT>
extends zzdbf.zzj<OutputT> {
    private static final Logger logger = Logger.getLogger(zzdbl.class.getName());
    @NullableDecl
    private zza zzgqh;

    zzdbl() {
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        zza zza2 = this.zzgqh;
        if (zza2 != null) {
            this.zzgqh = null;
            zzdaf zzdaf2 = zza2.zzgqd;
            boolean bl = this.wasInterrupted();
            if (bl) {
                zza2.interruptTask();
            }
            if (this.isCancelled() & zzdaf2 != null) {
                zzdbb zzdbb2 = (zzdbb)zzdaf2.iterator();
                while (zzdbb2.hasNext()) {
                    ((zzdcp)zzdbb2.next()).cancel(bl);
                }
            }
        }
    }

    @Override
    protected final String pendingToString() {
        zza zza2 = this.zzgqh;
        if (zza2 == null) {
            return null;
        }
        zzdaf zzdaf2 = zza2.zzgqd;
        if (zzdaf2 != null) {
            String string2 = String.valueOf(zzdaf2);
            return new StringBuilder(10 + String.valueOf(string2).length()).append("futures=[").append(string2).append("]").toString();
        }
        return null;
    }

    final void zzd(zza zza2) {
        this.zzgqh = zza2;
        zza2.zzaou();
    }

    private static boolean zza(Set<Throwable> set, Throwable throwable) {
        while (throwable != null) {
            if (!set.add(throwable)) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return true;
    }

    static /* synthetic */ zza zza(zzdbl zzdbl2, zza zza2) {
        zzdbl2.zzgqh = null;
        return null;
    }

    abstract class zza
    extends zzdbm
    implements Runnable {
        private zzdaf<? extends zzdcp<? extends InputT>> zzgqd;
        private final boolean zzgqe;
        private final boolean zzgqf;

        zza(zzdaf<? extends zzdcp<? extends InputT>> zzdaf2, boolean bl, boolean bl2) {
            super(zzdaf2.size());
            this.zzgqd = zzczx.checkNotNull(zzdaf2);
            this.zzgqe = bl;
            this.zzgqf = bl2;
        }

        @Override
        public final void run() {
            this.zzaov();
        }

        private final void zzaou() {
            if (this.zzgqd.isEmpty()) {
                this.zzaox();
                return;
            }
            if (this.zzgqe) {
                int n = 0;
                zzdbb zzdbb2 = (zzdbb)this.zzgqd.iterator();
                while (zzdbb2.hasNext()) {
                    zzdcp zzdcp2 = (zzdcp)zzdbb2.next();
                    int n2 = n++;
                    zzdcp2.addListener(new zzdbn(this, n2, zzdcp2), zzdbx.zzgqu);
                }
                return;
            }
            zzdbb zzdbb3 = (zzdbb)this.zzgqd.iterator();
            while (zzdbb3.hasNext()) {
                ((zzdcp)zzdbb3.next()).addListener(this, zzdbx.zzgqu);
            }
        }

        private final void zzh(Throwable throwable) {
            zzczx.checkNotNull(throwable);
            boolean bl = false;
            boolean bl2 = true;
            if (this.zzgqe) {
                bl = zzdbl.this.setException(throwable);
                if (bl) {
                    this.zzaow();
                } else {
                    bl2 = zzdbl.zza(this.zzaoz(), throwable);
                }
            }
            if (throwable instanceof Error | this.zzgqe & !bl & bl2) {
                String string2 = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
                logger.logp(Level.SEVERE, "com.google.common.util.concurrent.AggregateFuture$RunningState", "handleException", string2, throwable);
            }
        }

        @Override
        final void zzg(Set<Throwable> set) {
            if (!zzdbl.this.isCancelled()) {
                zzdbl.zza(set, zzdbl.this.zzaor());
            }
        }

        private final void zza(int n, Future<? extends InputT> future) {
            zzczx.checkState(this.zzgqe || !zzdbl.this.isDone() || zzdbl.this.isCancelled(), "Future was done before all dependencies completed");
            try {
                zzczx.checkState(future.isDone(), "Tried to set value from future which is not done");
                if (this.zzgqe) {
                    if (future.isCancelled()) {
                        zzdbl.zza(zzdbl.this, null);
                        zzdbl.this.cancel(false);
                        return;
                    }
                    Object InputT = zzdcf.zzb(future);
                    if (this.zzgqf) {
                        this.zza(this.zzgqe, n, InputT);
                    }
                    return;
                }
                if (this.zzgqf && !future.isCancelled()) {
                    this.zza(this.zzgqe, n, zzdcf.zzb(future));
                }
                return;
            }
            catch (ExecutionException executionException) {
                this.zzh(executionException.getCause());
                return;
            }
            catch (Throwable throwable) {
                this.zzh(throwable);
                return;
            }
        }

        private final void zzaov() {
            int n = this.zzapa();
            zzczx.checkState(n >= 0, "Less than 0 remaining futures");
            if (n == 0) {
                zza zza2 = this;
                if (zza2.zzgqf & !zza2.zzgqe) {
                    int n2 = 0;
                    zzdbb zzdbb2 = (zzdbb)zza2.zzgqd.iterator();
                    while (zzdbb2.hasNext()) {
                        zzdcp zzdcp2 = (zzdcp)zzdbb2.next();
                        zza2.zza(n2++, zzdcp2);
                    }
                }
                zza2.zzaox();
            }
        }

        void zzaow() {
            this.zzgqd = null;
        }

        abstract void zza(boolean var1, int var2, @NullableDecl InputT var3);

        abstract void zzaox();

        void interruptTask() {
        }

        static /* synthetic */ void zza(zza zza2, int n, Future future) {
            zza2.zza(n, future);
        }

        static /* synthetic */ void zzc(zza zza2) {
            zza2.zzaov();
        }
    }
}

