/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzddm;
import com.google.android.gms.internal.ads.zzddu;
import com.google.android.gms.internal.ads.zzddw;
import com.google.android.gms.internal.ads.zzdeb;
import com.google.android.gms.internal.ads.zzdec;
import com.google.android.gms.internal.ads.zzdee;
import com.google.android.gms.internal.ads.zzdeh;
import com.google.android.gms.internal.ads.zzdei;
import com.google.android.gms.internal.ads.zzdiu;
import com.google.android.gms.internal.ads.zzdiy;
import com.google.android.gms.internal.ads.zzdja;
import com.google.android.gms.internal.ads.zzdje;
import com.google.android.gms.internal.ads.zzdot;
import com.google.android.gms.internal.ads.zzdrn;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdef {
    private static final Logger logger = Logger.getLogger(zzdef.class.getName());
    private static final ConcurrentMap<String, zza> zzgsj = new ConcurrentHashMap<String, zza>();
    private static final ConcurrentMap<String, Boolean> zzgsk = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzddm<?>> zzgsl = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, zzdee<?>> zzgsm = new ConcurrentHashMap();

    private static synchronized zza zzgs(String string2) throws GeneralSecurityException {
        if (!zzgsj.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new GeneralSecurityException(string3.length() != 0 ? "No key manager found for key type ".concat(string3) : new String("No key manager found for key type "));
        }
        return (zza)zzgsj.get(string2);
    }

    public static synchronized void zza(String string2, zzddm<?> zzddm2) throws GeneralSecurityException {
        if (zzgsl.containsKey(string2.toLowerCase())) {
            zzddm zzddm3 = (zzddm)zzgsl.get(string2.toLowerCase());
            if (!zzddm2.getClass().equals(zzddm3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzgsl.put(string2.toLowerCase(), zzddm2);
    }

    public static zzddm<?> zzgt(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzddm zzddm2 = (zzddm)zzgsl.get(string2.toLowerCase());
        if (zzddm2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.register().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.register().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.register().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzddm2;
    }

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static synchronized <P> void zza(zzddu<P> zzddu2) throws GeneralSecurityException {
        zzdef.zza(zzddu2, true);
    }

    public static synchronized <P> void zza(zzddu<P> zzddu2, boolean bl) throws GeneralSecurityException {
        if (zzddu2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String string2 = zzddu2.getKeyType();
        if (zzgsj.containsKey(string2)) {
            zza zza2 = (zza)zzgsj.get(string2);
            boolean bl2 = (Boolean)zzgsk.get(string2);
            if (!zzddu2.getClass().equals(zza2.zzaps()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zza2.zzaps().getName(), zzddu2.getClass().getName()));
            }
        }
        zzddu<P> zzddu3 = zzddu2;
        zzgsj.put(string2, new zzdeh(zzddu3));
        zzgsk.put(string2, bl);
    }

    public static synchronized <P> void zza(zzdee<P> zzdee2) throws GeneralSecurityException {
        if (zzdee2 == null) {
            throw new IllegalArgumentException("wrapper must be non-null");
        }
        Class<P> clazz = zzdee2.zzapj();
        if (zzgsm.containsKey(clazz)) {
            zzdee zzdee3 = (zzdee)zzgsm.get(clazz);
            if (!zzdee2.getClass().equals(zzdee3.getClass())) {
                String string2 = String.valueOf(clazz.toString());
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", string2.length() != 0 ? "Attempted overwrite of a registered SetWrapper for type ".concat(string2) : new String("Attempted overwrite of a registered SetWrapper for type "));
                throw new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", clazz.getName(), zzdee3.getClass().getName(), zzdee2.getClass().getName()));
            }
        }
        zzgsm.put(clazz, zzdee2);
    }

    private static zzddu<?> zzgu(String string2) throws GeneralSecurityException {
        return zzdef.zzgs(string2).zzapr();
    }

    private static <P> zzddu<P> zza(String string2, Class<P> clazz) throws GeneralSecurityException {
        zza zza2 = zzdef.zzgs(string2);
        if (clazz == null) {
            return zza2.zzapr();
        }
        if (zza2.zzapt().contains(clazz)) {
            return zza2.zzb(clazz);
        }
        String string3 = clazz.getName();
        String string4 = String.valueOf(zza2.zzaps());
        Set<Class<?>> set = zza2.zzapt();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Class<?> clazz2 : set) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz2.getCanonicalName());
            bl = false;
        }
        String string5 = stringBuilder.toString();
        throw new GeneralSecurityException(new StringBuilder(77 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Primitive type ").append(string3).append(" not supported by key manager of type ").append(string4).append(", supported primitives: ").append(string5).toString());
    }

    public static synchronized zzdiu zza(zzdja zzdja2) throws GeneralSecurityException {
        zzddu<?> zzddu2 = zzdef.zzgu(zzdja2.zzatp());
        if (((Boolean)zzgsk.get(zzdja2.zzatp())).booleanValue()) {
            return zzddu2.zzr(zzdja2.zzatq());
        }
        String string2 = String.valueOf(zzdja2.zzatp());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdrn zzb(zzdja zzdja2) throws GeneralSecurityException {
        zzddu<?> zzddu2 = zzdef.zzgu(zzdja2.zzatp());
        if (((Boolean)zzgsk.get(zzdja2.zzatp())).booleanValue()) {
            return zzddu2.zzq(zzdja2.zzatq());
        }
        String string2 = String.valueOf(zzdja2.zzatp());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdrn zza(String string2, zzdrn zzdrn2) throws GeneralSecurityException {
        zzddu zzddu2 = zzdef.zza(string2, null);
        if (((Boolean)zzgsk.get(string2)).booleanValue()) {
            return zzddu2.zzb(zzdrn2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zza(String string2, zzdrn zzdrn2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdef.checkNotNull(clazz);
        zzdrn zzdrn3 = zzdrn2;
        return zzdef.zza(string2, clazz2).zza(zzdrn3);
    }

    private static <P> P zza(String string2, zzdot zzdot2, Class<P> clazz) throws GeneralSecurityException {
        return zzdef.zza(string2, clazz).zzp(zzdot2);
    }

    public static <P> P zza(String string2, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = clazz;
        zzdot zzdot2 = zzdot.zzy((byte[])byArray);
        return zzdef.zza(string2, zzdot2, zzdef.checkNotNull(clazz2));
    }

    public static <P> zzdec<P> zza(zzddw zzddw2, zzddu<P> zzddu2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdef.checkNotNull(clazz);
        zzddw zzddw3 = zzddw2;
        zzdei.zzd(zzddw3.zzapl());
        zzdec<P> zzdec2 = zzdec.zza(clazz2);
        for (zzdje.zza zza2 : zzddw3.zzapl().zzaue()) {
            if (zza2.zzapn() != zzdiy.zzgxh) continue;
            P p = zzdef.zza(zza2.zzauj().zzatp(), zza2.zzauj().zzatq(), clazz2);
            zzdeb<P> zzdeb2 = zzdec2.zza(p, zza2);
            if (zza2.zzauk() != zzddw3.zzapl().zzaud()) continue;
            zzdec2.zza(zzdeb2);
        }
        return zzdec2;
    }

    public static <P> P zza(zzdec<P> zzdec2) throws GeneralSecurityException {
        zzdee zzdee2 = (zzdee)zzgsm.get(zzdec2.zzapj());
        if (zzdee2 == null) {
            String string2 = String.valueOf(zzdec2.zzapj().getName());
            throw new GeneralSecurityException(string2.length() != 0 ? "No wrapper found for ".concat(string2) : new String("No wrapper found for "));
        }
        return zzdee2.zza(zzdec2);
    }

    static interface zza {
        public <P> zzddu<P> zzb(Class<P> var1) throws GeneralSecurityException;

        public zzddu<?> zzapr();

        public Class<?> zzaps();

        public Set<Class<?>> zzapt();
    }
}

