/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdea;
import com.google.android.gms.internal.ads.zzdnb;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzdnp
implements zzdea {
    private final Mac zzhee;
    private final int zzhef;
    private final String zzheg;
    private final Key zzheh;

    public zzdnp(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        if (key.getEncoded().length < 16) {
            throw new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzheg = string2;
        this.zzhef = n;
        this.zzheh = key;
        this.zzhee = zzdnb.zzhdm.zzhf(string2);
        this.zzhee.init(key);
    }

    @Override
    public final byte[] zzk(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzhee.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzdnb.zzhdm.zzhf(this.zzheg);
            mac.init(this.zzheh);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzhef];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzhef);
        return byArray2;
    }
}

