/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.ads.zzbo;
import com.google.android.gms.internal.ads.zzci;
import com.google.android.gms.internal.ads.zzcyk;
import com.google.android.gms.internal.ads.zzda;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdk;
import com.google.android.gms.internal.ads.zzdot;
import com.google.android.gms.internal.ads.zzdpq;
import com.google.android.gms.internal.ads.zzdqd;
import com.google.android.gms.internal.ads.zzdw;
import com.google.android.gms.internal.ads.zzdz;
import com.google.android.gms.internal.ads.zzea;
import com.google.android.gms.internal.ads.zzeb;
import com.google.android.gms.internal.ads.zzec;
import com.google.android.gms.internal.ads.zzee;
import com.google.android.gms.internal.ads.zzfj;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdx {
    private static final String TAG = zzdx.class.getSimpleName();
    protected Context zzlk;
    private ExecutorService zzxr;
    private DexClassLoader zzxs;
    private zzdh zzxt;
    private byte[] zzxu;
    private volatile AdvertisingIdClient zzxv = null;
    private volatile boolean zzwo = false;
    private Future zzxw = null;
    private boolean zzxx;
    private volatile zzbo.zza zzxy = null;
    private Future zzxz = null;
    private zzda zzya;
    protected boolean zzyb = false;
    private boolean zzyc = false;
    private Map<Pair<String, String>, zzfj> zzyd;
    private boolean zzye = false;
    private boolean zzyf = true;
    private boolean zzyg = false;

    public static zzdx zza(Context context, String string2, String string3, boolean bl) {
        zzdx zzdx2 = new zzdx(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdx zzdx3 = zzdx2;
            zzdx2.zzxr = Executors.newCachedThreadPool(new zzea());
            boolean bl3 = bl2;
            zzdx zzdx4 = zzdx3;
            zzdx3.zzwo = bl3;
            if (bl3) {
                zzdx4.zzxw = zzdx4.zzxr.submit(new zzdz(zzdx4));
            }
            zzdx zzdx5 = zzdx3;
            zzdx5.zzxr.execute(new zzeb(zzdx5));
            try {
                object = GoogleApiAvailabilityLight.getInstance();
                zzdx5.zzyb = object.getApkVersion(zzdx5.zzlk) > 0;
                zzdx5.zzyc = object.isGooglePlayServicesAvailable(zzdx5.zzlk) == 0;
            }
            catch (Throwable throwable) {}
            zzdx3.zza(0, true);
            if (zzee.isMainThread()) {
                zzdx4 = zzyt.zzcnc;
                if (((Boolean)zzuo.zzoj().zzd((zzyi)zzdx4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzdx5 = zzdx3;
            zzdx3.zzxt = new zzdh(null);
            try {
                zzdx5.zzxu = zzdx5.zzxt.zzaq((String)object);
            }
            catch (zzdk zzdk2) {
                throw new zzdw(zzdk2);
            }
            object = string4;
            zzdx5 = zzdx3;
            try {
                String string6;
                File file = zzdx5.zzlk.getCacheDir();
                if (file == null && (file = zzdx5.zzlk.getDir("dex", 0)) == null) {
                    throw new zzdw();
                }
                String string7 = string6 = "1557357152169";
                File file2 = file;
                Object object2 = object;
                zzdx zzdx6 = zzdx5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzdx6.zzxt.zza(zzdx6.zzxu, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdx5.zzb(file, string6);
                try {
                    zzdx5.zzxs = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdx5.zzlk.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdx.zzb(file4);
                    zzdx5.zza(file, string6);
                    zzdx.zzar(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzdx.zzb(file4);
                zzdx5.zza(file, string6);
                zzdx.zzar(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzdw(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzdw(iOException);
            }
            catch (zzdk zzdk3) {
                throw new zzdw(zzdk3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzdw(nullPointerException);
            }
            zzdx4 = zzdx3;
            if (!zzdx4.zzyg) {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.USER_PRESENT");
                intentFilter.addAction("android.intent.action.SCREEN_OFF");
                zzdx4.zzlk.registerReceiver((BroadcastReceiver)zzdx4.new zza(null), intentFilter);
                zzdx4.zzyg = true;
            }
            zzdx3.zzya = new zzda(zzdx3);
            zzdx3.zzye = true;
        }
        catch (zzdw zzdw2) {}
        return zzdx2;
    }

    public final Context getContext() {
        return this.zzlk;
    }

    public final boolean isInitialized() {
        return this.zzye;
    }

    public final ExecutorService zzcd() {
        return this.zzxr;
    }

    public final DexClassLoader zzce() {
        return this.zzxs;
    }

    public final zzdh zzcf() {
        return this.zzxt;
    }

    public final byte[] zzcg() {
        return this.zzxu;
    }

    public final boolean zzch() {
        return this.zzyb;
    }

    public final zzda zzci() {
        return this.zzya;
    }

    public final boolean zzcj() {
        return this.zzyc;
    }

    public final boolean zzck() {
        return this.zzyf;
    }

    public final zzbo.zza zzcl() {
        return this.zzxy;
    }

    public final Future zzcm() {
        return this.zzxz;
    }

    private zzdx(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzxx = context2 != null;
        this.zzlk = this.zzxx ? context2 : context;
        this.zzyd = new HashMap<Pair<String, String>, zzfj>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdx.zzb(file2);
            return;
        }
        System.out.print("test");
        System.out.print("test");
        System.out.print("test");
        zzbo.zzd.zza zza2 = zzbo.zzd.zzbb().zzl(zzdot.zzy((byte[])Build.VERSION.SDK.getBytes())).zzk(zzdot.zzy((byte[])string2.getBytes()));
        byte[] byArray2 = this.zzxt.zzb(this.zzxu, byArray).getBytes();
        zza2.zzi(zzdot.zzy((byte[])byArray2)).zzj(zzdot.zzy((byte[])zzci.zzb(byArray2)));
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = ((zzbo.zzd)((zzdqd)zza2.zzazm())).toByteArray();
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdx.zzb(file2);
        return;
        catch (zzdk | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdx.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdx.zzb(file2);
            throw throwable;
        }
    }

    private static void zzar(String string2) {
        zzdx.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbo.zzd zzd2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdx.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdx.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                zzd2 = zzbo.zzd.zzc((byte[])byArray, (zzdpq)zzdpq.zzayw());
                if (string2.equals(new String(zzd2.zzaz().toByteArray())) && Arrays.equals(zzd2.zzay().toByteArray(), zzci.zzb(zzd2.zzax().toByteArray())) && Arrays.equals(zzd2.zzba().toByteArray(), Build.VERSION.SDK.getBytes())) break block30;
                zzdx.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzxt.zza(this.zzxu, new String(zzd2.zzax().toByteArray()));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzdk | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzyd.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzyd.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzfj(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzfj zzfj2 = this.zzyd.get(new Pair((Object)string2, (Object)string3));
        if (zzfj2 == null) {
            return null;
        }
        return zzfj2.zzcy();
    }

    private final void zzcn() {
        try {
            if (this.zzxv == null && this.zzxx) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzlk);
                advertisingIdClient.start();
                this.zzxv = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzxv = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzyc) {
            return;
        }
        Future<?> future = this.zzxr.submit(new zzec(this, n, bl));
        if (n == 0) {
            this.zzxz = future;
        }
    }

    @VisibleForTesting
    final zzbo.zza zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzco();
    }

    private static boolean zza(int n, zzbo.zza zza2) {
        if (n < 4) {
            if (zza2 == null) {
                return true;
            }
            if (!zza2.zzah() || zza2.zzad().equals("0000000000000000000000000000000000000000000000000000000000000000")) {
                return true;
            }
            if (!zza2.zzaj() || !zza2.zzak().zzbd() || zza2.zzak().zzbe() == -2L) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzbo.zza zzco() {
        zzbo.zza zza2 = null;
        try {
            PackageInfo packageInfo = this.zzlk.getPackageManager().getPackageInfo(this.zzlk.getPackageName(), 0);
            zza2 = zzcyk.zzj((Context)this.zzlk, (String)this.zzlk.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zza2;
    }

    public final AdvertisingIdClient zzcp() {
        if (!this.zzwo) {
            return null;
        }
        if (this.zzxv != null) {
            return this.zzxv;
        }
        if (this.zzxw != null) {
            try {
                this.zzxw.get(2000L, TimeUnit.MILLISECONDS);
                this.zzxw = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzxw.cancel(true);
            }
        }
        return this.zzxv;
    }

    public final int zzbz() {
        int n = Integer.MIN_VALUE;
        if (this.zzya != null) {
            n = zzda.zzbz();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdx zzdx2) {
        zzdx2.zzcn();
    }

    static /* synthetic */ zzbo.zza zza(zzdx zzdx2, zzbo.zza zza2) {
        zzdx2.zzxy = zza2;
        return zzdx2.zzxy;
    }

    static /* synthetic */ boolean zzb(int n, zzbo.zza zza2) {
        return zzdx.zza(n, zza2);
    }

    final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public final void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzdx.this.zzyf = true;
                return;
            }
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzdx.this.zzyf = false;
            }
        }

        /* synthetic */ zza(zzea zzea2) {
            this();
        }
    }
}

