/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.ConditionVariable;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zzgc;
import com.google.android.gms.internal.ads.zzgw;
import com.google.android.gms.internal.ads.zzhd;
import com.google.android.gms.internal.ads.zzhe;
import com.google.android.gms.internal.ads.zzhf;
import com.google.android.gms.internal.ads.zzhg;
import com.google.android.gms.internal.ads.zzhp;
import com.google.android.gms.internal.ads.zzhr;
import com.google.android.gms.internal.ads.zzhs;
import com.google.android.gms.internal.ads.zzht;
import com.google.android.gms.internal.ads.zzhu;
import com.google.android.gms.internal.ads.zzhv;
import com.google.android.gms.internal.ads.zzhw;
import com.google.android.gms.internal.ads.zzhx;
import com.google.android.gms.internal.ads.zzhy;
import com.google.android.gms.internal.ads.zzia;
import com.google.android.gms.internal.ads.zzie;
import com.google.android.gms.internal.ads.zzig;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zzoh;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;

public final class zzhq {
    private static boolean zzaho = false;
    private static boolean zzahp = false;
    private final zzhd zzahq = null;
    private final zzhx zzahr;
    private final zzig zzahs;
    private final zzhg[] zzaht;
    private final zzhw zzahu;
    private final ConditionVariable zzahv;
    private final long[] zzahw;
    private final zzhs zzahx;
    private final LinkedList<zzhv> zzahy;
    private AudioTrack zzahz;
    private int zzafm;
    private int zzaia;
    private int zzaib;
    private int zzaic;
    private int streamType;
    private boolean zzaid;
    private int zzaie;
    private long zzaif;
    private zzgw zzaig;
    private zzgw zzade;
    private long zzaih;
    private long zzaii;
    private ByteBuffer zzaij;
    private int zzaik;
    private int zzail;
    private int zzaim;
    private long zzain;
    private long zzaio;
    private boolean zzaip;
    private long zzaiq;
    private Method zzair;
    private int zzais;
    private long zzait;
    private long zzaiu;
    private int zzaiv;
    private long zzaiw;
    private long zzaix;
    private int zzaiy;
    private int zzaiz;
    private long zzaja;
    private long zzajb;
    private long zzajc;
    private float zzcw;
    private zzhg[] zzajd;
    private ByteBuffer[] zzaje;
    private ByteBuffer zzajf;
    private ByteBuffer zzajg;
    private byte[] zzajh;
    private int zzaji;
    private int zzajj;
    private boolean zzajk;
    private boolean zzajl;
    private int zzajm;
    private boolean zzajn;
    private boolean zzajo;
    private long zzajp;

    public zzhq(zzhd zzhd2, zzhg[] zzhgArray, zzhw zzhw2) {
        this.zzahu = zzhw2;
        this.zzahv = new ConditionVariable(true);
        if (zzoh.SDK_INT >= 18) {
            try {
                this.zzair = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.zzahx = zzoh.SDK_INT >= 19 ? new zzhr() : new zzhs(null);
        this.zzahr = new zzhx();
        this.zzahs = new zzig();
        this.zzaht = new zzhg[3 + zzhgArray.length];
        this.zzaht[0] = new zzie();
        this.zzaht[1] = this.zzahr;
        System.arraycopy(zzhgArray, 0, this.zzaht, 2, zzhgArray.length);
        this.zzaht[2 + zzhgArray.length] = this.zzahs;
        this.zzahw = new long[10];
        this.zzcw = 1.0f;
        this.zzaiz = 0;
        this.streamType = 3;
        this.zzajm = 0;
        this.zzade = zzgw.zzafx;
        this.zzajj = -1;
        this.zzajd = new zzhg[0];
        this.zzaje = new ByteBuffer[0];
        this.zzahy = new LinkedList();
    }

    public final boolean zzav(String string2) {
        return this.zzahq != null && this.zzahq.zzp(zzhq.zzaw(string2));
    }

    public final long zzi(boolean bl) {
        long l;
        long l2;
        zzhq zzhq2 = this;
        if (!(zzhq2.isInitialized() && zzhq2.zzaiz != 0)) {
            return Long.MIN_VALUE;
        }
        if (this.zzahz.getPlayState() == 3) {
            zzhq2 = this;
            l2 = zzhq2.zzahx.zzfj();
            if (l2 != 0L) {
                long l3 = System.nanoTime() / 1000L;
                if (l3 - zzhq2.zzaio >= 30000L) {
                    zzhq2.zzahw[zzhq2.zzail] = l2 - l3;
                    zzhq2.zzail = (zzhq2.zzail + 1) % 10;
                    if (zzhq2.zzaim < 10) {
                        ++zzhq2.zzaim;
                    }
                    zzhq2.zzaio = l3;
                    zzhq2.zzain = 0L;
                    for (int i = 0; i < zzhq2.zzaim; ++i) {
                        zzhq2.zzain += zzhq2.zzahw[i] / (long)zzhq2.zzaim;
                    }
                }
                if (!zzhq2.zzfe() && l3 - zzhq2.zzaiq >= 500000L) {
                    zzhq2.zzaip = zzhq2.zzahx.zzff();
                    if (zzhq2.zzaip) {
                        String string2;
                        long l4 = zzhq2.zzahx.zzfg() / 1000L;
                        long l5 = zzhq2.zzahx.zzfh();
                        if (l4 < zzhq2.zzajb) {
                            zzhq2.zzaip = false;
                        } else if (Math.abs(l4 - l3) > 5000000L) {
                            string2 = new StringBuilder(136).append("Spurious audio timestamp (system clock mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzhq2.zzaip = false;
                        } else if (Math.abs(zzhq2.zzdq(l5) - l2) > 5000000L) {
                            string2 = new StringBuilder(138).append("Spurious audio timestamp (frame position mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzhq2.zzaip = false;
                        }
                    }
                    if (zzhq2.zzair != null && !zzhq2.zzaid) {
                        try {
                            zzhq2.zzajc = (long)((Integer)zzhq2.zzair.invoke((Object)zzhq2.zzahz, null)).intValue() * 1000L - zzhq2.zzaif;
                            zzhq2.zzajc = Math.max(zzhq2.zzajc, 0L);
                            if (zzhq2.zzajc > 5000000L) {
                                long l6 = zzhq2.zzajc;
                                Log.w((String)"AudioTrack", (String)new StringBuilder(61).append("Ignoring impossibly large audio latency: ").append(l6).toString());
                                zzhq2.zzajc = 0L;
                            }
                        }
                        catch (Exception exception) {
                            zzhq2.zzair = null;
                        }
                    }
                    zzhq2.zzaiq = l3;
                }
            }
        }
        long l7 = System.nanoTime() / 1000L;
        if (this.zzaip) {
            long l8 = l7 - this.zzahx.zzfg() / 1000L;
            long l9 = this.zzdr(l8);
            long l10 = this.zzahx.zzfh() + l9;
            l = this.zzdq(l10);
        } else {
            l = this.zzaim == 0 ? this.zzahx.zzfj() : l7 + this.zzain;
            if (!bl) {
                l -= this.zzajc;
            }
        }
        l2 = l;
        zzhq2 = this;
        while (!zzhq2.zzahy.isEmpty() && l2 >= zzhv.zzb(zzhq2.zzahy.getFirst())) {
            zzhv zzhv2 = zzhq2.zzahy.remove();
            zzhq2.zzade = zzhv.zza(zzhv2);
            zzhq2.zzaii = zzhv.zzb(zzhv2);
            zzhq2.zzaih = zzhv.zzc(zzhv2) - zzhq2.zzaja;
        }
        return this.zzaja + (zzhq2.zzade.zzafy == 1.0f ? l2 + zzhq2.zzaih - zzhq2.zzaii : (zzhq2.zzahy.isEmpty() && zzhq2.zzahs.zzfs() >= 1024L ? zzhq2.zzaih + zzoh.zza(l2 - zzhq2.zzaii, zzhq2.zzahs.zzfr(), zzhq2.zzahs.zzfs()) : zzhq2.zzaih + (long)((double)zzhq2.zzade.zzafy * (double)(l2 - zzhq2.zzaii))));
    }

    public final void zza(String string2, int n, int n2, int n3, int n4, int[] nArray) throws zzhu {
        int n5;
        zzhq zzhq2;
        int n6;
        int n7;
        int n8;
        boolean bl = !"audio/raw".equals(string2);
        int n9 = bl ? zzhq.zzaw(string2) : n3;
        boolean bl2 = false;
        if (!bl) {
            this.zzais = zzoh.zzf(n3, n);
            this.zzahr.zzb(nArray);
            zzhg[] zzhgArray = this.zzaht;
            n8 = this.zzaht.length;
            for (n7 = 0; n7 < n8; ++n7) {
                zzhg zzhg2 = zzhgArray[n7];
                try {
                    bl2 |= zzhg2.zzb(n2, n, n9);
                }
                catch (zzhf zzhf2) {
                    throw new zzhu(zzhf2);
                }
                if (!zzhg2.isActive()) continue;
                n = zzhg2.zzeq();
                n9 = zzhg2.zzer();
            }
            if (bl2) {
                this.zzeu();
            }
        }
        switch (n) {
            case 1: {
                n6 = 4;
                break;
            }
            case 2: {
                n6 = 12;
                break;
            }
            case 3: {
                n6 = 28;
                break;
            }
            case 4: {
                n6 = 204;
                break;
            }
            case 5: {
                n6 = 220;
                break;
            }
            case 6: {
                n6 = 252;
                break;
            }
            case 7: {
                n6 = 1276;
                break;
            }
            case 8: {
                n6 = zzgc.CHANNEL_OUT_7POINT1_SURROUND;
                break;
            }
            default: {
                n8 = n;
                throw new zzhu(new StringBuilder(38).append("Unsupported channel count: ").append(n8).toString());
            }
        }
        if (zzoh.SDK_INT <= 23 && "foster".equals(zzoh.DEVICE) && "NVIDIA".equals(zzoh.MANUFACTURER)) {
            switch (n) {
                case 7: {
                    n6 = zzgc.CHANNEL_OUT_7POINT1_SURROUND;
                    break;
                }
                case 3: 
                case 5: {
                    n6 = 252;
                }
            }
        }
        if (zzoh.SDK_INT <= 25 && "fugu".equals(zzoh.DEVICE) && bl && n == 1) {
            n6 = 12;
        }
        if (!bl2 && this.isInitialized() && this.zzaib == n9 && this.zzafm == n2 && this.zzaia == n6) {
            return;
        }
        this.reset();
        this.zzaib = n9;
        this.zzaid = bl;
        this.zzafm = n2;
        this.zzaia = n6;
        this.zzaic = bl ? n9 : 2;
        this.zzaiv = zzoh.zzf(2, n);
        if (bl) {
            if (this.zzaic == 5 || this.zzaic == 6) {
                zzhq2 = this;
                n5 = 20480;
            } else {
                zzhq2 = this;
                n5 = 49152;
            }
        } else {
            n8 = AudioTrack.getMinBufferSize((int)n2, (int)n6, (int)this.zzaic);
            zznt.checkState(n8 != -2);
            n7 = n8 << 2;
            int n10 = (int)this.zzdr(250000L) * this.zzaiv;
            int n11 = (int)Math.max((long)n8, this.zzdr(750000L) * (long)this.zzaiv);
            zzhq2 = this;
            n5 = n7 < n10 ? n10 : (n7 > n11 ? n11 : n7);
        }
        zzhq2.zzaie = n5;
        this.zzaif = bl ? -9223372036854775807L : this.zzdq(this.zzaie / this.zzaiv);
        this.zzb(this.zzade);
    }

    private final void zzeu() {
        ArrayList<zzhg> arrayList = new ArrayList<zzhg>();
        zzhg[] zzhgArray = this.zzaht;
        int n = this.zzaht.length;
        for (int i = 0; i < n; ++i) {
            zzhg zzhg2 = zzhgArray[i];
            if (zzhg2.isActive()) {
                arrayList.add(zzhg2);
                continue;
            }
            zzhg2.flush();
        }
        int n2 = arrayList.size();
        this.zzajd = arrayList.toArray(new zzhg[n2]);
        this.zzaje = new ByteBuffer[n2];
        for (n = 0; n < n2; ++n) {
            zzhg zzhg3 = this.zzajd[n];
            zzhg3.flush();
            this.zzaje[n] = zzhg3.zzet();
        }
    }

    public final void play() {
        this.zzajl = true;
        if (this.isInitialized()) {
            this.zzajb = System.nanoTime() / 1000L;
            this.zzahz.play();
        }
    }

    public final void zzev() {
        if (this.zzaiz == 1) {
            this.zzaiz = 2;
        }
    }

    public final boolean zza(ByteBuffer byteBuffer, long l) throws zzht, zzhy {
        long l2;
        zzhq zzhq2;
        zznt.checkArgument(this.zzajf == null || byteBuffer == this.zzajf);
        if (!this.isInitialized()) {
            int n;
            zzhq2 = this;
            zzhq2.zzahv.block();
            if (zzhq2.zzajn) {
                int n2 = zzhq2.zzajm;
                int n3 = zzhq2.zzaie;
                int n4 = zzhq2.zzaic;
                n = zzhq2.zzaia;
                int n5 = zzhq2.zzafm;
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).setFlags(16).build();
                AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(n).setEncoding(n4).setSampleRate(n5).build();
                zzhq2.zzahz = new AudioTrack(audioAttributes, audioFormat, n3, 1, n2);
            } else {
                zzhq2.zzahz = zzhq2.zzajm == 0 ? new AudioTrack(zzhq2.streamType, zzhq2.zzafm, zzhq2.zzaia, zzhq2.zzaic, zzhq2.zzaie, 1) : new AudioTrack(zzhq2.streamType, zzhq2.zzafm, zzhq2.zzaia, zzhq2.zzaic, zzhq2.zzaie, 1, zzhq2.zzajm);
            }
            zzhq zzhq3 = zzhq2;
            n = zzhq3.zzahz.getState();
            if (n != 1) {
                try {
                    zzhq3.zzahz.release();
                }
                catch (Exception exception) {
                }
                finally {
                    zzhq3.zzahz = null;
                }
                throw new zzht(n, zzhq3.zzafm, zzhq3.zzaia, zzhq3.zzaie);
            }
            int n6 = zzhq2.zzahz.getAudioSessionId();
            if (zzhq2.zzajm != n6) {
                zzhq2.zzajm = n6;
                zzhq2.zzahu.zzr(n6);
            }
            zzhq2.zzahx.zza(zzhq2.zzahz, zzhq2.zzfe());
            zzhq2.zzfb();
            zzhq2.zzajo = false;
            if (this.zzajl) {
                this.play();
            }
        }
        if (this.zzfe()) {
            if (this.zzahz.getPlayState() == 2) {
                this.zzajo = false;
                return false;
            }
            if (this.zzahz.getPlayState() == 1 && this.zzahx.zzfi() != 0L) {
                return false;
            }
        }
        boolean bl = this.zzajo;
        this.zzajo = this.zzey();
        if (bl && !this.zzajo && this.zzahz.getPlayState() != 1) {
            l2 = SystemClock.elapsedRealtime() - this.zzajp;
            this.zzahu.zzc(this.zzaie, zzgc.zzdi(this.zzaif), l2);
        }
        if (this.zzajf == null) {
            if (!byteBuffer.hasRemaining()) {
                return true;
            }
            if (this.zzaid && this.zzaiy == 0) {
                int n;
                ByteBuffer byteBuffer2 = byteBuffer;
                int n7 = this.zzaic;
                if (n7 == 7 || n7 == 8) {
                    n = zzia.zzj(byteBuffer2);
                } else if (n7 == 5) {
                    n = zzhe.zzep();
                } else if (n7 == 6) {
                    n = zzhe.zzh(byteBuffer2);
                } else {
                    throw new IllegalStateException(new StringBuilder(38).append("Unexpected audio encoding: ").append(n7).toString());
                }
                this.zzaiy = n;
            }
            if (this.zzaig != null) {
                if (!this.zzex()) {
                    return false;
                }
                this.zzahy.add(new zzhv(this.zzaig, Math.max(0L, l), this.zzdq(this.zzfc()), null));
                this.zzaig = null;
                this.zzeu();
            }
            if (this.zzaiz == 0) {
                this.zzaja = Math.max(0L, l);
                this.zzaiz = 1;
            } else {
                zzhq2 = this;
                l2 = this.zzaja + this.zzdq(zzhq2.zzaid ? zzhq2.zzaiu : zzhq2.zzait / (long)zzhq2.zzais);
                if (this.zzaiz == 1 && Math.abs(l2 - l) > 200000L) {
                    Log.e((String)"AudioTrack", (String)new StringBuilder(80).append("Discontinuity detected [expected ").append(l2).append(", got ").append(l).append("]").toString());
                    this.zzaiz = 2;
                }
                if (this.zzaiz == 2) {
                    this.zzaja += l - l2;
                    this.zzaiz = 1;
                    this.zzahu.zzdr();
                }
            }
            if (this.zzaid) {
                this.zzaiu += (long)this.zzaiy;
            } else {
                this.zzait += (long)byteBuffer.remaining();
            }
            this.zzajf = byteBuffer;
        }
        if (this.zzaid) {
            this.zzb(this.zzajf, l);
        } else {
            this.zzdp(l);
        }
        if (!this.zzajf.hasRemaining()) {
            this.zzajf = null;
            return true;
        }
        return false;
    }

    private final void zzdp(long l) throws zzhy {
        int n;
        int n2 = n = this.zzajd.length;
        while (n2 >= 0) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = n2 > 0 ? this.zzaje[n2 - 1] : (byteBuffer = this.zzajf != null ? this.zzajf : zzhg.zzagz);
            if (n2 == n) {
                this.zzb(byteBuffer, l);
            } else {
                ByteBuffer byteBuffer3;
                zzhg zzhg2 = this.zzajd[n2];
                zzhg2.zzi(byteBuffer);
                this.zzaje[n2] = byteBuffer3 = zzhg2.zzet();
                if (byteBuffer3.hasRemaining()) {
                    ++n2;
                    continue;
                }
            }
            if (byteBuffer.hasRemaining()) {
                return;
            }
            --n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean zzb(ByteBuffer var1_1, long var2_2) throws zzhy {
        block19: {
            block20: {
                block18: {
                    if (!var1_1.hasRemaining()) {
                        return true;
                    }
                    if (this.zzajg != null) {
                        zznt.checkArgument(this.zzajg == var1_1);
                    } else {
                        this.zzajg = var1_1;
                        if (zzoh.SDK_INT < 21) {
                            var4_3 = var1_1.remaining();
                            if (this.zzajh == null || this.zzajh.length < var4_3) {
                                this.zzajh = new byte[var4_3];
                            }
                            var5_4 = var1_1.position();
                            var1_1.get(this.zzajh, 0, var4_3);
                            var1_1.position(var5_4);
                            this.zzaji = 0;
                        }
                    }
                    var4_3 = var1_1.remaining();
                    var5_4 = 0;
                    if (zzoh.SDK_INT >= 21) break block18;
                    var6_5 = (int)(this.zzaiw - this.zzahx.zzfi() * (long)this.zzaiv);
                    var7_6 = this.zzaie - var6_5;
                    if (var7_6 > 0 && (var5_4 = this.zzahz.write(this.zzajh, this.zzaji, var7_6 = Math.min(var4_3, var7_6))) > 0) {
                        this.zzaji += var5_4;
                        var1_1.position(var1_1.position() + var5_4);
                    }
                    break block19;
                }
                if (!this.zzajn) break block20;
                zznt.checkState(var2_2 != -9223372036854775807L);
                var11_7 = var2_2;
                var10_8 = var1_1;
                var9_9 = this.zzahz;
                var8_11 = this;
                if (var8_11.zzaij == null) {
                    var8_11.zzaij = ByteBuffer.allocate(16);
                    var8_11.zzaij.order(ByteOrder.BIG_ENDIAN);
                    var8_11.zzaij.putInt(0x55550001);
                }
                if (var8_11.zzaik == 0) {
                    var8_11.zzaij.putInt(4, var4_3);
                    var8_11.zzaij.putLong(8, var11_7 * 1000L);
                    var8_11.zzaij.position(0);
                    var8_11.zzaik = var4_3;
                }
                if ((var13_12 = var8_11.zzaij.remaining()) <= 0) ** GOTO lbl-1000
                var14_13 = var9_9.write(var8_11.zzaij, var13_12, 1);
                if (var14_13 < 0) {
                    var8_11.zzaik = 0;
                    v0 = var14_13;
                } else if (var14_13 < var13_12) {
                    v0 = 0;
                } else if ((var14_13 = var9_9.write(var15_14 = var10_8, var4_3, 1)) < 0) {
                    var8_11.zzaik = 0;
                    v0 = var14_13;
                } else {
                    var8_11.zzaik -= var14_13;
                    v0 = var14_13;
                }
                var5_4 = v0;
                break block19;
            }
            var9_10 = var1_1;
            var5_4 = this.zzahz.write(var9_10, var4_3, 1);
        }
        this.zzajp = SystemClock.elapsedRealtime();
        if (var5_4 < 0) {
            throw new zzhy(var5_4);
        }
        if (!this.zzaid) {
            this.zzaiw += (long)var5_4;
        }
        if (var5_4 == var4_3) {
            if (this.zzaid) {
                this.zzaix += (long)this.zzaiy;
            }
            this.zzajg = null;
            return true;
        }
        return false;
    }

    public final void zzew() throws zzhy {
        if (this.zzajk || !this.isInitialized()) {
            return;
        }
        if (this.zzex()) {
            this.zzahx.zzds(this.zzfc());
            this.zzaik = 0;
            this.zzajk = true;
        }
    }

    private final boolean zzex() throws zzhy {
        boolean bl = false;
        if (this.zzajj == -1) {
            this.zzajj = this.zzaid ? this.zzajd.length : 0;
            bl = true;
        }
        while (this.zzajj < this.zzajd.length) {
            zzhg zzhg2 = this.zzajd[this.zzajj];
            if (bl) {
                zzhg2.zzes();
            }
            this.zzdp(-9223372036854775807L);
            if (!zzhg2.zzel()) {
                return false;
            }
            bl = true;
            ++this.zzajj;
        }
        if (this.zzajg != null) {
            this.zzb(this.zzajg, -9223372036854775807L);
            if (this.zzajg != null) {
                return false;
            }
        }
        this.zzajj = -1;
        return true;
    }

    public final boolean zzel() {
        return !this.isInitialized() || this.zzajk && !this.zzey();
    }

    public final boolean zzey() {
        zzhq zzhq2;
        return this.isInitialized() && (this.zzfc() > this.zzahx.zzfi() || (zzhq2 = this).zzfe() && zzhq2.zzahz.getPlayState() == 2 && zzhq2.zzahz.getPlaybackHeadPosition() == 0);
    }

    public final zzgw zzb(zzgw zzgw2) {
        zzgw zzgw3;
        if (this.zzaid) {
            this.zzade = zzgw.zzafx;
            return this.zzade;
        }
        zzgw2 = new zzgw(this.zzahs.zzb(zzgw2.zzafy), this.zzahs.zzc(zzgw2.zzafz));
        zzgw zzgw4 = this.zzaig != null ? this.zzaig : (zzgw3 = !this.zzahy.isEmpty() ? zzhv.zza(this.zzahy.getLast()) : this.zzade);
        if (!zzgw2.equals(zzgw3)) {
            if (this.isInitialized()) {
                this.zzaig = zzgw2;
            } else {
                this.zzade = zzgw2;
            }
        }
        return this.zzade;
    }

    public final zzgw zzez() {
        return this.zzade;
    }

    public final void setStreamType(int n) {
        if (this.streamType == n) {
            return;
        }
        this.streamType = n;
        if (this.zzajn) {
            return;
        }
        this.reset();
        this.zzajm = 0;
    }

    public final void zzs(int n) {
        zznt.checkState(zzoh.SDK_INT >= 21);
        if (!this.zzajn || this.zzajm != n) {
            this.zzajn = true;
            this.zzajm = n;
            this.reset();
        }
    }

    public final void zzfa() {
        if (this.zzajn) {
            this.zzajn = false;
            this.zzajm = 0;
            this.reset();
        }
    }

    public final void setVolume(float f) {
        if (this.zzcw != f) {
            this.zzcw = f;
            this.zzfb();
        }
    }

    private final void zzfb() {
        if (this.isInitialized()) {
            if (zzoh.SDK_INT >= 21) {
                float f = this.zzcw;
                this.zzahz.setVolume(f);
                return;
            }
            float f = this.zzcw;
            this.zzahz.setStereoVolume(f, f);
        }
    }

    public final void pause() {
        this.zzajl = false;
        if (this.isInitialized()) {
            this.zzfd();
            this.zzahx.pause();
        }
    }

    public final void reset() {
        if (this.isInitialized()) {
            zzhg zzhg2;
            this.zzait = 0L;
            this.zzaiu = 0L;
            this.zzaiw = 0L;
            this.zzaix = 0L;
            this.zzaiy = 0;
            if (this.zzaig != null) {
                this.zzade = this.zzaig;
                this.zzaig = null;
            } else if (!this.zzahy.isEmpty()) {
                this.zzade = zzhv.zza(this.zzahy.getLast());
            }
            this.zzahy.clear();
            this.zzaih = 0L;
            this.zzaii = 0L;
            this.zzajf = null;
            this.zzajg = null;
            for (int i = 0; i < this.zzajd.length; ++i) {
                zzhg2 = this.zzajd[i];
                zzhg2.flush();
                this.zzaje[i] = zzhg2.zzet();
            }
            this.zzajk = false;
            this.zzajj = -1;
            this.zzaij = null;
            this.zzaik = 0;
            this.zzaiz = 0;
            this.zzajc = 0L;
            this.zzfd();
            if (this.zzahz.getPlayState() == 3) {
                this.zzahz.pause();
            }
            zzhg2 = this.zzahz;
            this.zzahz = null;
            this.zzahx.zza(null, false);
            this.zzahv.close();
            new zzhp(this, (AudioTrack)zzhg2).start();
        }
    }

    public final void release() {
        this.reset();
        zzhg[] zzhgArray = this.zzaht;
        int n = this.zzaht.length;
        for (int i = 0; i < n; ++i) {
            zzhgArray[i].reset();
        }
        this.zzajm = 0;
        this.zzajl = false;
    }

    private final boolean isInitialized() {
        return this.zzahz != null;
    }

    private final long zzdq(long l) {
        return l * 1000000L / (long)this.zzafm;
    }

    private final long zzdr(long l) {
        return l * (long)this.zzafm / 1000000L;
    }

    private final long zzfc() {
        if (this.zzaid) {
            return this.zzaix;
        }
        return this.zzaiw / (long)this.zzaiv;
    }

    private final void zzfd() {
        this.zzain = 0L;
        this.zzaim = 0;
        this.zzail = 0;
        this.zzaio = 0L;
        this.zzaip = false;
        this.zzaiq = 0L;
    }

    private final boolean zzfe() {
        return zzoh.SDK_INT < 23 && (this.zzaic == 5 || this.zzaic == 6);
    }

    private static int zzaw(String string2) {
        switch (string2) {
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
        }
        return 0;
    }

    static /* synthetic */ ConditionVariable zza(zzhq zzhq2) {
        return zzhq2.zzahv;
    }
}

