/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.ads.zzgc;
import com.google.android.gms.internal.ads.zzin;
import com.google.android.gms.internal.ads.zzip;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zzoh;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;

public final class zzil
implements Parcelable,
Comparator<zza> {
    private final zza[] zzamf;
    private int zzafu;
    public final int zzamg;
    public static final Parcelable.Creator<zzil> CREATOR = new zzin();

    public zzil(zza ... zzaArray) {
        this(true, zzaArray);
    }

    private zzil(boolean bl, zza ... zzaArray) {
        zzaArray = (zza[])zzaArray.clone();
        Arrays.sort(zzaArray, this);
        for (int i = 1; i < zzaArray.length; ++i) {
            if (!zzaArray[i - 1].uuid.equals(zzaArray[i].uuid)) continue;
            String string2 = String.valueOf(zzaArray[i].uuid);
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string2).length()).append("Duplicate data for uuid: ").append(string2).toString());
        }
        this.zzamf = zzaArray;
        this.zzamg = zzaArray.length;
    }

    zzil(Parcel parcel) {
        this.zzamf = (zza[])parcel.createTypedArray(zza.CREATOR);
        this.zzamg = this.zzamf.length;
    }

    public final zza zzx(int n) {
        return this.zzamf[n];
    }

    public final int hashCode() {
        if (this.zzafu == 0) {
            this.zzafu = Arrays.hashCode(this.zzamf);
        }
        return this.zzafu;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.zzamf, ((zzil)object).zzamf);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedArray((Parcelable[])this.zzamf, 0);
    }

    @Override
    public final /* synthetic */ int compare(Object object, Object object2) {
        zza zza2 = (zza)object2;
        zza zza3 = (zza)object;
        if (zzgc.zzacf.equals(zza3.uuid)) {
            if (zzgc.zzacf.equals(zza2.uuid)) {
                return 0;
            }
            return 1;
        }
        return zza3.uuid.compareTo(zza2.uuid);
    }

    public static final class zza
    implements Parcelable {
        private int zzafu;
        private final UUID uuid;
        private final String mimeType;
        private final byte[] data;
        public final boolean zzamk;
        public static final Parcelable.Creator<zza> CREATOR = new zzip();

        public zza(UUID uUID, String string2, byte[] byArray) {
            this(uUID, string2, byArray, false);
        }

        private zza(UUID uUID, String string2, byte[] byArray, boolean bl) {
            this.uuid = zznt.checkNotNull(uUID);
            this.mimeType = zznt.checkNotNull(string2);
            this.data = zznt.checkNotNull(byArray);
            this.zzamk = false;
        }

        zza(Parcel parcel) {
            this.uuid = new UUID(parcel.readLong(), parcel.readLong());
            this.mimeType = parcel.readString();
            this.data = parcel.createByteArray();
            this.zzamk = parcel.readByte() != 0;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            zza zza2 = (zza)object;
            return this.mimeType.equals(zza2.mimeType) && zzoh.zza(this.uuid, zza2.uuid) && Arrays.equals(this.data, zza2.data);
        }

        public final int hashCode() {
            if (this.zzafu == 0) {
                int n = this.uuid.hashCode();
                n = n * 31 + this.mimeType.hashCode();
                this.zzafu = n = n * 31 + Arrays.hashCode(this.data);
            }
            return this.zzafu;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.uuid.getMostSignificantBits());
            parcel.writeLong(this.uuid.getLeastSignificantBits());
            parcel.writeString(this.mimeType);
            parcel.writeByteArray(this.data);
            parcel.writeByte((byte)(this.zzamk ? 1 : 0));
        }
    }
}

