/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.util.Log;
import com.google.android.gms.internal.ads.zzgq;
import com.google.android.gms.internal.ads.zzgt;
import com.google.android.gms.internal.ads.zzil;
import com.google.android.gms.internal.ads.zziw;
import com.google.android.gms.internal.ads.zzje;
import com.google.android.gms.internal.ads.zzjf;
import com.google.android.gms.internal.ads.zzjk;
import com.google.android.gms.internal.ads.zzjn;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzoa;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzoi;
import com.google.android.gms.internal.ads.zzoj;
import com.google.android.gms.internal.ads.zzop;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class zzjp {
    public String zzapl;
    public int number;
    public int type;
    public int zzapm;
    public boolean zzapn;
    public byte[] zzapo;
    public zzje zzapp;
    public byte[] zzapq;
    public zzil zzafe;
    public int width = -1;
    public int height = -1;
    public int zzapr = -1;
    public int zzaps = -1;
    public int zzapt = 0;
    public byte[] zzafj = null;
    public int zzafi = -1;
    public boolean zzapu = false;
    public int zzapv = -1;
    public int zzapw = -1;
    public int zzapx = -1;
    public int zzapy = 1000;
    public int zzapz = 200;
    public float zzaqa = -1.0f;
    public float zzaqb = -1.0f;
    public float zzaqc = -1.0f;
    public float zzaqd = -1.0f;
    public float zzaqe = -1.0f;
    public float zzaqf = -1.0f;
    public float zzaqg = -1.0f;
    public float zzaqh = -1.0f;
    public float zzaqi = -1.0f;
    public float zzaqj = -1.0f;
    public int zzafl = 1;
    public int zzaqk = -1;
    public int zzafm = 8000;
    public long zzaql = 0L;
    public long zzaqm = 0L;
    public boolean zzaqn;
    public boolean zzaqo = true;
    private String zzafs = "eng";
    public zzjf zzaqp;
    public int zzaqq;

    private zzjp() {
    }

    public final void zza(zziw zziw2, int n) throws zzgt {
        zzgq zzgq2;
        int n2;
        String string2;
        String string3;
        int n3 = -1;
        int n4 = -1;
        List<byte[]> list = null;
        switch (this.zzapl) {
            case "V_VP8": {
                string3 = "video/x-vnd.on2.vp8";
                break;
            }
            case "V_VP9": {
                string3 = "video/x-vnd.on2.vp9";
                break;
            }
            case "V_MPEG2": {
                string3 = "video/mpeg2";
                break;
            }
            case "V_MPEG4/ISO/SP": 
            case "V_MPEG4/ISO/ASP": 
            case "V_MPEG4/ISO/AP": {
                string3 = "video/mp4v-es";
                list = this.zzapq == null ? null : Collections.singletonList(this.zzapq);
                break;
            }
            case "V_MPEG4/ISO/AVC": {
                string3 = "video/avc";
                zzoj zzoj2 = zzoj.zzf(new zzoa(this.zzapq));
                list = zzoj2.zzafd;
                this.zzaqq = zzoj2.zzaqq;
                break;
            }
            case "V_MPEGH/ISO/HEVC": {
                string3 = "video/hevc";
                zzop zzop2 = zzop.zzh(new zzoa(this.zzapq));
                list = zzop2.zzafd;
                this.zzaqq = zzop2.zzaqq;
                break;
            }
            case "V_MS/VFW/FOURCC": {
                list = zzjp.zza(new zzoa(this.zzapq));
                if (list != null) {
                    string3 = "video/wvc1";
                    break;
                }
                Log.w((String)"MatroskaExtractor", (String)"Unsupported FourCC. Setting mimeType to video/x-unknown");
                string3 = "video/x-unknown";
                break;
            }
            case "V_THEORA": {
                string3 = "video/x-unknown";
                break;
            }
            case "A_VORBIS": {
                string3 = "audio/vorbis";
                n3 = 8192;
                list = zzjp.zzd(this.zzapq);
                break;
            }
            case "A_OPUS": {
                string3 = "audio/opus";
                n3 = 5760;
                list = new ArrayList<byte[]>(3);
                list.add(this.zzapq);
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzaql).array());
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzaqm).array());
                break;
            }
            case "A_AAC": {
                string3 = "audio/mp4a-latm";
                list = Collections.singletonList(this.zzapq);
                break;
            }
            case "A_MPEG/L2": {
                string3 = "audio/mpeg-L2";
                n3 = 4096;
                break;
            }
            case "A_MPEG/L3": {
                string3 = "audio/mpeg";
                n3 = 4096;
                break;
            }
            case "A_AC3": {
                string3 = "audio/ac3";
                break;
            }
            case "A_EAC3": {
                string3 = "audio/eac3";
                break;
            }
            case "A_TRUEHD": {
                string3 = "audio/true-hd";
                break;
            }
            case "A_DTS": 
            case "A_DTS/EXPRESS": {
                string3 = "audio/vnd.dts";
                break;
            }
            case "A_DTS/LOSSLESS": {
                string3 = "audio/vnd.dts.hd";
                break;
            }
            case "A_FLAC": {
                string3 = "audio/x-flac";
                list = Collections.singletonList(this.zzapq);
                break;
            }
            case "A_MS/ACM": {
                int n5;
                string3 = "audio/raw";
                if (zzjp.zzb(new zzoa(this.zzapq))) {
                    n4 = zzoh.zzbj(this.zzaqk);
                    if (n4 != 0) break;
                    n4 = -1;
                    string3 = "audio/x-unknown";
                    n5 = this.zzaqk;
                    string2 = string3;
                    Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                    break;
                }
                string3 = "audio/x-unknown";
                String string4 = String.valueOf(string3);
                Log.w((String)"MatroskaExtractor", (String)(string4.length() != 0 ? "Non-PCM MS/ACM is unsupported. Setting mimeType to ".concat(string4) : new String("Non-PCM MS/ACM is unsupported. Setting mimeType to ")));
                break;
            }
            case "A_PCM/INT/LIT": {
                string3 = "audio/raw";
                n4 = zzoh.zzbj(this.zzaqk);
                if (n4 != 0) break;
                n4 = -1;
                string3 = "audio/x-unknown";
                int n5 = this.zzaqk;
                string2 = string3;
                Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                break;
            }
            case "S_TEXT/UTF8": {
                string3 = "application/x-subrip";
                break;
            }
            case "S_VOBSUB": {
                string3 = "application/vobsub";
                list = Collections.singletonList(this.zzapq);
                break;
            }
            case "S_HDMV/PGS": {
                string3 = "application/pgs";
                break;
            }
            case "S_DVBSUB": {
                string3 = "application/dvbsubs";
                list = Collections.singletonList(new byte[]{this.zzapq[0], this.zzapq[1], this.zzapq[2], this.zzapq[3]});
                break;
            }
            default: {
                throw new zzgt("Unrecognized codec identifier.");
            }
        }
        int n6 = 0 | (this.zzaqo ? 1 : 0) | (this.zzaqn ? 2 : 0);
        if (zznw.zzbc(string3)) {
            n2 = 1;
            zzgq2 = zzgq.zza(Integer.toString(n), string3, null, -1, n3, this.zzafl, this.zzafm, n4, list, this.zzafe, n6, this.zzafs);
        } else if (zznw.zzbd(string3)) {
            n2 = 2;
            if (this.zzapt == 0) {
                this.zzapr = this.zzapr == -1 ? this.width : this.zzapr;
                this.zzaps = this.zzaps == -1 ? this.height : this.zzaps;
            }
            float f = -1.0f;
            if (this.zzapr != -1 && this.zzaps != -1) {
                f = (float)(this.height * this.zzapr) / (float)(this.width * this.zzaps);
            }
            zzoi zzoi2 = null;
            if (this.zzapu) {
                byte[] byArray;
                zzjp zzjp2 = this;
                if (zzjp2.zzaqa == -1.0f || zzjp2.zzaqb == -1.0f || zzjp2.zzaqc == -1.0f || zzjp2.zzaqd == -1.0f || zzjp2.zzaqe == -1.0f || zzjp2.zzaqf == -1.0f || zzjp2.zzaqg == -1.0f || zzjp2.zzaqh == -1.0f || zzjp2.zzaqi == -1.0f || zzjp2.zzaqj == -1.0f) {
                    byArray = null;
                } else {
                    byte[] byArray2 = new byte[25];
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                    byteBuffer.put((byte)0);
                    byteBuffer.putShort((short)(zzjp2.zzaqa * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqb * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqc * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqd * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqe * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqf * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqg * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqh * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqi + 0.5f));
                    byteBuffer.putShort((short)(zzjp2.zzaqj + 0.5f));
                    byteBuffer.putShort((short)zzjp2.zzapy);
                    byteBuffer.putShort((short)zzjp2.zzapz);
                    byArray = byArray2;
                }
                string2 = byArray;
                zzoi2 = new zzoi(this.zzapv, this.zzapx, this.zzapw, (byte[])string2);
            }
            zzgq2 = zzgq.zza(Integer.toString(n), string3, null, -1, n3, this.width, this.height, -1.0f, list, -1, f, this.zzafj, this.zzafi, zzoi2, this.zzafe);
        } else if ("application/x-subrip".equals(string3)) {
            n2 = 3;
            zzgq2 = zzgq.zza(Integer.toString(n), string3, null, -1, n6, this.zzafs, this.zzafe);
        } else if ("application/vobsub".equals(string3) || "application/pgs".equals(string3) || "application/dvbsubs".equals(string3)) {
            n2 = 3;
            zzgq2 = zzgq.zza(Integer.toString(n), string3, null, -1, list, this.zzafs, this.zzafe);
        } else {
            throw new zzgt("Unexpected MIME type.");
        }
        this.zzaqp = zziw2.zzb(this.number, n2);
        this.zzaqp.zze(zzgq2);
    }

    private static List<byte[]> zza(zzoa zzoa2) throws zzgt {
        try {
            zzoa2.zzbe(16);
            if (zzoa2.zzih() != 826496599L) {
                return null;
            }
            int n = zzoa2.getPosition() + 20;
            byte[] byArray = zzoa2.data;
            for (int i = n; i < byArray.length - 4; ++i) {
                if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != 15) continue;
                return Collections.singletonList(Arrays.copyOfRange(byArray, i, byArray.length));
            }
            throw new zzgt("Failed to find FourCC VC1 initialization data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzgt("Error parsing FourCC VC1 codec private");
        }
    }

    private static List<byte[]> zzd(byte[] byArray) throws zzgt {
        try {
            if (byArray[0] != 2) {
                throw new zzgt("Error parsing vorbis codec private");
            }
            int n = 1;
            int n2 = 0;
            while (byArray[n] == -1) {
                n2 += 255;
                ++n;
            }
            n2 += byArray[n++];
            int n3 = 0;
            while (byArray[n] == -1) {
                n3 += 255;
                ++n;
            }
            n3 += byArray[n++];
            if (byArray[n] != 1) {
                throw new zzgt("Error parsing vorbis codec private");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (byArray[n += n2] != 3) {
                throw new zzgt("Error parsing vorbis codec private");
            }
            if (byArray[n += n3] != 5) {
                throw new zzgt("Error parsing vorbis codec private");
            }
            byte[] byArray3 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
            arrayList.add(byArray2);
            arrayList.add(byArray3);
            return arrayList;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzgt("Error parsing vorbis codec private");
        }
    }

    private static boolean zzb(zzoa zzoa2) throws zzgt {
        try {
            int n = zzoa2.zzif();
            if (n == 1) {
                return true;
            }
            if (n == 65534) {
                zzoa2.zzbd(24);
                return zzoa2.readLong() == zzjk.zzge().getMostSignificantBits() && zzoa2.readLong() == zzjk.zzge().getLeastSignificantBits();
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzgt("Error parsing MS/ACM codec private");
        }
    }

    /* synthetic */ zzjp(zzjn zzjn2) {
        this();
    }

    static /* synthetic */ String zza(zzjp zzjp2, String string2) {
        zzjp2.zzafs = string2;
        return zzjp2.zzafs;
    }
}

