/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.SparseIntArray;
import com.google.android.gms.internal.ads.zzkk;
import com.google.android.gms.internal.ads.zzks;
import com.google.android.gms.internal.ads.zzkt;
import com.google.android.gms.internal.ads.zzku;
import com.google.android.gms.internal.ads.zzkw;
import com.google.android.gms.internal.ads.zzoh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TargetApi(value=16)
@SuppressLint(value={"InlinedApi"})
public final class zzkr {
    private static final zzkk zzazc = zzkk.zzay("OMX.google.raw.decoder");
    private static final Pattern zzazd = Pattern.compile("^\\D?(\\d+)$");
    private static final HashMap<zza, List<zzkk>> zzaze = new HashMap();
    private static final SparseIntArray zzazf;
    private static final SparseIntArray zzazg;
    private static final Map<String, Integer> zzazh;
    private static int zzazi;

    public static zzkk zzgs() {
        return zzazc;
    }

    public static zzkk zzc(String string2, boolean bl) throws zzks {
        List<zzkk> list = zzkr.zzd(string2, bl);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static synchronized List<zzkk> zzd(String string2, boolean bl) throws zzks {
        zza zza2 = new zza(string2, bl);
        List<zzkk> list = zzaze.get(zza2);
        if (list != null) {
            return list;
        }
        zzku zzku2 = zzoh.SDK_INT >= 21 ? new zzkw(bl) : new zzkt(null);
        list = zzkr.zza(zza2, zzku2);
        if (bl && list.isEmpty() && 21 <= zzoh.SDK_INT && zzoh.SDK_INT <= 23 && !(list = zzkr.zza(zza2, zzku2 = new zzkt(null))).isEmpty()) {
            String string3 = list.get((int)0).name;
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("MediaCodecList API didn't list secure decoder for: ").append(string2).append(". Assuming: ").append(string3).toString());
        }
        list = Collections.unmodifiableList(list);
        zzaze.put(zza2, list);
        return list;
    }

    public static int zzgt() throws zzks {
        if (zzazi == -1) {
            int n = 0;
            zzkk zzkk2 = zzkr.zzc("video/avc", false);
            if (zzkk2 != null) {
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = zzkk2.zzgl();
                int n2 = codecProfileLevelArray.length;
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    switch (codecProfileLevelArray[i].level) {
                        case 1: {
                            n3 = 25344;
                            break;
                        }
                        case 2: {
                            n3 = 25344;
                            break;
                        }
                        case 8: {
                            n3 = 101376;
                            break;
                        }
                        case 16: {
                            n3 = 101376;
                            break;
                        }
                        case 32: {
                            n3 = 101376;
                            break;
                        }
                        case 64: {
                            n3 = 202752;
                            break;
                        }
                        case 128: {
                            n3 = 414720;
                            break;
                        }
                        case 256: {
                            n3 = 414720;
                            break;
                        }
                        case 512: {
                            n3 = 921600;
                            break;
                        }
                        case 1024: {
                            n3 = 0x140000;
                            break;
                        }
                        case 2048: {
                            n3 = 0x200000;
                            break;
                        }
                        case 4096: {
                            n3 = 0x200000;
                            break;
                        }
                        case 8192: {
                            n3 = 0x220000;
                            break;
                        }
                        case 16384: {
                            n3 = 5652480;
                            break;
                        }
                        case 32768: {
                            n3 = 0x900000;
                            break;
                        }
                        case 65536: {
                            n3 = 0x900000;
                            break;
                        }
                        default: {
                            n3 = -1;
                        }
                    }
                    n = Math.max(n3, n);
                }
                n = Math.max(n, zzoh.SDK_INT >= 21 ? 345600 : 172800);
            }
            zzazi = n;
        }
        return zzazi;
    }

    public static Pair<Integer, Integer> zzbb(String string2) {
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split("\\.");
        switch (stringArray[0]) {
            case "hev1": 
            case "hvc1": {
                int n;
                String[] stringArray2 = stringArray;
                String string3 = string2;
                if (stringArray2.length < 4) {
                    String string4 = String.valueOf(string3);
                    Log.w((String)"MediaCodecUtil", (String)(string4.length() != 0 ? "Ignoring malformed HEVC codec string: ".concat(string4) : new String("Ignoring malformed HEVC codec string: ")));
                    return null;
                }
                Matcher matcher = zzazd.matcher(stringArray2[1]);
                if (!matcher.matches()) {
                    String string5 = String.valueOf(string3);
                    Log.w((String)"MediaCodecUtil", (String)(string5.length() != 0 ? "Ignoring malformed HEVC codec string: ".concat(string5) : new String("Ignoring malformed HEVC codec string: ")));
                    return null;
                }
                String string6 = matcher.group(1);
                if ("1".equals(string6)) {
                    n = 1;
                } else if ("2".equals(string6)) {
                    n = 2;
                } else {
                    String string7 = String.valueOf(string6);
                    Log.w((String)"MediaCodecUtil", (String)(string7.length() != 0 ? "Unknown HEVC profile string: ".concat(string7) : new String("Unknown HEVC profile string: ")));
                    return null;
                }
                Integer n2 = zzazh.get(stringArray2[3]);
                if (n2 == null) {
                    String string8 = String.valueOf(matcher.group(1));
                    Log.w((String)"MediaCodecUtil", (String)(string8.length() != 0 ? "Unknown HEVC level string: ".concat(string8) : new String("Unknown HEVC level string: ")));
                    return null;
                }
                return new Pair((Object)n, (Object)n2);
            }
            case "avc1": 
            case "avc2": {
                return zzkr.zza(string2, stringArray);
            }
        }
        return null;
    }

    private static List<zzkk> zza(zza zza2, zzku zzku2) throws zzks {
        try {
            ArrayList<zzkk> arrayList = new ArrayList<zzkk>();
            String string2 = zza2.mimeType;
            int n = zzku2.getCodecCount();
            boolean bl = zzku2.zzgu();
            for (int i = 0; i < n; ++i) {
                MediaCodecInfo mediaCodecInfo = zzku2.getCodecInfoAt(i);
                String string3 = mediaCodecInfo.getName();
                boolean bl2 = bl;
                String string4 = string3;
                if (!(mediaCodecInfo.isEncoder() || !bl2 && string4.endsWith(".secure") ? false : (zzoh.SDK_INT < 21 && ("CIPAACDecoder".equals(string4) || "CIPMP3Decoder".equals(string4) || "CIPVorbisDecoder".equals(string4) || "CIPAMRNBDecoder".equals(string4) || "AACDecoder".equals(string4) || "MP3Decoder".equals(string4)) ? false : (zzoh.SDK_INT < 18 && "OMX.SEC.MP3.Decoder".equals(string4) ? false : (zzoh.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(string4) && "a70".equals(zzoh.DEVICE) ? false : (zzoh.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(string4) && ("dlxu".equals(zzoh.DEVICE) || "protou".equals(zzoh.DEVICE) || "ville".equals(zzoh.DEVICE) || "villeplus".equals(zzoh.DEVICE) || "villec2".equals(zzoh.DEVICE) || zzoh.DEVICE.startsWith("gee") || "C6602".equals(zzoh.DEVICE) || "C6603".equals(zzoh.DEVICE) || "C6606".equals(zzoh.DEVICE) || "C6616".equals(zzoh.DEVICE) || "L36h".equals(zzoh.DEVICE) || "SO-02E".equals(zzoh.DEVICE)) ? false : (zzoh.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(string4) && ("C1504".equals(zzoh.DEVICE) || "C1505".equals(zzoh.DEVICE) || "C1604".equals(zzoh.DEVICE) || "C1605".equals(zzoh.DEVICE)) ? false : (zzoh.SDK_INT <= 19 && "OMX.SEC.vp8.dec".equals(string4) && "samsung".equals(zzoh.MANUFACTURER) && (zzoh.DEVICE.startsWith("d2") || zzoh.DEVICE.startsWith("serrano") || zzoh.DEVICE.startsWith("jflte") || zzoh.DEVICE.startsWith("santos") || zzoh.DEVICE.startsWith("t0")) ? false : zzoh.SDK_INT > 19 || !zzoh.DEVICE.startsWith("jflte") || !"OMX.qcom.video.decoder.vp8".equals(string4))))))))) continue;
                for (String string5 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string5.equalsIgnoreCase(string2)) continue;
                    try {
                        boolean bl3;
                        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string5);
                        boolean bl4 = zzku2.zza(string2, codecCapabilities);
                        String string6 = string3;
                        boolean bl5 = bl3 = !(zzoh.SDK_INT > 22 || !zzoh.MODEL.equals("ODROID-XU3") && !zzoh.MODEL.equals("Nexus 10") || !"OMX.Exynos.AVC.Decoder".equals(string6) && !"OMX.Exynos.AVC.Decoder.secure".equals(string6));
                        if (bl && zza2.zzaxk == bl4 || !bl && !zza2.zzaxk) {
                            arrayList.add(zzkk.zza(string3, string2, codecCapabilities, bl3, false));
                            continue;
                        }
                        if (bl || !bl4) continue;
                        arrayList.add(zzkk.zza(String.valueOf(string3).concat(".secure"), string2, codecCapabilities, bl3, true));
                        return arrayList;
                    }
                    catch (Exception exception) {
                        if (zzoh.SDK_INT <= 23 && !arrayList.isEmpty()) {
                            Log.e((String)"MediaCodecUtil", (String)new StringBuilder(46 + String.valueOf(string3).length()).append("Skipping codec ").append(string3).append(" (failed to query capabilities)").toString());
                            continue;
                        }
                        Log.e((String)"MediaCodecUtil", (String)new StringBuilder(25 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("Failed to query codec ").append(string3).append(" (").append(string5).append(")").toString());
                        throw exception;
                    }
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new zzks(exception, null);
        }
    }

    private static Pair<Integer, Integer> zza(String string2, String[] stringArray) {
        Integer n;
        Integer n2;
        block7: {
            if (stringArray.length < 2) {
                String string3 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string3.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string3) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
            try {
                if (stringArray[1].length() == 6) {
                    n2 = Integer.parseInt(stringArray[1].substring(0, 2), 16);
                    n = Integer.parseInt(stringArray[1].substring(4), 16);
                    break block7;
                }
                if (stringArray.length >= 3) {
                    n2 = Integer.parseInt(stringArray[1]);
                    n = Integer.parseInt(stringArray[2]);
                    break block7;
                }
                String string4 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string4.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string4) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string5.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string5) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
        }
        Integer n3 = zzazf.get(n2.intValue());
        if (n3 == null) {
            String string6 = String.valueOf(n2);
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(21 + String.valueOf(string6).length()).append("Unknown AVC profile: ").append(string6).toString());
            return null;
        }
        Integer n4 = zzazg.get(n.intValue());
        if (n4 == null) {
            String string7 = String.valueOf(n);
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(19 + String.valueOf(string7).length()).append("Unknown AVC level: ").append(string7).toString());
            return null;
        }
        return new Pair((Object)n3, (Object)n4);
    }

    static {
        zzazi = -1;
        zzazf = new SparseIntArray();
        zzazf.put(66, 1);
        zzazf.put(77, 2);
        zzazf.put(88, 4);
        zzazf.put(100, 8);
        zzazg = new SparseIntArray();
        zzazg.put(10, 1);
        zzazg.put(11, 4);
        zzazg.put(12, 8);
        zzazg.put(13, 16);
        zzazg.put(20, 32);
        zzazg.put(21, 64);
        zzazg.put(22, 128);
        zzazg.put(30, 256);
        zzazg.put(31, 512);
        zzazg.put(32, 1024);
        zzazg.put(40, 2048);
        zzazg.put(41, 4096);
        zzazg.put(42, 8192);
        zzazg.put(50, 16384);
        zzazg.put(51, 32768);
        zzazg.put(52, 65536);
        zzazh = new HashMap<String, Integer>();
        zzazh.put("L30", 1);
        zzazh.put("L60", 4);
        zzazh.put("L63", 16);
        zzazh.put("L90", 64);
        zzazh.put("L93", 256);
        zzazh.put("L120", 1024);
        zzazh.put("L123", 4096);
        zzazh.put("L150", 16384);
        zzazh.put("L153", 65536);
        zzazh.put("L156", 262144);
        zzazh.put("L180", 0x100000);
        zzazh.put("L183", 0x400000);
        zzazh.put("L186", 0x1000000);
        zzazh.put("H30", 2);
        zzazh.put("H60", 8);
        zzazh.put("H63", 32);
        zzazh.put("H90", 128);
        zzazh.put("H93", 512);
        zzazh.put("H120", 2048);
        zzazh.put("H123", 8192);
        zzazh.put("H150", 32768);
        zzazh.put("H153", 131072);
        zzazh.put("H156", 524288);
        zzazh.put("H180", 0x200000);
        zzazh.put("H183", 0x800000);
        zzazh.put("H186", 0x2000000);
    }

    static final class zza {
        public final String mimeType;
        public final boolean zzaxk;

        public zza(String string2, boolean bl) {
            this.mimeType = string2;
            this.zzaxk = bl;
        }

        public final int hashCode() {
            int n = 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            return n * 31 + (this.zzaxk ? 1231 : 1237);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != zza.class) {
                return false;
            }
            zza zza2 = (zza)object;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)zza2.mimeType) && this.zzaxk == zza2.zzaxk;
        }
    }
}

