/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.ads.zznc;
import com.google.android.gms.internal.ads.zzne;
import com.google.android.gms.internal.ads.zznh;
import com.google.android.gms.internal.ads.zzni;
import com.google.android.gms.internal.ads.zznk;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznq;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zzoc;
import com.google.android.gms.internal.ads.zzoh;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zznj
implements zznc {
    private static final Pattern zzbet = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzbeu = new AtomicReference();
    private final boolean zzbev;
    private final int zzbew;
    private final int zzbex;
    private final String zzbey;
    private final zzoc<String> zzbez;
    private final zznk zzbfa;
    private final zznk zzbfb;
    private final zznq<? super zznj> zzbfc;
    private zznh zzbes;
    private HttpURLConnection zzbfd;
    private InputStream zzbfe;
    private boolean zzbff;
    private long zzbfg;
    private long zzbfh;
    private long zzbfi;
    private long zzcc;

    public zznj(String string2, zzoc<String> zzoc2, zznq<? super zznj> zznq2, int n, int n2, boolean bl, zznk zznk2) {
        this.zzbey = zznt.checkNotEmpty(string2);
        this.zzbez = null;
        this.zzbfc = zznq2;
        this.zzbfb = new zznk();
        this.zzbew = n;
        this.zzbex = n2;
        this.zzbev = true;
        this.zzbfa = null;
    }

    @Override
    public final Uri getUri() {
        if (this.zzbfd == null) {
            return null;
        }
        return Uri.parse((String)this.zzbfd.getURL().toString());
    }

    public final Map<String, List<String>> getResponseHeaders() {
        if (this.zzbfd == null) {
            return null;
        }
        return this.zzbfd.getHeaderFields();
    }

    @Override
    public final long zza(zznh zznh2) throws zzni {
        long l;
        int n;
        this.zzbes = zznh2;
        this.zzcc = 0L;
        this.zzbfi = 0L;
        try {
            HttpURLConnection httpURLConnection;
            block15: {
                zznh zznh3 = zznh2;
                zznj zznj2 = this;
                URL uRL = new URL(zznh3.uri.toString());
                byte[] byArray = zznh3.zzbeq;
                long l2 = zznh3.zzams;
                long l3 = zznh3.zzcb;
                boolean bl = zznh3.zzba(1);
                if (!zznj2.zzbev) {
                    httpURLConnection = zznj2.zza(uRL, byArray, l2, l3, bl, true);
                } else {
                    int n2 = 0;
                    while (n2++ <= 20) {
                        HttpURLConnection httpURLConnection2 = zznj2.zza(uRL, byArray, l2, l3, bl, false);
                        int n3 = httpURLConnection2.getResponseCode();
                        if (n3 == 300 || n3 == 301 || n3 == 302 || n3 == 303 || byArray == null && (n3 == 307 || n3 == 308)) {
                            byArray = null;
                            String string2 = httpURLConnection2.getHeaderField("Location");
                            httpURLConnection2.disconnect();
                            String string3 = string2;
                            URL uRL2 = uRL;
                            if (string3 == null) {
                                throw new ProtocolException("Null location redirect");
                            }
                            URL uRL3 = new URL(uRL2, string3);
                            String string4 = uRL3.getProtocol();
                            if (!"https".equals(string4) && !"http".equals(string4)) {
                                String string5 = String.valueOf(string4);
                                throw new ProtocolException(string5.length() != 0 ? "Unsupported protocol redirect: ".concat(string5) : new String("Unsupported protocol redirect: "));
                            }
                            uRL = uRL3;
                            continue;
                        }
                        httpURLConnection = httpURLConnection2;
                        break block15;
                    }
                    int n4 = n2;
                    throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(n4).toString());
                }
            }
            this.zzbfd = httpURLConnection;
        }
        catch (IOException iOException) {
            String string6 = String.valueOf(zznh2.uri.toString());
            throw new zzni(string6.length() != 0 ? "Unable to connect to ".concat(string6) : new String("Unable to connect to "), iOException, zznh2, 1);
        }
        try {
            n = this.zzbfd.getResponseCode();
        }
        catch (IOException iOException) {
            this.zzia();
            String string7 = String.valueOf(zznh2.uri.toString());
            throw new zzni(string7.length() != 0 ? "Unable to connect to ".concat(string7) : new String("Unable to connect to "), iOException, zznh2, 1);
        }
        if (n < 200 || n > 299) {
            Map<String, List<String>> map = this.zzbfd.getHeaderFields();
            this.zzia();
            zznl zznl2 = new zznl(n, map, zznh2);
            if (n == 416) {
                zznl2.initCause(new zzne(0));
            }
            throw zznl2;
        }
        this.zzbfd.getContentType();
        long l4 = this.zzbfg = n == 200 && zznh2.zzams != 0L ? zznh2.zzams : 0L;
        this.zzbfh = !zznh2.zzba(1) ? (zznh2.zzcb != -1L ? zznh2.zzcb : ((l = zznj.zzc(this.zzbfd)) != -1L ? l - this.zzbfg : -1L)) : zznh2.zzcb;
        try {
            this.zzbfe = this.zzbfd.getInputStream();
        }
        catch (IOException iOException) {
            this.zzia();
            throw new zzni(iOException, zznh2, 1);
        }
        this.zzbff = true;
        if (this.zzbfc != null) {
            this.zzbfc.zza(this, zznh2);
        }
        return this.zzbfh;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzni {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zznj zznj2 = this;
            if (zznj2.zzbfi != zznj2.zzbfg) {
                byArray2 = zzbeu.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zznj2.zzbfi != zznj2.zzbfg) {
                    n5 = (int)Math.min(zznj2.zzbfg - zznj2.zzbfi, (long)byArray2.length);
                    n4 = zznj2.zzbfe.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zznj2.zzbfi += (long)n4;
                    if (zznj2.zzbfc == null) continue;
                    zznj2.zzbfc.zzc(zznj2, n4);
                }
                zzbeu.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zznj2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zznj2.zzbfh != -1L) {
                long l = zznj2.zzbfh - zznj2.zzcc;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zznj2.zzbfe.read(byArray2, n5, n4)) == -1) {
                if (zznj2.zzbfh != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zznj2.zzcc += (long)n3;
            if (zznj2.zzbfc != null) {
                zznj2.zzbfc.zzc(zznj2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzni(iOException, this.zzbes, 2);
        }
    }

    @Override
    public final void close() throws zzni {
        try {
            if (this.zzbfe != null) {
                block14: {
                    Object object = this;
                    long l = ((zznj)object).zzbfh == -1L ? ((zznj)object).zzbfh : ((zznj)object).zzbfh - ((zznj)object).zzcc;
                    object = this.zzbfd;
                    if (zzoh.SDK_INT == 19 || zzoh.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block14;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzbfe.close();
                }
                catch (IOException iOException) {
                    throw new zzni(iOException, this.zzbes, 3);
                }
            }
            this.zzbfe = null;
            this.zzia();
            if (this.zzbff) {
                this.zzbff = false;
                if (this.zzbfc != null) {
                    this.zzbfc.zze(this);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.zzbfe = null;
            this.zzia();
            if (this.zzbff) {
                this.zzbff = false;
                if (this.zzbfc != null) {
                    this.zzbfc.zze(this);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final HttpURLConnection zza(URL uRL, byte[] byArray, long l, long l2, boolean bl, boolean bl2) throws IOException {
        Object object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.zzbew);
        httpURLConnection.setReadTimeout(this.zzbex);
        for (Map.Entry<String, String> entry : this.zzbfb.zzib().entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (l != 0L || l2 != -1L) {
            object = new StringBuilder(27).append("bytes=").append(l).append("-").toString();
            if (l2 != -1L) {
                String string2 = String.valueOf(object);
                long l3 = l + l2 - 1L;
                object = new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l3).toString();
            }
            httpURLConnection.setRequestProperty("Range", (String)object);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.zzbey);
        if (!bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        }
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setDoOutput(byArray != null);
        if (byArray != null) {
            httpURLConnection.setRequestMethod("POST");
            if (byArray.length != 0) {
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                httpURLConnection.connect();
                object = httpURLConnection.getOutputStream();
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).close();
                return httpURLConnection;
            }
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzbet.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    Log.w((String)"DefaultHttpDataSource", (String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzia() {
        if (this.zzbfd != null) {
            try {
                this.zzbfd.disconnect();
            }
            catch (Exception exception) {
                Log.e((String)"DefaultHttpDataSource", (String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzbfd = null;
        }
    }
}

