/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zznm;
import com.google.android.gms.internal.ads.zznn;
import com.google.android.gms.internal.ads.zzno;
import com.google.android.gms.internal.ads.zznr;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zzoe;
import java.io.IOException;

@SuppressLint(value={"HandlerLeak"})
final class zznp<T extends zzno>
extends Handler
implements Runnable {
    private final T zzbfp;
    private final zznm<T> zzbfq;
    public final int zzbfr;
    private final long zzbfs;
    private IOException zzbft;
    private int zzbfu;
    private volatile Thread zzbfv;
    private volatile boolean zzads;
    private final /* synthetic */ zznn zzbfw;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public zznp(zznn zznn2, Looper looper, zzno zzno2, zznm zznm2, int n, long l) {
        this.zzbfw = zznn2;
        super(looper);
        this.zzbfp = zzno2;
        this.zzbfq = zznm2;
        this.zzbfr = n;
        this.zzbfs = l;
    }

    public final void zzbb(int n) throws IOException {
        if (this.zzbft != null && this.zzbfu > n) {
            throw this.zzbft;
        }
    }

    public final void zzee(long l) {
        zznt.checkState(zznn.zza(this.zzbfw) == null);
        zznn.zza(this.zzbfw, this);
        if (l > 0L) {
            this.sendEmptyMessageDelayed(0, l);
            return;
        }
        this.execute();
    }

    public final void zzk(boolean bl) {
        this.zzads = bl;
        this.zzbft = null;
        if (this.hasMessages(0)) {
            this.removeMessages(0);
            if (!bl) {
                this.sendEmptyMessage(1);
            }
        } else {
            this.zzbfp.cancelLoad();
            if (this.zzbfv != null) {
                this.zzbfv.interrupt();
            }
        }
        if (bl) {
            this.finish();
            long l = SystemClock.elapsedRealtime();
            this.zzbfq.zza(this.zzbfp, l, l - this.zzbfs, true);
        }
    }

    @Override
    public final void run() {
        try {
            this.zzbfv = Thread.currentThread();
            if (!this.zzbfp.zzhg()) {
                String string2 = String.valueOf(this.zzbfp.getClass().getSimpleName());
                zzoe.beginSection(string2.length() != 0 ? "load:".concat(string2) : new String("load:"));
                try {
                    this.zzbfp.zzhh();
                }
                finally {
                    zzoe.endSection();
                }
            }
            if (!this.zzads) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (IOException iOException) {
            if (!this.zzads) {
                this.obtainMessage(3, iOException).sendToTarget();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            zznt.checkState(this.zzbfp.zzhg());
            if (!this.zzads) {
                this.sendEmptyMessage(2);
            }
            return;
        }
        catch (Exception exception) {
            Log.e((String)"LoadTask", (String)"Unexpected exception loading stream", (Throwable)exception);
            if (!this.zzads) {
                this.obtainMessage(3, new zznr(exception)).sendToTarget();
            }
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)"LoadTask", (String)"OutOfMemory error loading stream", (Throwable)outOfMemoryError);
            if (!this.zzads) {
                this.obtainMessage(3, new zznr(outOfMemoryError)).sendToTarget();
            }
            return;
        }
        catch (Error error) {
            Log.e((String)"LoadTask", (String)"Unexpected error loading stream", (Throwable)error);
            if (!this.zzads) {
                this.obtainMessage(4, error).sendToTarget();
            }
            throw error;
        }
    }

    public final void handleMessage(Message message) {
        if (this.zzads) {
            return;
        }
        if (message.what == 0) {
            this.execute();
            return;
        }
        if (message.what == 4) {
            throw (Error)message.obj;
        }
        this.finish();
        long l = SystemClock.elapsedRealtime();
        long l2 = l - this.zzbfs;
        if (this.zzbfp.zzhg()) {
            this.zzbfq.zza(this.zzbfp, l, l2, false);
            return;
        }
        switch (message.what) {
            case 1: {
                this.zzbfq.zza(this.zzbfp, l, l2, false);
                return;
            }
            case 2: {
                this.zzbfq.zza(this.zzbfp, l, l2);
                return;
            }
            case 3: {
                this.zzbft = (IOException)message.obj;
                int n = this.zzbfq.zza(this.zzbfp, l, l2, this.zzbft);
                if (n == 3) {
                    zznn.zza(this.zzbfw, this.zzbft);
                    return;
                }
                if (n == 2) break;
                this.zzbfu = n == 1 ? 1 : this.zzbfu + 1;
                this.zzee(Math.min((this.zzbfu - 1) * 1000, 5000));
            }
        }
    }

    private final void execute() {
        this.zzbft = null;
        zznn.zzb(this.zzbfw).execute(zznn.zza(this.zzbfw));
    }

    private final void finish() {
        zznn.zza(this.zzbfw, null);
    }
}

