/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zznt;

public final class zzoa {
    public byte[] data;
    private int position;
    private int limit;

    public zzoa() {
    }

    public zzoa(int n) {
        this.data = new byte[n];
        this.limit = n;
    }

    public zzoa(byte[] byArray) {
        this.data = byArray;
        this.limit = byArray.length;
    }

    public final void reset(int n) {
        this.zzb(this.capacity() < n ? new byte[n] : this.data, n);
    }

    public final void zzb(byte[] byArray, int n) {
        this.data = byArray;
        this.limit = n;
        this.position = 0;
    }

    public final void reset() {
        this.position = 0;
        this.limit = 0;
    }

    public final int zzie() {
        return this.limit - this.position;
    }

    public final int limit() {
        return this.limit;
    }

    public final void zzbc(int n) {
        zznt.checkArgument(n >= 0 && n <= this.data.length);
        this.limit = n;
    }

    public final int getPosition() {
        return this.position;
    }

    public final int capacity() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    public final void zzbd(int n) {
        zznt.checkArgument(n >= 0 && n <= this.limit);
        this.position = n;
    }

    public final void zzbe(int n) {
        this.zzbd(this.position + n);
    }

    public final void zze(byte[] byArray, int n, int n2) {
        System.arraycopy(this.data, this.position, byArray, n, n2);
        this.position += n2;
    }

    public final int readUnsignedByte() {
        return this.data[this.position++] & 0xFF;
    }

    public final int readUnsignedShort() {
        return (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public final int zzif() {
        return this.data[this.position++] & 0xFF | (this.data[this.position++] & 0xFF) << 8;
    }

    public final short readShort() {
        return (short)((this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF);
    }

    public final long zzig() {
        return ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public final long zzih() {
        return (long)this.data[this.position++] & 0xFFL | ((long)this.data[this.position++] & 0xFFL) << 8 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 24;
    }

    public final int readInt() {
        return (this.data[this.position++] & 0xFF) << 24 | (this.data[this.position++] & 0xFF) << 16 | (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
    }

    public final long readLong() {
        return ((long)this.data[this.position++] & 0xFFL) << 56 | ((long)this.data[this.position++] & 0xFFL) << 48 | ((long)this.data[this.position++] & 0xFFL) << 40 | ((long)this.data[this.position++] & 0xFFL) << 32 | ((long)this.data[this.position++] & 0xFFL) << 24 | ((long)this.data[this.position++] & 0xFFL) << 16 | ((long)this.data[this.position++] & 0xFFL) << 8 | (long)this.data[this.position++] & 0xFFL;
    }

    public final int zzii() {
        int n = (this.data[this.position++] & 0xFF) << 8 | this.data[this.position++] & 0xFF;
        this.position += 2;
        return n;
    }

    public final int zzij() {
        int n = this.readInt();
        if (n < 0) {
            throw new IllegalStateException(new StringBuilder(29).append("Top bit not zero: ").append(n).toString());
        }
        return n;
    }

    public final long zzik() {
        long l = this.readLong();
        if (l < 0L) {
            throw new IllegalStateException(new StringBuilder(38).append("Top bit not zero: ").append(l).toString());
        }
        return l;
    }

    public final String zzbf(int n) {
        if (n == 0) {
            return "";
        }
        int n2 = n;
        int n3 = this.position + n - 1;
        if (n3 < this.limit && this.data[n3] == 0) {
            --n2;
        }
        String string2 = new String(this.data, this.position, n2);
        this.position += n;
        return string2;
    }
}

