/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.android.gms.internal.ads.zzgb;
import com.google.android.gms.internal.ads.zzgq;
import com.google.android.gms.internal.ads.zzil;
import com.google.android.gms.internal.ads.zzim;
import com.google.android.gms.internal.ads.zziq;
import com.google.android.gms.internal.ads.zzkk;
import com.google.android.gms.internal.ads.zzkn;
import com.google.android.gms.internal.ads.zzkp;
import com.google.android.gms.internal.ads.zzkr;
import com.google.android.gms.internal.ads.zzks;
import com.google.android.gms.internal.ads.zznt;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zzoe;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzok;
import com.google.android.gms.internal.ads.zzoq;
import com.google.android.gms.internal.ads.zzos;
import com.google.android.gms.internal.ads.zzot;
import com.google.android.gms.internal.ads.zzou;
import com.google.android.gms.internal.ads.zzox;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class zzoo
extends zzkn {
    private static final int[] zzbhh = new int[]{1920, 1600, 1440, 1280, 960, 854, 640, 540, 480};
    private final Context zzlk;
    private final zzos zzbhi;
    private final zzox zzbhj;
    private final long zzbhk;
    private final int zzbhl;
    private final boolean zzbhm;
    private final long[] zzbhn;
    private zzgq[] zzbho;
    private zzoq zzbhp;
    private Surface zzbhq;
    private Surface zzbhr;
    private int zzbhs;
    private boolean zzbht;
    private long zzbhu;
    private long zzbhv;
    private int zzbhw;
    private int zzbhx;
    private int zzbhy;
    private float zzbhz;
    private int zzbia;
    private int zzbib;
    private int zzbic;
    private float zzbid;
    private int zzbie;
    private int zzbif;
    private int zzbig;
    private float zzbih;
    private boolean zzajn;
    private int zzagc;
    zzot zzbii;
    private long zzbij;
    private int zzbik;

    public zzoo(Context context, zzkp zzkp2, long l, Handler handler, zzou zzou2, int n) {
        this(context, zzkp2, 0L, null, false, handler, zzou2, -1);
    }

    private zzoo(Context context, zzkp zzkp2, long l, zziq<Object> zziq2, boolean bl, Handler handler, zzou zzou2, int n) {
        super(2, zzkp2, null, false);
        this.zzbhk = 0L;
        this.zzbhl = -1;
        this.zzlk = context.getApplicationContext();
        this.zzbhi = new zzos(context);
        this.zzbhj = new zzox(handler, zzou2);
        this.zzbhm = zzoh.SDK_INT <= 22 && "foster".equals(zzoh.DEVICE) && "NVIDIA".equals(zzoh.MANUFACTURER);
        this.zzbhn = new long[10];
        this.zzbij = -9223372036854775807L;
        this.zzbhu = -9223372036854775807L;
        this.zzbia = -1;
        this.zzbib = -1;
        this.zzbid = -1.0f;
        this.zzbhz = -1.0f;
        this.zzbhs = 1;
        this.zzit();
    }

    @Override
    protected final int zza(zzkp zzkp2, zzgq zzgq2) throws zzks {
        int n;
        int n2;
        zzkk zzkk2;
        String string2 = zzgq2.zzafb;
        if (!zznw.zzbd(string2)) {
            return 0;
        }
        boolean bl = false;
        zzil zzil2 = zzgq2.zzafe;
        if (zzil2 != null) {
            for (int i = 0; i < zzil2.zzamg; ++i) {
                bl |= zzil2.zzx((int)i).zzamk;
            }
        }
        if ((zzkk2 = zzkp2.zzc(string2, bl)) == null) {
            return 1;
        }
        boolean bl2 = zzkk2.zzaz(zzgq2.zzaey);
        if (bl2 && zzgq2.width > 0 && zzgq2.height > 0) {
            if (zzoh.SDK_INT >= 21) {
                bl2 = zzkk2.zza(zzgq2.width, zzgq2.height, zzgq2.zzaff);
            } else {
                bl2 = zzgq2.width * zzgq2.height <= zzkr.zzgt();
                if (!bl2) {
                    n2 = zzgq2.width;
                    n = zzgq2.height;
                    String string3 = zzoh.zzbgs;
                    Log.d((String)"MediaCodecVideoRenderer", (String)new StringBuilder(56 + String.valueOf(string3).length()).append("FalseCheck [legacyFrameSize, ").append(n2).append("x").append(n).append("] [").append(string3).append("]").toString());
                }
            }
        }
        n2 = zzkk2.zzaxj ? 8 : 4;
        n = zzkk2.zzajn ? 16 : 0;
        int n3 = bl2 ? 3 : 2;
        return n2 | n | n3;
    }

    @Override
    protected final void zzd(boolean bl) throws zzgb {
        super.zzd(bl);
        this.zzagc = this.zzdp().zzagc;
        this.zzajn = this.zzagc != 0;
        this.zzbhj.zza(this.zzaza);
        this.zzbhi.enable();
    }

    @Override
    protected final void zza(zzgq[] zzgqArray, long l) throws zzgb {
        this.zzbho = zzgqArray;
        if (this.zzbij == -9223372036854775807L) {
            this.zzbij = l;
        } else {
            if (this.zzbik == this.zzbhn.length) {
                long l2 = this.zzbhn[this.zzbik - 1];
                Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(65).append("Too many stream changes, so dropping offset: ").append(l2).toString());
            } else {
                ++this.zzbik;
            }
            this.zzbhn[this.zzbik - 1] = l;
        }
        super.zza(zzgqArray, l);
    }

    @Override
    protected final void zza(long l, boolean bl) throws zzgb {
        super.zza(l, bl);
        this.zzir();
        this.zzbhx = 0;
        if (this.zzbik != 0) {
            this.zzbij = this.zzbhn[this.zzbik - 1];
            this.zzbik = 0;
        }
        if (bl) {
            this.zziq();
            return;
        }
        this.zzbhu = -9223372036854775807L;
    }

    @Override
    public final boolean isReady() {
        if (super.isReady() && (this.zzbht || this.zzbhr != null && this.zzbhq == this.zzbhr || this.zzgn() == null)) {
            this.zzbhu = -9223372036854775807L;
            return true;
        }
        if (this.zzbhu == -9223372036854775807L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() < this.zzbhu) {
            return true;
        }
        this.zzbhu = -9223372036854775807L;
        return false;
    }

    @Override
    protected final void onStarted() {
        super.onStarted();
        this.zzbhw = 0;
        this.zzbhv = SystemClock.elapsedRealtime();
        this.zzbhu = -9223372036854775807L;
    }

    @Override
    protected final void onStopped() {
        this.zziw();
        super.onStopped();
    }

    @Override
    protected final void zzdo() {
        this.zzbia = -1;
        this.zzbib = -1;
        this.zzbid = -1.0f;
        this.zzbhz = -1.0f;
        this.zzbij = -9223372036854775807L;
        this.zzbik = 0;
        this.zzit();
        this.zzir();
        this.zzbhi.disable();
        this.zzbii = null;
        this.zzajn = false;
        try {
            super.zzdo();
            return;
        }
        finally {
            this.zzaza.zzfu();
            this.zzbhj.zzb(this.zzaza);
        }
    }

    @Override
    public final void zza(int n, Object object) throws zzgb {
        if (n == 1) {
            Surface surface = (Surface)object;
            zzoo zzoo2 = this;
            if (surface == null) {
                if (zzoo2.zzbhr != null) {
                    surface = zzoo2.zzbhr;
                } else {
                    zzkk zzkk2 = zzoo2.zzgo();
                    if (zzkk2 != null && zzoo2.zzm(zzkk2.zzaxk)) {
                        surface = zzoo2.zzbhr = zzok.zzc(zzoo2.zzlk, zzkk2.zzaxk);
                    }
                }
            }
            if (zzoo2.zzbhq != surface) {
                zzoo2.zzbhq = surface;
                int n2 = zzoo2.getState();
                if (n2 == 1 || n2 == 2) {
                    MediaCodec mediaCodec = zzoo2.zzgn();
                    if (zzoh.SDK_INT >= 23 && mediaCodec != null && surface != null) {
                        Surface surface2 = surface;
                        mediaCodec.setOutputSurface(surface2);
                    } else {
                        ((zzkn)zzoo2).zzgp();
                        zzoo2.zzgm();
                    }
                }
                if (surface != null && surface != zzoo2.zzbhr) {
                    zzoo2.zziv();
                    zzoo2.zzir();
                    if (n2 == 2) {
                        zzoo2.zziq();
                        return;
                    }
                } else {
                    zzoo2.zzit();
                    zzoo2.zzir();
                }
                return;
            }
            if (surface != null && surface != zzoo2.zzbhr) {
                zzoo2.zziv();
                zzoo zzoo3 = zzoo2;
                if (zzoo3.zzbht) {
                    zzoo3.zzbhj.zzb(zzoo3.zzbhq);
                }
            }
            return;
        }
        if (n == 4) {
            this.zzbhs = (Integer)object;
            MediaCodec mediaCodec = this.zzgn();
            if (mediaCodec != null) {
                int n3 = this.zzbhs;
                mediaCodec.setVideoScalingMode(n3);
            }
            return;
        }
        super.zza(n, object);
    }

    @Override
    protected final boolean zza(zzkk zzkk2) {
        return this.zzbhq != null || this.zzm(zzkk2.zzaxk);
    }

    @Override
    protected final void zza(zzkk zzkk2, MediaCodec mediaCodec, zzgq zzgq2, MediaCrypto mediaCrypto) throws zzks {
        zzoq zzoq2;
        zzgq[] zzgqArray = this.zzbho;
        Object object = zzgq2;
        zzkk zzkk3 = zzkk2;
        int n = ((zzgq)object).width;
        int n2 = ((zzgq)object).height;
        int n3 = zzoo.zzi((zzgq)object);
        if (zzgqArray.length == 1) {
            zzoq2 = new zzoq(n, n2, n3);
        } else {
            boolean bl = false;
            zzgq[] zzgqArray2 = zzgqArray;
            int n4 = zzgqArray.length;
            for (int i = 0; i < n4; ++i) {
                zzgq zzgq3 = zzgqArray2[i];
                if (!zzoo.zza(zzkk3.zzaxj, (zzgq)object, zzgq3)) continue;
                bl |= zzgq3.width == -1 || zzgq3.height == -1;
                n = Math.max(n, zzgq3.width);
                n2 = Math.max(n2, zzgq3.height);
                n3 = Math.max(n3, zzoo.zzi(zzgq3));
            }
            if (bl) {
                Point point;
                Point point2;
                block16: {
                    int n5 = n;
                    n4 = n2;
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(66).append("Resolutions unknown. Codec max resolution: ").append(n5).append("x").append(n4).toString());
                    Object object2 = object;
                    zzkk zzkk4 = zzkk3;
                    boolean bl2 = ((zzgq)object2).height > ((zzgq)object2).width;
                    int n6 = bl2 ? ((zzgq)object2).height : ((zzgq)object2).width;
                    int n7 = bl2 ? ((zzgq)object2).width : ((zzgq)object2).height;
                    float f = (float)n7 / (float)n6;
                    int[] nArray = zzbhh;
                    int n8 = zzbhh.length;
                    for (int i = 0; i < n8; ++i) {
                        int n9 = nArray[i];
                        int n10 = (int)((float)n9 * f);
                        if (n9 <= n6 || n10 <= n7) {
                            point2 = null;
                        } else if (zzoh.SDK_INT >= 21) {
                            Point point3 = zzkk4.zzc(bl2 ? n10 : n9, bl2 ? n9 : n10);
                            float f2 = ((zzgq)object2).zzaff;
                            if (!zzkk4.zza(point3.x, point3.y, f2)) continue;
                            point2 = point3;
                        } else {
                            if ((n9 = zzoh.zze(n9, 16) << 4) * (n10 = zzoh.zze(n10, 16) << 4) > zzkr.zzgt()) continue;
                            point2 = new Point(bl2 ? n10 : n9, bl2 ? n9 : n10);
                        }
                        break block16;
                    }
                    point2 = point = null;
                }
                if (point2 != null) {
                    n = Math.max(n, point.x);
                    n2 = Math.max(n2, point.y);
                    n3 = Math.max(n3, zzoo.zza(((zzgq)object).zzafb, n, n2));
                    Log.w((String)"MediaCodecVideoRenderer", (String)new StringBuilder(57).append("Codec max resolution adjusted to: ").append(n).append("x").append(n2).toString());
                }
            }
            zzoq2 = new zzoq(n, n2, n3);
        }
        this.zzbhp = zzoq2;
        int n11 = this.zzagc;
        boolean bl = this.zzbhm;
        object = this.zzbhp;
        MediaFormat mediaFormat = zzgq2.zzeh();
        mediaFormat.setInteger("max-width", ((zzoq)object).width);
        mediaFormat.setInteger("max-height", ((zzoq)object).height);
        if (((zzoq)object).zzbil != -1) {
            mediaFormat.setInteger("max-input-size", ((zzoq)object).zzbil);
        }
        if (bl) {
            mediaFormat.setInteger("auto-frc", 0);
        }
        if (n11 != 0) {
            n3 = n11;
            MediaFormat mediaFormat2 = mediaFormat;
            mediaFormat2.setFeatureEnabled("tunneled-playback", true);
            mediaFormat2.setInteger("audio-session-id", n3);
        }
        MediaFormat mediaFormat3 = mediaFormat;
        if (this.zzbhq == null) {
            zznt.checkState(this.zzm(zzkk2.zzaxk));
            if (this.zzbhr == null) {
                this.zzbhr = zzok.zzc(this.zzlk, zzkk2.zzaxk);
            }
            this.zzbhq = this.zzbhr;
        }
        mediaCodec.configure(mediaFormat3, this.zzbhq, null, 0);
        if (zzoh.SDK_INT >= 23 && this.zzajn) {
            this.zzbii = new zzot(this, mediaCodec, null);
        }
    }

    @Override
    protected final void zzgp() {
        block4: {
            block5: {
                try {
                    super.zzgp();
                    if (this.zzbhr == null) break block4;
                    if (this.zzbhq != this.zzbhr) break block5;
                    this.zzbhq = null;
                }
                catch (Throwable throwable) {
                    if (this.zzbhr != null) {
                        if (this.zzbhq == this.zzbhr) {
                            this.zzbhq = null;
                        }
                        this.zzbhr.release();
                        this.zzbhr = null;
                    }
                    throw throwable;
                }
            }
            this.zzbhr.release();
            this.zzbhr = null;
            return;
        }
    }

    @Override
    protected final void zzc(String string2, long l, long l2) {
        this.zzbhj.zza(string2, l, l2);
    }

    @Override
    protected final void zzd(zzgq zzgq2) throws zzgb {
        super.zzd(zzgq2);
        this.zzbhj.zzb(zzgq2);
        zzgq zzgq3 = zzgq2;
        this.zzbhz = zzgq3.zzafh == -1.0f ? 1.0f : zzgq3.zzafh;
        this.zzbhy = zzoo.zzj(zzgq2);
    }

    @Override
    protected final void zza(zzim zzim2) {
        if (zzoh.SDK_INT < 23 && this.zzajn) {
            this.zzis();
        }
    }

    @Override
    protected final void onOutputFormatChanged(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        boolean bl = mediaFormat.containsKey("crop-right") && mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-bottom") && mediaFormat.containsKey("crop-top");
        this.zzbia = bl ? mediaFormat.getInteger("crop-right") - mediaFormat.getInteger("crop-left") + 1 : mediaFormat.getInteger("width");
        this.zzbib = bl ? mediaFormat.getInteger("crop-bottom") - mediaFormat.getInteger("crop-top") + 1 : mediaFormat.getInteger("height");
        this.zzbid = this.zzbhz;
        if (zzoh.SDK_INT >= 21) {
            if (this.zzbhy == 90 || this.zzbhy == 270) {
                int n = this.zzbia;
                this.zzbia = this.zzbib;
                this.zzbib = n;
                this.zzbid = 1.0f / this.zzbid;
            }
        } else {
            this.zzbic = this.zzbhy;
        }
        int n = this.zzbhs;
        mediaCodec.setVideoScalingMode(n);
    }

    @Override
    protected final boolean zza(MediaCodec mediaCodec, boolean bl, zzgq zzgq2, zzgq zzgq3) {
        return zzoo.zza(bl, zzgq2, zzgq3) && zzgq3.width <= this.zzbhp.width && zzgq3.height <= this.zzbhp.height && zzgq3.zzafc <= this.zzbhp.zzbil;
    }

    @Override
    protected final boolean zza(long l, long l2, MediaCodec mediaCodec, ByteBuffer byteBuffer, int n, int n2, long l3, boolean bl) {
        while (this.zzbik != 0 && l3 >= this.zzbhn[0]) {
            this.zzbij = this.zzbhn[0];
            --this.zzbik;
            System.arraycopy(this.zzbhn, 1, this.zzbhn, 0, this.zzbik);
        }
        long l4 = l3 - this.zzbij;
        if (bl) {
            this.zza(mediaCodec, n, l4);
            return true;
        }
        long l5 = l3 - l;
        if (this.zzbhq == this.zzbhr) {
            if (zzoo.zzeg(l5)) {
                this.zza(mediaCodec, n, l4);
                return true;
            }
            return false;
        }
        if (!this.zzbht) {
            if (zzoh.SDK_INT >= 21) {
                this.zza(mediaCodec, n, l4, System.nanoTime());
            } else {
                this.zzb(mediaCodec, n, l4);
            }
            return true;
        }
        if (this.getState() != 2) {
            return false;
        }
        long l6 = SystemClock.elapsedRealtime() * 1000L - l2;
        l5 -= l6;
        long l7 = System.nanoTime();
        long l8 = l7 + l5 * 1000L;
        long l9 = this.zzbhi.zzf(l3, l8);
        l5 = (l9 - l7) / 1000L;
        if (zzoo.zzeg(l5)) {
            int n3 = n;
            MediaCodec mediaCodec2 = mediaCodec;
            zzoo zzoo2 = this;
            zzoe.beginSection("dropVideoBuffer");
            mediaCodec2.releaseOutputBuffer(n3, false);
            zzoe.endSection();
            ++zzoo2.zzaza.zzamc;
            ++zzoo2.zzbhw;
            ++zzoo2.zzbhx;
            zzoo2.zzaza.zzamd = Math.max(zzoo2.zzbhx, zzoo2.zzaza.zzamd);
            if (zzoo2.zzbhw == zzoo2.zzbhl) {
                zzoo2.zziw();
            }
            return true;
        }
        if (zzoh.SDK_INT >= 21) {
            if (l5 < 50000L) {
                this.zza(mediaCodec, n, l4, l9);
                return true;
            }
        } else if (l5 < 30000L) {
            if (l5 > 11000L) {
                try {
                    Thread.sleep((l5 - 10000L) / 1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            this.zzb(mediaCodec, n, l4);
            return true;
        }
        return false;
    }

    private final void zza(MediaCodec mediaCodec, int n, long l) {
        zzoe.beginSection("skipVideoBuffer");
        mediaCodec.releaseOutputBuffer(n, false);
        zzoe.endSection();
        ++this.zzaza.zzamb;
    }

    private final void zzb(MediaCodec mediaCodec, int n, long l) {
        this.zziu();
        zzoe.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, true);
        zzoe.endSection();
        ++this.zzaza.zzama;
        this.zzbhx = 0;
        this.zzis();
    }

    @TargetApi(value=21)
    private final void zza(MediaCodec mediaCodec, int n, long l, long l2) {
        this.zziu();
        zzoe.beginSection("releaseOutputBuffer");
        mediaCodec.releaseOutputBuffer(n, l2);
        zzoe.endSection();
        ++this.zzaza.zzama;
        this.zzbhx = 0;
        this.zzis();
    }

    private final boolean zzm(boolean bl) {
        return zzoh.SDK_INT >= 23 && !this.zzajn && (!bl || zzok.zzc(this.zzlk));
    }

    private final void zziq() {
        this.zzbhu = this.zzbhk > 0L ? SystemClock.elapsedRealtime() + this.zzbhk : -9223372036854775807L;
    }

    private final void zzir() {
        MediaCodec mediaCodec;
        this.zzbht = false;
        if (zzoh.SDK_INT >= 23 && this.zzajn && (mediaCodec = this.zzgn()) != null) {
            this.zzbii = new zzot(this, mediaCodec, null);
        }
    }

    final void zzis() {
        if (!this.zzbht) {
            this.zzbht = true;
            this.zzbhj.zzb(this.zzbhq);
        }
    }

    private final void zzit() {
        this.zzbie = -1;
        this.zzbif = -1;
        this.zzbih = -1.0f;
        this.zzbig = -1;
    }

    private final void zziu() {
        if (this.zzbie != this.zzbia || this.zzbif != this.zzbib || this.zzbig != this.zzbic || this.zzbih != this.zzbid) {
            this.zzbhj.zzb(this.zzbia, this.zzbib, this.zzbic, this.zzbid);
            this.zzbie = this.zzbia;
            this.zzbif = this.zzbib;
            this.zzbig = this.zzbic;
            this.zzbih = this.zzbid;
        }
    }

    private final void zziv() {
        if (this.zzbie != -1 || this.zzbif != -1) {
            this.zzbhj.zzb(this.zzbia, this.zzbib, this.zzbic, this.zzbid);
        }
    }

    private final void zziw() {
        if (this.zzbhw > 0) {
            long l = SystemClock.elapsedRealtime();
            long l2 = l - this.zzbhv;
            this.zzbhj.zzf(this.zzbhw, l2);
            this.zzbhw = 0;
            this.zzbhv = l;
        }
    }

    private static boolean zzeg(long l) {
        return l < -30000L;
    }

    private static int zzi(zzgq zzgq2) {
        if (zzgq2.zzafc != -1) {
            return zzgq2.zzafc;
        }
        return zzoo.zza(zzgq2.zzafb, zzgq2.width, zzgq2.height);
    }

    private static int zza(String string2, int n, int n2) {
        int n3;
        int n4;
        if (n == -1 || n2 == -1) {
            return -1;
        }
        switch (string2) {
            case "video/3gpp": 
            case "video/mp4v-es": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/avc": {
                if ("BRAVIA 4K 2015".equals(zzoh.MODEL)) {
                    return -1;
                }
                n4 = zzoh.zze(n, 16) * zzoh.zze(n2, 16) << 4 << 4;
                n3 = 2;
                break;
            }
            case "video/x-vnd.on2.vp8": {
                n4 = n * n2;
                n3 = 2;
                break;
            }
            case "video/hevc": 
            case "video/x-vnd.on2.vp9": {
                n4 = n * n2;
                n3 = 4;
                break;
            }
            default: {
                return -1;
            }
        }
        return n4 * 3 / (2 * n3);
    }

    private static boolean zza(boolean bl, zzgq zzgq2, zzgq zzgq3) {
        return zzgq2.zzafb.equals(zzgq3.zzafb) && zzoo.zzj(zzgq2) == zzoo.zzj(zzgq3) && (bl || zzgq2.width == zzgq3.width && zzgq2.height == zzgq3.height);
    }

    private static int zzj(zzgq zzgq2) {
        if (zzgq2.zzafg == -1) {
            return 0;
        }
        return zzgq2.zzafg;
    }
}

