/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzavu;
import com.google.android.gms.internal.ads.zzpg;
import com.google.android.gms.internal.ads.zzpi;
import com.google.android.gms.internal.ads.zzpj;
import com.google.android.gms.internal.ads.zzpk;
import com.google.android.gms.internal.ads.zzpl;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@TargetApi(value=14)
public final class zzph
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzbnl;
    private final Context zzzc;
    private Application zzxh;
    private final WindowManager zzbnm;
    private final PowerManager zzzd;
    private final KeyguardManager zzze;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzbnn;
    private WeakReference<ViewTreeObserver> zzzg;
    private WeakReference<View> zzbno;
    private zzpk zzbnp;
    private zzavu zzbnq = new zzavu(zzbnl);
    private boolean zzbnr = false;
    private int zzzk = -1;
    private final HashSet<zzpl> zzbns = new HashSet();
    private final DisplayMetrics zzwl;
    private final Rect zzbnt;

    public zzph(Context context, View view) {
        this.zzzc = context.getApplicationContext();
        this.zzbnm = (WindowManager)context.getSystemService("window");
        this.zzzd = (PowerManager)this.zzzc.getSystemService("power");
        this.zzze = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzzc instanceof Application) {
            this.zzxh = (Application)this.zzzc;
            this.zzbnp = new zzpk((Application)this.zzzc, this);
        }
        this.zzwl = context.getResources().getDisplayMetrics();
        this.zzbnt = new Rect();
        this.zzbnt.right = this.zzbnm.getDefaultDisplay().getWidth();
        this.zzbnt.bottom = this.zzbnm.getDefaultDisplay().getHeight();
        View view2 = view;
        zzph zzph2 = this;
        View view3 = zzph2.zzbno != null ? (View)zzph2.zzbno.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzph2);
            zzph2.zzf(view3);
        }
        zzph2.zzbno = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzp.zzka().isAttachedToWindow(view2)) {
                zzph2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzph2);
        }
    }

    public final void zza(zzpl zzpl2) {
        this.zzbns.add(zzpl2);
        this.zzbm(3);
    }

    public final void zzb(zzpl zzpl2) {
        this.zzbns.remove(zzpl2);
    }

    private final void zzcq() {
        zzatv.zzdsk.post((Runnable)new zzpg(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzzk = -1;
        this.zze(view);
        this.zzbm(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzzk = -1;
        this.zzbm(3);
        this.zzcq();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzbno == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzbno.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzzk = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzbm(3);
        this.zzcq();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzbm(3);
        this.zzcq();
    }

    public final void onGlobalLayout() {
        this.zzbm(2);
        this.zzcq();
    }

    public final void onScrollChanged() {
        this.zzbm(1);
    }

    private final void zzbm(int n) {
        boolean bl;
        if (this.zzbns.size() == 0) {
            return;
        }
        if (this.zzbno == null) {
            return;
        }
        View view = (View)this.zzbno.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        zzyi zzyi2 = zzyt.zzclu;
        List<Rect> list = (Boolean)zzuo.zzoj().zzd(zzyi2) != false && view != null ? this.zzh(view) : Collections.emptyList();
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzzk != -1 ? this.zzzk : n2;
        boolean bl6 = bl = !bl3 && zzp.zzjy().zza(view, this.zzzd, this.zzze) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzbnq.tryAcquire() && bl == this.zzbnr) {
            return;
        }
        if (!bl && !this.zzbnr && n == 1) {
            return;
        }
        zzpi zzpi2 = new zzpi(zzp.zzkf().elapsedRealtime(), this.zzzd.isScreenOn(), view != null && zzp.zzka().isAttachedToWindow(view), view != null ? view.getWindowVisibility() : 8, this.zza(this.zzbnt), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwl.density, bl, list);
        Iterator<zzpl> iterator = this.zzbns.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzpi2);
        }
        this.zzbnr = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzbn(rect.left), this.zzbn(rect.top), this.zzbn(rect.right), this.zzbn(rect.bottom));
    }

    private final int zzbn(int n) {
        float f = this.zzwl.density;
        return (int)((float)n / f);
    }

    private final List<Rect> zzh(View view) {
        try {
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof View) {
                View view2 = (View)viewParent;
                Rect rect = new Rect();
                View view3 = view2;
                if ((Build.VERSION.SDK_INT >= 16 ? view3.isScrollContainer() : view3 instanceof ScrollView || view3 instanceof ListView) && view2.getGlobalVisibleRect(rect)) {
                    arrayList.add(this.zza(rect));
                }
                viewParent = viewParent.getParent();
            }
            return arrayList;
        }
        catch (Exception exception) {
            zzp.zzkc().zza(exception, "PositionWatcher.getParentScrollViewRects");
            return Collections.emptyList();
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzzg = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzph zzph2 = this;
        if (zzph2.zzbnn == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzph2.zzbnn = new zzpj(zzph2);
            zzp.zzkt().zza(zzph2.zzzc, zzph2.zzbnn, intentFilter);
        }
        if (this.zzxh != null) {
            try {
                this.zzxh.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbnp);
                return;
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzzg != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzzg.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzzg = null;
            }
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzph zzph2 = this;
        if (zzph2.zzbnn != null) {
            try {
                zzp.zzkt().zza(zzph2.zzzc, zzph2.zzbnn);
            }
            catch (IllegalStateException illegalStateException) {
                zzatm.zzc((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzp.zzkc().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzph2.zzbnn = null;
        }
        if (this.zzxh != null) {
            try {
                this.zzxh.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbnp);
                return;
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public final void zzeh(long l) {
        this.zzbnq.zzev(l);
    }

    public final void zzlf() {
        this.zzbnq.zzev(zzbnl);
    }

    final /* synthetic */ void zzlg() {
        this.zzbm(3);
    }

    static /* synthetic */ void zza(zzph zzph2, int n) {
        zzph2.zzbm(3);
    }

    static {
        zzyi zzyi2 = zzyt.zzclr;
        zzbnl = (Long)zzuo.zzoj().zzd(zzyi2);
    }
}

