/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzatv;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzpy;
import com.google.android.gms.internal.ads.zzpz;
import com.google.android.gms.internal.ads.zzqn;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

@TargetApi(value=14)
final class zzpw
implements Application.ActivityLifecycleCallbacks {
    @Nullable
    private Activity zzzr;
    private Context zzlk;
    private final Object lock = new Object();
    private boolean foreground = true;
    private boolean zzbox = false;
    @GuardedBy(value="lock")
    private final List<zzpy> zzboy = new ArrayList<zzpy>();
    @GuardedBy(value="lock")
    private final List<zzqn> zzboz = new ArrayList<zzqn>();
    private Runnable zzbpa;
    private boolean zzye = false;
    private long zzbpb;

    zzpw() {
    }

    public final void zza(Application application, Context context) {
        if (!this.zzye) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            if (context instanceof Activity) {
                this.setActivity((Activity)context);
            }
            this.zzlk = application;
            zzyi zzyi2 = zzyt.zzckh;
            this.zzbpb = (Long)zzuo.zzoj().zzd(zzyi2);
            this.zzye = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzpy zzpy2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzboy.add(zzpy2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzpy zzpy2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzboy.remove(zzpy2);
            return;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
    }

    @Nullable
    public final Activity getActivity() {
        return this.zzzr;
    }

    @Nullable
    public final Context getContext() {
        return this.zzlk;
    }

    public final void onActivityStarted(Activity activity) {
        this.setActivity(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityResumed(Activity activity) {
        this.setActivity(activity);
        this.zzbox = false;
        boolean bl = !this.foreground;
        this.foreground = true;
        if (this.zzbpa != null) {
            zzatv.zzdsk.removeCallbacks(this.zzbpa);
        }
        Object object = this.lock;
        synchronized (object) {
            for (zzqn object2 : this.zzboz) {
                try {
                    object2.onActivityResumed(activity);
                }
                catch (Exception exception) {
                    zzp.zzkc().zza(exception, "AppActivityTracker.ActivityListener.onActivityResumed");
                    Exception exception2 = exception;
                    zzawo.zzc((String)"", (Throwable)exception2);
                }
            }
            if (bl) {
                for (zzpy zzpy2 : this.zzboy) {
                    try {
                        zzpy2.zzo(true);
                    }
                    catch (Exception exception) {
                        zzawo.zzc((String)"", (Throwable)exception);
                    }
                }
            } else {
                zzatm.zzdv((String)"App is still foreground.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityPaused(Activity activity) {
        this.setActivity(activity);
        Object object = this.lock;
        synchronized (object) {
            for (zzqn zzqn2 : this.zzboz) {
                try {
                    zzqn2.onActivityPaused(activity);
                }
                catch (Exception exception) {
                    zzp.zzkc().zza(exception, "AppActivityTracker.ActivityListener.onActivityPaused");
                    Exception exception2 = exception;
                    zzawo.zzc((String)"", (Throwable)exception2);
                }
            }
        }
        this.zzbox = true;
        if (this.zzbpa != null) {
            zzatv.zzdsk.removeCallbacks(this.zzbpa);
        }
        this.zzbpa = new zzpz(this);
        zzatv.zzdsk.postDelayed(this.zzbpa, this.zzbpb);
    }

    public final void onActivityStopped(Activity activity) {
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onActivityDestroyed(Activity activity) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzzr == null) {
                return;
            }
            if (this.zzzr.equals(activity)) {
                this.zzzr = null;
            }
            Iterator<zzqn> iterator = this.zzboz.iterator();
            while (iterator.hasNext()) {
                zzqn zzqn2 = iterator.next();
                try {
                    if (!zzqn2.zza(activity)) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    zzp.zzkc().zza(exception, "AppActivityTracker.ActivityListener.onActivityDestroyed");
                    Exception exception2 = exception;
                    zzawo.zzc((String)"", (Throwable)exception2);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setActivity(Activity activity) {
        Object object = this.lock;
        synchronized (object) {
            if (!activity.getClass().getName().startsWith("com.google.android.gms.ads")) {
                this.zzzr = activity;
            }
            return;
        }
    }

    static /* synthetic */ Object zza(zzpw zzpw2) {
        return zzpw2.lock;
    }

    static /* synthetic */ boolean zzb(zzpw zzpw2) {
        return zzpw2.foreground;
    }

    static /* synthetic */ boolean zzc(zzpw zzpw2) {
        return zzpw2.zzbox;
    }

    static /* synthetic */ boolean zza(zzpw zzpw2, boolean bl) {
        zzpw2.foreground = false;
        return false;
    }

    static /* synthetic */ List zzd(zzpw zzpw2) {
        return zzpw2.zzboy;
    }
}

