/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzbbc;
import com.google.android.gms.internal.ads.zzpu;
import com.google.android.gms.internal.ads.zzpv;
import com.google.android.gms.internal.ads.zzqa;
import com.google.android.gms.internal.ads.zzqd;
import com.google.android.gms.internal.ads.zzqf;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyt;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzqb
extends Thread {
    private boolean started = false;
    private boolean zzbpi = false;
    private boolean zzbpj = false;
    private final Object lock;
    private final zzpu zzbpk;
    private final int zzbpl;
    private final int zzboi;
    private final int zzbpm;
    private final int zzbok;
    private final int zzbpn;
    private final int zzbpo;
    private final int zzbpp;
    private final int zzbpq;
    private final String zzbpr;
    private final boolean zzbps;
    private final boolean zzbol;
    private final boolean zzbpt;

    public zzqb() {
        this(new zzpu());
    }

    @VisibleForTesting
    private zzqb(zzpu zzpu2) {
        this.zzbpk = zzpu2;
        this.lock = new Object();
        zzyi zzyi2 = zzyt.zzcii;
        this.zzboi = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcij;
        this.zzbpm = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcik;
        this.zzbok = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcil;
        this.zzbpn = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcin;
        this.zzbpo = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcio;
        this.zzbpp = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcip;
        this.zzbpq = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcim;
        this.zzbpl = (Integer)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcir;
        this.zzbpr = (String)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcis;
        this.zzbps = (Boolean)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzciw;
        this.zzbol = (Boolean)zzuo.zzoj().zzd(zzyi2);
        zzyi2 = zzyt.zzcix;
        this.zzbpt = (Boolean)zzuo.zzoj().zzd(zzyi2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzlr() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                zzatm.zzdv((String)"Content hash thread already started, quiting...");
                return;
            }
            this.started = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzqb.zzls()) {
                    object = zzp.zzkb().getActivity();
                    if (object == null) {
                        zzatm.zzdv((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzlu();
                    } else {
                        Activity activity = object;
                        zzqb zzqb2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzp.zzkc().zza(exception, "ContentFetchTask.extractContent");
                                zzatm.zzdv((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                boolean bl;
                                View view2 = view;
                                zzqb zzqb3 = zzqb2;
                                if (view2 == null) {
                                    bl = false;
                                } else {
                                    view2.post((Runnable)new zzqa(zzqb3, view2));
                                    bl = true;
                                }
                            }
                        }
                    }
                } else {
                    zzatm.zzdv((String)"ContentFetchTask: sleeping");
                    this.zzlu();
                }
                Thread.sleep(this.zzbpl * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzatm.zzc((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzatm.zzc((String)"Error in ContentFetchTask", (Throwable)exception);
                zzp.zzkc().zza(exception, "ContentFetchTask.run");
            }
            object = this.lock;
            synchronized (object) {
                while (this.zzbpi) {
                    try {
                        zzatm.zzdv((String)"ContentFetchTask: waiting");
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzi(View view) {
        try {
            zzpv zzpv2 = new zzpv(this.zzboi, this.zzbpm, this.zzbok, this.zzbpn, this.zzbpo, this.zzbpp, this.zzbpq, this.zzbol);
            Context context = zzp.zzkb().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzbpr)) {
                zzyi zzyi2 = zzyt.zzciq;
                int n = context.getResources().getIdentifier((String)zzuo.zzoj().zzd(zzyi2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzbpr)) {
                    return;
                }
            }
            zzqf zzqf2 = this.zza(view, zzpv2);
            zzpv2.zzlp();
            if (zzqf2.zzbqa == 0 && zzqf2.zzbqb == 0) {
                return;
            }
            if (zzqf2.zzbqb == 0 && zzpv2.zzlq() == 0) {
                return;
            }
            if (zzqf2.zzbqb == 0 && this.zzbpk.zza(zzpv2)) {
                return;
            }
            this.zzbpk.zzc(zzpv2);
            return;
        }
        catch (Exception exception) {
            zzatm.zzc((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzp.zzkc().zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzls() {
        try {
            Context context = zzp.zzkb().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzp.zzkc().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzqf zza(@Nullable View view, zzpv zzpv2) {
        if (view == null) {
            return new zzqf(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzpv2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzqf(this, 1, 0);
            }
            return new zzqf(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzbbc)) {
            boolean bl2;
            zzpv zzpv3 = zzpv2;
            WebView webView = (WebView)view;
            zzqb zzqb2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzpv3.zzln();
                webView.post((Runnable)new zzqd(zzqb2, zzpv3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzqf(this, 0, 1);
            }
            return new zzqf(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzqf zzqf2 = this.zza(viewGroup.getChildAt(i), zzpv2);
                n += zzqf2.zzbqa;
                n2 += zzqf2.zzbqb;
            }
            return new zzqf(this, n, n2);
        }
        return new zzqf(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzpv zzpv2, WebView webView, String string2, boolean bl) {
        zzpv2.zzlm();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzbps && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzpv2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzpv2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzpv2.zzlh()) {
                this.zzbpk.zzb(zzpv2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzatm.zzdv((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzatm.zzb((String)"Failed to get webview content.", (Throwable)throwable);
            zzp.zzkc().zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzpv zzlt() {
        return this.zzbpk.zzn(this.zzbpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.zzbpi = false;
            this.lock.notifyAll();
            zzatm.zzdv((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzlu() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.zzbpi = true;
            zzatm.zzdv((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzlv() {
        return this.zzbpi;
    }
}

