/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzatm;
import com.google.android.gms.internal.ads.zzrk;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CacheOfferingCreator")
public final class zzrl
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzrl> CREATOR = new zzrk();
    @SafeParcelable.Field(id=2)
    @Nullable
    public final String url;
    @SafeParcelable.Field(id=3)
    private final long zzbqz;
    @SafeParcelable.Field(id=4)
    private final String zzbra;
    @SafeParcelable.Field(id=5)
    private final String zzbrb;
    @SafeParcelable.Field(id=6)
    private final String zzbrc;
    @SafeParcelable.Field(id=7)
    private final Bundle zzbrd;
    @SafeParcelable.Field(id=8)
    public final boolean zzbre;
    @SafeParcelable.Field(id=9)
    public long zzbrf;

    @Nullable
    public static zzrl zzbt(String string2) {
        return zzrl.zze(Uri.parse((String)string2));
    }

    @Nullable
    public static zzrl zze(Uri uri) {
        try {
            if (!"gcache".equals(uri.getScheme())) {
                return null;
            }
            List list = uri.getPathSegments();
            if (list.size() != 2) {
                int n = list.size();
                zzatm.zzeu((String)new StringBuilder(62).append("Expected 2 path parts for namespace and id, found :").append(n).toString());
                return null;
            }
            String string2 = (String)list.get(0);
            String string3 = (String)list.get(1);
            String string4 = uri.getHost();
            String string5 = uri.getQueryParameter("url");
            boolean bl = "1".equals(uri.getQueryParameter("read_only"));
            String string6 = uri.getQueryParameter("expiration");
            long l = string6 == null ? 0L : Long.parseLong(string6);
            Bundle bundle = new Bundle();
            zzp.zzka();
            for (String string7 : uri.getQueryParameterNames()) {
                if (!string7.startsWith("tag.")) continue;
                String string8 = string7.substring(4);
                String string9 = uri.getQueryParameter(string7);
                bundle.putString(string8, string9);
            }
            return new zzrl(string5, l, string4, string2, string3, bundle, bl, 0L);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            zzatm.zzd((String)"Unable to parse Uri into cache offering.", (Throwable)runtimeException);
            return null;
        }
    }

    @SafeParcelable.Constructor
    zzrl(@SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) String string3, @SafeParcelable.Param(id=5) String string4, @SafeParcelable.Param(id=6) String string5, @SafeParcelable.Param(id=7) Bundle bundle, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) long l2) {
        this.url = string2;
        this.zzbqz = l;
        this.zzbra = string3 != null ? string3 : "";
        this.zzbrb = string4 != null ? string4 : "";
        this.zzbrc = string5 != null ? string5 : "";
        this.zzbrd = bundle != null ? bundle : new Bundle();
        this.zzbre = bl;
        this.zzbrf = l2;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzrl zzrl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzrl2.url, (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)zzrl2.zzbqz);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzrl2.zzbra, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzrl2.zzbrb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)zzrl2.zzbrc, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)parcel2, (int)7, (Bundle)zzrl2.zzbrd, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)8, (boolean)zzrl2.zzbre);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)9, (long)zzrl2.zzbrf);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

