/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobServiceEngine;
import android.app.job.JobWorkItem;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class JobIntentService
extends Service {
    static final String TAG = "JobIntentService";
    static final boolean DEBUG = false;
    CompatJobEngine mJobImpl;
    WorkEnqueuer mCompatWorkEnqueuer;
    CommandProcessor mCurProcessor;
    boolean mInterruptIfStopped = false;
    boolean mStopped = false;
    boolean mDestroyed = false;
    final ArrayList<CompatWorkItem> mCompatQueue = Build.VERSION.SDK_INT >= 26 ? null : new ArrayList();
    static final Object sLock = new Object();
    static final HashMap<ComponentName, WorkEnqueuer> sClassWorkEnqueuer = new HashMap();

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            this.mJobImpl = new JobServiceEngineImpl(this);
            this.mCompatWorkEnqueuer = null;
        } else {
            this.mJobImpl = null;
            ComponentName cn = new ComponentName((Context)this, ((Object)((Object)this)).getClass());
            this.mCompatWorkEnqueuer = JobIntentService.getWorkEnqueuer((Context)this, cn, false, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (this.mCompatQueue != null) {
            this.mCompatWorkEnqueuer.serviceStartReceived();
            ArrayList<CompatWorkItem> arrayList = this.mCompatQueue;
            synchronized (arrayList) {
                this.mCompatQueue.add(new CompatWorkItem(intent != null ? intent : new Intent(), startId));
                this.ensureProcessorRunningLocked(true);
            }
            return 3;
        }
        return 2;
    }

    public IBinder onBind(@NonNull Intent intent) {
        if (this.mJobImpl != null) {
            IBinder engine = this.mJobImpl.compatGetBinder();
            return engine;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        super.onDestroy();
        if (this.mCompatQueue != null) {
            ArrayList<CompatWorkItem> arrayList = this.mCompatQueue;
            synchronized (arrayList) {
                this.mDestroyed = true;
                this.mCompatWorkEnqueuer.serviceProcessingFinished();
            }
        }
    }

    public static void enqueueWork(@NonNull Context context, @NonNull Class cls, int jobId, @NonNull Intent work) {
        JobIntentService.enqueueWork(context, new ComponentName(context, cls), jobId, work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueueWork(@NonNull Context context, @NonNull ComponentName component, int jobId, @NonNull Intent work) {
        if (work == null) {
            throw new IllegalArgumentException("work must not be null");
        }
        Object object = sLock;
        synchronized (object) {
            WorkEnqueuer we = JobIntentService.getWorkEnqueuer(context, component, true, jobId);
            we.ensureJobId(jobId);
            we.enqueueWork(work);
        }
    }

    static WorkEnqueuer getWorkEnqueuer(Context context, ComponentName cn, boolean hasJobId, int jobId) {
        WorkEnqueuer we = sClassWorkEnqueuer.get(cn);
        if (we == null) {
            if (Build.VERSION.SDK_INT >= 26) {
                if (!hasJobId) {
                    throw new IllegalArgumentException("Can't be here without a job id");
                }
                we = new JobWorkEnqueuer(context, cn, jobId);
            } else {
                we = new CompatWorkEnqueuer(context, cn);
            }
            sClassWorkEnqueuer.put(cn, we);
        }
        return we;
    }

    protected abstract void onHandleWork(@NonNull Intent var1);

    public void setInterruptIfStopped(boolean interruptIfStopped) {
        this.mInterruptIfStopped = interruptIfStopped;
    }

    public boolean isStopped() {
        return this.mStopped;
    }

    public boolean onStopCurrentWork() {
        return true;
    }

    boolean doStopCurrentWork() {
        if (this.mCurProcessor != null) {
            this.mCurProcessor.cancel(this.mInterruptIfStopped);
        }
        this.mStopped = true;
        return this.onStopCurrentWork();
    }

    void ensureProcessorRunningLocked(boolean reportStarted) {
        if (this.mCurProcessor == null) {
            this.mCurProcessor = new CommandProcessor();
            if (this.mCompatWorkEnqueuer != null && reportStarted) {
                this.mCompatWorkEnqueuer.serviceProcessingStarted();
            }
            this.mCurProcessor.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processorFinished() {
        if (this.mCompatQueue != null) {
            ArrayList<CompatWorkItem> arrayList = this.mCompatQueue;
            synchronized (arrayList) {
                this.mCurProcessor = null;
                if (this.mCompatQueue != null && this.mCompatQueue.size() > 0) {
                    this.ensureProcessorRunningLocked(false);
                } else if (!this.mDestroyed) {
                    this.mCompatWorkEnqueuer.serviceProcessingFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GenericWorkItem dequeueWork() {
        if (this.mJobImpl != null) {
            return this.mJobImpl.dequeueWork();
        }
        ArrayList<CompatWorkItem> arrayList = this.mCompatQueue;
        synchronized (arrayList) {
            if (this.mCompatQueue.size() > 0) {
                return this.mCompatQueue.remove(0);
            }
            return null;
        }
    }

    final class CommandProcessor
    extends AsyncTask<Void, Void, Void> {
        CommandProcessor() {
        }

        protected Void doInBackground(Void ... params) {
            GenericWorkItem work;
            while ((work = JobIntentService.this.dequeueWork()) != null) {
                JobIntentService.this.onHandleWork(work.getIntent());
                work.complete();
            }
            return null;
        }

        protected void onCancelled(Void aVoid) {
            JobIntentService.this.processorFinished();
        }

        protected void onPostExecute(Void aVoid) {
            JobIntentService.this.processorFinished();
        }
    }

    final class CompatWorkItem
    implements GenericWorkItem {
        final Intent mIntent;
        final int mStartId;

        CompatWorkItem(Intent intent, int startId) {
            this.mIntent = intent;
            this.mStartId = startId;
        }

        @Override
        public Intent getIntent() {
            return this.mIntent;
        }

        @Override
        public void complete() {
            JobIntentService.this.stopSelf(this.mStartId);
        }
    }

    static interface GenericWorkItem {
        public Intent getIntent();

        public void complete();
    }

    @RequiresApi(value=26)
    static final class JobWorkEnqueuer
    extends WorkEnqueuer {
        private final JobInfo mJobInfo;
        private final JobScheduler mJobScheduler;

        JobWorkEnqueuer(Context context, ComponentName cn, int jobId) {
            super(context, cn);
            this.ensureJobId(jobId);
            JobInfo.Builder b = new JobInfo.Builder(jobId, this.mComponentName);
            this.mJobInfo = b.setOverrideDeadline(0L).build();
            this.mJobScheduler = (JobScheduler)context.getApplicationContext().getSystemService("jobscheduler");
        }

        @Override
        void enqueueWork(Intent work) {
            this.mJobScheduler.enqueue(this.mJobInfo, new JobWorkItem(work));
        }
    }

    @RequiresApi(value=26)
    static final class JobServiceEngineImpl
    extends JobServiceEngine
    implements CompatJobEngine {
        static final String TAG = "JobServiceEngineImpl";
        static final boolean DEBUG = false;
        final JobIntentService mService;
        final Object mLock = new Object();
        JobParameters mParams;

        JobServiceEngineImpl(JobIntentService service) {
            super((Service)service);
            this.mService = service;
        }

        @Override
        public IBinder compatGetBinder() {
            return this.getBinder();
        }

        public boolean onStartJob(JobParameters params) {
            this.mParams = params;
            this.mService.ensureProcessorRunningLocked(false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onStopJob(JobParameters params) {
            boolean result = this.mService.doStopCurrentWork();
            Object object = this.mLock;
            synchronized (object) {
                this.mParams = null;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GenericWorkItem dequeueWork() {
            JobWorkItem work;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mParams == null) {
                    return null;
                }
                work = this.mParams.dequeueWork();
            }
            if (work != null) {
                work.getIntent().setExtrasClassLoader(this.mService.getClassLoader());
                return new WrapperWorkItem(work);
            }
            return null;
        }

        final class WrapperWorkItem
        implements GenericWorkItem {
            final JobWorkItem mJobWork;

            WrapperWorkItem(JobWorkItem jobWork) {
                this.mJobWork = jobWork;
            }

            @Override
            public Intent getIntent() {
                return this.mJobWork.getIntent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete() {
                Object object = JobServiceEngineImpl.this.mLock;
                synchronized (object) {
                    if (JobServiceEngineImpl.this.mParams != null) {
                        JobServiceEngineImpl.this.mParams.completeWork(this.mJobWork);
                    }
                }
            }
        }
    }

    static final class CompatWorkEnqueuer
    extends WorkEnqueuer {
        private final Context mContext;
        private final PowerManager.WakeLock mLaunchWakeLock;
        private final PowerManager.WakeLock mRunWakeLock;
        boolean mLaunchingService;
        boolean mServiceProcessing;

        CompatWorkEnqueuer(Context context, ComponentName cn) {
            super(context, cn);
            this.mContext = context.getApplicationContext();
            PowerManager pm = (PowerManager)context.getSystemService("power");
            this.mLaunchWakeLock = pm.newWakeLock(1, cn.getClassName() + ":launch");
            this.mLaunchWakeLock.setReferenceCounted(false);
            this.mRunWakeLock = pm.newWakeLock(1, cn.getClassName() + ":run");
            this.mRunWakeLock.setReferenceCounted(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void enqueueWork(Intent work) {
            Intent intent = new Intent(work);
            intent.setComponent(this.mComponentName);
            if (this.mContext.startService(intent) != null) {
                CompatWorkEnqueuer compatWorkEnqueuer = this;
                synchronized (compatWorkEnqueuer) {
                    if (!this.mLaunchingService) {
                        this.mLaunchingService = true;
                        if (!this.mServiceProcessing) {
                            this.mLaunchWakeLock.acquire(60000L);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceStartReceived() {
            CompatWorkEnqueuer compatWorkEnqueuer = this;
            synchronized (compatWorkEnqueuer) {
                this.mLaunchingService = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceProcessingStarted() {
            CompatWorkEnqueuer compatWorkEnqueuer = this;
            synchronized (compatWorkEnqueuer) {
                if (!this.mServiceProcessing) {
                    this.mServiceProcessing = true;
                    this.mRunWakeLock.acquire(600000L);
                    this.mLaunchWakeLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceProcessingFinished() {
            CompatWorkEnqueuer compatWorkEnqueuer = this;
            synchronized (compatWorkEnqueuer) {
                if (this.mServiceProcessing) {
                    if (this.mLaunchingService) {
                        this.mLaunchWakeLock.acquire(60000L);
                    }
                    this.mServiceProcessing = false;
                    this.mRunWakeLock.release();
                }
            }
        }
    }

    static interface CompatJobEngine {
        public IBinder compatGetBinder();

        public GenericWorkItem dequeueWork();
    }

    static abstract class WorkEnqueuer {
        final ComponentName mComponentName;
        boolean mHasJobId;
        int mJobId;

        WorkEnqueuer(Context context, ComponentName cn) {
            this.mComponentName = cn;
        }

        void ensureJobId(int jobId) {
            if (!this.mHasJobId) {
                this.mHasJobId = true;
                this.mJobId = jobId;
            } else if (this.mJobId != jobId) {
                throw new IllegalArgumentException("Given job ID " + jobId + " is different than previous " + this.mJobId);
            }
        }

        abstract void enqueueWork(Intent var1);

        public void serviceStartReceived() {
        }

        public void serviceProcessingStarted() {
        }

        public void serviceProcessingFinished() {
        }
    }
}

