/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.support.v4.app.INotificationSideChannel;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class NotificationManagerCompat {
    private static final String TAG = "NotifManCompat";
    private static final String CHECK_OP_NO_THROW = "checkOpNoThrow";
    private static final String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
    public static final String EXTRA_USE_SIDE_CHANNEL = "android.support.useSideChannel";
    public static final String ACTION_BIND_SIDE_CHANNEL = "android.support.BIND_NOTIFICATION_SIDE_CHANNEL";
    static final int MAX_SIDE_CHANNEL_SDK_VERSION = 19;
    private static final int SIDE_CHANNEL_RETRY_BASE_INTERVAL_MS = 1000;
    private static final int SIDE_CHANNEL_RETRY_MAX_COUNT = 6;
    private static final String SETTING_ENABLED_NOTIFICATION_LISTENERS = "enabled_notification_listeners";
    private static final Object sEnabledNotificationListenersLock = new Object();
    @GuardedBy(value="sEnabledNotificationListenersLock")
    private static String sEnabledNotificationListeners;
    @GuardedBy(value="sEnabledNotificationListenersLock")
    private static Set<String> sEnabledNotificationListenerPackages;
    private final Context mContext;
    private final NotificationManager mNotificationManager;
    private static final Object sLock;
    @GuardedBy(value="sLock")
    private static SideChannelManager sSideChannelManager;
    public static final int IMPORTANCE_UNSPECIFIED = -1000;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;
    public static final int IMPORTANCE_MAX = 5;

    @NonNull
    public static NotificationManagerCompat from(@NonNull Context context) {
        return new NotificationManagerCompat(context);
    }

    private NotificationManagerCompat(Context context) {
        this.mContext = context;
        this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
    }

    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    public void cancel(@Nullable String tag, int id2) {
        this.mNotificationManager.cancel(tag, id2);
        if (Build.VERSION.SDK_INT <= 19) {
            this.pushSideChannelQueue(new CancelTask(this.mContext.getPackageName(), id2, tag));
        }
    }

    public void cancelAll() {
        this.mNotificationManager.cancelAll();
        if (Build.VERSION.SDK_INT <= 19) {
            this.pushSideChannelQueue(new CancelTask(this.mContext.getPackageName()));
        }
    }

    public void notify(int id2, @NonNull Notification notification) {
        this.notify(null, id2, notification);
    }

    public void notify(@Nullable String tag, int id2, @NonNull Notification notification) {
        if (NotificationManagerCompat.useSideChannelForNotification(notification)) {
            this.pushSideChannelQueue(new NotifyTask(this.mContext.getPackageName(), id2, tag, notification));
            this.mNotificationManager.cancel(tag, id2);
        } else {
            this.mNotificationManager.notify(tag, id2, notification);
        }
    }

    public boolean areNotificationsEnabled() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.mNotificationManager.areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
            ApplicationInfo appInfo = this.mContext.getApplicationInfo();
            String pkg = this.mContext.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, value, uid, pkg) == 0;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                return true;
            }
        }
        return true;
    }

    public int getImportance() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.mNotificationManager.getImportance();
        }
        return -1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Set<String> getEnabledListenerPackages(@NonNull Context context) {
        String enabledNotificationListeners = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)SETTING_ENABLED_NOTIFICATION_LISTENERS);
        Object object = sEnabledNotificationListenersLock;
        synchronized (object) {
            if (enabledNotificationListeners != null && !enabledNotificationListeners.equals(sEnabledNotificationListeners)) {
                String[] components = enabledNotificationListeners.split(":", -1);
                HashSet<String> packageNames = new HashSet<String>(components.length);
                for (String component : components) {
                    ComponentName componentName = ComponentName.unflattenFromString((String)component);
                    if (componentName == null) continue;
                    packageNames.add(componentName.getPackageName());
                }
                sEnabledNotificationListenerPackages = packageNames;
                sEnabledNotificationListeners = enabledNotificationListeners;
            }
            return sEnabledNotificationListenerPackages;
        }
    }

    private static boolean useSideChannelForNotification(Notification notification) {
        Bundle extras = NotificationCompat.getExtras(notification);
        return extras != null && extras.getBoolean(EXTRA_USE_SIDE_CHANNEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSideChannelQueue(Task task) {
        Object object = sLock;
        synchronized (object) {
            if (sSideChannelManager == null) {
                sSideChannelManager = new SideChannelManager(this.mContext.getApplicationContext());
            }
            sSideChannelManager.queueTask(task);
        }
    }

    static {
        sEnabledNotificationListenerPackages = new HashSet<String>();
        sLock = new Object();
    }

    private static class CancelTask
    implements Task {
        final String packageName;
        final int id;
        final String tag;
        final boolean all;

        CancelTask(String packageName) {
            this.packageName = packageName;
            this.id = 0;
            this.tag = null;
            this.all = true;
        }

        CancelTask(String packageName, int id2, String tag) {
            this.packageName = packageName;
            this.id = id2;
            this.tag = tag;
            this.all = false;
        }

        @Override
        public void send(INotificationSideChannel service) throws RemoteException {
            if (this.all) {
                service.cancelAll(this.packageName);
            } else {
                service.cancel(this.packageName, this.id, this.tag);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CancelTask[");
            sb.append("packageName:").append(this.packageName);
            sb.append(", id:").append(this.id);
            sb.append(", tag:").append(this.tag);
            sb.append(", all:").append(this.all);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class NotifyTask
    implements Task {
        final String packageName;
        final int id;
        final String tag;
        final Notification notif;

        NotifyTask(String packageName, int id2, String tag, Notification notif) {
            this.packageName = packageName;
            this.id = id2;
            this.tag = tag;
            this.notif = notif;
        }

        @Override
        public void send(INotificationSideChannel service) throws RemoteException {
            service.notify(this.packageName, this.id, this.tag, this.notif);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NotifyTask[");
            sb.append("packageName:").append(this.packageName);
            sb.append(", id:").append(this.id);
            sb.append(", tag:").append(this.tag);
            sb.append("]");
            return sb.toString();
        }
    }

    private static interface Task {
        public void send(INotificationSideChannel var1) throws RemoteException;
    }

    private static class ServiceConnectedEvent {
        final ComponentName componentName;
        final IBinder iBinder;

        ServiceConnectedEvent(ComponentName componentName, IBinder iBinder) {
            this.componentName = componentName;
            this.iBinder = iBinder;
        }
    }

    private static class SideChannelManager
    implements Handler.Callback,
    ServiceConnection {
        private static final int MSG_QUEUE_TASK = 0;
        private static final int MSG_SERVICE_CONNECTED = 1;
        private static final int MSG_SERVICE_DISCONNECTED = 2;
        private static final int MSG_RETRY_LISTENER_QUEUE = 3;
        private final Context mContext;
        private final HandlerThread mHandlerThread;
        private final Handler mHandler;
        private final Map<ComponentName, ListenerRecord> mRecordMap = new HashMap<ComponentName, ListenerRecord>();
        private Set<String> mCachedEnabledPackages = new HashSet<String>();

        SideChannelManager(Context context) {
            this.mContext = context;
            this.mHandlerThread = new HandlerThread("NotificationManagerCompat");
            this.mHandlerThread.start();
            this.mHandler = new Handler(this.mHandlerThread.getLooper(), (Handler.Callback)this);
        }

        public void queueTask(Task task) {
            this.mHandler.obtainMessage(0, (Object)task).sendToTarget();
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.handleQueueTask((Task)msg.obj);
                    return true;
                }
                case 1: {
                    ServiceConnectedEvent event = (ServiceConnectedEvent)msg.obj;
                    this.handleServiceConnected(event.componentName, event.iBinder);
                    return true;
                }
                case 2: {
                    this.handleServiceDisconnected((ComponentName)msg.obj);
                    return true;
                }
                case 3: {
                    this.handleRetryListenerQueue((ComponentName)msg.obj);
                    return true;
                }
            }
            return false;
        }

        private void handleQueueTask(Task task) {
            this.updateListenerMap();
            for (ListenerRecord record : this.mRecordMap.values()) {
                record.taskQueue.add(task);
                this.processListenerQueue(record);
            }
        }

        private void handleServiceConnected(ComponentName componentName, IBinder iBinder) {
            ListenerRecord record = this.mRecordMap.get(componentName);
            if (record != null) {
                record.service = INotificationSideChannel.Stub.asInterface(iBinder);
                record.retryCount = 0;
                this.processListenerQueue(record);
            }
        }

        private void handleServiceDisconnected(ComponentName componentName) {
            ListenerRecord record = this.mRecordMap.get(componentName);
            if (record != null) {
                this.ensureServiceUnbound(record);
            }
        }

        private void handleRetryListenerQueue(ComponentName componentName) {
            ListenerRecord record = this.mRecordMap.get(componentName);
            if (record != null) {
                this.processListenerQueue(record);
            }
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                Log.d((String)NotificationManagerCompat.TAG, (String)("Connected to service " + componentName));
            }
            this.mHandler.obtainMessage(1, (Object)new ServiceConnectedEvent(componentName, iBinder)).sendToTarget();
        }

        public void onServiceDisconnected(ComponentName componentName) {
            if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                Log.d((String)NotificationManagerCompat.TAG, (String)("Disconnected from service " + componentName));
            }
            this.mHandler.obtainMessage(2, (Object)componentName).sendToTarget();
        }

        private void updateListenerMap() {
            Set<String> enabledPackages = NotificationManagerCompat.getEnabledListenerPackages(this.mContext);
            if (enabledPackages.equals(this.mCachedEnabledPackages)) {
                return;
            }
            this.mCachedEnabledPackages = enabledPackages;
            List resolveInfos = this.mContext.getPackageManager().queryIntentServices(new Intent().setAction(NotificationManagerCompat.ACTION_BIND_SIDE_CHANNEL), 0);
            HashSet<ComponentName> enabledComponents = new HashSet<ComponentName>();
            for (ResolveInfo resolveInfo : resolveInfos) {
                if (!enabledPackages.contains(resolveInfo.serviceInfo.packageName)) continue;
                ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
                if (resolveInfo.serviceInfo.permission != null) {
                    Log.w((String)NotificationManagerCompat.TAG, (String)("Permission present on component " + componentName + ", not adding listener record."));
                    continue;
                }
                enabledComponents.add(componentName);
            }
            for (ComponentName componentName : enabledComponents) {
                if (this.mRecordMap.containsKey(componentName)) continue;
                if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                    Log.d((String)NotificationManagerCompat.TAG, (String)("Adding listener record for " + componentName));
                }
                this.mRecordMap.put(componentName, new ListenerRecord(componentName));
            }
            Iterator<Map.Entry<ComponentName, ListenerRecord>> it = this.mRecordMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ComponentName, ListenerRecord> entry = it.next();
                if (enabledComponents.contains(entry.getKey())) continue;
                if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                    Log.d((String)NotificationManagerCompat.TAG, (String)("Removing listener record for " + entry.getKey()));
                }
                this.ensureServiceUnbound(entry.getValue());
                it.remove();
            }
        }

        private boolean ensureServiceBound(ListenerRecord record) {
            if (record.bound) {
                return true;
            }
            Intent intent = new Intent(NotificationManagerCompat.ACTION_BIND_SIDE_CHANNEL).setComponent(record.componentName);
            record.bound = this.mContext.bindService(intent, (ServiceConnection)this, 33);
            if (record.bound) {
                record.retryCount = 0;
            } else {
                Log.w((String)NotificationManagerCompat.TAG, (String)("Unable to bind to listener " + record.componentName));
                this.mContext.unbindService((ServiceConnection)this);
            }
            return record.bound;
        }

        private void ensureServiceUnbound(ListenerRecord record) {
            if (record.bound) {
                this.mContext.unbindService((ServiceConnection)this);
                record.bound = false;
            }
            record.service = null;
        }

        private void scheduleListenerRetry(ListenerRecord record) {
            if (this.mHandler.hasMessages(3, (Object)record.componentName)) {
                return;
            }
            ++record.retryCount;
            if (record.retryCount > 6) {
                Log.w((String)NotificationManagerCompat.TAG, (String)("Giving up on delivering " + record.taskQueue.size() + " tasks to " + record.componentName + " after " + record.retryCount + " retries"));
                record.taskQueue.clear();
                return;
            }
            int delayMs = 1000 * (1 << record.retryCount - 1);
            if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                Log.d((String)NotificationManagerCompat.TAG, (String)("Scheduling retry for " + delayMs + " ms"));
            }
            Message msg = this.mHandler.obtainMessage(3, (Object)record.componentName);
            this.mHandler.sendMessageDelayed(msg, (long)delayMs);
        }

        private void processListenerQueue(ListenerRecord record) {
            Task task;
            if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                Log.d((String)NotificationManagerCompat.TAG, (String)("Processing component " + record.componentName + ", " + record.taskQueue.size() + " queued tasks"));
            }
            if (record.taskQueue.isEmpty()) {
                return;
            }
            if (!this.ensureServiceBound(record) || record.service == null) {
                this.scheduleListenerRetry(record);
                return;
            }
            while ((task = record.taskQueue.peek()) != null) {
                try {
                    if (Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) {
                        Log.d((String)NotificationManagerCompat.TAG, (String)("Sending task " + task));
                    }
                    task.send(record.service);
                    record.taskQueue.remove();
                }
                catch (DeadObjectException e) {
                    if (!Log.isLoggable((String)NotificationManagerCompat.TAG, (int)3)) break;
                    Log.d((String)NotificationManagerCompat.TAG, (String)("Remote service has died: " + record.componentName));
                    break;
                }
                catch (RemoteException e) {
                    Log.w((String)NotificationManagerCompat.TAG, (String)("RemoteException communicating with " + record.componentName), (Throwable)e);
                    break;
                }
            }
            if (!record.taskQueue.isEmpty()) {
                this.scheduleListenerRetry(record);
            }
        }

        private static class ListenerRecord {
            final ComponentName componentName;
            boolean bound = false;
            INotificationSideChannel service;
            ArrayDeque<Task> taskQueue = new ArrayDeque();
            int retryCount = 0;

            ListenerRecord(ComponentName componentName) {
                this.componentName = componentName;
            }
        }
    }
}

