/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.view.View;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.NativeAdViewHolder;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.NativeContentAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.OnImmersiveModeUpdatedListener;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzbdp;
import com.google.android.gms.internal.ads.zzth;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzwk;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAdViewAdapter
implements MediationBannerAdapter,
MediationNativeAdapter,
OnImmersiveModeUpdatedListener,
com.google.android.gms.ads.mediation.zza,
MediationRewardedVideoAdAdapter,
zzbdp {
    public static final String AD_UNIT_ID_PARAMETER = "pubid";
    private AdView zzmn;
    private InterstitialAd zzmo;
    private AdLoader zzmp;
    private Context zzmq;
    private InterstitialAd zzmr;
    private MediationRewardedVideoAdListener zzms;
    @VisibleForTesting
    private final RewardedVideoAdListener zzmt = new com.google.ads.mediation.zzb(this);

    protected abstract Bundle zza(Bundle var1, Bundle var2);

    private final AdRequest zza(Context context, MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        String string;
        Location location;
        Set<String> set;
        int n;
        AdRequest.Builder builder = new AdRequest.Builder();
        Date date = mediationAdRequest.getBirthday();
        if (date != null) {
            builder.setBirthday(date);
        }
        if ((n = mediationAdRequest.getGender()) != 0) {
            builder.setGender(n);
        }
        if ((set = mediationAdRequest.getKeywords()) != null) {
            location = set.iterator();
            while (location.hasNext()) {
                string = (String)location.next();
                builder.addKeyword(string);
            }
        }
        if ((location = mediationAdRequest.getLocation()) != null) {
            builder.setLocation(location);
        }
        if (mediationAdRequest.isTesting()) {
            zzuo.zzof();
            builder.addTestDevice(zzawe.zzbh(context));
        }
        if (mediationAdRequest.taggedForChildDirectedTreatment() != -1) {
            builder.tagForChildDirectedTreatment(mediationAdRequest.taggedForChildDirectedTreatment() == 1);
        }
        builder.setIsDesignedForFamilies(mediationAdRequest.isDesignedForFamilies());
        string = this.zza(bundle, bundle2);
        builder.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)string);
        return builder.build();
    }

    @Override
    public void onDestroy() {
        if (this.zzmn != null) {
            this.zzmn.destroy();
            this.zzmn = null;
        }
        if (this.zzmo != null) {
            this.zzmo = null;
        }
        if (this.zzmp != null) {
            this.zzmp = null;
        }
        if (this.zzmr != null) {
            this.zzmr = null;
        }
    }

    @Override
    public void onPause() {
        if (this.zzmn != null) {
            this.zzmn.pause();
        }
    }

    @Override
    public void onResume() {
        if (this.zzmn != null) {
            this.zzmn.resume();
        }
    }

    public String getAdUnitId(Bundle bundle) {
        return bundle.getString(AD_UNIT_ID_PARAMETER);
    }

    @Override
    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle bundle, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzmn = new AdView(context);
        this.zzmn.setAdSize(new AdSize(adSize.getWidth(), adSize.getHeight()));
        this.zzmn.setAdUnitId(this.getAdUnitId(bundle));
        this.zzmn.setAdListener(new zzc(this, mediationBannerListener));
        this.zzmn.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public View getBannerView() {
        return this.zzmn;
    }

    @Override
    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzmo = new InterstitialAd(context);
        this.zzmo.setAdUnitId(this.getAdUnitId(bundle));
        this.zzmo.setAdListener(new zzf(this, mediationInterstitialListener));
        this.zzmo.loadAd(this.zza(context, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void onImmersiveModeUpdated(boolean bl) {
        if (this.zzmo != null) {
            this.zzmo.setImmersiveMode(bl);
        }
        if (this.zzmr != null) {
            this.zzmr.setImmersiveMode(bl);
        }
    }

    @Override
    public zzwk getVideoController() {
        VideoController videoController;
        if (this.zzmn != null && (videoController = this.zzmn.getVideoController()) != null) {
            return videoController.zzdd();
        }
        return null;
    }

    @Override
    public void showInterstitial() {
        this.zzmo.show();
    }

    @Override
    public Bundle getInterstitialAdapterInfo() {
        return new MediationAdapter.zza().zzdd(1).zzaav();
    }

    @Override
    public void requestNativeAd(Context context, MediationNativeListener mediationNativeListener, Bundle bundle, NativeMediationAdRequest nativeMediationAdRequest, Bundle bundle2) {
        zze zze2 = new zze(this, mediationNativeListener);
        String string = bundle.getString(AD_UNIT_ID_PARAMETER);
        Context context2 = context;
        AdLoader.Builder builder = new AdLoader.Builder(context2, string).withAdListener(zze2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        if (nativeAdOptions != null) {
            builder.withNativeAdOptions(nativeAdOptions);
        }
        if (nativeMediationAdRequest.isUnifiedNativeAdRequested()) {
            builder.forUnifiedNativeAd(zze2);
        }
        if (nativeMediationAdRequest.isAppInstallAdRequested()) {
            builder.forAppInstallAd(zze2);
        }
        if (nativeMediationAdRequest.isContentAdRequested()) {
            builder.forContentAd(zze2);
        }
        if (nativeMediationAdRequest.zzrz()) {
            for (String string2 : nativeMediationAdRequest.zzsa().keySet()) {
                builder.forCustomTemplateAd(string2, zze2, nativeMediationAdRequest.zzsa().get(string2) != false ? zze2 : null);
            }
        }
        this.zzmp = builder.build();
        this.zzmp.loadAd(this.zza(context, nativeMediationAdRequest, bundle2, bundle));
    }

    @Override
    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.zzmq = context.getApplicationContext();
        this.zzms = mediationRewardedVideoAdListener;
        this.zzms.onInitializationSucceeded(this);
    }

    @Override
    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        if (this.zzmq == null || this.zzms == null) {
            zzawo.zzes("AdMobAdapter.loadAd called before initialize.");
            return;
        }
        this.zzmr = new InterstitialAd(this.zzmq);
        this.zzmr.zzc(true);
        this.zzmr.setAdUnitId(this.getAdUnitId(bundle));
        this.zzmr.setRewardedVideoAdListener(this.zzmt);
        this.zzmr.setAdMetadataListener(new com.google.ads.mediation.zza(this));
        this.zzmr.loadAd(this.zza(this.zzmq, mediationAdRequest, bundle2, bundle));
    }

    @Override
    public void showVideo() {
        this.zzmr.show();
    }

    @Override
    public boolean isInitialized() {
        return this.zzms != null;
    }

    static /* synthetic */ MediationRewardedVideoAdListener zza(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzms;
    }

    static /* synthetic */ InterstitialAd zza(AbstractAdViewAdapter abstractAdViewAdapter, InterstitialAd interstitialAd) {
        abstractAdViewAdapter.zzmr = null;
        return null;
    }

    static /* synthetic */ InterstitialAd zzb(AbstractAdViewAdapter abstractAdViewAdapter) {
        return abstractAdViewAdapter.zzmr;
    }

    static final class zza
    extends NativeContentAdMapper {
        private final NativeContentAd zzmv;

        public zza(NativeContentAd nativeContentAd) {
            this.zzmv = nativeContentAd;
            this.setHeadline(nativeContentAd.getHeadline().toString());
            this.setImages(nativeContentAd.getImages());
            this.setBody(nativeContentAd.getBody().toString());
            if (nativeContentAd.getLogo() != null) {
                this.setLogo(nativeContentAd.getLogo());
            }
            this.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.setAdvertiser(nativeContentAd.getAdvertiser().toString());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeContentAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzmv);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbka.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzmv);
            }
        }
    }

    static final class zzd
    extends UnifiedNativeAdMapper {
        private final UnifiedNativeAd zzmz;

        public zzd(UnifiedNativeAd unifiedNativeAd) {
            this.zzmz = unifiedNativeAd;
            this.setHeadline(unifiedNativeAd.getHeadline());
            this.setImages(unifiedNativeAd.getImages());
            this.setBody(unifiedNativeAd.getBody());
            this.setIcon(unifiedNativeAd.getIcon());
            this.setCallToAction(unifiedNativeAd.getCallToAction());
            this.setAdvertiser(unifiedNativeAd.getAdvertiser());
            this.setStarRating(unifiedNativeAd.getStarRating());
            this.setStore(unifiedNativeAd.getStore());
            this.setPrice(unifiedNativeAd.getPrice());
            this.zzn(unifiedNativeAd.zzjf());
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(unifiedNativeAd.getVideoController());
        }

        @Override
        public final void trackViews(View view, Map<String, View> map, Map<String, View> map2) {
            if (view instanceof UnifiedNativeAdView) {
                ((UnifiedNativeAdView)view).setNativeAd(this.zzmz);
                return;
            }
            NativeAdViewHolder nativeAdViewHolder = NativeAdViewHolder.zzbka.get(view);
            if (nativeAdViewHolder != null) {
                nativeAdViewHolder.setNativeAd(this.zzmz);
            }
        }
    }

    static final class zzb
    extends NativeAppInstallAdMapper {
        private final NativeAppInstallAd zzmw;

        public zzb(NativeAppInstallAd nativeAppInstallAd) {
            this.zzmw = nativeAppInstallAd;
            this.setHeadline(nativeAppInstallAd.getHeadline().toString());
            this.setImages(nativeAppInstallAd.getImages());
            this.setBody(nativeAppInstallAd.getBody().toString());
            this.setIcon(nativeAppInstallAd.getIcon());
            this.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            if (nativeAppInstallAd.getStarRating() != null) {
                this.setStarRating(nativeAppInstallAd.getStarRating());
            }
            if (nativeAppInstallAd.getStore() != null) {
                this.setStore(nativeAppInstallAd.getStore().toString());
            }
            if (nativeAppInstallAd.getPrice() != null) {
                this.setPrice(nativeAppInstallAd.getPrice().toString());
            }
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            this.zza(nativeAppInstallAd.getVideoController());
        }

        @Override
        public final void trackView(View view) {
            NativeAdViewHolder nativeAdViewHolder;
            if (view instanceof NativeAdView) {
                ((NativeAdView)view).setNativeAd(this.zzmw);
            }
            if ((nativeAdViewHolder = NativeAdViewHolder.zzbka.get(view)) != null) {
                nativeAdViewHolder.setNativeAd(this.zzmw);
            }
        }
    }

    @VisibleForTesting
    static final class zze
    extends AdListener
    implements NativeAppInstallAd.OnAppInstallAdLoadedListener,
    NativeContentAd.OnContentAdLoadedListener,
    NativeCustomTemplateAd.OnCustomClickListener,
    NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener,
    UnifiedNativeAd.OnUnifiedNativeAdLoadedListener {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmx;
        @VisibleForTesting
        private final MediationNativeListener zzna;

        public zze(AbstractAdViewAdapter abstractAdViewAdapter, MediationNativeListener mediationNativeListener) {
            this.zzmx = abstractAdViewAdapter;
            this.zzna = mediationNativeListener;
        }

        @Override
        public final void onAdLoaded() {
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzna.onAdFailedToLoad(this.zzmx, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzna.onAdOpened(this.zzmx);
        }

        @Override
        public final void onAdClosed() {
            this.zzna.onAdClosed(this.zzmx);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzna.onAdLeftApplication(this.zzmx);
        }

        @Override
        public final void onAdClicked() {
            this.zzna.onAdClicked(this.zzmx);
        }

        @Override
        public final void onAdImpression() {
            this.zzna.onAdImpression(this.zzmx);
        }

        @Override
        public final void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
            this.zzna.onAdLoaded((MediationNativeAdapter)this.zzmx, new zzb(nativeAppInstallAd));
        }

        @Override
        public final void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
            this.zzna.onAdLoaded((MediationNativeAdapter)this.zzmx, new zzd(unifiedNativeAd));
        }

        @Override
        public final void onContentAdLoaded(NativeContentAd nativeContentAd) {
            this.zzna.onAdLoaded((MediationNativeAdapter)this.zzmx, new zza(nativeContentAd));
        }

        @Override
        public final void onCustomTemplateAdLoaded(NativeCustomTemplateAd nativeCustomTemplateAd) {
            this.zzna.zza(this.zzmx, nativeCustomTemplateAd);
        }

        @Override
        public final void onCustomClick(NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
            this.zzna.zza(this.zzmx, nativeCustomTemplateAd, string);
        }
    }

    @VisibleForTesting
    static final class zzf
    extends AdListener
    implements zzth {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmx;
        @VisibleForTesting
        private final MediationInterstitialListener zznb;

        public zzf(AbstractAdViewAdapter abstractAdViewAdapter, MediationInterstitialListener mediationInterstitialListener) {
            this.zzmx = abstractAdViewAdapter;
            this.zznb = mediationInterstitialListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zznb.onAdLoaded(this.zzmx);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zznb.onAdFailedToLoad(this.zzmx, n);
        }

        @Override
        public final void onAdOpened() {
            this.zznb.onAdOpened(this.zzmx);
        }

        @Override
        public final void onAdClosed() {
            this.zznb.onAdClosed(this.zzmx);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zznb.onAdLeftApplication(this.zzmx);
        }

        @Override
        public final void onAdClicked() {
            this.zznb.onAdClicked(this.zzmx);
        }
    }

    @VisibleForTesting
    static final class zzc
    extends AdListener
    implements AppEventListener,
    zzth {
        @VisibleForTesting
        private final AbstractAdViewAdapter zzmx;
        @VisibleForTesting
        private final MediationBannerListener zzmy;

        public zzc(AbstractAdViewAdapter abstractAdViewAdapter, MediationBannerListener mediationBannerListener) {
            this.zzmx = abstractAdViewAdapter;
            this.zzmy = mediationBannerListener;
        }

        @Override
        public final void onAdLoaded() {
            this.zzmy.onAdLoaded(this.zzmx);
        }

        @Override
        public final void onAdFailedToLoad(int n) {
            this.zzmy.onAdFailedToLoad(this.zzmx, n);
        }

        @Override
        public final void onAdOpened() {
            this.zzmy.onAdOpened(this.zzmx);
        }

        @Override
        public final void onAdClosed() {
            this.zzmy.onAdClosed(this.zzmx);
        }

        @Override
        public final void onAdLeftApplication() {
            this.zzmy.onAdLeftApplication(this.zzmx);
        }

        @Override
        public final void onAdClicked() {
            this.zzmy.onAdClicked(this.zzmx);
        }

        @Override
        public final void onAppEvent(String string, String string2) {
            this.zzmy.zza(this.zzmx, string, string2);
        }
    }
}

