/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaai;
import com.google.android.gms.internal.ads.zzacv;
import com.google.android.gms.internal.ads.zzacx;
import com.google.android.gms.internal.ads.zzacy;
import com.google.android.gms.internal.ads.zzacz;
import com.google.android.gms.internal.ads.zzada;
import com.google.android.gms.internal.ads.zzadb;
import com.google.android.gms.internal.ads.zzaje;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zztl;
import com.google.android.gms.internal.ads.zztu;
import com.google.android.gms.internal.ads.zztw;
import com.google.android.gms.internal.ads.zzuo;
import com.google.android.gms.internal.ads.zzuw;
import com.google.android.gms.internal.ads.zzux;
import com.google.android.gms.internal.ads.zzws;
import com.google.android.gms.internal.ads.zzzzi$zyv;

public class AdLoader {
    private final zztu zzaax;
    private final Context zzlk;
    private final zzuw zzaay;

    AdLoader(Context context, zzuw zzuw2) {
        this(context, zzuw2, zztu.zzccd);
    }

    private AdLoader(Context context, zzuw zzuw2, zztu zztu2) {
        this.zzlk = context;
        this.zzaay = zzuw2;
        this.zzaax = zztu2;
    }

    private final void zza(zzws zzws2) {
        try {
            this.zzaay.zzb(zztu.zza(this.zzlk, zzws2));
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzda());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzws zzws2 = adRequest.zzda();
        AdLoader adLoader = this;
        try {
            adLoader.zzaay.zza(zztu.zza(adLoader.zzlk, zzws2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzawo.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzda());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzaay.zzjp();
        }
        catch (RemoteException remoteException) {
            zzawo.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzaay.isLoading();
        }
        catch (RemoteException remoteException) {
            zzawo.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzlk;
        private final zzux zzaba;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzuo.zzog().zzb(context, zzzzi$zyv.c(context, string, 4), new zzaje()));
        }

        private Builder(Context context, zzux zzux2) {
            this.zzlk = context;
            this.zzaba = zzux2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzaba.zza(new zzacy(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzaba.zza(new zzacv(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzaba.zza(new zzadb(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzaba.zza(string, new zzada(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzacx(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zztw zztw2 = new zztw(this.zzlk, adSizeArray);
                this.zzaba.zza(new zzacz(onPublisherAdViewLoadedListener), zztw2);
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzaba.zzb(new zztl(adListener));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzaba.zza(new zzaai(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzaba.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzawo.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        @Deprecated
        @KeepForSdk
        public Builder withCorrelator(@NonNull Correlator correlator) {
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzlk, this.zzaba.zzon());
            }
            catch (RemoteException remoteException) {
                zzawo.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

