/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.internal.ads.zzawo;
import com.google.android.gms.internal.ads.zzth;
import com.google.android.gms.internal.ads.zzwu;

class BaseAdView
extends ViewGroup {
    protected final zzwu zzabf;

    public BaseAdView(Context context, int n) {
        super(context);
        this.zzabf = new zzwu(this, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.zzabf = new zzwu(this, attributeSet, false, n);
    }

    public BaseAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        this.zzabf = new zzwu(this, attributeSet, false, n2);
    }

    public void destroy() {
        this.zzabf.destroy();
    }

    public AdListener getAdListener() {
        return this.zzabf.getAdListener();
    }

    public AdSize getAdSize() {
        return this.zzabf.getAdSize();
    }

    public String getAdUnitId() {
        return this.zzabf.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zzabf.zza(adRequest.zzda());
    }

    public void pause() {
        this.zzabf.pause();
    }

    public void resume() {
        this.zzabf.resume();
    }

    public boolean isLoading() {
        return this.zzabf.isLoading();
    }

    public void setAdListener(AdListener adListener) {
        this.zzabf.setAdListener(adListener);
        if (adListener == null) {
            this.zzabf.zza((zzth)null);
            this.zzabf.setAppEventListener(null);
            return;
        }
        if (adListener instanceof zzth) {
            this.zzabf.zza((zzth)((Object)adListener));
        }
        if (adListener instanceof AppEventListener) {
            this.zzabf.setAppEventListener((AppEventListener)((Object)adListener));
        }
    }

    public void setAdSize(AdSize adSize) {
        this.zzabf.setAdSizes(adSize);
    }

    public void setAdUnitId(String string) {
        this.zzabf.setAdUnitId(string);
    }

    public String getMediationAdapterClassName() {
        return this.zzabf.getMediationAdapterClassName();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzawo.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

