/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import com.google.android.gms.ads.zzc;
import com.google.android.gms.internal.ads.zzawo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class RequestConfiguration {
    private final int zzabj;
    private final int zzabk;
    private final String zzabl;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_UNSPECIFIED = -1;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_FALSE = 0;
    public static final int TAG_FOR_CHILD_DIRECTED_TREATMENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_TRUE = 1;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_FALSE = 0;
    public static final int TAG_FOR_UNDER_AGE_OF_CONSENT_UNSPECIFIED = -1;
    public static final String MAX_AD_CONTENT_RATING_UNSPECIFIED = "";
    public static final String MAX_AD_CONTENT_RATING_G = "G";
    public static final String MAX_AD_CONTENT_RATING_PG = "PG";
    public static final String MAX_AD_CONTENT_RATING_T = "T";
    public static final String MAX_AD_CONTENT_RATING_MA = "MA";
    public static final List<String> zzabm = Arrays.asList("MA", "T", "PG", "G");

    private RequestConfiguration(int n, int n2, String string) {
        this.zzabj = n;
        this.zzabk = n2;
        this.zzabl = string;
    }

    public int getTagForChildDirectedTreatment() {
        return this.zzabj;
    }

    public int getTagForUnderAgeOfConsent() {
        return this.zzabk;
    }

    public String getMaxAdContentRating() {
        if (this.zzabl == null) {
            return MAX_AD_CONTENT_RATING_UNSPECIFIED;
        }
        return this.zzabl;
    }

    public Builder toBuilder() {
        return new Builder().setTagForChildDirectedTreatment(this.zzabj).setTagForUnderAgeOfConsent(this.zzabk).setMaxAdContentRating(this.zzabl);
    }

    /* synthetic */ RequestConfiguration(int n, int n2, String string, zzc zzc2) {
        this(n, n2, string);
    }

    public static class Builder {
        private int zzabj = -1;
        private int zzabk = -1;
        private String zzabl = null;

        public RequestConfiguration build() {
            return new RequestConfiguration(this.zzabj, this.zzabk, this.zzabl, null);
        }

        public Builder setTagForChildDirectedTreatment(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabj = n;
            } else {
                zzawo.zzeu(new StringBuilder(68).append("Invalid value passed to setTagForChildDirectedTreatment: ").append(n).toString());
            }
            return this;
        }

        public Builder setTagForUnderAgeOfConsent(int n) {
            if (n == -1 || n == 0 || n == 1) {
                this.zzabk = n;
            } else {
                zzawo.zzeu(new StringBuilder(63).append("Invalid value passed to setTagForUnderAgeOfConsent: ").append(n).toString());
            }
            return this;
        }

        public Builder setMaxAdContentRating(String string) {
            if (string == null || RequestConfiguration.MAX_AD_CONTENT_RATING_UNSPECIFIED.equals(string)) {
                this.zzabl = null;
            } else if (RequestConfiguration.MAX_AD_CONTENT_RATING_G.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_PG.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_T.equals(string) || RequestConfiguration.MAX_AD_CONTENT_RATING_MA.equals(string)) {
                this.zzabl = string;
            } else {
                String string2 = String.valueOf(string);
                zzawo.zzeu(string2.length() != 0 ? "Invalid value passed to setMaxAdContentRating: ".concat(string2) : new String("Invalid value passed to setMaxAdContentRating: "));
            }
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MaxAdContentRating {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForUnderAgeOfConsent {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TagForChildDirectedTreatment {
    }
}

